/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.slicer;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.slicer.SliceLanguageSupportProvider;
import com.intellij.slicer.SliceLeafAnalyzer;
import com.intellij.slicer.SliceLeafEquality;
import com.intellij.slicer.SliceLeafValueRootNode;
import com.intellij.slicer.SliceManager;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.util.WalkingState;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.HashingStrategy;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightBundle;
import org.jetbrains.kotlin.idea.codeInsight.slicer.HackedSliceLeafValueClassNode;

public abstract class HackedSliceNullnessAnalyzerBase {
    @NotNull
    private final SliceLeafEquality myLeafEquality;
    @NotNull
    private final SliceLanguageSupportProvider myProvider;

    public HackedSliceNullnessAnalyzerBase(@NotNull SliceLeafEquality leafEquality, @NotNull SliceLanguageSupportProvider provider2) {
        if (leafEquality == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(0);
        }
        if (provider2 == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(1);
        }
        this.myLeafEquality = leafEquality;
        this.myProvider = provider2;
    }

    private void groupByNullness(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = this.createNewTree(result2, oldRoot, map2);
        SliceUsage rootUsage = (SliceUsage)((SliceNode)oldRoot.getCachedChildren().get(0)).getValue();
        SliceManager.getInstance((Project)root.getProject()).createToolWindow(true, root, true, SliceManager.getElementDescription(null, (PsiElement)rootUsage.getElement(), (String)KotlinCodeInsightBundle.message("slice.nullness.tab.title.grouped.by.nullness", new Object[0])));
    }

    @NotNull
    public SliceRootNode createNewTree(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2) {
        SliceRootNode root = oldRoot.copy();
        assert (oldRoot.getCachedChildren().size() == 1);
        SliceNode oldRootStart = (SliceNode)oldRoot.getCachedChildren().get(0);
        root.setChanged();
        root.targetEqualUsages.clear();
        ArrayList children = new ArrayList();
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "Null Values", 0)));
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "NotNull Values", 1)));
        ContainerUtil.addIfNotNull(children, (Object)((Object)this.createValueRootNode(result2, oldRoot, map2, root, oldRootStart, "Other Values", 2)));
        root.setChildren(children);
        SliceRootNode sliceRootNode = root;
        if (sliceRootNode == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(2);
        }
        return sliceRootNode;
    }

    private HackedSliceLeafValueClassNode createValueRootNode(NullAnalysisResult result2, SliceRootNode oldRoot, Map<SliceNode, NullAnalysisResult> map2, SliceRootNode root, SliceNode oldRootStart, String nodeName, int group) {
        Collection<PsiElement> groupedByValue = result2.groupedByValue[group];
        if (groupedByValue.isEmpty()) {
            return null;
        }
        HackedSliceLeafValueClassNode valueRoot = new HackedSliceLeafValueClassNode(root.getProject(), (SliceNode)root, nodeName);
        Set uniqueValues = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)this.myLeafEquality);
        uniqueValues.addAll(groupedByValue);
        for (PsiElement expression : uniqueValues) {
            SliceNode newRoot = SliceLeafAnalyzer.filterTree((SliceNode)oldRootStart, oldNode -> {
                if (oldNode.getDuplicate() != null) {
                    return null;
                }
                for (PsiElement nullSuspect : HackedSliceNullnessAnalyzerBase.group(oldNode, map2, group)) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nullSuspect, (PsiElement)expression)) continue;
                    return oldNode.copy();
                }
                return null;
            }, (node, children) -> {
                if (!children.isEmpty()) {
                    return true;
                }
                PsiElement element = ((SliceUsage)node.getValue()).getElement();
                if (element == null) {
                    return false;
                }
                return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)expression);
            });
            valueRoot.myCachedChildren.add(new SliceLeafValueRootNode(root.getProject(), (SliceNode)valueRoot, this.myProvider.createRootUsage(expression, ((SliceUsage)oldRoot.getValue()).params), Collections.singletonList(newRoot)));
        }
        return valueRoot;
    }

    public void startAnalyzeNullness(final @NotNull AbstractTreeStructure treeStructure, final @NotNull Runnable finish2) {
        if (treeStructure == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(3);
        }
        if (finish2 == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(4);
        }
        final SliceRootNode root = (SliceRootNode)treeStructure.getRootElement();
        final Ref leafExpressions = Ref.create(null);
        final Map<SliceNode, NullAnalysisResult> map2 = HackedSliceNullnessAnalyzerBase.createMap();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(root.getProject(), KotlinCodeInsightBundle.message("slice.nullness.progress.title.expanding.all.nodes", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                NullAnalysisResult l = HackedSliceNullnessAnalyzerBase.this.calcNullableLeaves((SliceNode)root, treeStructure, map2);
                leafExpressions.set((Object)l);
            }

            public void onCancel() {
                finish2.run();
            }

            public void onSuccess() {
                try {
                    NullAnalysisResult leaves = (NullAnalysisResult)leafExpressions.get();
                    if (leaves == null) {
                        return;
                    }
                    HackedSliceNullnessAnalyzerBase.this.groupByNullness(leaves, root, map2);
                }
                finally {
                    finish2.run();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/kotlin/idea/codeInsight/slicer/HackedSliceNullnessAnalyzerBase$1", "run"));
            }
        });
    }

    public static Map<SliceNode, NullAnalysisResult> createMap() {
        return FactoryMap.createMap(k -> new NullAnalysisResult(), () -> new Reference2ObjectOpenHashMap());
    }

    private static NullAnalysisResult node(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls) {
        if (node == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(5);
        }
        if (nulls == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(6);
        }
        return nulls.get(node);
    }

    private static Collection<PsiElement> group(@NotNull SliceNode node, @NotNull Map<SliceNode, NullAnalysisResult> nulls, int group) {
        if (node == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(7);
        }
        if (nulls == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(8);
        }
        return nulls.get((Object)node).groupedByValue[group];
    }

    @NotNull
    public NullAnalysisResult calcNullableLeaves(@NotNull SliceNode root, @NotNull AbstractTreeStructure treeStructure, final @NotNull Map<SliceNode, NullAnalysisResult> map2) {
        if (root == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(9);
        }
        if (treeStructure == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(10);
        }
        if (map2 == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(11);
        }
        final SliceLeafAnalyzer.SliceNodeGuide guide = new SliceLeafAnalyzer.SliceNodeGuide(treeStructure);
        WalkingState<SliceNode> walkingState = new WalkingState<SliceNode>((WalkingState.TreeGuide)guide){

            public void visit(@NotNull SliceNode element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                element.calculateDupNode();
                HackedSliceNullnessAnalyzerBase.node(element, map2).clear();
                SliceNode duplicate = element.getDuplicate();
                if (duplicate != null) {
                    HackedSliceNullnessAnalyzerBase.node(element, map2).add(HackedSliceNullnessAnalyzerBase.node(duplicate, map2));
                } else {
                    Nullability nullability;
                    PsiElement value = (PsiElement)ReadAction.compute(() -> ((SliceUsage)element.getValue()).getElement());
                    boolean canBeLeaf = (Boolean)ReadAction.compute(() -> ((SliceUsage)element.getValue()).canBeLeaf());
                    Nullability nullability2 = nullability = canBeLeaf ? (Nullability)ReadAction.compute(() -> HackedSliceNullnessAnalyzerBase.this.checkNullability(value)) : Nullability.UNKNOWN;
                    if (nullability == Nullability.NULLABLE) {
                        HackedSliceNullnessAnalyzerBase.group(element, map2, 0).add(value);
                    } else if (nullability == Nullability.NOT_NULL) {
                        HackedSliceNullnessAnalyzerBase.group(element, map2, 1).add(value);
                    } else {
                        Collection children = (Collection)ReadAction.compute(() -> ((SliceNode)element).getChildren());
                        if (children.isEmpty()) {
                            HackedSliceNullnessAnalyzerBase.group(element, map2, 2).add(value);
                        }
                        super.visit((Object)element);
                    }
                }
            }

            public void elementFinished(@NotNull SliceNode element) {
                SliceNode parent;
                if (element == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((parent = guide.getParent(element)) != null) {
                    HackedSliceNullnessAnalyzerBase.node(parent, map2).add(HackedSliceNullnessAnalyzerBase.node(element, map2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "element";
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/slicer/HackedSliceNullnessAnalyzerBase$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visit";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "elementFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        walkingState.visit((Object)root);
        NullAnalysisResult nullAnalysisResult = HackedSliceNullnessAnalyzerBase.node(root, map2);
        if (nullAnalysisResult == null) {
            HackedSliceNullnessAnalyzerBase.$$$reportNull$$$0(12);
        }
        return nullAnalysisResult;
    }

    @NotNull
    protected Nullability checkNullability(PsiElement element) {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafEquality";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/slicer/HackedSliceNullnessAnalyzerBase";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finish";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nulls";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/slicer/HackedSliceNullnessAnalyzerBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNewTree";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "calcNullableLeaves";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 12: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startAnalyzeNullness";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "node";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "group";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "calcNullableLeaves";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 12 -> new IllegalStateException(string);
        };
    }

    public static class NullAnalysisResult {
        static final int NULLS = 0;
        static final int NOT_NULLS = 1;
        static final int UNKNOWNS = 2;
        final Collection<PsiElement>[] groupedByValue = new Collection[]{new LinkedHashSet(), new LinkedHashSet(), new LinkedHashSet()};

        public void clear() {
            for (Collection<PsiElement> elements : this.groupedByValue) {
                elements.clear();
            }
        }

        private void add(NullAnalysisResult duplicate) {
            for (int i2 = 0; i2 < this.groupedByValue.length; ++i2) {
                Collection<PsiElement> elements = this.groupedByValue[i2];
                Collection<PsiElement> other = duplicate.groupedByValue[i2];
                elements.addAll(other);
            }
        }
    }
}

