/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.debugger.KotlinReentrantSourcePosition;
import org.jetbrains.kotlin.idea.debugger.KotlinSourcePositionWithEntireLineHighlighted;
import org.jetbrains.kotlin.idea.debugger.base.util.JvmDebuggerBasePsiUtils;
import org.jetbrains.kotlin.idea.debugger.core.stepping.KotlinSteppingCommandProviderKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0014\u0010\b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter;", "Lcom/intellij/debugger/engine/SourcePositionHighlighter;", "<init>", "()V", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "cutInit", "newStartOffset", "", "cutTail", "newEndOffset", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinSourcePositionHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSourcePositionHighlighter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n66#2,2:77\n1#3:79\n*S KotlinDebug\n*F\n+ 1 KotlinSourcePositionHighlighter.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinSourcePositionHighlighter\n*L\n35#1:77,2\n*E\n"})
public final class KotlinSourcePositionHighlighter
extends SourcePositionHighlighter {
    @Nullable
    public TextRange getHighlightRange(@Nullable SourcePosition sourcePosition) {
        Object object;
        block17: {
            block16: {
                if (sourcePosition == null || sourcePosition instanceof KotlinSourcePositionWithEntireLineHighlighted || sourcePosition instanceof KotlinReentrantSourcePosition) {
                    return null;
                }
                PsiElement psiElement = sourcePosition.getElementAt();
                if (psiElement == null) {
                    return null;
                }
                PsiElement element = psiElement;
                if (JavaLineBreakpointType.isReturnKeyword((PsiElement)element) && element == JavaLineBreakpointType.findSingleConditionalReturn((SourcePosition)sourcePosition)) {
                    return element.getTextRange();
                }
                PsiElement $this$parentOfType_u24default$iv = element;
                boolean withSelf$iv = false;
                boolean $i$f$parentOfType = false;
                object = (KtFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, KtFunction.class, (boolean)true);
                if (object == null) break block16;
                KtFunction it = withSelf$iv = object;
                boolean bl = false;
                object = it instanceof KtFunctionLiteral || it.getName() == null ? withSelf$iv : null;
                if (object != null) break block17;
            }
            return null;
        }
        KtFunction lambda2 = object;
        TextRange lambdaRange = JavaLineBreakpointType.getTextRangeWithoutTrailingComments((PsiElement)((PsiElement)lambda2));
        KtExpression ktExpression = lambda2.getBodyExpression();
        if (ktExpression == null) {
            ktExpression = (KtExpression)lambda2;
        }
        KtExpression body2 = ktExpression;
        TextRange bodyRange = JavaLineBreakpointType.getTextRangeWithoutTrailingComments((PsiElement)((PsiElement)body2));
        if (PsiLinesUtilsKt.isOneLiner((PsiElement)lambda2)) {
            return !bodyRange.isEmpty() ? bodyRange : lambdaRange;
        }
        IntRange intRange = KotlinSteppingCommandProviderKt.getLineRange((PsiElement)lambda2);
        if (intRange == null) {
            return null;
        }
        IntRange lambdaLineRange = intRange;
        PsiFile psiFile = sourcePosition.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        TextRange textRange = JvmDebuggerBasePsiUtils.getRangeOfLine(psiFile, sourcePosition.getLine(), false);
        if (textRange == null) {
            return null;
        }
        TextRange lineRange = textRange;
        TextRange intersection = lineRange.intersection(lambdaRange);
        if (sourcePosition.getLine() == lambdaLineRange.getFirst()) {
            TextRange textRange2;
            if (intersection.contains(bodyRange.getStartOffset())) {
                Intrinsics.checkNotNull((Object)intersection);
                textRange2 = this.cutInit(intersection, bodyRange.getStartOffset());
            } else {
                textRange2 = intersection;
            }
            TextRange onlyBody = textRange2;
            return onlyBody.grown(1);
        }
        if (sourcePosition.getLine() == lambdaLineRange.getLast() && !Intrinsics.areEqual((Object)intersection, (Object)lineRange) && intersection.getLength() > 1) {
            TextRange textRange3;
            if (intersection.contains(bodyRange.getEndOffset())) {
                Intrinsics.checkNotNull((Object)intersection);
                textRange3 = this.cutTail(intersection, bodyRange.getEndOffset());
            } else {
                textRange3 = intersection;
            }
            TextRange onlyBody = textRange3;
            return onlyBody;
        }
        return null;
    }

    private final TextRange cutInit(TextRange $this$cutInit, int newStartOffset) {
        return new TextRange(newStartOffset, $this$cutInit.getEndOffset());
    }

    private final TextRange cutTail(TextRange $this$cutTail, int newEndOffset) {
        return new TextRange($this$cutTail.getStartOffset(), newEndOffset);
    }
}

