/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core.stepping;

import com.intellij.debugger.engine.DebugProcessEvents;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.LocatableEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.stepping.AdditionalProbeBreakpoint;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0001X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/stepping/ClearSteppingBreakpoint;", "Lorg/jetbrains/kotlin/idea/debugger/core/stepping/AdditionalProbeBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "originalThread", "Lcom/sun/jdi/ThreadReference;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/sun/jdi/ThreadReference;)V", "counter", "", "getCounter", "()I", "setCounter", "(I)V", "probeResumeBreakpoint", "getProbeResumeBreakpoint", "()Lorg/jetbrains/kotlin/idea/debugger/core/stepping/AdditionalProbeBreakpoint;", "setProbeResumeBreakpoint", "(Lorg/jetbrains/kotlin/idea/debugger/core/stepping/AdditionalProbeBreakpoint;)V", "value", "", "steppingRemoved", "getSteppingRemoved", "()Z", "processLocatableEvent", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "removeRequestAndStepping", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nCoroutineBreakpointFacility.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/ClearSteppingBreakpoint\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,220:1\n23#2:221\n60#2,5:222\n23#2:227\n23#2:228\n60#2,5:229\n*S KotlinDebug\n*F\n+ 1 CoroutineBreakpointFacility.kt\norg/jetbrains/kotlin/idea/debugger/core/stepping/ClearSteppingBreakpoint\n*L\n189#1:221\n189#1:222,5\n193#1:227\n203#1:228\n203#1:229,5\n*E\n"})
final class ClearSteppingBreakpoint
extends AdditionalProbeBreakpoint {
    @NotNull
    private final ThreadReference originalThread;
    private int counter;
    public AdditionalProbeBreakpoint probeResumeBreakpoint;
    private boolean steppingRemoved;

    public ClearSteppingBreakpoint(@NotNull Project project, @NotNull ThreadReference originalThread) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)originalThread, (String)"originalThread");
        super(project);
        this.originalThread = originalThread;
        this.counter = 1;
    }

    public final int getCounter() {
        return this.counter;
    }

    public final void setCounter(int n) {
        this.counter = n;
    }

    @NotNull
    public final AdditionalProbeBreakpoint getProbeResumeBreakpoint() {
        AdditionalProbeBreakpoint additionalProbeBreakpoint = this.probeResumeBreakpoint;
        if (additionalProbeBreakpoint != null) {
            return additionalProbeBreakpoint;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"probeResumeBreakpoint");
        return null;
    }

    public final void setProbeResumeBreakpoint(@NotNull AdditionalProbeBreakpoint additionalProbeBreakpoint) {
        Intrinsics.checkNotNullParameter((Object)((Object)additionalProbeBreakpoint), (String)"<set-?>");
        this.probeResumeBreakpoint = additionalProbeBreakpoint;
    }

    public final boolean getSteppingRemoved() {
        return this.steppingRemoved;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action2, @Nullable LocatableEvent event) {
        ThreadReference currentThread;
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        int n = this.counter;
        this.counter = n + -1;
        SuspendContextImpl suspendContext = action2.getSuspendContext();
        SuspendContextImpl suspendContextImpl = suspendContext;
        ThreadReference threadReference = suspendContextImpl != null && (suspendContextImpl = suspendContextImpl.getThread()) != null ? suspendContextImpl.getThreadReference() : (currentThread = null);
        if (Intrinsics.areEqual((Object)this.originalThread, (Object)currentThread)) {
            if (this.counter == 0) {
                this.removeRequestAndStepping(suspendContext);
            } else {
                void $this$debug_u24default$iv;
                ClearSteppingBreakpoint $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ClearSteppingBreakpoint.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                $this$thisLogger$iv = logger;
                Throwable e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    void var9_12 = $this$debug_u24default$iv;
                    boolean bl = false;
                    var9_12.debug("Exit from undispatched coroutine in " + currentThread + ", new counter = " + this.counter, e$iv);
                }
            }
        } else {
            ClearSteppingBreakpoint $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ClearSteppingBreakpoint.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Skip remove stepping breakpoint for thread " + this.originalThread.name());
        }
        return false;
    }

    public final void removeRequestAndStepping(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        if (this.steppingRemoved) {
            return;
        }
        this.steppingRemoved = true;
        ClearSteppingBreakpoint $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ClearSteppingBreakpoint.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger $this$debug_u24default$iv = logger;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger2 = $this$debug_u24default$iv;
            boolean bl = false;
            logger2.debug("Remove stepping requests " + suspendContext, e$iv);
        }
        DebugProcessEvents.removeStepRequests((SuspendContextImpl)suspendContext, (ThreadReference)this.originalThread);
        suspendContext.getDebugProcess().getRequestsManager().deleteRequest((Requestor)this);
        suspendContext.getDebugProcess().getRequestsManager().deleteRequest((Requestor)this.getProbeResumeBreakpoint());
    }
}

