/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy.overrides;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.Substitutable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.caches.resolve.util.JavaResolutionUtils;
import org.jetbrains.kotlin.idea.util.TypeUtils;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0010H\u0002J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor;", "Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;", "parentNode", "klass", "Lcom/intellij/psi/PsiElement;", "baseElement", "<init>", "(Lcom/intellij/ide/hierarchy/HierarchyNodeDescriptor;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;)V", "Lcom/intellij/psi/SmartPsiElementPointer;", "rawIcon", "Ljavax/swing/Icon;", "stateIcon", "resolveToDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "psiElement", "getBaseDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getCurrentClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getCurrentDescriptor", "calculateState", "calculateState$kotlin_idea", "update", "", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinOverrideHierarchyNodeDescriptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinOverrideHierarchyNodeDescriptor.kt\norg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,156:1\n1#2:157\n1761#3,3:158\n1321#4,2:161\n*S KotlinDebug\n*F\n+ 1 KotlinOverrideHierarchyNodeDescriptor.kt\norg/jetbrains/kotlin/idea/hierarchy/overrides/KotlinOverrideHierarchyNodeDescriptor\n*L\n72#1:158,3\n130#1:161,2\n*E\n"})
public final class KotlinOverrideHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> baseElement;
    @Nullable
    private Icon rawIcon;
    @Nullable
    private Icon stateIcon;

    public KotlinOverrideHierarchyNodeDescriptor(@Nullable HierarchyNodeDescriptor parentNode, @NotNull PsiElement klass, @NotNull PsiElement baseElement) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter((Object)baseElement, (String)"baseElement");
        super(klass.getProject(), (NodeDescriptor)parentNode, klass, parentNode == null);
        this.baseElement = SmartPointersKt.createSmartPointer((PsiElement)baseElement);
    }

    private final DeclarationDescriptor resolveToDescriptor(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement;
        return psiElement2 instanceof KtNamedDeclaration ? ResolutionUtils.unsafeResolveToDescriptor$default((KtDeclaration)psiElement, null, 1, null) : (psiElement2 instanceof PsiMember ? JavaResolutionUtils.getJavaMemberDescriptor((PsiMember)psiElement) : null);
    }

    private final CallableMemberDescriptor getBaseDescriptor() {
        DeclarationDescriptor declarationDescriptor;
        PsiElement psiElement = this.baseElement.getElement();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            declarationDescriptor = this.resolveToDescriptor(it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        return declarationDescriptor2 instanceof CallableMemberDescriptor ? (CallableMemberDescriptor)declarationDescriptor2 : null;
    }

    private final ClassDescriptor getCurrentClassDescriptor() {
        DeclarationDescriptor declarationDescriptor;
        PsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            declarationDescriptor = this.resolveToDescriptor(it);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
        return declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
    }

    private final CallableMemberDescriptor getCurrentDescriptor() {
        ClassDescriptor classDescriptor = this.getCurrentClassDescriptor();
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        CallableMemberDescriptor callableMemberDescriptor = this.getBaseDescriptor();
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor baseDescriptor = callableMemberDescriptor;
        DeclarationDescriptor declarationDescriptor = baseDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor3 = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor3 == null) {
            return null;
        }
        ClassDescriptor baseClassDescriptor = classDescriptor3;
        SimpleType simpleType = baseClassDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"getDefaultType(...)");
        KotlinType kotlinType = (KotlinType)simpleType;
        SimpleType simpleType2 = classDescriptor2.getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
        LinkedHashMap<TypeConstructor, TypeProjection> linkedHashMap = TypeUtils.getTypeSubstitution(kotlinType, (KotlinType)simpleType2);
        if (linkedHashMap == null) {
            return null;
        }
        LinkedHashMap<TypeConstructor, TypeProjection> substitution2 = linkedHashMap;
        Object t = TypeUtils.substitute((Substitutable)baseDescriptor, (Map<TypeConstructor, ? extends TypeProjection>)substitution2);
        Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.CallableMemberDescriptor");
        return org.jetbrains.kotlin.util.DescriptorUtilsKt.findCallableMemberBySignature$default(classDescriptor2, (CallableMemberDescriptor)t, false, 2, null);
    }

    @Nullable
    public final Icon calculateState$kotlin_idea() {
        boolean bl;
        boolean isAbstractClass;
        block7: {
            ClassDescriptor classDescriptor = this.getCurrentClassDescriptor();
            if (classDescriptor == null) {
                return null;
            }
            ClassDescriptor classDescriptor2 = classDescriptor;
            CallableMemberDescriptor callableMemberDescriptor = this.getCurrentDescriptor();
            if (callableMemberDescriptor == null) {
                return AllIcons.Hierarchy.MethodNotDefined;
            }
            CallableMemberDescriptor callableDescriptor = callableMemberDescriptor;
            if (callableDescriptor.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
                if (callableDescriptor.getModality() == Modality.ABSTRACT) {
                    return null;
                }
                return AllIcons.Hierarchy.MethodDefined;
            }
            isAbstractClass = classDescriptor2.getModality() == Modality.ABSTRACT;
            Set set = DescriptorUtils.getAllOverriddenDeclarations((CallableMemberDescriptor)callableDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllOverriddenDeclarations(...)");
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!(it.getModality() != Modality.ABSTRACT)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasBaseImplementation = bl;
        return isAbstractClass || hasBaseImplementation ? AllIcons.Hierarchy.MethodNotDefined : AllIcons.Hierarchy.ShouldDefineMethod;
    }

    public boolean update() {
        int flags = 1;
        if (this.isMarkReadOnly()) {
            flags |= 2;
        }
        boolean changes = super.update();
        PsiElement classPsi = this.getPsiElement();
        ClassDescriptor classDescriptor = this.getCurrentClassDescriptor();
        if (classPsi == null || classDescriptor == null) {
            String string = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String invalidPrefix = string;
            String string2 = this.myHighlightedText.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (!StringsKt.startsWith$default((String)string2, (String)invalidPrefix, (boolean)false, (int)2, null)) {
                this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
            }
            return true;
        }
        Icon newRawIcon = classPsi.getIcon(flags);
        Icon newStateIcon = this.calculateState$kotlin_idea();
        if (changes || newRawIcon != this.rawIcon || newStateIcon != this.stateIcon) {
            Icon[] icon2;
            changes = true;
            this.rawIcon = newRawIcon;
            this.stateIcon = newStateIcon;
            Icon newIcon = this.rawIcon;
            if (this.myIsBase) {
                icon2 = new LayeredIcon(2);
                icon2.setIcon(newIcon, 0);
                icon2.setIcon(AllIcons.Actions.Forward, 1, -AllIcons.Actions.Forward.getIconWidth() / 2, 0);
                newIcon = (Icon)icon2;
            }
            if (this.stateIcon != null) {
                icon2 = new Icon[]{this.stateIcon, newIcon};
                newIcon = (Icon)new RowIcon(icon2);
            }
            this.setIcon(newIcon);
        }
        CompositeAppearance compositeAppearance = this.myHighlightedText;
        Intrinsics.checkNotNullExpressionValue((Object)compositeAppearance, (String)"myHighlightedText");
        CompositeAppearance oldText = compositeAppearance;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        CompositeAppearance.DequeEnd $this$update_u24lambda_u240 = this.myHighlightedText.getEnding();
        boolean bl = false;
        String string = classDescriptor.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String classDescriptorAsString = string;
        $this$update_u24lambda_u240.addText(classDescriptorAsString, classNameAttributes);
        Sequence $this$forEach$iv = DescriptorUtilsKt.getParents((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DeclarationDescriptor parentDescriptor = (DeclarationDescriptor)element$iv;
            boolean bl2 = false;
            DeclarationDescriptor declarationDescriptor = parentDescriptor;
            if (declarationDescriptor instanceof MemberDescriptor) {
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)((MemberDescriptor)parentDescriptor).getName().asString(), (String)"asString(...)");
                $this$update_u24lambda_u240.addText(KotlinBundle.message((String)"hierarchy.text.in", (Object[])objectArray), classNameAttributes);
                if (!(parentDescriptor instanceof FunctionDescriptor)) continue;
                $this$update_u24lambda_u240.addText("()", classNameAttributes);
                continue;
            }
            if (!(declarationDescriptor instanceof PackageFragmentDescriptor)) continue;
            String parentDescriptorAsString = ((PackageFragmentDescriptor)parentDescriptor).getFqName().asString();
            $this$update_u24lambda_u240.addText("  (" + parentDescriptorAsString + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

