/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.interpreter.StandardDataFlowInterpreter;
import com.intellij.codeInspection.dataFlow.jvm.JvmDfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.UnsatisfiedConditionProblem;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.lang.ir.DataFlowIRProvider;
import com.intellij.codeInspection.dataFlow.lang.ir.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.ThreeState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.base.facet.platform.TargetPlatformDetectorUtils;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.base.util.GenericPsiUtils;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeinsight.api.classic.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinAnchor;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinConstantConditionsInspection$reportProblems$lambda$0$;
import org.jetbrains.kotlin.idea.inspections.dfa.KotlinProblem;
import org.jetbrains.kotlin.idea.inspections.dfa.KtDfaHelpersKt;
import org.jetbrains.kotlin.idea.inspections.dfa.SmartCastHelpersKt;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.intentions.loopToCallChain.CommonUtilsKt;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 *2\u00020\u0001:\u0003()*B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0016H\u0002J\u0018\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u0018\u0010$\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/classic/inspections/AbstractKotlinInspection;", "<init>", "()V", "warnOnConstantRefs", "", "getWarnOnConstantRefs", "()Z", "setWarnOnConstantRefs", "(Z)V", "getOptionsPane", "Lcom/intellij/codeInspection/options/OptPane;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "processDataflowAnalysis", "", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "body", "Lorg/jetbrains/kotlin/psi/KtExpression;", "states", "", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "reportProblems", "listener", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "shouldSuppressForCondition", "loopRange", "shouldReportAsValue", "cv", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "expr", "logicalChain", "shouldSuppressWhenCondition", "condition", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "isLastCondition", "ConstantValue", "KotlinDfaListener", "Companion", "kotlin.idea"})
@SourceDebugExtension(value={"SMAP\nKotlinConstantConditionsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConstantConditionsInspection.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,649:1\n1563#2:650\n1634#2,3:651\n216#3:654\n217#3:661\n216#3,2:662\n477#4:655\n1321#4,2:656\n477#4:658\n1321#4,2:659\n*S KotlinDebug\n*F\n+ 1 KotlinConstantConditionsInspection.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection\n*L\n161#1:650\n161#1:651,3\n174#1:654\n174#1:661\n239#1:662,2\n216#1:655\n218#1:656,2\n221#1:658\n225#1:659,2\n*E\n"})
public final class KotlinConstantConditionsInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean warnOnConstantRefs = true;

    public final boolean getWarnOnConstantRefs() {
        return this.warnOnConstantRefs;
    }

    public final void setWarnOnConstantRefs(boolean bl) {
        this.warnOnConstantRefs = bl;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptRegularComponent[] optRegularComponentArray = new OptRegularComponent[]{OptPane.checkbox((String)"warnOnConstantRefs", (String)JavaAnalysisBundle.message((String)"inspection.data.flow.warn.when.reading.a.value.guaranteed.to.be.constant", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])};
        OptPane optPane = OptPane.pane((OptRegularComponent[])optRegularComponentArray);
        Intrinsics.checkNotNullExpressionValue((Object)optPane, (String)"pane(...)");
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        PsiFile psiFile = holder2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        Module module = GenericPsiUtils.getModule((PsiElement)psiFile);
        if (!(module != null && (module = TargetPlatformDetectorUtils.getPlatform(module)) != null ? JvmPlatformKt.isJvm((TargetPlatform)module) : false)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return (PsiElementVisitor)new KtVisitorVoid(holder2, this){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ KotlinConstantConditionsInspection this$0;
            {
                this.$holder = $holder;
                this.this$0 = $receiver;
            }

            public void visitProperty(KtProperty property) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                if (this.shouldAnalyzeProperty(property)) {
                    KtExpression ktExpression = property.getDelegateExpressionOrInitializer();
                    if (ktExpression == null) {
                        return;
                    }
                    KtExpression initializer2 = ktExpression;
                    this.analyze(initializer2);
                }
            }

            public void visitPropertyAccessor(KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                if (this.shouldAnalyzeProperty(accessor.getProperty())) {
                    KtExpression ktExpression = accessor.getBodyExpression();
                    if (ktExpression == null) {
                        KtBlockExpression ktBlockExpression = accessor.getBodyBlockExpression();
                        if (ktBlockExpression != null) {
                            ktExpression = (KtExpression)ktBlockExpression;
                        } else {
                            return;
                        }
                    }
                    KtExpression bodyExpression = ktExpression;
                    this.analyze(bodyExpression);
                }
            }

            public void visitParameter(KtParameter parameter) {
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                KtExpression ktExpression = parameter.getDefaultValue();
                if (ktExpression == null) {
                    return;
                }
                this.analyze(ktExpression);
            }

            private final boolean shouldAnalyzeProperty(KtProperty property) {
                return property.isTopLevel() || property.getParent() instanceof KtClassBody;
            }

            public void visitClassInitializer(KtClassInitializer initializer2) {
                Intrinsics.checkNotNullParameter((Object)initializer2, (String)"initializer");
                KtExpression ktExpression = initializer2.getBody();
                if (ktExpression == null) {
                    return;
                }
                this.analyze(ktExpression);
            }

            public void visitNamedFunction(KtNamedFunction function) {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                KtExpression ktExpression = function.getBodyExpression();
                if (ktExpression == null) {
                    KtBlockExpression ktBlockExpression = function.getBodyBlockExpression();
                    if (ktBlockExpression != null) {
                        ktExpression = (KtExpression)ktBlockExpression;
                    } else {
                        return;
                    }
                }
                KtExpression body2 = ktExpression;
                this.analyze(body2);
            }

            private final void analyze(KtExpression body2) {
                DfaValueFactory factory2 = new DfaValueFactory(this.$holder.getProject());
                KotlinConstantConditionsInspection.access$processDataflowAnalysis(this.this$0, factory2, body2, this.$holder, CollectionsKt.listOf((Object)new JvmDfaMemoryStateImpl(factory2)));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final void processDataflowAnalysis(DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder2, Collection<? extends DfaMemoryState> states) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ControlFlow controlFlow = DataFlowIRProvider.forElement((PsiElement)((PsiElement)body2), (DfaValueFactory)factory2);
        if (controlFlow == null) {
            return;
        }
        ControlFlow flow = controlFlow;
        KotlinDfaListener listener2 = new KotlinDfaListener();
        StandardDataFlowInterpreter interpreter = new StandardDataFlowInterpreter(flow, (DfaListener)listener2);
        Iterable iterable = states;
        StandardDataFlowInterpreter standardDataFlowInterpreter = interpreter;
        boolean $i$f$map = false;
        void var10_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void s;
            DfaMemoryState dfaMemoryState = (DfaMemoryState)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DfaInstructionState(flow.getInstruction(0), (DfaMemoryState)s));
        }
        if (standardDataFlowInterpreter.interpret((List)destination$iv$iv) != RunnerResult.OK) {
            return;
        }
        this.reportProblems(listener2, holder2);
        for (Map.Entry entry : interpreter.getClosures().entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            PsiElement closure = (PsiElement)entry.getKey();
            Collection closureStates = (Collection)entry.getValue();
            if (!(closure instanceof KtExpression)) continue;
            KtExpression ktExpression = (KtExpression)closure;
            Intrinsics.checkNotNull((Object)closureStates);
            this.processDataflowAnalysis(factory2, ktExpression, holder2, closureStates);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void reportProblems(KotlinDfaListener listener2, ProblemsHolder holder2) {
        KtExpression expr;
        Object object;
        Map.Entry entry;
        Map.Entry element$iv;
        Map $this$forEach$iv = listener2.getConstantConditions();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            String message2;
            ProblemHighlightType highlightType;
            entry = element$iv = iterator2.next();
            boolean bl = false;
            KotlinAnchor anchor = (KotlinAnchor)entry.getKey();
            ConstantValue cv = (ConstantValue)((Object)entry.getValue());
            if (cv == ConstantValue.UNKNOWN) continue;
            object = anchor;
            if (object instanceof KotlinAnchor.KotlinExpressionAnchor) {
                expr = ((KotlinAnchor.KotlinExpressionAnchor)anchor).getExpression();
                if (KotlinConstantConditionsInspection.Companion.shouldSuppress(cv, expr)) continue;
                String key = switch (WhenMappings.$EnumSwitchMapping$0[cv.ordinal()]) {
                    case 1 -> {
                        if (this.shouldReportAsValue(cv, expr)) {
                            yield "inspection.message.value.always.true";
                        }
                        if (this.logicalChain(expr)) {
                            yield "inspection.message.condition.always.true.when.reached";
                        }
                        yield "inspection.message.condition.always.true";
                    }
                    case 2 -> {
                        if (this.shouldReportAsValue(cv, expr)) {
                            yield "inspection.message.value.always.false";
                        }
                        if (this.logicalChain(expr)) {
                            yield "inspection.message.condition.always.false.when.reached";
                        }
                        yield "inspection.message.condition.always.false";
                    }
                    case 3 -> "inspection.message.value.always.null";
                    case 4 -> "inspection.message.value.always.zero";
                    default -> throw new IllegalStateException("Unexpected constant: " + cv);
                };
                ProblemHighlightType problemHighlightType = highlightType = this.shouldReportAsValue(cv, expr) ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (!this.warnOnConstantRefs && highlightType != ProblemHighlightType.GENERIC_ERROR_OR_WARNING) continue;
                PsiElement psiElement = (PsiElement)expr;
                Object[] objectArray = new Object[1];
                Intrinsics.checkNotNullExpressionValue((Object)expr.getText(), (String)"getText(...)");
                holder2.registerProblem(psiElement, KotlinBundle.message((String)key, (Object[])objectArray), highlightType, new LocalQuickFix[0]);
                continue;
            }
            if (object instanceof KotlinAnchor.KotlinWhenConditionAnchor) {
                void $this$forEach$iv2;
                Sequence $this$filterIsInstance$iv;
                KtWhenEntry nextEntry;
                void $this$forEach$iv3;
                Sequence $this$filterIsInstance$iv2;
                KtWhenCondition condition2 = ((KotlinAnchor.KotlinWhenConditionAnchor)anchor).getCondition();
                if (this.shouldSuppressWhenCondition(cv, condition2)) continue;
                message2 = KotlinBundle.message((String)"inspection.message.when.condition.always.false", (Object[])new Object[0]);
                if (cv == ConstantValue.FALSE) {
                    holder2.registerProblem((PsiElement)condition2, message2, new LocalQuickFix[0]);
                    continue;
                }
                if (cv != ConstantValue.TRUE) continue;
                highlightType = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)condition2), (boolean)true, (boolean)false);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv2, (Function1)reportProblems$lambda$0$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv2 = SequencesKt.filter((Sequence)sequence, KotlinConstantConditionsInspection::reportProblems$lambda$0$0);
                boolean $i$f$forEach22 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    KtWhenCondition cond = (KtWhenCondition)element$iv2;
                    boolean bl2 = false;
                    holder2.registerProblem((PsiElement)cond, message2, new LocalQuickFix[0]);
                }
                Iterator iterator3 = condition2.getParent();
                if ((iterator3 instanceof KtWhenEntry ? (KtWhenEntry)iterator3 : null) == null) continue;
                nextEntry = nextEntry;
                Sequence $i$f$forEach22 = PsiTreeUtilKt.siblings((PsiElement)((PsiElement)nextEntry), (boolean)true, (boolean)false);
                boolean $i$f$filterIsInstance2 = false;
                Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)reportProblems$lambda$0$$inlined$filterIsInstance$2.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                $this$filterIsInstance$iv = SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterNot((Sequence)sequence2, KotlinConstantConditionsInspection::reportProblems$lambda$0$2), KotlinConstantConditionsInspection::reportProblems$lambda$0$3), KotlinConstantConditionsInspection::reportProblems$lambda$0$4);
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    KtWhenCondition cond = (KtWhenCondition)element$iv3;
                    boolean bl3 = false;
                    holder2.registerProblem((PsiElement)cond, message2, new LocalQuickFix[0]);
                }
                continue;
            }
            if (object instanceof KotlinAnchor.KotlinForVisitedAnchor) {
                KtExpression loopRange;
                Intrinsics.checkNotNull((Object)((KotlinAnchor.KotlinForVisitedAnchor)anchor).getForExpression().getLoopRange());
                if (cv != ConstantValue.FALSE || this.shouldSuppressForCondition(loopRange)) continue;
                message2 = KotlinBundle.message((String)"inspection.message.for.never.visited", (Object[])new Object[0]);
                holder2.registerProblem((PsiElement)loopRange, message2, new LocalQuickFix[0]);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
        $this$forEach$iv = listener2.getProblems();
        $i$f$forEach = false;
        iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            entry = element$iv = iterator2.next();
            boolean bl = false;
            KotlinProblem problem = (KotlinProblem)entry.getKey();
            ThreeState state = (ThreeState)entry.getValue();
            if (state != ThreeState.YES) continue;
            object = problem;
            if (object instanceof KotlinProblem.KotlinArrayIndexProblem) {
                holder2.registerProblem((PsiElement)((KotlinProblem.KotlinArrayIndexProblem)problem).getIndex(), KotlinBundle.message((String)"inspection.message.index.out.of.bounds", (Object[])new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (object instanceof KotlinProblem.KotlinNullCheckProblem) {
                expr = ((KotlinProblem.KotlinNullCheckProblem)problem).getExpr();
                KtExpression ktExpression = expr.getBaseExpression();
                if (ktExpression != null ? PsiUtilsKt.isNull((KtExpression)ktExpression) : false) continue;
                holder2.registerProblem((PsiElement)expr.getOperationReference(), KotlinBundle.message((String)"inspection.message.nonnull.cast.will.always.fail", (Object[])new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            if (object instanceof KotlinProblem.KotlinCastProblem) {
                KtBinaryExpressionWithTypeRHS ktBinaryExpressionWithTypeRHS = ((KotlinProblem.KotlinCastProblem)problem).getCast();
                Object object2 = ktBinaryExpressionWithTypeRHS instanceof KtBinaryExpressionWithTypeRHS ? ktBinaryExpressionWithTypeRHS : null;
                KtExpression anchor = object2 != null && (object2 = object2.getOperationReference()) != null ? (KtExpression)object2 : (KtExpression)((KotlinProblem.KotlinCastProblem)problem).getCast();
                if (KotlinConstantConditionsInspection.Companion.isCompilationWarning((KtElement)anchor)) continue;
                holder2.registerProblem((PsiElement)anchor, KotlinBundle.message((String)"inspection.message.cast.will.always.fail", (Object[])new Object[0]), new LocalQuickFix[0]);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final boolean shouldSuppressForCondition(KtExpression loopRange) {
        if (loopRange instanceof KtBinaryExpression) {
            KtExpression left = ((KtBinaryExpression)loopRange).getLeft();
            KtExpression right = ((KtBinaryExpression)loopRange).getRight();
            return left != null && right != null && CommonUtilsKt.isConstant(left) && CommonUtilsKt.isConstant(right);
        }
        return false;
    }

    private final boolean shouldReportAsValue(ConstantValue cv, KtExpression expr) {
        if (!(expr instanceof KtSimpleNameExpression || expr instanceof KtQualifiedExpression && ((KtQualifiedExpression)expr).getSelectorExpression() instanceof KtSimpleNameExpression)) {
            return false;
        }
        PsiElement parent = expr.getParent();
        while (parent instanceof KtParenthesizedExpression) {
            parent = ((KtParenthesizedExpression)parent).getParent();
        }
        if (parent instanceof KtBinaryExpression && (cv == ConstantValue.TRUE || cv == ConstantValue.FALSE)) {
            return false;
        }
        if (parent instanceof KtContainerNode && ((KtContainerNode)parent).getParent() instanceof KtIfExpression) {
            return false;
        }
        return !(parent instanceof KtWhenConditionWithExpression);
    }

    private final boolean logicalChain(KtExpression expr) {
        KtExpression context2 = expr;
        PsiElement parent = context2.getParent();
        while (parent instanceof KtParenthesizedExpression) {
            context2 = (KtExpression)parent;
            parent = ((KtParenthesizedExpression)context2).getParent();
        }
        if (parent instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getRight(), (Object)context2)) {
            IElementType iElementType = ((KtBinaryExpression)parent).getOperationToken();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
            IElementType token = iElementType;
            return Intrinsics.areEqual((Object)token, (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)token, (Object)KtTokens.OROR);
        }
        return false;
    }

    private final boolean shouldSuppressWhenCondition(ConstantValue cv, KtWhenCondition condition2) {
        if (cv != ConstantValue.FALSE && cv != ConstantValue.TRUE) {
            return true;
        }
        if (cv == ConstantValue.TRUE && this.isLastCondition(condition2)) {
            return true;
        }
        if (condition2.getTextLength() == 0) {
            return true;
        }
        return KotlinConstantConditionsInspection.Companion.isCompilationWarning((KtElement)condition2);
    }

    private final boolean isLastCondition(KtWhenCondition condition2) {
        PsiElement psiElement = condition2.getParent();
        KtWhenEntry ktWhenEntry = psiElement instanceof KtWhenEntry ? (KtWhenEntry)psiElement : null;
        if (ktWhenEntry == null) {
            return false;
        }
        KtWhenEntry entry = ktWhenEntry;
        PsiElement psiElement2 = entry.getParent();
        KtWhenExpression ktWhenExpression = psiElement2 instanceof KtWhenExpression ? (KtWhenExpression)psiElement2 : null;
        if (ktWhenExpression == null) {
            return false;
        }
        KtWhenExpression whenExpr = ktWhenExpression;
        KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
        if (Intrinsics.areEqual((Object)ArraysKt.last((Object[])ktWhenConditionArray), (Object)condition2)) {
            List list2 = whenExpr.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            List entries = list2;
            KtWhenEntry lastEntry = (KtWhenEntry)CollectionsKt.last((List)entries);
            if (Intrinsics.areEqual((Object)lastEntry, (Object)entry)) {
                return true;
            }
            int size = entries.size();
            if (lastEntry.isElse() && size > 1 && Intrinsics.areEqual(entries.get(size - 2), (Object)entry)) {
                return true;
            }
        }
        return false;
    }

    private static final boolean reportProblems$lambda$0$0(KtWhenCondition cond) {
        Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
        String string = cond.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    private static final boolean reportProblems$lambda$0$2(KtWhenEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return entry.isElse();
    }

    private static final Sequence reportProblems$lambda$0$3(KtWhenEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
        Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
        return ArraysKt.asSequence((Object[])ktWhenConditionArray);
    }

    private static final boolean reportProblems$lambda$0$4(KtWhenCondition cond) {
        String string = cond.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return ((CharSequence)string).length() > 0;
    }

    public static final /* synthetic */ void access$processDataflowAnalysis(KotlinConstantConditionsInspection $this, DfaValueFactory factory2, KtExpression body2, ProblemsHolder holder2, Collection states) {
        $this.processDataflowAnalysis(factory2, body2, holder2, states);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002J#\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0082\u0010J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u001a\u0010\u001f\u001a\u00020\u00052\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u001a\u0010#\u001a\u00020\u00052\b\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0016\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020)2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0018\u0010(\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J \u0010+\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u00101\u001a\u000202H\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$Companion;", "", "<init>", "()V", "areEquivalent", "", "e1", "Lorg/jetbrains/kotlin/psi/KtElement;", "e2", "isOppositeCondition", "candidate", "Lorg/jetbrains/kotlin/psi/KtExpression;", "template", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "expression", "hasOppositeCondition", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "topCondition", "isPairingConditionInWhen", "isCompilationWarning", "anchor", "isCallToMethod", "call", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "packageName", "", "methodName", "isLetConstant", "expr", "isAlsoChain", "isAssertion", "parent", "Lcom/intellij/psi/PsiElement;", "value", "hasWritesTo", "block", "variable", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isUpdateChain", "shouldSuppress", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "isZero", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "isAndOrConditionWithNothingOperand", "token", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "kotlin.idea"})
    @SourceDebugExtension(value={"SMAP\nKotlinConstantConditionsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinConstantConditionsInspection.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,649:1\n1761#2,3:650\n1761#2,3:653\n*S KotlinDebug\n*F\n+ 1 KotlinConstantConditionsInspection.kt\norg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$Companion\n*L\n401#1:650,3\n566#1:653,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean areEquivalent(KtElement e1, KtElement e2) {
            return PsiEquivalenceUtil.areEquivalent((PsiElement)((PsiElement)e1), (PsiElement)((PsiElement)e2), (arg_0, arg_1) -> Companion.areEquivalent$lambda$1(Companion::areEquivalent$lambda$0, arg_0, arg_1), null, null, (boolean)false);
        }

        private final boolean isOppositeCondition(KtExpression candidate, KtBinaryExpression template2, KtExpression expression) {
            Companion companion = this;
            while (candidate instanceof KtBinaryExpression && ((KtBinaryExpression)candidate).getOperationToken() == KtTokens.ANDAND) {
                KtExpression left = ((KtBinaryExpression)candidate).getLeft();
                KtExpression right = ((KtBinaryExpression)candidate).getRight();
                if (left == null || right == null) {
                    return false;
                }
                KtExpression templateLeft = template2.getLeft();
                KtExpression templateRight = template2.getRight();
                if (templateLeft == null || templateRight == null) {
                    return false;
                }
                if (templateRight == expression) {
                    return companion.areEquivalent((KtElement)left, (KtElement)templateLeft) && companion.areEquivalent((KtElement)UtilsKt.negate(right, false), (KtElement)templateRight);
                }
                if (!companion.areEquivalent((KtElement)right, (KtElement)templateRight)) {
                    return false;
                }
                if (templateLeft == expression) {
                    return companion.areEquivalent((KtElement)UtilsKt.negate(left, false), (KtElement)templateLeft);
                }
                if (!(templateLeft instanceof KtBinaryExpression) || ((KtBinaryExpression)templateLeft).getOperationToken() != KtTokens.ANDAND) {
                    return false;
                }
                Companion companion2 = companion;
                KtExpression ktExpression = left;
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)templateLeft;
                KtExpression ktExpression2 = expression;
                companion = companion2;
                candidate = ktExpression;
                template2 = ktBinaryExpression;
                expression = ktExpression2;
            }
            return false;
        }

        private final boolean hasOppositeCondition(KtWhenExpression whenExpression, KtExpression topCondition, KtExpression expression) {
            for (KtWhenEntry entry : whenExpression.getEntries()) {
                KtWhenCondition[] ktWhenConditionArray;
                Intrinsics.checkNotNullExpressionValue((Object)entry.getConditions(), (String)"getConditions(...)");
                for (KtWhenCondition condition2 : ktWhenConditionArray) {
                    if (!(condition2 instanceof KtWhenConditionWithExpression)) continue;
                    KtExpression candidate = ((KtWhenConditionWithExpression)condition2).getExpression();
                    if (candidate == topCondition) {
                        return false;
                    }
                    if (topCondition instanceof KtBinaryExpression && this.isOppositeCondition(candidate, (KtBinaryExpression)topCondition, expression)) {
                        return true;
                    }
                    if (candidate == null || !this.areEquivalent((KtElement)UtilsKt.negate(expression, false), (KtElement)candidate)) continue;
                    return true;
                }
            }
            return false;
        }

        private final boolean isPairingConditionInWhen(KtExpression expression) {
            PsiElement psiElement;
            PsiElement parent = expression.getParent();
            if (parent instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.ANDAND)) {
                PsiElement nextParent;
                KtBinaryExpression topAnd = (KtBinaryExpression)parent;
                while ((nextParent = topAnd.getParent()) instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)nextParent).getOperationToken(), (Object)KtTokens.ANDAND)) {
                    topAnd = (KtBinaryExpression)nextParent;
                }
                PsiElement topAndParent = topAnd.getParent();
                if (topAndParent instanceof KtWhenConditionWithExpression) {
                    KtWhenExpression whenExpression;
                    PsiElement psiElement2 = ((KtWhenConditionWithExpression)topAndParent).getParent();
                    KtWhenEntry ktWhenEntry = psiElement2 instanceof KtWhenEntry ? (KtWhenEntry)psiElement2 : null;
                    psiElement = ktWhenEntry != null ? ktWhenEntry.getParent() : null;
                    KtWhenExpression ktWhenExpression = whenExpression = psiElement instanceof KtWhenExpression ? (KtWhenExpression)psiElement : null;
                    if (whenExpression != null && this.hasOppositeCondition(whenExpression, (KtExpression)topAnd, expression)) {
                        return true;
                    }
                }
            }
            if (parent instanceof KtWhenConditionWithExpression) {
                KtWhenExpression whenExpression;
                psiElement = ((KtWhenConditionWithExpression)parent).getParent();
                KtWhenEntry ktWhenEntry = psiElement instanceof KtWhenEntry ? (KtWhenEntry)psiElement : null;
                PsiElement psiElement3 = ktWhenEntry != null ? ktWhenEntry.getParent() : null;
                KtWhenExpression ktWhenExpression = whenExpression = psiElement3 instanceof KtWhenExpression ? (KtWhenExpression)psiElement3 : null;
                if (whenExpression != null && this.hasOppositeCondition(whenExpression, expression, expression)) {
                    return true;
                }
            }
            return false;
        }

        private final boolean isCompilationWarning(KtElement anchor) {
            boolean bl;
            block4: {
                BindingContext context2 = ResolutionUtils.analyze(anchor, BodyResolveMode.FULL);
                Iterable $this$any$iv = context2.getDiagnostics().forElement((PsiElement)anchor);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Diagnostic it = (Diagnostic)element$iv;
                        boolean bl2 = false;
                        if (!(Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.CAST_NEVER_SUCCEEDS) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_COMPARISON) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.SENSELESS_NULL_IN_WHEN) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.USELESS_IS_CHECK) || Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.DUPLICATE_LABEL_IN_WHEN))) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
            PsiFile rootElement = anchor.getContainingFile();
            Project project = anchor.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KotlinSuppressCache suppressionCache = KotlinCacheService.Companion.getInstance(project).getSuppressionCache();
            Intrinsics.checkNotNull((Object)rootElement);
            return suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "CAST_NEVER_SUCCEEDS", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_COMPARISON", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "SENSELESS_NULL_IN_WHEN", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "USELESS_IS_CHECK", Severity.WARNING) || suppressionCache.isSuppressed((Object)anchor, (Object)rootElement, "DUPLICATE_LABEL_IN_WHEN", Severity.WARNING);
        }

        private final boolean isCallToMethod(KtCallExpression call2, String packageName, String methodName) {
            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)call2, null, 1, null);
            if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
                return false;
            }
            ResolvedCall descriptor2 = resolvedCall;
            if (!Intrinsics.areEqual((Object)descriptor2.getName().asString(), (Object)methodName)) {
                return false;
            }
            DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
            PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
            if (packageFragmentDescriptor == null) {
                return false;
            }
            PackageFragmentDescriptor packageFragment2 = packageFragmentDescriptor;
            return Intrinsics.areEqual((Object)packageFragment2.getFqName().asString(), (Object)packageName);
        }

        private final boolean isLetConstant(KtExpression expr) {
            KtQualifiedExpression ktQualifiedExpression = expr instanceof KtQualifiedExpression ? (KtQualifiedExpression)expr : null;
            KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call2 = ktCallExpression;
            if (!this.isCallToMethod(call2, "kotlin", "let")) {
                return false;
            }
            KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)call2.getLambdaArguments());
            if (ktLambdaArgument == null || (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) == null) {
                return false;
            }
            KtLambdaArgument lambda2 = ktLambdaArgument;
            Object object = lambda2.getBodyExpression();
            return (object != null && (object = object.getStatements()) != null ? (KtExpression)CollectionsKt.singleOrNull((List)object) : null) instanceof KtConstantExpression;
        }

        private final boolean isAlsoChain(KtExpression expr) {
            KtQualifiedExpression ktQualifiedExpression = expr instanceof KtQualifiedExpression ? (KtQualifiedExpression)expr : null;
            KtExpression ktExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getSelectorExpression() : null;
            KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression call2 = ktCallExpression;
            return this.isCallToMethod(call2, "kotlin", "also");
        }

        private final boolean isAssertion(PsiElement parent, boolean value) {
            boolean bl;
            PsiElement psiElement = parent;
            if (psiElement instanceof KtBinaryExpression) {
                bl = (Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.ANDAND) || Intrinsics.areEqual((Object)((KtBinaryExpression)parent).getOperationToken(), (Object)KtTokens.OROR)) && this.isAssertion(((KtBinaryExpression)parent).getParent(), value);
            } else if (psiElement instanceof KtParenthesizedExpression) {
                bl = this.isAssertion(((KtParenthesizedExpression)parent).getParent(), value);
            } else if (psiElement instanceof KtPrefixExpression) {
                bl = Intrinsics.areEqual((Object)((KtPrefixExpression)parent).getOperationToken(), (Object)KtTokens.EXCL) && this.isAssertion(((KtPrefixExpression)parent).getParent(), !value);
            } else {
                if (psiElement instanceof KtValueArgument) {
                    if (!value) {
                        return false;
                    }
                    PsiElement psiElement2 = ((KtValueArgument)parent).getParent();
                    KtValueArgumentList ktValueArgumentList = psiElement2 instanceof KtValueArgumentList ? (KtValueArgumentList)psiElement2 : null;
                    if (ktValueArgumentList == null) {
                        return false;
                    }
                    KtValueArgumentList valueArgList = ktValueArgumentList;
                    PsiElement psiElement3 = valueArgList.getParent();
                    KtCallExpression ktCallExpression = psiElement3 instanceof KtCallExpression ? (KtCallExpression)psiElement3 : null;
                    if (ktCallExpression == null) {
                        return false;
                    }
                    KtCallExpression call2 = ktCallExpression;
                    ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)call2, null, 1, null);
                    if (resolvedCall == null || (resolvedCall = resolvedCall.getResultingDescriptor()) == null) {
                        return false;
                    }
                    ResolvedCall descriptor2 = resolvedCall;
                    String string = descriptor2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    String name2 = string;
                    if (!(Intrinsics.areEqual((Object)name2, (Object)"assert") || Intrinsics.areEqual((Object)name2, (Object)"require") || Intrinsics.areEqual((Object)name2, (Object)"check"))) {
                        return false;
                    }
                    DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
                    PackageFragmentDescriptor packageFragmentDescriptor = declarationDescriptor instanceof PackageFragmentDescriptor ? (PackageFragmentDescriptor)declarationDescriptor : null;
                    if (packageFragmentDescriptor == null) {
                        return false;
                    }
                    PackageFragmentDescriptor pkg = packageFragmentDescriptor;
                    return Intrinsics.areEqual((Object)pkg.getFqName().asString(), (Object)"kotlin");
                }
                bl = false;
            }
            return bl;
        }

        private final boolean hasWritesTo(PsiElement block, KtProperty variable) {
            return !PsiTreeUtil.processElements((PsiElement)block, KtSimpleNameExpression.class, (PsiElementProcessor)new PsiElementProcessor(variable){
                final /* synthetic */ KtProperty $variable;
                {
                    this.$variable = $variable;
                }

                public final boolean execute(KtSimpleNameExpression ref) {
                    Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                    boolean write = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)ref).isReferenceTo((PsiElement)this.$variable) && ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)ref), (boolean)false).isWrite();
                    return !write;
                }
            });
        }

        private final boolean isUpdateChain(KtExpression expression) {
            if (!(expression instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement = ((KtSimpleNameExpression)expression).getParent();
            KtBinaryExpression ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
            if (ktBinaryExpression == null) {
                return false;
            }
            KtBinaryExpression binOp = ktBinaryExpression;
            String op = binOp.getOperationReference().getText();
            if (!(Intrinsics.areEqual((Object)op, (Object)"or") || Intrinsics.areEqual((Object)op, (Object)"and") || Intrinsics.areEqual((Object)op, (Object)"xor") || Intrinsics.areEqual((Object)op, (Object)"||") || Intrinsics.areEqual((Object)op, (Object)"&&"))) {
                return false;
            }
            PsiElement psiElement2 = binOp.getParent();
            KtBinaryExpression ktBinaryExpression2 = psiElement2 instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement2 : null;
            if (ktBinaryExpression2 == null) {
                return false;
            }
            KtBinaryExpression assignment2 = ktBinaryExpression2;
            if (!Intrinsics.areEqual((Object)assignment2.getOperationToken(), (Object)KtTokens.EQ)) {
                return false;
            }
            KtExpression left = assignment2.getLeft();
            if (!(left instanceof KtSimpleNameExpression) || !((KtSimpleNameExpression)left).textMatches((CharSequence)((KtSimpleNameExpression)expression).getText())) {
                return false;
            }
            PsiElement psiElement3 = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression)).resolve();
            KtProperty ktProperty = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
            if (ktProperty == null) {
                return false;
            }
            KtProperty variable = ktProperty;
            PsiElement psiElement4 = variable.getParent();
            KtBlockExpression ktBlockExpression = psiElement4 instanceof KtBlockExpression ? (KtBlockExpression)psiElement4 : null;
            if (ktBlockExpression == null) {
                return false;
            }
            KtBlockExpression varParent = ktBlockExpression;
            PsiElement context2 = (PsiElement)assignment2;
            PsiElement block = context2.getParent();
            while (true) {
                block15: {
                    block16: {
                        if (block instanceof KtContainerNode) break block15;
                        if (!(block instanceof KtBlockExpression)) break block16;
                        List list2 = ((KtBlockExpression)block).getStatements();
                        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                        if (Intrinsics.areEqual((Object)CollectionsKt.first((List)list2), (Object)context2)) break block15;
                    }
                    if (!(block instanceof KtIfExpression)) break;
                    KtExpression ktExpression = ((KtIfExpression)block).getThen();
                    if (!Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getParent() : null), (Object)context2) || ((KtIfExpression)block).getElse() != null || this.hasWritesTo((PsiElement)((KtIfExpression)block).getCondition(), variable)) break;
                }
                context2 = block;
                block = ((KtElement)context2).getParent();
            }
            if (block != varParent) {
                return false;
            }
            PsiElement curExpression = variable.getNextSibling();
            while (!Intrinsics.areEqual((Object)curExpression, (Object)context2)) {
                if (this.hasWritesTo(curExpression, variable)) {
                    return false;
                }
                curExpression = curExpression.getNextSibling();
            }
            return true;
        }

        public final boolean shouldSuppress(@NotNull DfType value, @NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            DfType dfType = value;
            ConstantValue constant = Intrinsics.areEqual((Object)dfType, (Object)DfTypes.NULL) ? ConstantValue.NULL : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : (Intrinsics.areEqual((Object)dfType, (Object)DfTypes.intValue((int)0)) || Intrinsics.areEqual((Object)dfType, (Object)DfTypes.longValue((long)0L)) ? ConstantValue.ZERO : ConstantValue.UNKNOWN)));
            return this.shouldSuppress(constant, expression);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean shouldSuppress(ConstantValue value, KtExpression expression) {
            PsiElement target;
            PsiElement psiElement;
            PsiElement parent = expression.getParent();
            if (parent instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent).getSelectorExpression(), (Object)expression)) {
                return true;
            }
            while (parent instanceof KtParenthesizedExpression) {
                parent = ((KtParenthesizedExpression)parent).getParent();
            }
            if (expression instanceof KtConstantExpression) return true;
            if (expression instanceof KtProperty) return true;
            if (expression instanceof KtBinaryExpression) {
                if (Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)KtTokens.EQ)) return true;
            }
            KtPrefixExpression ktPrefixExpression = (psiElement = parent) instanceof KtPrefixExpression ? (KtPrefixExpression)psiElement : null;
            if (Intrinsics.areEqual((Object)(ktPrefixExpression != null ? ktPrefixExpression.getOperationToken() : null), (Object)KtTokens.EXCL)) {
                return true;
            }
            if (expression instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)KtTokens.ELVIS)) {
                boolean bl;
                KtExpression ktExpression = ((KtBinaryExpression)expression).getLeft();
                if (ktExpression != null && (ktExpression = KtDfaHelpersKt.getKotlinType(ktExpression)) != null) {
                    if (TypeUtilsKt.isNullableNothing((KotlinType)ktExpression)) {
                        return true;
                    }
                    bl = false;
                } else {
                    bl = false;
                }
                if (bl) {
                    return true;
                }
            }
            if (this.isAlsoChain(expression)) return true;
            if (this.isLetConstant(expression)) return true;
            if (this.isUpdateChain(expression)) {
                return true;
            }
            KotlinType kotlinType = KtDfaHelpersKt.getKotlinType(expression);
            if (kotlinType == null) {
                return false;
            }
            KotlinType kotlinType2 = kotlinType;
            switch (WhenMappings.$EnumSwitchMapping$0[value.ordinal()]) {
                case 1: {
                    KtSingleValueToken ktSingleValueToken = KtTokens.OROR;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"OROR");
                    if (this.isAndOrConditionWithNothingOperand(expression, ktSingleValueToken)) {
                        return true;
                    }
                    if (SmartCastHelpersKt.isSmartCastNecessary(expression, true)) {
                        return true;
                    }
                    if (this.isPairingConditionInWhen(expression)) {
                        return true;
                    }
                    if (!this.isAssertion(parent, true)) break;
                    return true;
                }
                case 2: {
                    KtSingleValueToken ktSingleValueToken = KtTokens.ANDAND;
                    Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"ANDAND");
                    if (this.isAndOrConditionWithNothingOperand(expression, ktSingleValueToken)) {
                        return true;
                    }
                    if (SmartCastHelpersKt.isSmartCastNecessary(expression, false)) {
                        return true;
                    }
                    if (!this.isAssertion(parent, false)) break;
                    return true;
                }
                case 3: {
                    BindingContext bindingContext;
                    if (ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)expression, (boolean)false).isWrite()) {
                        return true;
                    }
                    if (expression instanceof KtDotQualifiedExpression) {
                        KtExpression ktExpression = ((KtDotQualifiedExpression)expression).getSelectorExpression();
                        boolean bl = ktExpression != null ? ktExpression.textMatches((CharSequence)"ordinal") : false;
                        if (bl) {
                            KtExpression receiver2 = ((KtDotQualifiedExpression)expression).getReceiverExpression();
                            if (receiver2 instanceof KtQualifiedExpression) {
                                receiver2 = ((KtQualifiedExpression)receiver2).getSelectorExpression();
                            }
                            if (receiver2 instanceof KtSimpleNameExpression) {
                                boolean bl2;
                                void $this$any$iv;
                                Iterable iterable = ReferenceUtilKt.resolveMainReferenceToDescriptors((KtElement)receiver2);
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl2 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        DeclarationDescriptor desc = (DeclarationDescriptor)element$iv;
                                        boolean bl3 = false;
                                        if (desc instanceof ClassDescriptor && ((ClassDescriptor)desc).getKind() == ClassKind.ENUM_ENTRY) {
                                            return true;
                                        }
                                        boolean bl4 = false;
                                        if (!bl4) continue;
                                        return true;
                                    }
                                    bl2 = false;
                                }
                                if (bl2) {
                                    return true;
                                }
                            }
                        }
                    }
                    if (ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext = ResolutionUtils.analyze$default((KtElement)expression, null, 1, null)) != null) {
                        return true;
                    }
                    if (expression instanceof KtSimpleNameExpression) {
                        if (parent instanceof KtValueArgument) return true;
                        if (parent instanceof KtContainerNode && ((KtContainerNode)parent).getParent() instanceof KtArrayAccessExpression) {
                            return true;
                        }
                    }
                    if (!(parent instanceof KtBinaryExpression)) break;
                    IElementType iElementType = ((KtBinaryExpression)parent).getOperationToken();
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
                    IElementType token = iElementType;
                    if (token != KtTokens.EQEQ && token != KtTokens.EXCLEQ && token != KtTokens.EQEQEQ && token != KtTokens.EXCLEQEQEQ) break;
                    KtExpression left = ((KtBinaryExpression)parent).getLeft();
                    if (left != null && this.isZero(left, bindingContext, kotlinType2)) {
                        return true;
                    }
                    KtExpression right = ((KtBinaryExpression)parent).getRight();
                    if (right == null || !this.isZero(right, bindingContext, kotlinType2)) break;
                    return true;
                }
                case 4: {
                    KotlinType expectedType;
                    if (parent instanceof KtProperty && ((KtProperty)parent).getTypeReference() == null && expression instanceof KtSimpleNameExpression) {
                        return true;
                    }
                    if (kotlinType2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)(expectedType = (KotlinType)ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.FULL).get((ReadOnlySlice)BindingContext.EXPECTED_EXPRESSION_TYPE, (Object)expression)), (Object)kotlinType2)) {
                        return true;
                    }
                    if (expression instanceof KtBinaryExpressionWithTypeRHS) {
                        KtExpression ktExpression = ((KtBinaryExpressionWithTypeRHS)expression).getLeft();
                        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeft(...)");
                        if (PsiUtilsKt.isNull((KtExpression)ktExpression)) {
                            return true;
                        }
                    }
                    if (parent instanceof KtBinaryExpression) {
                        IElementType iElementType = ((KtBinaryExpression)parent).getOperationToken();
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getOperationToken(...)");
                        IElementType token = iElementType;
                        if (token == KtTokens.EQEQ || token == KtTokens.EXCLEQ || token == KtTokens.EQEQEQ || token == KtTokens.EXCLEQEQEQ) {
                            boolean bl;
                            boolean bl5;
                            KtExpression ktExpression = ((KtBinaryExpression)parent).getLeft();
                            if (ktExpression != null) {
                                if (PsiUtilsKt.isNull((KtExpression)ktExpression)) {
                                    return true;
                                }
                                bl5 = false;
                            } else {
                                bl5 = false;
                            }
                            if (bl5) return true;
                            KtExpression ktExpression2 = ((KtBinaryExpression)parent).getRight();
                            if (ktExpression2 != null) {
                                if (PsiUtilsKt.isNull((KtExpression)ktExpression2)) {
                                    return true;
                                }
                                bl = false;
                            } else {
                                bl = false;
                            }
                            if (bl) {
                                return true;
                            }
                        }
                    }
                    if (!Intrinsics.areEqual((Object)KtDfaHelpersKt.toDfType(kotlinType2), (Object)DfTypes.NULL)) break;
                    return true;
                }
            }
            if (expression instanceof KtSimpleNameExpression && (target = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)((KtSimpleNameExpression)expression)).resolve()) instanceof KtProperty && !((KtProperty)target).isVar() && ((KtProperty)target).getInitializer() instanceof KtConstantExpression) {
                return true;
            }
            if (!this.isCompilationWarning((KtElement)expression)) return BindingContextUtilsKt.isUsedAsStatement((KtExpression)expression, (BindingContext)ResolutionUtils.analyze((KtElement)expression, BodyResolveMode.FULL));
            return true;
        }

        private final boolean isZero(KtExpression expr, BindingContext bindingContext, KotlinType kotlinType) {
            Object value;
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expr, bindingContext);
            Object object = value = compileTimeConstant != null ? compileTimeConstant.getValue(kotlinType) : null;
            return value instanceof Number && ((Number)value).doubleValue() == 0.0;
        }

        private final boolean isAndOrConditionWithNothingOperand(KtExpression expression, KtSingleValueToken token) {
            if (!(expression instanceof KtBinaryExpression) || !Intrinsics.areEqual((Object)((KtBinaryExpression)expression).getOperationToken(), (Object)token)) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)expression).getRight();
            KotlinType type2 = ktExpression != null ? KtDfaHelpersKt.getKotlinType(ktExpression) : null;
            return type2 != null && TypeUtilsKt.isNothing((KotlinType)type2);
        }

        private static final boolean areEquivalent$lambda$0(PsiReference ref1, PsiReference ref2) {
            return ref1.getElement().getText().equals(ref2.getElement().getText());
        }

        private static final boolean areEquivalent$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (Boolean)$tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ConstantValue.values().length];
                try {
                    nArray[ConstantValue.TRUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.FALSE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.ZERO.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ConstantValue.NULL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "", "<init>", "(Ljava/lang/String;I)V", "TRUE", "FALSE", "NULL", "ZERO", "UNKNOWN", "kotlin.idea"})
    private static final class ConstantValue
    extends Enum<ConstantValue> {
        public static final /* enum */ ConstantValue TRUE = new ConstantValue();
        public static final /* enum */ ConstantValue FALSE = new ConstantValue();
        public static final /* enum */ ConstantValue NULL = new ConstantValue();
        public static final /* enum */ ConstantValue ZERO = new ConstantValue();
        public static final /* enum */ ConstantValue UNKNOWN = new ConstantValue();
        private static final /* synthetic */ ConstantValue[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConstantValue[] values() {
            return (ConstantValue[])$VALUES.clone();
        }

        public static ConstantValue valueOf(String value) {
            return Enum.valueOf(ConstantValue.class, value);
        }

        @NotNull
        public static EnumEntries<ConstantValue> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = constantValueArray = new ConstantValue[]{ConstantValue.TRUE, ConstantValue.FALSE, ConstantValue.NULL, ConstantValue.ZERO, ConstantValue.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J(\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R-\u0010\u0004\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR-\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u0005j\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$KotlinDfaListener;", "Lcom/intellij/codeInspection/dataFlow/lang/DfaListener;", "<init>", "()V", "constantConditions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinAnchor;", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinConstantConditionsInspection$ConstantValue;", "Lkotlin/collections/HashMap;", "getConstantConditions", "()Ljava/util/HashMap;", "problems", "Lorg/jetbrains/kotlin/idea/inspections/dfa/KotlinProblem;", "Lcom/intellij/util/ThreeState;", "getProblems", "beforePush", "", "args", "", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "value", "anchor", "Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "([Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/value/DfaValue;Lcom/intellij/codeInspection/dataFlow/lang/DfaAnchor;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;)V", "onCondition", "problem", "Lcom/intellij/codeInspection/dataFlow/lang/UnsatisfiedConditionProblem;", "failed", "recordExpressionValue", "kotlin.idea"})
    private static final class KotlinDfaListener
    implements DfaListener {
        @NotNull
        private final HashMap<KotlinAnchor, ConstantValue> constantConditions = new HashMap();
        @NotNull
        private final HashMap<KotlinProblem, ThreeState> problems = new HashMap();

        @NotNull
        public final HashMap<KotlinAnchor, ConstantValue> getConstantConditions() {
            return this.constantConditions;
        }

        @NotNull
        public final HashMap<KotlinProblem, ThreeState> getProblems() {
            return this.problems;
        }

        public void beforePush(@NotNull DfaValue[] args, @NotNull DfaValue value, @NotNull DfaAnchor anchor, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (anchor instanceof KotlinAnchor) {
                this.recordExpressionValue((KotlinAnchor)anchor, state, value);
            }
        }

        public void onCondition(@NotNull UnsatisfiedConditionProblem problem, @NotNull DfaValue value, @NotNull ThreeState failed, @NotNull DfaMemoryState state) {
            Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)failed, (String)"failed");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (problem instanceof KotlinProblem) {
                this.problems.merge((KotlinProblem)problem, failed, (arg_0, arg_1) -> KotlinDfaListener.onCondition$lambda$0(onCondition.1.INSTANCE, arg_0, arg_1));
            }
        }

        private final void recordExpressionValue(KotlinAnchor anchor, DfaMemoryState state, DfaValue value) {
            Number constVal;
            ConstantValue newVal;
            ConstantValue oldVal = this.constantConditions.get(anchor);
            if (oldVal == ConstantValue.UNKNOWN) {
                return;
            }
            DfType dfType = state.getDfType(value);
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
            DfType dfType2 = dfType;
            ConstantValue constantValue = Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.TRUE) ? ConstantValue.TRUE : (Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.FALSE) ? ConstantValue.FALSE : (Intrinsics.areEqual((Object)dfType2, (Object)DfTypes.NULL) ? ConstantValue.NULL : (newVal = (constVal = (Number)dfType2.getConstantOfType(Number.class)) != null && (Intrinsics.areEqual((Object)constVal, (Object)0) || Intrinsics.areEqual((Object)constVal, (Object)0L)) ? ConstantValue.ZERO : ConstantValue.UNKNOWN)));
            if (oldVal != null && oldVal != newVal) {
                newVal = ConstantValue.UNKNOWN;
            }
            ((Map)this.constantConditions).put(anchor, newVal);
        }

        private static final ThreeState onCondition$lambda$0(Function2 $tmp0, Object p0, Object p1) {
            return (ThreeState)$tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConstantValue.values().length];
            try {
                nArray[ConstantValue.TRUE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.FALSE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConstantValue.ZERO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

