/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.jvmDecompiler;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.dummy.DummyFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.KotlinDefaultHighlightingSettingsProviderKt;
import org.jetbrains.kotlin.idea.jvm.shared.internal.DecompileFailedException;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinBytecodeDecompiler;
import org.jetbrains.kotlin.idea.jvmDecompiler.KotlinJvmDecompilerBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompilerTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "<init>", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "decompiledText", "", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onSuccess", "generateDecompiledVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getOrCreateDummyRoot", "Companion", "intellij.kotlin.jvm.decompiler"})
@ApiStatus.Internal
public final class KotlinBytecodeDecompilerTask
extends Task.Backgroundable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile file;
    @Nullable
    private String decompiledText;
    @NotNull
    public static final String KOTLIN_DECOMPILED_FOLDER = "kotlinDecompiled";
    @NotNull
    public static final String KOTLIN_DECOMPILED_ROOT = "dummy://kotlinDecompiled";

    public KotlinBytecodeDecompilerTask(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(file.getProject(), KotlinJvmDecompilerBundle.message("internal.action.text.decompile.kotlin.bytecode", new Object[0]));
        this.file = file;
    }

    public void run(@NotNull ProgressIndicator indicator) {
        KotlinBytecodeDecompilerTask kotlinBytecodeDecompilerTask;
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Object object = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.file.getName(), (String)"getName(...)");
        indicator.setText(KotlinJvmDecompilerBundle.message("internal.indicator.text.decompiling", object));
        KotlinBytecodeDecompilerTask kotlinBytecodeDecompilerTask2 = this;
        try {
            kotlinBytecodeDecompilerTask = kotlinBytecodeDecompilerTask2;
            object = KotlinBytecodeDecompiler.INSTANCE.decompile(this.file);
        }
        catch (DecompileFailedException decompileFailedException) {
            kotlinBytecodeDecompilerTask = kotlinBytecodeDecompilerTask2;
            object = null;
        }
        kotlinBytecodeDecompilerTask.decompiledText = object;
    }

    public void onSuccess() {
        if (!this.file.isValid()) {
            return;
        }
        String text = this.decompiledText;
        if (text != null) {
            VirtualFile decompiledVirtualFile = this.generateDecompiledVirtualFile(text);
            new OpenFileDescriptor(this.file.getProject(), decompiledVirtualFile).navigate(true);
        } else {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.file.getName(), (String)"getName(...)");
            Messages.showErrorDialog((String)KotlinJvmDecompilerBundle.message("internal.error.text.cannot.decompile", objectArray), (String)KotlinJvmDecompilerBundle.message("internal.title.decompiler.error", new Object[0]));
        }
    }

    @NotNull
    public final VirtualFile generateDecompiledVirtualFile(@NotNull String decompiledText) {
        Intrinsics.checkNotNullParameter((Object)decompiledText, (String)"decompiledText");
        VirtualFile virtualFile = (VirtualFile)ActionsKt.runWriteAction(() -> KotlinBytecodeDecompilerTask.generateDecompiledVirtualFile$lambda$0(this, decompiledText));
        KotlinDefaultHighlightingSettingsProviderKt.setKotlinDecompiledFile(virtualFile, true);
        return virtualFile;
    }

    private final VirtualFile getOrCreateDummyRoot() {
        VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByUrl(KOTLIN_DECOMPILED_ROOT);
        if (virtualFile == null) {
            VirtualFile virtualFile2 = DummyFileSystem.getInstance().createRoot(KOTLIN_DECOMPILED_FOLDER);
            virtualFile = virtualFile2;
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"createRoot(...)");
        }
        return virtualFile;
    }

    private static final VirtualFile generateDecompiledVirtualFile$lambda$0(KotlinBytecodeDecompilerTask this$0, String $decompiledText) {
        VirtualFile root = this$0.getOrCreateDummyRoot();
        String decompiledFileName = FileUtil.getNameWithoutExtension((String)this$0.file.getName()) + ".decompiled.java";
        VirtualFile virtualFile = DummyFileSystem.getInstance().createChildFile(null, root, decompiledFileName);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"createChildFile(...)");
        VirtualFile result2 = virtualFile;
        VfsUtil.saveText((VirtualFile)result2, (String)$decompiledText);
        return result2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/jvmDecompiler/KotlinBytecodeDecompilerTask$Companion;", "", "<init>", "()V", "KOTLIN_DECOMPILED_FOLDER", "", "KOTLIN_DECOMPILED_ROOT", "intellij.kotlin.jvm.decompiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

