/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.jvm.actions.CreateConstructorRequest;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.k2.codeinsight.quickFixes.createFromUsage.AddConstructorFixKt;
import org.jetbrains.kotlin.idea.quickfix.createFromUsage.CreateFromUsageUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassKt;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\r\u0010\u0010\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0007\u00a2\u0006\u0002\b\u0013H\u0016J$\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/quickFixes/createFromUsage/AddConstructorFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "element", "Lorg/jetbrains/kotlin/psi/KtClass;", "request", "Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "text", "", "<init>", "(Lorg/jetbrains/kotlin/psi/KtClass;Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;Ljava/lang/String;)V", "getRequest", "()Lcom/intellij/lang/jvm/actions/CreateConstructorRequest;", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "startInWriteAction", "", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getText", "Lcom/intellij/codeInspection/util/IntentionName;", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.kotlin.codeInsight"})
public final class AddConstructorFix
implements IntentionAction {
    @NotNull
    private final CreateConstructorRequest request;
    @NotNull
    private final String text;
    @NotNull
    private final SmartPsiElementPointer<KtClass> pointer;

    public AddConstructorFix(@NotNull KtClass element, @NotNull CreateConstructorRequest request, @IntentionName @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.request = request;
        this.text = text;
        this.pointer = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)element));
    }

    @NotNull
    public final CreateConstructorRequest getRequest() {
        return this.request;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"add.method", (Object[])new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.text;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.pointer.getElement() != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtClass ktClass = (KtClass)this.pointer.getElement();
        if (ktClass == null) {
            return;
        }
        KtClass targetClass = ktClass;
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        boolean needPrimary = !targetClass.hasExplicitPrimaryConstructor();
        String constructorText = AddConstructorFixKt.access$buildConstructorAsString(targetClass, this.request, psiFactory);
        if (needPrimary) {
            KtPrimaryConstructor newPrimaryConstructor = psiFactory.createPrimaryConstructor(constructorText);
            PsiElement psiElement = KtClassKt.createPrimaryConstructorIfAbsent((KtClass)targetClass).replace((PsiElement)newPrimaryConstructor);
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtPrimaryConstructor");
            KtPrimaryConstructor replacedConstructor = (KtPrimaryConstructor)psiElement;
            replacedConstructor.removeRedundantConstructorKeywordAndSpace();
        } else {
            KtSecondaryConstructor newSecondaryConstructor = psiFactory.createSecondaryConstructor(constructorText);
            CreateFromUsageUtil.placeDeclarationInContainer$default(CreateFromUsageUtil.INSTANCE, (KtNamedDeclaration)newSecondaryConstructor, (PsiElement)targetClass, null, null, 8, null);
        }
    }
}

