/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.idea.base.psi.KotlinPsiModificationUtils;
import org.jetbrains.kotlin.idea.codeinsights.impl.base.inspections.OperatorToFunctionConverter;
import org.jetbrains.kotlin.idea.kdoc.KDocElementFactory;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.rename.KotlinAwareJavaGetterRenameProcessorKt;
import org.jetbrains.kotlin.idea.references.AbstractKtReference;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.KtArrayAccessReference;
import org.jetbrains.kotlin.idea.references.KtDefaultAnnotationArgumentReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceMutateService;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.idea.references.ReadWriteAccessCheckerKt;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocName;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.PropertiesConventionUtilKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.plugin.references.SimpleNameReferenceExtension;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclarationContainer;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.DataClassResolver;
import org.jetbrains.kotlin.resolve.references.ReferenceAccess;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\"\u0010\u0013\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H&J,\u0010\u0017\u001a\u00020\u0015*\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u0015H\u0002J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0014\u0010\u001f\u001a\u00020\u0015*\u00020 2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u0005*\u00020!2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\"2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u001f\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0014\u0010\u001f\u001a\u00020#*\u00020$2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020'0&2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H&J\u0012\u0010.\u001a\u0004\u0018\u00010\u00152\u0006\u0010/\u001a\u000200H\u0004J\u001c\u00101\u001a\u00020\u0015*\n\u0012\u0006\b\u0001\u0012\u00020\u0015022\u0006\u0010\u001a\u001a\u00020\u0010H\u0002\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "<init>", "()V", "bindToElement", "Lcom/intellij/psi/PsiElement;", "simpleNameReference", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "element", "shorteningMode", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference$ShorteningMode;", "getAdjustedNewName", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "newElementName", "", "renameToOrdinaryMethod", "Lorg/jetbrains/kotlin/psi/KtElement;", "suggestVariableName", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "createCall", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "newName", "argument", "handleElementRename", "ktReference", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "renameTo", "Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference;", "Lorg/jetbrains/kotlin/idea/references/KDocReference;", "Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "Lorg/jetbrains/kotlin/idea/references/KtDefaultAnnotationArgumentReference;", "convertOperatorToFunctionCall", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "opExpression", "Lorg/jetbrains/kotlin/psi/KtOperationExpression;", "canMoveLambdaOutsideParentheses", "", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "replaceWithImplicitInvokeInvocation", "newExpression", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "renameImplicitConventionalCall", "Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "kotlin.refactorings.common"})
@SourceDebugExtension(value={"SMAP\nKtReferenceMutateServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtReferenceMutateServiceBase.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase\n+ 2 KotlinPsiModificationUtils.kt\norg/jetbrains/kotlin/idea/base/psi/KotlinPsiModificationUtils\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,283:1\n29#2,7:284\n29#2,7:291\n29#2,7:301\n29#2,7:310\n25#2:317\n29#2,7:318\n29#2,7:325\n29#2,7:333\n249#3:298\n183#4,2:299\n183#4,2:308\n1#5:332\n1563#6:340\n1634#6,3:341\n*S KotlinDebug\n*F\n+ 1 KtReferenceMutateServiceBase.kt\norg/jetbrains/kotlin/idea/refactoring/rename/KtReferenceMutateServiceBase\n*L\n67#1:284,7\n84#1:291,7\n97#1:301,7\n110#1:310,7\n125#1:317\n193#1:318,7\n196#1:325,7\n250#1:333,7\n87#1:298\n94#1:299,2\n99#1:308,2\n178#1:340\n178#1:341,3\n*E\n"})
public abstract class KtReferenceMutateServiceBase
implements KtReferenceMutateService {
    @NotNull
    public PsiElement bindToElement(@NotNull KtSimpleNameReference simpleNameReference, @NotNull PsiElement element, @NotNull KtSimpleNameReference.ShorteningMode shorteningMode) {
        Intrinsics.checkNotNullParameter((Object)simpleNameReference, (String)"simpleNameReference");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)shorteningMode, (String)"shorteningMode");
        FqName fqName2 = JavaPsiUtils.getKotlinFqName((PsiElement)KotlinCommonRefactoringUtilKt.nameDeterminant(element));
        if (fqName2 == null) {
            return (PsiElement)simpleNameReference.getExpression();
        }
        FqName fqName3 = fqName2;
        return this.bindToFqName(simpleNameReference, fqName3, shorteningMode, element);
    }

    @Nullable
    protected final Name getAdjustedNewName(@NotNull KtSimpleReference<KtNameReferenceExpression> $this$getAdjustedNewName, @NotNull String newElementName) {
        Intrinsics.checkNotNullParameter($this$getAdjustedNewName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        Name name2 = Name.identifier((String)newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        Name newNameAsName = name2;
        Name newName = JvmAbi.isGetterName((String)newElementName) ? PropertiesConventionUtilKt.propertyNameByGetMethodName((Name)newNameAsName) : (JvmAbi.isSetterName((String)newElementName) ? PropertiesConventionUtilKt.propertyNameBySetMethodName((Name)newNameAsName, (boolean)StringsKt.startsWith$default((String)((KtNameReferenceExpression)$this$getAdjustedNewName.getExpression()).getReferencedName(), (String)"is", (boolean)false, (int)2, null)) : null);
        return newName;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final KtElement renameToOrdinaryMethod(@NotNull KtSimpleReference<KtNameReferenceExpression> $this$renameToOrdinaryMethod, @NotNull String newElementName) {
        String newGetterName;
        Intrinsics.checkNotNullParameter($this$renameToOrdinaryMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        Project project = ((KtNameReferenceExpression)$this$renameToOrdinaryMethod.getExpression()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        boolean isGetterRename = KotlinAwareJavaGetterRenameProcessorKt.isKotlinAwareJavaGetterRename((KtReference)$this$renameToOrdinaryMethod);
        String string = newGetterName = isGetterRename ? newElementName : JvmAbi.getterName((String)((KtNameReferenceExpression)$this$renameToOrdinaryMethod.getExpression()).getReferencedName());
        if (ReadWriteAccessCheckerKt.readWriteAccess((KtExpression)((KtExpression)$this$renameToOrdinaryMethod.getExpression()), (boolean)false) == ReferenceAccess.READ) {
            PsiElement psiElement;
            void $this$replaced$iv;
            PsiElement psiElement2 = (PsiElement)$this$renameToOrdinaryMethod.getExpression();
            PsiElement newElement$iv = (PsiElement)KtReferenceMutateServiceBase.createCall$default(this, (KtExpression)$this$renameToOrdinaryMethod.getExpression(), psiFactory, newGetterName, null, 4, null);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression;
                }
            }
            return (KtElement)psiElement;
        }
        String newSetterName = isGetterRename ? JvmAbi.setterName((String)((KtNameReferenceExpression)$this$renameToOrdinaryMethod.getExpression()).getReferencedName()) : newElementName;
        KtExpression fullExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)$this$renameToOrdinaryMethod.getExpression()));
        KtBinaryExpression ktBinaryExpression = KtPsiUtilKt.getAssignmentByLHS((KtExpression)fullExpression);
        if (ktBinaryExpression != null) {
            PsiElement psiElement;
            void $this$replaced$iv;
            KtExpression ktExpression;
            PsiElement psiElement3;
            KtBinaryExpression assignment2 = ktBinaryExpression;
            boolean bl = false;
            KtExpression ktExpression2 = assignment2.getRight();
            if (ktExpression2 == null) {
                return $this$renameToOrdinaryMethod.getExpression();
            }
            KtExpression rhs = ktExpression2;
            IElementType iElementType = assignment2.getOperationToken();
            KtSingleValueToken ktSingleValueToken = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
            if (ktSingleValueToken == null) {
                return $this$renameToOrdinaryMethod.getExpression();
            }
            KtSingleValueToken operationToken = ktSingleValueToken;
            KtSingleValueToken counterpartOp = (KtSingleValueToken)OperatorConventions.ASSIGNMENT_OPERATION_COUNTERPARTS.get((Object)operationToken);
            if (counterpartOp != null) {
                KtExpression getterCall = isGetterRename ? KtReferenceMutateServiceBase.createCall$default(this, fullExpression, psiFactory, newGetterName, null, 4, null) : fullExpression;
                psiElement3 = new PsiElement[]{getterCall, rhs};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0 " + counterpartOp.getValue() + " $1"), (Object[])psiElement3, (boolean)false, (int)4, null);
            } else {
                ktExpression = rhs;
            }
            KtExpression setterArgument = ktExpression;
            KtExpression newSetterCall = this.createCall(fullExpression, psiFactory, newSetterName, setterArgument);
            psiElement3 = (PsiElement)assignment2;
            PsiElement newElement$iv = (PsiElement)newSetterCall;
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression3;
                }
            }
            return KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)psiElement));
        }
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)fullExpression;
        boolean $i$f$getStrictParentOfType = false;
        ktBinaryExpression = (KtUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtUnaryExpression.class, (boolean)true);
        if (ktBinaryExpression != null) {
            PsiElement psiElement;
            void $this$replaced$iv;
            Object v13;
            PsiElement context2;
            KtExpression incDecValue;
            KtExpression originalValue;
            Name operationName;
            KtBinaryExpression unaryExpr;
            block33: {
                Object v10;
                PsiElement parent;
                block32: {
                    unaryExpr = ktBinaryExpression;
                    boolean bl = false;
                    IElementType rhs = unaryExpr.getOperationToken();
                    KtSingleValueToken ktSingleValueToken = rhs instanceof KtSingleValueToken ? (KtSingleValueToken)rhs : null;
                    if (ktSingleValueToken == null) {
                        return $this$renameToOrdinaryMethod.getExpression();
                    }
                    KtSingleValueToken operationToken = ktSingleValueToken;
                    if (!OperatorConventions.INCREMENT_OPERATIONS.contains((Object)operationToken)) {
                        return $this$renameToOrdinaryMethod.getExpression();
                    }
                    operationName = OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)operationToken));
                    originalValue = isGetterRename ? KtReferenceMutateServiceBase.createCall$default(this, fullExpression, psiFactory, newGetterName, null, 4, null) : fullExpression;
                    Object[] counterpartOp = new Object[]{originalValue};
                    incDecValue = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("$0." + operationName + "()"), (Object[])counterpartOp, (boolean)false, (int)4, null);
                    parent = unaryExpr.getParent();
                    Intrinsics.checkNotNull((Object)parent);
                    Sequence $this$firstOrNull$iv = PsiTreeUtilKt.parents((PsiElement)parent, (boolean)true);
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof KtBlockExpression || it instanceof KtDeclarationContainer)) continue;
                        v10 = element$iv;
                        break block32;
                    }
                    v10 = null;
                }
                context2 = v10;
                if (Intrinsics.areEqual((Object)context2, (Object)parent) || context2 == null) {
                    PsiElement psiElement4;
                    void $this$replaced$iv2;
                    KtExpression newSetterCall = this.createCall(fullExpression, psiFactory, newSetterName, incDecValue);
                    PsiElement $i$f$firstOrNull = (PsiElement)unaryExpr;
                    PsiElement newElement$iv = (PsiElement)newSetterCall;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv2, (Object)newElement$iv)) {
                        psiElement4 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv2.replace(newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement4 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement4 = (PsiElement)ktExpression;
                        }
                    }
                    return KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)psiElement4));
                }
                Sequence $this$firstOrNull$iv = PsiTreeUtilKt.parents((PsiElement)parent, (boolean)true);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getParent(), (Object)context2)) continue;
                    v13 = element$iv;
                    break block33;
                }
                v13 = null;
            }
            PsiElement anchor = v13;
            String varName = this.suggestVariableName($this$renameToOrdinaryMethod, (KtExpression)unaryExpr, context2);
            boolean isPrefix = unaryExpr instanceof KtPrefixExpression;
            KtExpression varInitializer = isPrefix ? incDecValue : originalValue;
            Object[] it = new Object[]{varInitializer};
            KtProperty newVar = (KtProperty)CreateByPatternKt.createDeclarationByPattern$default((KtPsiFactory)psiFactory, (String)("val " + varName + " = $0"), (Object[])it, (boolean)false, (int)4, null);
            KtExpression setterArgument = psiFactory.createExpression((String)(isPrefix ? varName : varName + "." + operationName + "()"));
            KtExpression newSetterCall = this.createCall(fullExpression, psiFactory, newSetterName, setterArgument);
            PsiElement newLine = psiFactory.createNewLine();
            context2.addBefore((PsiElement)newVar, anchor);
            context2.addBefore(newLine, anchor);
            context2.addBefore((PsiElement)newSetterCall, anchor);
            PsiElement psiElement5 = (PsiElement)unaryExpr;
            PsiElement newElement$iv = (PsiElement)psiFactory.createExpression(varName);
            boolean $i$f$replaced = false;
            if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                psiElement = newElement$iv;
            } else {
                PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                if (result$iv instanceof KtExpression) {
                    psiElement = result$iv;
                } else {
                    Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                    KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                    if (ktExpression == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                    }
                    psiElement = (PsiElement)ktExpression;
                }
            }
            return (KtElement)psiElement;
        }
        return $this$renameToOrdinaryMethod.getExpression();
    }

    @NotNull
    public abstract String suggestVariableName(@NotNull KtSimpleReference<KtNameReferenceExpression> var1, @NotNull KtExpression var2, @NotNull PsiElement var3);

    private final KtExpression createCall(KtExpression $this$createCall, KtPsiFactory psiFactory, String newName, KtExpression argument2) {
        KtExpression ktExpression;
        if ($this$createCall instanceof KtQualifiedExpression) {
            KtExpression selector2;
            PsiElement $this$copied$iv = (PsiElement)$this$createCall;
            boolean $i$f$copied = false;
            PsiElement psiElement = $this$copied$iv.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
            }
            PsiElement psiElement2 = (PsiElement)((KtQualifiedExpression)psiElement);
            KtQualifiedExpression it = (KtQualifiedExpression)psiElement2;
            boolean bl = false;
            KtElement ktElement = KtPsiUtilKt.getQualifiedElementSelector((KtElement)((KtElement)it));
            KtExpression ktExpression2 = selector2 = ktElement instanceof KtExpression ? (KtExpression)ktElement : null;
            if (ktExpression2 != null) {
                ktExpression2.replace((PsiElement)this.createCall(selector2, psiFactory, newName, argument2));
            }
            ktExpression = (KtExpression)psiElement2;
        } else {
            ktExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> KtReferenceMutateServiceBase.createCall$lambda$1(newName, $this$createCall, argument2, arg_0), (int)1, null);
        }
        return ktExpression;
    }

    static /* synthetic */ KtExpression createCall$default(KtReferenceMutateServiceBase ktReferenceMutateServiceBase, KtExpression ktExpression, KtPsiFactory ktPsiFactory, String string, KtExpression ktExpression2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createCall");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            ktExpression2 = null;
        }
        return ktReferenceMutateServiceBase.createCall(ktExpression, ktPsiFactory, string, ktExpression2);
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull KtReference ktReference, @NotNull String newElementName) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)ktReference, (String)"ktReference");
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        KtReference ktReference2 = ktReference;
        if (ktReference2 instanceof KtArrayAccessReference) {
            psiElement = (PsiElement)this.renameTo((KtArrayAccessReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KDocReference) {
            psiElement = this.renameTo((KDocReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtInvokeFunctionReference) {
            psiElement = this.renameTo((KtInvokeFunctionReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtSimpleNameReference) {
            psiElement = (PsiElement)this.renameTo((KtSimpleNameReference)ktReference, newElementName);
        } else if (ktReference2 instanceof KtDefaultAnnotationArgumentReference) {
            psiElement = (PsiElement)this.renameTo((KtDefaultAnnotationArgumentReference)ktReference, newElementName);
        } else {
            throw new IncorrectOperationException();
        }
        return psiElement;
    }

    private final KtExpression renameTo(KtArrayAccessReference $this$renameTo, String newElementName) {
        return this.renameImplicitConventionalCall((AbstractKtReference<? extends KtExpression>)((AbstractKtReference)$this$renameTo), newElementName);
    }

    private final PsiElement renameTo(KDocReference $this$renameTo, String newElementName) {
        TextRange textRange = ((KDocName)$this$renameTo.getElement()).getNameTextRange();
        String string = textRange.replace(((KDocName)$this$renameTo.getElement()).getText(), newElementName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        String newText = string;
        Project project = ((KDocName)$this$renameTo.getElement()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KDocName newLink = new KDocElementFactory(project).createNameFromText(newText);
        return ((KDocName)$this$renameTo.getElement()).replace((PsiElement)newLink);
    }

    private final PsiElement renameTo(KtInvokeFunctionReference $this$renameTo, String newElementName) {
        KtCallExpression callExpression = (KtCallExpression)$this$renameTo.getExpression();
        KtExpression fullCallExpression = KtPsiUtilKt.getQualifiedExpressionForSelectorOrThis((KtExpression)((KtExpression)callExpression));
        if (Intrinsics.areEqual((Object)newElementName, (Object)OperatorNameConventions.GET.asString()) && callExpression.getTypeArguments().isEmpty()) {
            Project project = callExpression.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            KtExpression arrayAccessExpression = CreateByPatternKt.buildExpression$default((KtPsiFactory)new KtPsiFactory(project, false, 2, null), (boolean)false, arg_0 -> KtReferenceMutateServiceBase.renameTo$lambda$0(fullCallExpression, callExpression, arg_0), (int)1, null);
            PsiElement psiElement = fullCallExpression.replace((PsiElement)arrayAccessExpression);
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"replace(...)");
            return psiElement;
        }
        return (PsiElement)this.renameImplicitConventionalCall((AbstractKtReference<? extends KtExpression>)((AbstractKtReference)$this$renameTo), newElementName);
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression renameTo(KtSimpleNameReference $this$renameTo, String newElementName) {
        PsiElement element;
        PsiElement renamedByExtension;
        PsiElement psiElement;
        PsiElement psiElement2;
        String quotedNewName;
        PsiElement nameElement;
        KtPsiFactory psiFactory;
        block24: {
            PsiElement psiElement3;
            if (!$this$renameTo.canRename()) {
                throw new IncorrectOperationException();
            }
            if (Intrinsics.areEqual((Object)KotlinPsiModificationUtils.unquoteKotlinIdentifier(newElementName), (Object)"")) {
                KtExpression ktExpression;
                KtElement qualifiedElement = KtPsiUtilKt.getQualifiedElement((KtSimpleNameExpression)((KtSimpleNameExpression)$this$renameTo.getExpression()));
                if (qualifiedElement instanceof KtQualifiedExpression) {
                    PsiElement psiElement4;
                    void $this$replaced$iv;
                    ((KtSimpleNameExpression)$this$renameTo.getExpression()).replace((PsiElement)((KtQualifiedExpression)qualifiedElement).getReceiverExpression());
                    PsiElement psiElement5 = (PsiElement)qualifiedElement;
                    KtExpression ktExpression2 = ((KtQualifiedExpression)qualifiedElement).getSelectorExpression();
                    Intrinsics.checkNotNull((Object)ktExpression2);
                    PsiElement newElement$iv = (PsiElement)ktExpression2;
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement4 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtExpression) {
                            psiElement4 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression3 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                            }
                            psiElement4 = (PsiElement)ktExpression3;
                        }
                    }
                    ktExpression = (KtExpression)psiElement4;
                } else if (qualifiedElement instanceof KtUserType) {
                    PsiElement psiElement6;
                    PsiElement $this$replaced$iv = (PsiElement)$this$renameTo.getExpression();
                    KtPsiFactory ktPsiFactory = new KtPsiFactory($this$renameTo.getExpression(), false, 2, null);
                    String string = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                    PsiElement newElement$iv = (PsiElement)ktPsiFactory.createSimpleName(string);
                    boolean $i$f$replaced = false;
                    if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
                        psiElement6 = newElement$iv;
                    } else {
                        PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
                        if (result$iv instanceof KtSimpleNameExpression) {
                            psiElement6 = result$iv;
                        } else {
                            Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                            KtExpression ktExpression4 = ((KtParenthesizedExpression)result$iv).getExpression();
                            if (ktExpression4 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtSimpleNameExpression");
                            }
                            psiElement6 = (PsiElement)((KtSimpleNameExpression)ktExpression4);
                        }
                    }
                    ktExpression = (KtExpression)psiElement6;
                } else {
                    ktExpression = (KtExpression)$this$renameTo.getExpression();
                }
                return ktExpression;
            }
            String expressionText = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getText();
            if (expressionText != null && Name.isValidIdentifier((String)expressionText)) {
                Name name2 = Name.identifier((String)expressionText);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                if (DataClassResolver.INSTANCE.isComponentLike(name2) && $this$renameTo.resolve() instanceof KtParameter) {
                    return (KtExpression)$this$renameTo.getExpression();
                }
            }
            Project project = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            psiFactory = new KtPsiFactory(project2, false, 2, null);
            nameElement = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getReferencedNameElement();
            IElementType iElementType = nameElement.getNode().getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType elementType = iElementType;
            KtOperationExpression opExpression = elementType instanceof KtToken && OperatorConventions.getNameForOperationSymbol((KtToken)((KtToken)elementType)) != null ? ((psiElement3 = ((KtSimpleNameExpression)$this$renameTo.getExpression()).getParent()) instanceof KtOperationExpression ? (KtOperationExpression)psiElement3 : null) : null;
            quotedNewName = KtPsiUtilKt.quoteIfNeeded((String)newElementName);
            if (opExpression != null) {
                Pair<KtExpression, KtSimpleNameExpression> pair = this.convertOperatorToFunctionCall(opExpression);
                KtExpression newExpression = (KtExpression)pair.component1();
                KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)pair.component2();
                newNameElement.replace((PsiElement)psiFactory.createSimpleName(quotedNewName));
                return newExpression;
            }
            Object[] objectArray = project2.getExtensionArea().getExtensionPoint(SimpleNameReferenceExtension.Companion.getEP_NAME()).getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getExtensions(...)");
            Object[] newExpression = objectArray;
            int n = newExpression.length;
            for (int j = 0; j < n; ++j) {
                SimpleNameReferenceExtension it = (SimpleNameReferenceExtension)newExpression[j];
                boolean bl = false;
                psiElement2 = it.handleElementRename($this$renameTo, psiFactory, newElementName);
                if (psiElement2 == null) {
                    continue;
                }
                break block24;
            }
            psiElement2 = null;
        }
        if ((psiElement = (renamedByExtension = psiElement2)) == null) {
            psiElement = psiFactory.createNameIdentifier(quotedNewName);
        }
        if (Intrinsics.areEqual((Object)(element = psiElement).getNode().getElementType(), (Object)KtTokens.IDENTIFIER)) {
            KtPsiUtilKt.astReplace((PsiElement)nameElement, (PsiElement)element);
        } else {
            nameElement.replace(element);
        }
        return (KtExpression)$this$renameTo.getExpression();
    }

    /*
     * WARNING - void declaration
     */
    private final KtValueArgument renameTo(KtDefaultAnnotationArgumentReference $this$renameTo, String newElementName) {
        PsiElement psiElement;
        void $this$replaced$iv;
        Project project = ((KtValueArgument)$this$renameTo.getExpression()).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        KtValueArgument newArgument = KtPsiFactory.createArgument$default((KtPsiFactory)psiFactory, (KtExpression)((KtValueArgument)$this$renameTo.getExpression()).getArgumentExpression(), (Name)Name.identifier((String)KtPsiUtilKt.quoteIfNeeded((String)newElementName)), (((KtValueArgument)$this$renameTo.getExpression()).getSpreadElement() != null ? 1 : 0) != 0, (boolean)false, (int)8, null);
        PsiElement psiElement2 = (PsiElement)$this$renameTo.getExpression();
        PsiElement newElement$iv = (PsiElement)newArgument;
        boolean $i$f$replaced = false;
        if (Intrinsics.areEqual((Object)$this$replaced$iv, (Object)newElement$iv)) {
            psiElement = newElement$iv;
        } else {
            PsiElement result$iv = $this$replaced$iv.replace(newElement$iv);
            if (result$iv instanceof KtValueArgument) {
                psiElement = result$iv;
            } else {
                Intrinsics.checkNotNull((Object)result$iv, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                KtExpression ktExpression = ((KtParenthesizedExpression)result$iv).getExpression();
                if (ktExpression == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
                }
                psiElement = (PsiElement)((KtValueArgument)ktExpression);
            }
        }
        return (KtValueArgument)psiElement;
    }

    private final Pair<KtExpression, KtSimpleNameExpression> convertOperatorToFunctionCall(KtOperationExpression opExpression) {
        return OperatorToFunctionConverter.INSTANCE.convert((KtExpression)opExpression);
    }

    public abstract boolean canMoveLambdaOutsideParentheses(@Nullable KtCallExpression var1);

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final KtExpression replaceWithImplicitInvokeInvocation(@NotNull KtDotQualifiedExpression newExpression) {
        KtExpression ktExpression;
        Intrinsics.checkNotNullParameter((Object)newExpression, (String)"newExpression");
        boolean canMoveLambda = this.canMoveLambdaOutsideParentheses(KtPsiUtilKt.getPossiblyQualifiedCallExpression((KtExpression)((KtExpression)newExpression)));
        KtExpression ktExpression2 = OperatorToFunctionConverter.INSTANCE.replaceExplicitInvokeCallWithImplicit(newExpression);
        if (ktExpression2 != null) {
            void var3_3;
            KtExpression newQualifiedExpression = ktExpression2;
            boolean bl = false;
            KtCallExpression ktCallExpression = KtPsiUtilKt.getPossiblyQualifiedCallExpression((KtExpression)newQualifiedExpression);
            if (ktCallExpression != null) {
                KtCallExpression ktCallExpression2;
                KtCallExpression ktCallExpression3;
                KtCallExpression it = ktCallExpression3 = ktCallExpression;
                boolean bl2 = false;
                Object object = ktCallExpression2 = canMoveLambda ? ktCallExpression3 : null;
                if (ktCallExpression2 != null) {
                    KtCallExpression p0 = ktCallExpression2;
                    boolean bl3 = false;
                    KotlinCommonRefactoringUtilKt.moveFunctionLiteralOutsideParentheses$default(p0, null, 1, null);
                }
            }
            ktExpression = var3_3;
        } else {
            ktExpression = null;
        }
        return ktExpression;
    }

    private final KtExpression renameImplicitConventionalCall(AbstractKtReference<? extends KtExpression> $this$renameImplicitConventionalCall, String newName) {
        KtExpression ktExpression;
        Pair<KtExpression, KtSimpleNameExpression> pair = OperatorToFunctionConverter.INSTANCE.convert((KtExpression)$this$renameImplicitConventionalCall.getExpression());
        KtExpression newExpression = (KtExpression)pair.component1();
        KtSimpleNameExpression newNameElement = (KtSimpleNameExpression)pair.component2();
        if (Intrinsics.areEqual((Object)OperatorNameConventions.INVOKE.asString(), (Object)newName) && newExpression instanceof KtDotQualifiedExpression && (ktExpression = this.replaceWithImplicitInvokeInvocation((KtDotQualifiedExpression)newExpression)) != null) {
            KtExpression it = ktExpression;
            boolean bl = false;
            return it;
        }
        ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)newNameElement).handleElementRename(newName);
        return newExpression;
    }

    private static final Unit createCall$lambda$1(String $newName, KtExpression $this_createCall, KtExpression $argument, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        BuilderByPattern builderByPattern = $newName != null ? $this$buildExpression.appendFixedText($newName) : $this$buildExpression.appendExpression($this_createCall);
        $this$buildExpression.appendFixedText("(");
        if ($argument != null) {
            $this$buildExpression.appendExpression($argument);
        }
        $this$buildExpression.appendFixedText(")");
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit renameTo$lambda$0(KtExpression $fullCallExpression, KtCallExpression $callExpression, BuilderByPattern $this$buildExpression) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        if ($fullCallExpression instanceof KtQualifiedExpression) {
            $this$buildExpression.appendExpression(((KtQualifiedExpression)$fullCallExpression).getReceiverExpression());
            String string = ((KtQualifiedExpression)$fullCallExpression).getOperationSign().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            $this$buildExpression.appendFixedText(string);
        }
        $this$buildExpression.appendExpression($callExpression.getCalleeExpression());
        $this$buildExpression.appendFixedText("[");
        Iterable iterable = $callExpression.getValueArguments();
        BuilderByPattern builderByPattern = $this$buildExpression;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getArgumentExpression());
        }
        BuilderByPattern.appendExpressions$default((BuilderByPattern)builderByPattern, (Iterable)((List)destination$iv$iv), null, (int)2, null);
        $this$buildExpression.appendFixedText("]");
        return Unit.INSTANCE;
    }
}

