/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.onboarding;

import com.intellij.codeWithMe.ClientId;
import com.intellij.internal.statistic.DeviceIdManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.onboarding.KotlinNewUserTrackerState;

@State(name="KotlinNewUserTracker", storages={@Storage(value="kotlin-onboarding.xml", roamingType=RoamingType.DISABLED)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\b\u0010\u0018\u001a\u00020\u0002H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0002H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0014H\u0007J\r\u0010\u001d\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\u001aH\u0002J\r\u0010\"\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b#R\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0002X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTracker;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTrackerState;", "<init>", "()V", "deviceIdProvider", "Lkotlin/Function0;", "", "getDeviceIdProvider$intellij_kotlin_onboarding", "()Lkotlin/jvm/functions/Function0;", "setDeviceIdProvider$intellij_kotlin_onboarding", "(Lkotlin/jvm/functions/Function0;)V", "currentState", "getCurrentState$intellij_kotlin_onboarding", "()Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTrackerState;", "setCurrentState$intellij_kotlin_onboarding", "(Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTrackerState;)V", "getInstallationId", "getInstallationId$intellij_kotlin_onboarding", "getInstallationDate", "Ljava/time/LocalDate;", "isNewIdeaUser", "", "isNewIdeaUser$intellij_kotlin_onboarding", "getState", "loadState", "", "state", "getFirstKotlinUsageDate", "isNewKtUser", "isNewKtUser$intellij_kotlin_onboarding", "shouldShowNewUserDialog", "shouldShowNewUserDialog$intellij_kotlin_onboarding", "checkForNewKtUser", "onKtFileOpened", "onKtFileOpened$intellij_kotlin_onboarding", "Companion", "intellij.kotlin.onboarding"})
@SourceDebugExtension(value={"SMAP\nKotlinNewUserTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNewUserTracker.kt\norg/jetbrains/kotlin/onboarding/KotlinNewUserTracker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
public final class KotlinNewUserTracker
implements PersistentStateComponent<KotlinNewUserTrackerState> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Function0<String> deviceIdProvider = KotlinNewUserTracker::deviceIdProvider$lambda$0;
    @NotNull
    private KotlinNewUserTrackerState currentState = new KotlinNewUserTrackerState();
    private static final Duration NEW_USER_SURVEY_DELAY = Duration.ofDays(7L);
    private static final Duration NEW_IDEA_USER_DURATION = Duration.ofDays(30L);
    private static final Duration NEW_USER_DURATION = Duration.ofDays(30L);
    private static final Duration NEW_USER_RESET = Duration.ofDays(90L);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public final Function0<String> getDeviceIdProvider$intellij_kotlin_onboarding() {
        return this.deviceIdProvider;
    }

    public final void setDeviceIdProvider$intellij_kotlin_onboarding(@NotNull Function0<String> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.deviceIdProvider = function0;
    }

    @NotNull
    public final KotlinNewUserTrackerState getCurrentState$intellij_kotlin_onboarding() {
        return this.currentState;
    }

    public final void setCurrentState$intellij_kotlin_onboarding(@NotNull KotlinNewUserTrackerState kotlinNewUserTrackerState) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinNewUserTrackerState), (String)"<set-?>");
        this.currentState = kotlinNewUserTrackerState;
    }

    @Nullable
    public final String getInstallationId$intellij_kotlin_onboarding() {
        Object object;
        Object object2 = this;
        try {
            KotlinNewUserTracker $this$getInstallationId_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)((String)$this$getInstallationId_u24lambda_u240.deviceIdProvider.invoke()));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (String)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @ApiStatus.Internal
    @Nullable
    public final LocalDate getInstallationDate() {
        String string;
        String string2 = this.getInstallationId$intellij_kotlin_onboarding();
        if (string2 == null) {
            return null;
        }
        String installationId = string2;
        String it = string = StringsKt.take((String)installationId, (int)6);
        boolean bl = false;
        String string3 = it.length() == 6 ? string : null;
        if (string3 == null) {
            return null;
        }
        String dateSubstring = string3;
        Integer n = StringsKt.toIntOrNull((String)StringsKt.substring((String)dateSubstring, (IntRange)new IntRange(0, 1)));
        if (n == null) {
            return null;
        }
        int day = n;
        Integer n2 = StringsKt.toIntOrNull((String)StringsKt.substring((String)dateSubstring, (IntRange)new IntRange(2, 3)));
        if (n2 == null) {
            return null;
        }
        int month = n2;
        Integer n3 = StringsKt.toIntOrNull((String)StringsKt.substring((String)dateSubstring, (IntRange)new IntRange(4, 5)));
        if (n3 == null) {
            return null;
        }
        int year = n3;
        return LocalDate.of(year + 2000, month, day);
    }

    public final boolean isNewIdeaUser$intellij_kotlin_onboarding() {
        LocalDate installationDate = this.getInstallationDate();
        if (installationDate == null) {
            LOG.debug("Could not get InstallationId for IDEA installation");
            return false;
        }
        LOG.debug("Got user installation date: " + installationDate);
        return Duration.between(installationDate.atStartOfDay(ZoneId.systemDefault()).toInstant(), Instant.now()).compareTo(NEW_IDEA_USER_DURATION) <= 0;
    }

    @NotNull
    public KotlinNewUserTrackerState getState() {
        return this.currentState;
    }

    public void loadState(@NotNull KotlinNewUserTrackerState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.currentState = state;
    }

    @ApiStatus.Internal
    @Nullable
    public final LocalDate getFirstKotlinUsageDate() {
        if (this.getState().getNewKtUserSince() == 0L) {
            return null;
        }
        return Instant.ofEpochSecond(this.getState().getNewKtUserSince()).atOffset(ZoneOffset.UTC).toLocalDate();
    }

    public final boolean isNewKtUser$intellij_kotlin_onboarding() {
        if (this.getState().getNewKtUserSince() == 0L) {
            return false;
        }
        Instant newUserStart = Instant.ofEpochSecond(this.getState().getNewKtUserSince());
        return Duration.between(newUserStart, Instant.now()).compareTo(NEW_USER_DURATION) <= 0;
    }

    public final boolean shouldShowNewUserDialog$intellij_kotlin_onboarding() {
        if (this.currentState.getFirstKtFileOpened() == 0L) {
            return false;
        }
        if (!this.isNewKtUser$intellij_kotlin_onboarding()) {
            LOG.debug("Not showing new user dialog because the user is not a new Kotlin user");
            return false;
        }
        Instant newKtUserInstant = Instant.ofEpochSecond(this.currentState.getNewKtUserSince());
        Duration durationSinceNewKtUser = Duration.between(newKtUserInstant, Instant.now());
        LOG.debug("Duration since user became a new Kotlin user: " + durationSinceNewKtUser.toDays() + " day(s)");
        return durationSinceNewKtUser.compareTo(NEW_USER_SURVEY_DELAY) > 0;
    }

    private final void checkForNewKtUser() {
        if (this.isNewKtUser$intellij_kotlin_onboarding()) {
            return;
        }
        Instant currentEpoch = Instant.now();
        if (this.currentState.getNewKtUserSince() == 0L && this.currentState.getFirstKtFileOpened() == 0L) {
            this.currentState.setNewKtUserSince(currentEpoch.getEpochSecond());
            LOG.debug("Marking user as new Kotlin user because they are new to IDEA");
            return;
        }
        if (this.currentState.getLastKtFileOpened() == 0L) {
            return;
        }
        Instant lastKtFileOpenedInstant = Instant.ofEpochSecond(this.currentState.getLastKtFileOpened());
        Duration durationSinceLastKtFileOpened = Duration.between(lastKtFileOpenedInstant, currentEpoch);
        if (durationSinceLastKtFileOpened.compareTo(NEW_USER_RESET) > 0) {
            LOG.debug("Marking user as new Kotlin user because they have not edited a Kotlin file in the past 3 months");
            this.currentState.setNewKtUserSince(currentEpoch.getEpochSecond());
        }
    }

    public final void onKtFileOpened$intellij_kotlin_onboarding() {
        this.checkForNewKtUser();
        Instant currentEpoch = Instant.now();
        this.currentState.setLastKtFileOpened(currentEpoch.getEpochSecond());
        if (this.currentState.getFirstKtFileOpened() == 0L) {
            this.currentState.setFirstKtFileOpened(currentEpoch.getEpochSecond());
            LOG.debug("Kotlin file opened by user for the first time");
        }
    }

    private static final String deviceIdProvider$lambda$0() {
        return DeviceIdManager.getOrGenerateId((DeviceIdManager.DeviceIdToken)new DeviceIdManager.DeviceIdToken(){}, (String)"FUS");
    }

    static {
        Logger logger = Logger.getInstance(KotlinNewUserTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001c\u0010\u000b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001c\u0010\r\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTracker$Companion;", "", "<init>", "()V", "NEW_USER_SURVEY_DELAY", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getNEW_USER_SURVEY_DELAY$intellij_kotlin_onboarding", "()Ljava/time/Duration;", "NEW_IDEA_USER_DURATION", "getNEW_IDEA_USER_DURATION$intellij_kotlin_onboarding", "NEW_USER_DURATION", "getNEW_USER_DURATION$intellij_kotlin_onboarding", "NEW_USER_RESET", "getNEW_USER_RESET$intellij_kotlin_onboarding", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/onboarding/KotlinNewUserTracker;", "intellij.kotlin.onboarding"})
    @SourceDebugExtension(value={"SMAP\nKotlinNewUserTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNewUserTracker.kt\norg/jetbrains/kotlin/onboarding/KotlinNewUserTracker$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,165:1\n42#2,3:166\n*S KotlinDebug\n*F\n+ 1 KotlinNewUserTracker.kt\norg/jetbrains/kotlin/onboarding/KotlinNewUserTracker$Companion\n*L\n38#1:166,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Duration getNEW_USER_SURVEY_DELAY$intellij_kotlin_onboarding() {
            return NEW_USER_SURVEY_DELAY;
        }

        public final Duration getNEW_IDEA_USER_DURATION$intellij_kotlin_onboarding() {
            return NEW_IDEA_USER_DURATION;
        }

        public final Duration getNEW_USER_DURATION$intellij_kotlin_onboarding() {
            return NEW_USER_DURATION;
        }

        public final Duration getNEW_USER_RESET$intellij_kotlin_onboarding() {
            return NEW_USER_RESET;
        }

        @NotNull
        public final KotlinNewUserTracker getInstance() {
            boolean $i$f$service = false;
            Class<KotlinNewUserTracker> serviceClass$iv = KotlinNewUserTracker.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (KotlinNewUserTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

