/*
 * Decompiled with CFR 0.152.
 */
package jme;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;

public class AtomDisplayLabel {
    public double smallAtomWidthLabel = 0.0;
    public double fullAtomWidthLabel;
    public int alignment;
    public boolean noLabelAtom;
    public Rectangle2D.Double atomLabelBoundingBox;
    public double labelX;
    public double labelY;
    public String str;
    int boundingBoxpadding = 2;
    public double atomMapY;
    public double atomMapX;
    public String mapString;
    public int[][] subscripts;
    public int[][] superscripts;

    public AtomDisplayLabel(double x, double y, String z, int an, int nv, int sbo, int nh, int q, int iso, int map, int alignment, FontMetrics fm, double h, boolean showHs) {
        int[] styleIndices;
        int pos;
        String isoSymbol;
        if (z == null || z.length() < 1) {
            z = "*";
            System.err.println("Z error!");
        }
        this.alignment = alignment;
        int padding = 2;
        this.noLabelAtom = an == 3 && q == 0 && iso == 0 && nv > 0 && (nv != 2 || sbo != 4);
        String hydrogenSymbols = "";
        if (showHs && !this.noLabelAtom && nh > 0) {
            hydrogenSymbols = hydrogenSymbols + "H";
            if (nh > 1) {
                hydrogenSymbols = hydrogenSymbols + nh;
            }
        }
        String string = isoSymbol = iso == 0 ? "" : "[" + iso + "]";
        String chargeSymbols = q == 0 ? "" : (Math.abs(q) > 1 ? "" + Math.abs(q) : "") + (q > 0 ? "+" : "-");
        String stringForWidth = z;
        z = alignment == 2 ? chargeSymbols + hydrogenSymbols + isoSymbol + z : isoSymbol + z + hydrogenSymbols + chargeSymbols;
        this.str = z;
        if (alignment == 1) {
            stringForWidth = z;
        }
        double smallWidth = fm.stringWidth(stringForWidth);
        double fullWidth = fm.stringWidth(z);
        this.smallAtomWidthLabel = smallWidth;
        this.fullAtomWidthLabel = fullWidth;
        boolean lineThickness = true;
        double xstart = x - smallWidth / 2.0;
        if (alignment == 2) {
            xstart -= fullWidth - smallWidth;
        }
        double ystart = y - h / 2.0;
        Rectangle2D.Double box = this.atomLabelBoundingBox = new Rectangle2D.Double((xstart -= (double)lineThickness) - (double)padding, ystart - (double)padding, (fullWidth += (double)lineThickness) + (double)(2 * padding), h + (double)(2 * padding));
        this.mapString = null;
        this.labelX = this.atomLabelBoundingBox.x + (double)padding + 1.0;
        this.labelY = this.atomLabelBoundingBox.y + h + (double)padding;
        if (hydrogenSymbols.length() > 1) {
            pos = z.indexOf(hydrogenSymbols);
            styleIndices = new int[]{pos + 1, hydrogenSymbols.length() - 1};
            this.subscripts = new int[][]{styleIndices};
        }
        if (chargeSymbols.length() > 0) {
            pos = z.indexOf(chargeSymbols);
            styleIndices = new int[]{pos, chargeSymbols.length()};
            this.superscripts = new int[][]{styleIndices};
        }
        if (isoSymbol.length() > 0) {
            pos = z.indexOf(isoSymbol);
            styleIndices = new int[]{pos, isoSymbol.length()};
            this.superscripts = this.superscripts == null ? (Object)new int[][]{styleIndices} : (int[][])new int[][]{this.superscripts[0], styleIndices};
        }
        if (map < 0) {
            return;
        }
        this.mapString = " " + map;
        if (this.noLabelAtom) {
            this.atomMapX = x + smallWidth / 4.0;
            this.atomMapY = y - h * 0.1;
        } else {
            double atomMapStringWidth = fm.stringWidth(this.mapString);
            if (alignment == 0) {
                this.atomMapX = x - smallWidth / 2.0 + fullWidth;
            } else {
                box.x -= atomMapStringWidth;
                this.atomMapX = x + smallWidth / 2.0 - fullWidth - atomMapStringWidth;
            }
            double superscriptMove = h * 0.3;
            this.atomMapY = y - superscriptMove;
            box.y -= superscriptMove;
            box.height += superscriptMove;
            box.width += atomMapStringWidth;
        }
    }

    public void draw(Graphics g) {
        g.drawString(this.str, (int)this.labelX, (int)this.labelY);
    }

    public void drawRect(Graphics g) {
        Rectangle2D.Double box = this.atomLabelBoundingBox;
        g.drawRect((int)box.x, (int)box.y, (int)box.width, (int)box.height);
    }

    public void fillRect(Graphics g) {
        Rectangle2D.Double box = this.atomLabelBoundingBox;
        g.fillRect((int)box.x, (int)box.y, (int)box.width, (int)box.height);
    }
}

