/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import net.sf.juife.LinkButton;
import net.sf.juife.NavigationPage;
import org.jsampler.CC;
import org.jsampler.DefaultOrchestraModel;
import org.jsampler.HF;
import org.jsampler.OrchestraInstrument;
import org.jsampler.OrchestraModel;
import org.jsampler.event.ListEvent;
import org.jsampler.event.ListListener;
import org.jsampler.event.OrchestraAdapter;
import org.jsampler.event.OrchestraEvent;
import org.jsampler.view.InstrumentTable;
import org.jsampler.view.InstrumentTableModel;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.LeftPane;

public class OrchestrasPage
extends NavigationPage {
    private final JComboBox cbOrchestras = new JComboBox();
    private final InstrumentTable instrumentTable = new InstrumentTable(new InstrTableModel());
    private final LinkButton lnkManageOrchestras = new LinkButton(ClassicI18n.i18n.getButtonLabel("OrchestrasPage.lnkManageOrchestras"));
    private final Handler eventHandler = new Handler();

    public OrchestrasPage() {
        this.setTitle(ClassicI18n.i18n.getLabel("OrchestrasPage.title"));
        this.setLayout(new BoxLayout(this, 1));
        this.lnkManageOrchestras.setAlignmentX(0.0f);
        this.add(this.lnkManageOrchestras);
        JSeparator jSeparator = new JSeparator();
        jSeparator.setMaximumSize(new Dimension(Short.MAX_VALUE, jSeparator.getPreferredSize().height));
        this.add(jSeparator);
        this.add(Box.createRigidArea(new Dimension(0, 12)));
        this.cbOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OrchestrasPage.this.orchestraChanged();
            }
        });
        for (int i = 0; i < CC.getOrchestras().getOrchestraCount(); ++i) {
            this.cbOrchestras.addItem(CC.getOrchestras().getOrchestra(i));
        }
        CC.getOrchestras().addOrchestraListListener(this.getHandler());
        this.cbOrchestras.setEnabled(this.cbOrchestras.getItemCount() != 0);
        Dimension dimension = new Dimension(Short.MAX_VALUE, this.cbOrchestras.getPreferredSize().height);
        this.cbOrchestras.setMaximumSize(dimension);
        this.cbOrchestras.setAlignmentX(0.0f);
        this.add(this.cbOrchestras);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        DnDScrollPane dnDScrollPane = new DnDScrollPane(this.instrumentTable);
        dnDScrollPane.setAlignmentX(0.0f);
        this.add(dnDScrollPane);
        this.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        this.installListeners();
    }

    private void installListeners() {
        this.lnkManageOrchestras.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LeftPane.getLeftPane().showManageOrchestrasPage();
            }
        });
        this.instrumentTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() < 2) {
                    return;
                }
                OrchestraInstrument orchestraInstrument = OrchestrasPage.this.instrumentTable.getSelectedInstrument();
                if (orchestraInstrument == null) {
                    return;
                }
                OrchestrasPage.this.loadInstrument(orchestraInstrument);
            }
        });
    }

    private void loadInstrument(OrchestraInstrument orchestraInstrument) {
        JSChannelsPane jSChannelsPane = CC.getMainFrame().getSelectedChannelsPane();
        JSChannel jSChannel = null;
        if (jSChannelsPane.hasSelectedChannel()) {
            jSChannel = jSChannelsPane.getSelectedChannels()[0];
        }
        if (jSChannel == null) {
            for (JSChannel jSChannel2 : jSChannelsPane.getChannels()) {
                if (jSChannel2.getChannelInfo().getInstrumentName() != null && jSChannel2.getChannelInfo().getInstrumentStatus() >= -1 || jSChannel2.getChannelInfo().getAudioOutputDevice() == -1) continue;
                jSChannel = jSChannel2;
                break;
            }
        }
        if (jSChannel == null) {
            HF.showErrorMessage("Select channel!");
            return;
        }
        jSChannel.getModel().loadBackendInstrument(orchestraInstrument.getFilePath(), orchestraInstrument.getInstrumentIndex());
    }

    public int getCurrentOrchestraIndex() {
        OrchestraModel orchestraModel = (OrchestraModel)this.cbOrchestras.getSelectedItem();
        return CC.getOrchestras().getOrchestraIndex(orchestraModel);
    }

    public void setSelectedOrchestra(OrchestraModel orchestraModel) {
        this.cbOrchestras.setSelectedItem(orchestraModel);
    }

    private void orchestraChanged() {
        OrchestraModel orchestraModel = (OrchestraModel)this.cbOrchestras.getSelectedItem();
        if (orchestraModel == null) {
            orchestraModel = new DefaultOrchestraModel();
        }
        this.instrumentTable.getModel().setOrchestraModel(orchestraModel);
        String string = orchestraModel.getDescription();
        if (string != null && string.length() == 0) {
            string = null;
        }
        this.cbOrchestras.setToolTipText(string);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class InstrTableModel
    extends InstrumentTableModel {
        private InstrTableModel() {
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return ClassicI18n.i18n.getLabel("OrchestrasPage.instruments");
        }
    }

    private class Handler
    extends OrchestraAdapter
    implements ListListener<OrchestraModel> {
        private Handler() {
        }

        @Override
        public void entryAdded(ListEvent<OrchestraModel> listEvent) {
            if (OrchestrasPage.this.cbOrchestras.getItemCount() == 0) {
                OrchestrasPage.this.cbOrchestras.setEnabled(true);
            }
            OrchestrasPage.this.cbOrchestras.addItem(listEvent.getEntry());
        }

        @Override
        public void entryRemoved(ListEvent<OrchestraModel> listEvent) {
            OrchestrasPage.this.cbOrchestras.removeItem(listEvent.getEntry());
            if (OrchestrasPage.this.cbOrchestras.getItemCount() == 0) {
                OrchestrasPage.this.cbOrchestras.setEnabled(false);
            }
        }

        @Override
        public void nameChanged(OrchestraEvent orchestraEvent) {
        }

        @Override
        public void descriptionChanged(OrchestraEvent orchestraEvent) {
        }
    }

    public class DnDScrollPane
    extends JScrollPane {
        private InstrumentTable instrumentTable;

        private DnDScrollPane(InstrumentTable instrumentTable) {
            this.instrumentTable = instrumentTable;
            this.setViewport(new DnDViewPort());
            this.setViewportView(this.instrumentTable);
            Dimension dimension = new Dimension(this.getMinimumSize().width, this.getPreferredSize().height);
            this.setPreferredSize(dimension);
        }

        public class DnDViewPort
        extends JViewport {
            private DnDViewPort() {
                this.setTransferHandler(new TransferHandler("instrument"){

                    @Override
                    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                        if (DnDScrollPane.this.instrumentTable.isPerformingDnD()) {
                            return false;
                        }
                        if (OrchestrasPage.this.cbOrchestras.getSelectedItem() == null) {
                            return false;
                        }
                        return super.canImport(jComponent, dataFlavorArray);
                    }
                });
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        DnDScrollPane.this.instrumentTable.clearSelection();
                    }
                });
            }

            public String getInstrument() {
                return null;
            }

            public void setInstrument(String string) {
                DnDScrollPane.this.instrumentTable.setSelectedInstrument(null);
                DnDScrollPane.this.instrumentTable.setInstrument(string);
            }
        }
    }
}

