/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Logger;
import twitter4j.StreamingGZIPInputStream;
import twitter4j.TwitterException;

class HttpResponse {
    private static final Logger logger = Logger.getLogger();
    private final boolean prettyDebug;
    private HttpURLConnection con;
    protected int statusCode;
    protected String responseAsString = null;
    protected InputStream is;
    private boolean streamConsumed = false;
    private JSONObject json = null;
    private JSONArray jsonArray = null;

    HttpResponse(HttpURLConnection con, boolean prettyDebug) throws IOException {
        this.con = con;
        this.prettyDebug = prettyDebug;
        try {
            this.statusCode = con.getResponseCode();
        }
        catch (IOException e) {
            if ("Received authentication challenge is null".equals(e.getMessage())) {
                this.statusCode = con.getResponseCode();
            }
            throw e;
        }
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (this.is != null && "gzip".equals(con.getContentEncoding())) {
            this.is = new StreamingGZIPInputStream(this.is);
        }
    }

    HttpResponse(boolean prettyDebug) {
        this.prettyDebug = prettyDebug;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    Map<String, List<String>> getResponseHeaderFields() {
        return this.con.getHeaderFields();
    }

    InputStream asStream() {
        if (this.streamConsumed) {
            throw new IllegalStateException("Stream has already been consumed.");
        }
        return this.is;
    }

    String asString() throws TwitterException {
        if (null == this.responseAsString) {
            BufferedReader br = null;
            InputStream stream = null;
            try {
                String line;
                stream = this.asStream();
                if (null == stream) {
                    String string = null;
                    return string;
                }
                br = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                StringBuilder buf = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    buf.append(line).append("\n");
                }
                this.responseAsString = buf.toString();
                logger.debug(this.responseAsString);
                stream.close();
                this.streamConsumed = true;
            }
            catch (IOException ioe) {
                throw new TwitterException(ioe.getMessage(), ioe);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                this.disconnectForcibly();
            }
        }
        return this.responseAsString;
    }

    JSONObject asJSONObject() throws TwitterException {
        if (this.json == null) {
            try {
                this.json = new JSONObject(this.asString());
                if (this.prettyDebug) {
                    logger.debug(this.json.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.json.toString());
                }
            }
            catch (JSONException jsone) {
                if (this.responseAsString == null) {
                    throw new TwitterException(jsone.getMessage(), jsone);
                }
                throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
            }
            finally {
                this.disconnectForcibly();
            }
        }
        return this.json;
    }

    JSONArray asJSONArray() throws TwitterException {
        if (this.jsonArray == null) {
            try {
                this.jsonArray = new JSONArray(this.asString());
                if (this.prettyDebug) {
                    logger.debug(this.jsonArray.toString(1));
                } else {
                    logger.debug(this.responseAsString != null ? this.responseAsString : this.jsonArray.toString());
                }
            }
            catch (JSONException jsone) {
                if (logger.isDebugEnabled()) {
                    throw new TwitterException(jsone.getMessage() + ":" + this.responseAsString, jsone);
                }
                throw new TwitterException(jsone.getMessage(), jsone);
            }
            finally {
                this.disconnectForcibly();
            }
        }
        return this.jsonArray;
    }

    Reader asReader() {
        return new BufferedReader(new InputStreamReader(this.is, StandardCharsets.UTF_8));
    }

    private void disconnectForcibly() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void disconnect() {
        this.con.disconnect();
    }

    public String toString() {
        return "HttpResponse{statusCode=" + this.statusCode + ", responseAsString='" + this.responseAsString + '\'' + ", is=" + this.is + ", streamConsumed=" + this.streamConsumed + '}';
    }
}

