/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.creator.MethodCreator;
import io.quarkus.gizmo2.creator.TypeParameterCreator;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.quarkus.gizmo2.impl.ExecutableCreatorImpl;
import io.quarkus.gizmo2.impl.TypeCreatorImpl;
import io.quarkus.gizmo2.impl.TypeParameterCreatorImpl;
import java.lang.annotation.ElementType;
import java.lang.constant.ClassDesc;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class MethodCreatorImpl
extends ExecutableCreatorImpl
implements MethodCreator {
    final String name;
    private MethodDesc desc;

    MethodCreatorImpl(TypeCreatorImpl owner, String name) {
        super(owner);
        this.name = name;
    }

    @Override
    public MethodDesc desc() {
        MethodDesc desc = this.desc;
        if (desc == null) {
            this.desc = desc = this.typeCreator.methodDesc(this.name(), this.type());
        }
        return desc;
    }

    @Override
    public void returning(GenericType type) {
        super.returning(type);
    }

    @Override
    public void returning(ClassDesc type) {
        super.returning(type);
    }

    @Override
    void clearType() {
        this.desc = null;
        super.clearType();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ElementType annotationTargetType() {
        return ElementType.METHOD;
    }

    @Override
    public GenericType.OfTypeVariable typeParameter(String name, Consumer<TypeParameterCreator> builder) {
        TypeParameterCreatorImpl creator = new TypeParameterCreatorImpl(name);
        builder.accept(creator);
        return this.addTypeParameter(creator.forMethod(this.desc)).genericType();
    }
}

