/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientregistration.policy;

import java.util.Arrays;
import java.util.Collections;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oidc.mappers.SHA256PairwiseSubMapper;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicy;
import org.keycloak.services.clientregistration.policy.ClientRegistrationPolicyManager;
import org.keycloak.services.clientregistration.policy.RegistrationAuth;

public class DefaultClientRegistrationPolicies {
    private static String[] DEFAULT_ALLOWED_PROTOCOL_MAPPERS = new String[]{"saml-user-attribute-mapper", "oidc-usermodel-attribute-mapper", "saml-user-property-mapper", "oidc-usermodel-property-mapper", "oidc-full-name-mapper", "oidc-address-mapper", new SHA256PairwiseSubMapper().getId(), "saml-role-list-mapper"};

    public static void addDefaultPolicies(RealmModel realm) {
        String anonPolicyType = ClientRegistrationPolicyManager.getComponentTypeKey(RegistrationAuth.ANONYMOUS);
        String authPolicyType = ClientRegistrationPolicyManager.getComponentTypeKey(RegistrationAuth.AUTHENTICATED);
        if (realm.getComponentsStream(realm.getId(), ClientRegistrationPolicy.class.getName()).count() == 0L) {
            DefaultClientRegistrationPolicies.addAnonymousPolicies(realm, anonPolicyType);
            DefaultClientRegistrationPolicies.addAuthPolicies(realm, authPolicyType);
        }
    }

    private static ComponentModel createModelInstance(String name, RealmModel realm, String providerId, String policyType) {
        ComponentModel model = new ComponentModel();
        model.setName(name);
        model.setParentId(realm.getId());
        model.setProviderId(providerId);
        model.setProviderType(ClientRegistrationPolicy.class.getName());
        model.setSubType(policyType);
        return model;
    }

    private static void addAnonymousPolicies(RealmModel realm, String policyTypeKey) {
        ComponentModel trustedHostModel = DefaultClientRegistrationPolicies.createModelInstance("Trusted Hosts", realm, "trusted-hosts", policyTypeKey);
        trustedHostModel.getConfig().put((Object)"trusted-hosts", Collections.emptyList());
        trustedHostModel.getConfig().putSingle((Object)"host-sending-registration-request-must-match", (Object)"true");
        trustedHostModel.getConfig().putSingle((Object)"client-uris-must-match", (Object)"true");
        realm.addComponentModel(trustedHostModel);
        ComponentModel consentRequiredModel = DefaultClientRegistrationPolicies.createModelInstance("Consent Required", realm, "consent-required", policyTypeKey);
        realm.addComponentModel(consentRequiredModel);
        ComponentModel scopeModel = DefaultClientRegistrationPolicies.createModelInstance("Full Scope Disabled", realm, "scope", policyTypeKey);
        realm.addComponentModel(scopeModel);
        ComponentModel maxClientsModel = DefaultClientRegistrationPolicies.createModelInstance("Max Clients Limit", realm, "max-clients", policyTypeKey);
        maxClientsModel.put("max-clients", 200);
        realm.addComponentModel(maxClientsModel);
        DefaultClientRegistrationPolicies.addGenericPolicies(realm, policyTypeKey);
    }

    private static void addAuthPolicies(RealmModel realm, String policyTypeKey) {
        DefaultClientRegistrationPolicies.addGenericPolicies(realm, policyTypeKey);
    }

    private static void addGenericPolicies(RealmModel realm, String policyTypeKey) {
        ComponentModel protMapperModel = DefaultClientRegistrationPolicies.createModelInstance("Allowed Protocol Mapper Types", realm, "allowed-protocol-mappers", policyTypeKey);
        protMapperModel.getConfig().put((Object)"allowed-protocol-mapper-types", Arrays.asList(DEFAULT_ALLOWED_PROTOCOL_MAPPERS));
        realm.addComponentModel(protMapperModel);
        ComponentModel clientTemplatesModel = DefaultClientRegistrationPolicies.createModelInstance("Allowed Client Scopes", realm, "allowed-client-templates", policyTypeKey);
        clientTemplatesModel.getConfig().put((Object)"allowed-client-scopes", Collections.emptyList());
        clientTemplatesModel.put("allow-default-scopes", true);
        realm.addComponentModel(clientTemplatesModel);
        ComponentModel allowedRegistrationWebOrigins = DefaultClientRegistrationPolicies.createModelInstance("Allowed Registration Web Origins", realm, "registration-web-origins", policyTypeKey);
        allowedRegistrationWebOrigins.getConfig().put((Object)"web-origins", Collections.emptyList());
        realm.addComponentModel(allowedRegistrationWebOrigins);
    }
}

