/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.nio.ByteBuffer;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.message.EndTxnMarker;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecord;
import org.apache.kafka.common.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndTransactionMarker {
    private static final Logger log = LoggerFactory.getLogger(EndTransactionMarker.class);
    private final ControlRecordType type;
    private final int coordinatorEpoch;
    private final ByteBuffer buffer;

    public EndTransactionMarker(ControlRecordType type, int coordinatorEpoch) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        this.type = type;
        this.coordinatorEpoch = coordinatorEpoch;
        EndTxnMarker marker = new EndTxnMarker().setCoordinatorEpoch(coordinatorEpoch);
        this.buffer = MessageUtil.toVersionPrefixedByteBuffer((short)0, marker);
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ControlRecordType controlType() {
        return this.type;
    }

    public ByteBuffer serializeValue() {
        return this.buffer.duplicate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndTransactionMarker that = (EndTransactionMarker)o;
        return this.coordinatorEpoch == that.coordinatorEpoch && this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.coordinatorEpoch;
        return result;
    }

    private static void ensureTransactionMarkerControlType(ControlRecordType type) {
        if (type != ControlRecordType.COMMIT && type != ControlRecordType.ABORT) {
            throw new IllegalArgumentException("Invalid control record type for end transaction marker " + String.valueOf((Object)type));
        }
    }

    public static EndTransactionMarker deserialize(Record record) {
        ControlRecordType type = ControlRecordType.parse(record.key());
        return EndTransactionMarker.deserializeValue(type, record.value());
    }

    static EndTransactionMarker deserializeValue(ControlRecordType type, ByteBuffer value) {
        EndTransactionMarker.ensureTransactionMarkerControlType(type);
        short version = value.getShort();
        if (version < 0) {
            throw new InvalidRecordException("Invalid version found for end transaction marker: " + version + ". May indicate data corruption");
        }
        if (version > 0) {
            log.debug("Received end transaction marker value version {}. Parsing as version {}", (Object)version, (Object)0);
            version = 0;
        }
        EndTxnMarker marker = new EndTxnMarker(new ByteBufferAccessor(value), version);
        return new EndTransactionMarker(type, marker.coordinatorEpoch());
    }

    public int endTxnMarkerValueSize() {
        return DefaultRecord.sizeInBytes(0, 0L, 4, this.buffer.remaining(), Record.EMPTY_HEADERS);
    }
}

