/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.pip.PipParseUtils;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryUtil;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonInterpreterTargetEnvironmentFactory;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.impl.PySdkBundle;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true)
@ApiStatus.Internal
public class PyTargetEnvCreationManager {
    private static final Logger LOG = Logger.getInstance(PyTargetEnvCreationManager.class);
    @NotNull
    private final Sdk mySdk;
    protected static final String SETUPTOOLS_VERSION = "44.1.1";
    protected static final String PIP_VERSION = "24.3.1";
    protected static final String SETUPTOOLS_WHEEL_NAME = "setuptools-44.1.1-py2.py3-none-any.whl";
    protected static final String PIP_WHEEL_NAME = "pip-24.3.1-py2.py3-none-any.whl";
    protected static final int ERROR_NO_SETUPTOOLS = 3;
    protected static final String PACKAGING_TOOL = "packaging_tool.py";
    protected static final int TIMEOUT = 600000;
    protected static final String INSTALL = "install";
    protected static final String UNINSTALL = "uninstall";
    private final AtomicBoolean myUpdatingCache;
    protected String mySeparator;
    @Nullable
    protected volatile List<PyPackage> myPackagesCache;

    public PyTargetEnvCreationManager(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(0);
        }
        this.myUpdatingCache = new AtomicBoolean(false);
        this.mySeparator = File.separator;
        this.myPackagesCache = null;
        this.mySdk = sdk2;
    }

    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        Sdk sdk2;
        LanguageLevel languageLevel;
        if (destinationDir == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(1);
        }
        if ((languageLevel = PyTargetEnvCreationManager.getOrRequestLanguageLevelForSdk(sdk2 = this.getSdk())).isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException(PySdkBundle.message((String)"python.sdk.packaging.creating.virtual.environment.for.python.not.supported", (Object[])new Object[]{languageLevel, LanguageLevel.PYTHON27}));
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PyTargetEnvCreationManager.isLegacyPython(languageLevel) != false ? PythonHelper.LEGACY_VIRTUALENV_ZIPAPP : PythonHelper.VIRTUALENV_ZIPAPP, helpersAwareTargetRequest);
        if (useGlobalSite) {
            pythonExecution.addParameter("--system-site-packages");
        }
        pythonExecution.addParameter(destinationDir);
        this.getPythonProcessResult(pythonExecution, false, true, targetEnvironmentRequest);
        Path binary = VirtualEnvReader.getInstance().findPythonInPythonRoot(Path.of(destinationDir, new String[0]));
        char separator = targetEnvironmentRequest.getTargetPlatform().getPlatform().fileSeparator;
        String binaryFallback = destinationDir + separator + "bin" + separator + "python";
        Object object = binary != null ? binary.toString() : binaryFallback;
        if (object == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(2);
        }
        return object;
    }

    @NotNull
    private HelpersAwareTargetEnvironmentRequest getPythonTargetInterpreter() throws ExecutionException {
        HelpersAwareTargetEnvironmentRequest request = PythonInterpreterTargetEnvironmentFactory.findPythonTargetInterpreter(this.getSdk(), ProjectManager.getInstance().getDefaultProject());
        if (request == null) {
            throw new ExecutionException(PySdkBundle.message((String)"python.sdk.package.managing.not.supported.for.sdk", (Object[])new Object[]{this.getSdk().getName()}));
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetEnvironmentRequest = request;
        if (helpersAwareTargetEnvironmentRequest == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(3);
        }
        return helpersAwareTargetEnvironmentRequest;
    }

    @NotNull
    private static Boolean isLegacyPython(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(4);
        }
        Boolean bl = languageLevel.isPython2() || languageLevel.isOlderThan(LanguageLevel.PYTHON37);
        if (bl == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(5);
        }
        return bl;
    }

    @NotNull
    private String getPythonProcessResult(@NotNull PythonExecution pythonExecution, boolean askForSudo, boolean showProgress, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) throws ExecutionException {
        if (pythonExecution == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(6);
        }
        if (targetEnvironmentRequest == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(7);
        }
        ProcessOutputWithCommandLine result2 = this.getPythonProcessOutput(pythonExecution, askForSudo, showProgress, targetEnvironmentRequest);
        String path2 = result2.getExePath();
        List<String> args = result2.getArgs();
        ProcessOutput processOutput = result2.getProcessOutput();
        int exitCode = processOutput.getExitCode();
        if (processOutput.isTimeout()) {
            throw PyExecutionException.createForTimeout((String)PySdkBundle.message((String)"python.sdk.packaging.timed.out", (Object[])new Object[0]), (String)path2, args);
        }
        if (exitCode != 0) {
            throw new PyExecutionException(PySdkBundle.message((String)"python.sdk.packaging.non.zero.exit.code", (Object[])new Object[]{exitCode}), path2, args, processOutput);
        }
        String string = processOutput.getStdout();
        if (string == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected final Sdk getSdk() {
        Sdk sdk2 = this.mySdk;
        if (sdk2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(9);
        }
        return sdk2;
    }

    @NotNull
    private ProcessOutputWithCommandLine getPythonProcessOutput(@NotNull PythonExecution pythonExecution, boolean askForSudo, boolean showProgress, @NotNull TargetEnvironmentRequest targetEnvironmentRequest) throws ExecutionException {
        ProcessOutput result2;
        if (pythonExecution == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(10);
        }
        if (targetEnvironmentRequest == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(11);
        }
        TargetProgressIndicator targetProgressIndicator = TargetProgressIndicator.EMPTY;
        TargetEnvironment targetEnvironment2 = targetEnvironmentRequest.prepareEnvironment(targetProgressIndicator);
        for (Map.Entry entry : targetEnvironment2.getUploadVolumes().entrySet()) {
            try {
                ((TargetEnvironment.UploadableVolume)entry.getValue()).upload(".", TargetProgressIndicator.EMPTY);
            }
            catch (IOException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        TargetedCommandLine targetedCommandLine = PythonScripts.buildTargetedCommandLine(pythonExecution, targetEnvironment2, this.getSdk(), Collections.emptyList());
        LOG.info("Running packaging tool");
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        Process process2 = this.createProcess(targetEnvironment2, targetedCommandLine, askForSudo, indicator);
        List commandLine = targetedCommandLine.collectCommandsSynchronously();
        String commandLineString = StringUtil.join((Collection)commandLine, (String)" ");
        CapturingProcessHandler handler = new CapturingProcessHandler(process2, targetedCommandLine.getCharset(), commandLineString);
        if (showProgress && indicator != null) {
            handler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
            result2 = handler.runProcessWithProgressIndicator(indicator);
        } else {
            result2 = handler.runProcess(600000);
        }
        if (result2.isCancelled()) {
            throw new RunCanceledByUserException();
        }
        result2.checkSuccess(LOG);
        int exitCode = result2.getExitCode();
        String helperPath = (String)ContainerUtil.getFirstItem((Collection)commandLine, (Object)"");
        List<String> args = commandLine.subList(Math.min(1, commandLine.size()), commandLine.size());
        if (exitCode != 0) {
            String message = StringUtil.isEmptyOrSpaces((String)result2.getStdout()) && StringUtil.isEmptyOrSpaces((String)result2.getStderr()) ? PySdkBundle.message((String)"python.conda.permission.denied", (Object[])new Object[0]) : PySdkBundle.message((String)"python.sdk.packaging.non.zero.exit.code", (Object[])new Object[]{exitCode});
            throw new PyExecutionException(message, helperPath, args, result2);
        }
        return new ProcessOutputWithCommandLine(helperPath, args, result2);
    }

    @NotNull
    private Process createProcess(@NotNull TargetEnvironment targetEnvironment2, @NotNull TargetedCommandLine targetedCommandLine, boolean askForSudo, @Nullable ProgressIndicator indicator) throws ExecutionException {
        if (targetEnvironment2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(12);
        }
        if (targetedCommandLine == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(13);
        }
        if (askForSudo) {
            if (!(targetEnvironment2 instanceof LocalTargetEnvironment)) {
                LOG.warn("Sudo flag is ignored");
            } else if (PySdkExtKt.adminPermissionsNeeded(this.getSdk())) {
                GeneralCommandLine localCommandLine = ((LocalTargetEnvironment)targetEnvironment2).createGeneralCommandLine(targetedCommandLine);
                return PyTargetEnvCreationManager.executeOnLocalMachineWithSudo(localCommandLine);
            }
        }
        Process process2 = targetEnvironment2.createProcess(targetedCommandLine, Objects.requireNonNullElseGet(indicator, EmptyProgressIndicator::new));
        if (process2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(14);
        }
        return process2;
    }

    protected void installUsingPipWheel(String ... pipArgs) throws ExecutionException {
        if (pipArgs == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(15);
        }
        HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest = this.getPythonTargetInterpreter();
        PythonScriptExecution pythonExecution = PythonScripts.prepareHelperScriptExecution(PyTargetEnvCreationManager.getPipHelperPackage(), helpersAwareTargetRequest);
        pythonExecution.addParameter(INSTALL);
        pythonExecution.addParameters(pipArgs);
        this.getPythonProcessResult(pythonExecution, true, true, helpersAwareTargetRequest.getTargetEnvironmentRequest());
    }

    @RequiresReadLock(generateAssertion=false)
    @NotNull
    protected static LanguageLevel getOrRequestLanguageLevelForSdk(@NotNull Sdk sdk2) throws ExecutionException {
        if (sdk2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(16);
        }
        if (sdk2 instanceof PyDetectedSdk) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor((Sdk)sdk2);
            if (flavor != null && sdk2.getHomePath() != null) {
                LanguageLevel languageLevel = flavor.getLanguageLevel(sdk2.getHomePath());
                if (languageLevel == null) {
                    PyTargetEnvCreationManager.$$$reportNull$$$0(17);
                }
                return languageLevel;
            }
            throw new ExecutionException(PySdkBundle.message((String)"python.sdk.packaging.cannot.retrieve.version", (Object[])new Object[]{sdk2.getHomePath()}));
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk2);
        if (languageLevel == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(18);
        }
        return languageLevel;
    }

    @Nullable
    protected static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    protected static List<String> makeSafeToDisplayCommand(@NotNull List<String> cmdline) {
        if (cmdline == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(19);
        }
        ArrayList<String> safeCommand = new ArrayList<String>(cmdline);
        for (int i = 0; i < safeCommand.size(); ++i) {
            if (cmdline.get(i).equals("--proxy") && i + 1 < cmdline.size()) {
                safeCommand.set(i + 1, PyTargetEnvCreationManager.makeSafeUrlArgument(cmdline.get(i + 1)));
            }
            if (!cmdline.get(i).equals("--index-url") || i + 1 >= cmdline.size()) continue;
            safeCommand.set(i + 1, PyTargetEnvCreationManager.makeSafeUrlArgument(cmdline.get(i + 1)));
        }
        ArrayList<String> arrayList = safeCommand;
        if (arrayList == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @NotNull
    private static String makeSafeUrlArgument(@NotNull String urlArgument) {
        block7: {
            String string;
            String maskedCredentials;
            String password;
            String login;
            block8: {
                int colonIndex;
                if (urlArgument == null) {
                    PyTargetEnvCreationManager.$$$reportNull$$$0(21);
                }
                URI proxyUri = new URI(urlArgument);
                String credentials = proxyUri.getUserInfo();
                if (credentials == null || (colonIndex = credentials.indexOf(":")) < 0) break block7;
                login = credentials.substring(0, colonIndex);
                password = credentials.substring(colonIndex + 1);
                String maskedPassword = StringUtil.repeatSymbol((char)'*', (int)password.length());
                maskedCredentials = login + ":" + maskedPassword;
                if (!urlArgument.contains(credentials)) break block8;
                String string2 = urlArgument.replaceFirst(Pattern.quote(credentials), maskedCredentials);
                if (string2 == null) {
                    PyTargetEnvCreationManager.$$$reportNull$$$0(22);
                }
                return string2;
            }
            try {
                String encodedCredentials = PyPackageRepositoryUtil.encodeCredentialsForUrl(login, password);
                string = urlArgument.replaceFirst(Pattern.quote(encodedCredentials), maskedCredentials);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string == null) {
                PyTargetEnvCreationManager.$$$reportNull$$$0(23);
            }
            return string;
        }
        String string = urlArgument;
        if (string == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(24);
        }
        return string;
    }

    @NotNull
    protected static List<PyPackage> parsePackagingToolOutput(@NotNull String output2) {
        if (output2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(25);
        }
        List<@NotNull PythonPackage> packageList = PipParseUtils.parseListResult(output2);
        ArrayList<PyPackage> packages2 = new ArrayList<PyPackage>();
        for (PythonPackage pythonPackage : packageList) {
            PyPackage pkg = new PyPackage(pythonPackage.getName(), pythonPackage.getVersion());
            packages2.add(pkg);
        }
        ArrayList<PyPackage> arrayList = packages2;
        if (arrayList == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    private static void applyWorkingDir(@NotNull PythonScriptExecution execution, @Nullable String workingDir) {
        if (execution == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(27);
        }
        if (workingDir != null) {
            execution.setWorkingDir(TargetEnvironmentFunctions.constant((Object)workingDir));
        }
    }

    @NotNull
    private static Process executeOnLocalMachineWithSudo(@NotNull GeneralCommandLine localCommandLine) throws ExecutionException {
        Process process2;
        if (localCommandLine == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(28);
        }
        try {
            process2 = ExecUtil.sudo((GeneralCommandLine)localCommandLine, (String)PySdkBundle.message((String)"python.sdk.packaging.enter.your.password.to.make.changes", (Object[])new Object[0]));
        }
        catch (IOException e) {
            String exePath = localCommandLine.getExePath();
            List args = localCommandLine.getCommandLineList(exePath);
            throw new PyExecutionException(e, null, exePath, args);
        }
        if (process2 == null) {
            PyTargetEnvCreationManager.$$$reportNull$$$0(29);
        }
        return process2;
    }

    @NotNull
    private static HelperPackage getPipHelperPackage() {
        return new PythonHelper.ScriptPythonHelper("pip-24.3.1-py2.py3-none-any.whl/pip", PythonHelpersLocator.getCommunityHelpersRoot().toFile(), Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 8, 9, 14, 17, 18, 20, 22, 23, 24, 26, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyTargetEnvCreationManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pythonExecution";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironmentRequest";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEnvironment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetedCommandLine";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipArgs";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlArgument";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyTargetEnvCreationManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonTargetInterpreter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "isLegacyPython";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeToDisplayCommand";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeUrlArgument";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "executeOnLocalMachineWithSudo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 8: 
            case 9: 
            case 14: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 29: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLegacyPython";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "installUsingPipWheel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeToDisplayCommand";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeUrlArgument";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "applyWorkingDir";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "executeOnLocalMachineWithSudo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 8, 9, 14, 17, 18, 20, 22, 23, 24, 26, 29 -> new IllegalStateException(string);
        };
    }

    private static class ProcessOutputWithCommandLine {
        @NotNull
        private final String myExePath;
        @NotNull
        private final List<String> myArgs;
        @NotNull
        private final ProcessOutput myProcessOutput;

        private ProcessOutputWithCommandLine(@NotNull String exePath, @NotNull List<String> args, @NotNull ProcessOutput output2) {
            if (exePath == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(0);
            }
            if (args == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(1);
            }
            if (output2 == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(2);
            }
            this.myExePath = exePath;
            this.myArgs = args;
            this.myProcessOutput = output2;
        }

        @NotNull
        private String getExePath() {
            String string = this.myExePath;
            if (string == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        private List<String> getArgs() {
            List<String> list = this.myArgs;
            if (list == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(4);
            }
            return list;
        }

        @NotNull
        private ProcessOutput getProcessOutput() {
            ProcessOutput processOutput = this.myProcessOutput;
            if (processOutput == null) {
                ProcessOutputWithCommandLine.$$$reportNull$$$0(5);
            }
            return processOutput;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyTargetEnvCreationManager$ProcessOutputWithCommandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyTargetEnvCreationManager$ProcessOutputWithCommandLine";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExePath";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArgs";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProcessOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

