/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.ResizableCellEditorsSupport;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.AbstractTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GridTableCellEditor
extends AbstractTableCellEditor {
    public static final String TABLE_CELL_EDITOR_PROPERTY = "tableCellEditor";
    public static final Key<EventObject> EDITING_STARTER_CLIENT_PROPERTY_KEY = Key.create((String)"EventThatCausedEditingToStart");
    private final DataGrid myGrid;
    private final ModelIndex<GridRow> myRowIdx;
    private final ModelIndex<GridColumn> myColumnIdx;
    private final GridCellEditorFactory myEditorFactory;
    private GridCellEditor myEditor = null;

    public GridTableCellEditor(DataGrid grid, ModelIndex<GridRow> rowIdx, ModelIndex<GridColumn> columnIdx, GridCellEditorFactory editorFactory) {
        this.myGrid = grid;
        this.myRowIdx = rowIdx;
        this.myColumnIdx = columnIdx;
        this.myEditorFactory = editorFactory;
    }

    public boolean shouldMoveFocus() {
        return this.myEditor == null || this.myEditor.shouldMoveFocus();
    }

    @TestOnly
    public GridCellEditor getEditor() {
        return this.myEditor;
    }

    public Component getTableCellEditorComponent(final JTable table2, Object value, boolean isSelected, int row, int column) {
        if (this.myEditorFactory == null) {
            return null;
        }
        if (this.myEditor == null) {
            EventObject e = (EventObject)ComponentUtil.getClientProperty((JComponent)table2, EDITING_STARTER_CLIENT_PROPERTY_KEY);
            this.myEditor = this.myEditorFactory.createEditor(this.myGrid, this.myRowIdx, this.myColumnIdx, value, e);
            this.myEditor.setEditingListener((Consumer<Object>)((Consumer)object -> {
                this.myGrid.fireValueEdited(object);
                Rectangle r = GridTableCellEditor.calculateSelectedRect(table2);
                if (r == null) {
                    return;
                }
                table2.revalidate();
                table2.repaint(r);
            }));
        }
        table2.addPropertyChangeListener(TABLE_CELL_EDITOR_PROPERTY, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() == GridTableCellEditor.this && evt.getNewValue() != GridTableCellEditor.this) {
                    Disposer.dispose((Disposable)GridTableCellEditor.this.myEditor);
                    table2.removePropertyChangeListener(GridTableCellEditor.TABLE_CELL_EDITOR_PROPERTY, this);
                }
            }
        });
        return this.myEditor.isColumnSpanAllowed() ? new GridCellEditorComponentWrapper(this.myEditor) : this.myEditor.getComponent();
    }

    public Object getCellEditorValue() {
        return this.myEditor != null ? this.myEditor.getValue() : null;
    }

    @Nullable
    public String getCellEditorText() {
        return this.myEditor != null ? this.myEditor.getText() : null;
    }

    public boolean isCellEditable(EventObject e) {
        if (this.myEditorFactory == null) {
            return false;
        }
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    public boolean stopCellEditing() {
        GridModel model2 = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        if (!this.myGrid.isEditable() && !model2.allValuesEqualTo(ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{this.myRowIdx.asInteger()}), ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[]{this.myColumnIdx.asInteger()}), this.getCellEditorValue())) {
            this.showCannotApplyCellEditorChangesDialog();
            return false;
        }
        return this.myEditor != null && this.myEditor.stop() && super.stopCellEditing();
    }

    public void cancelCellEditing() {
        if (this.myEditor != null) {
            this.myEditor.cancel();
        }
        super.cancelCellEditing();
    }

    @Nullable
    private static Rectangle calculateSelectedRect(@NotNull JTable table2) {
        if (table2 == null) {
            GridTableCellEditor.$$$reportNull$$$0(0);
        }
        int[] rows = table2.getSelectedRows();
        int[] columns = table2.getSelectedColumns();
        Rectangle selected = null;
        for (int row : rows) {
            for (int column : columns) {
                Rectangle rect = table2.getCellRect(row, column, true);
                selected = selected == null ? rect : selected.union(rect);
            }
        }
        return selected;
    }

    private void showCannotApplyCellEditorChangesDialog() {
        ModalityState currentModality;
        Application application = ApplicationManager.getApplication();
        ModalityState gridModality = application.getModalityStateForComponent((Component)this.myGrid.getPanel().getComponent());
        if (Comparing.equal((Object)gridModality, (Object)(currentModality = ModalityState.current())) && this.myGrid.getPanel().getComponent().isShowing()) {
            GridUtil.showCannotApplyCellEditorChanges(this.myGrid);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/GridTableCellEditor", "calculateSelectedRect"));
    }

    private static class GridCellEditorComponentWrapper
    extends JComponent
    implements ResizableCellEditorsSupport.ResizableCellEditor {
        private final GridCellEditor myEditor;
        private boolean myWidthChangeEnabled;
        private KeyEvent myCurrentEvent;

        GridCellEditorComponentWrapper(@NotNull GridCellEditor editor) {
            if (editor == null) {
                GridCellEditorComponentWrapper.$$$reportNull$$$0(0);
            }
            this.myWidthChangeEnabled = true;
            this.myCurrentEvent = null;
            this.myEditor = editor;
            this.setLayout(new BorderLayout());
            this.add((Component)editor.getComponent(), "Center");
            this.setFocusable(false);
        }

        @Override
        public void setWidthChangeEnabled(boolean b) {
            this.myWidthChangeEnabled = b;
        }

        @Override
        @NotNull
        public ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection getHorizontalResizeDirection() {
            Editor editor;
            if (this.myEditor instanceof GridCellEditor.EditorBased && (editor = ((GridCellEditor.EditorBased)((Object)this.myEditor)).getEditor()) instanceof EditorImpl && ((EditorImpl)editor).isRightAligned()) {
                ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection horizontalResizeDirection = ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection.LEFT;
                if (horizontalResizeDirection == null) {
                    GridCellEditorComponentWrapper.$$$reportNull$$$0(1);
                }
                return horizontalResizeDirection;
            }
            ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection horizontalResizeDirection = ResizableCellEditorsSupport.ResizableCellEditor.HorizontalResizeDirection.RIGHT;
            if (horizontalResizeDirection == null) {
                GridCellEditorComponentWrapper.$$$reportNull$$$0(2);
            }
            return horizontalResizeDirection;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(this.myWidthChangeEnabled ? x : this.getX(), y, this.myWidthChangeEnabled ? width : this.getWidth(), height);
        }

        @Override
        public void requestFocus() {
            if (this.getComponentCount() == 1) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.getComponent(0), true));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (condition == 0 && this.myCurrentEvent != e && this.getComponentCount() == 1) {
                try {
                    this.myCurrentEvent = e;
                    this.getComponent(0).dispatchEvent(e);
                }
                finally {
                    this.myCurrentEvent = null;
                }
            }
            return e.isConsumed() || super.processKeyBinding(ks, e, condition, pressed);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ui/GridTableCellEditor$GridCellEditorComponentWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ui/GridTableCellEditor$GridCellEditorComponentWrapper";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getHorizontalResizeDirection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

