/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentEP;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentI;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerKt;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.platform.vcs.impl.shared.ui.ToolWindowLazyContent;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.awt.Component;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\"!\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"'\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00060\u00060\u0001\u00a2\u0006\u0002\b\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"IS_CONTENT_CREATED", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "CHANGES_VIEW_EXTENSION", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentEP;", "getCHANGES_VIEW_EXTENSION", "()Lcom/intellij/openapi/util/Key;", "getExtension", "content", "Lcom/intellij/ui/content/Content;", "updateContentIfCreated", "", "toolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "updateContent", "getExtensions", "Lkotlin/sequences/Sequence;", "createExtensionContent", "project", "Lcom/intellij/openapi/project/Project;", "extension", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nVcsToolWindowFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsToolWindowFactory.kt\ncom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactoryKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,165:1\n1321#2,2:166\n*S KotlinDebug\n*F\n+ 1 VcsToolWindowFactory.kt\ncom/intellij/openapi/vcs/changes/ui/VcsToolWindowFactoryKt\n*L\n129#1:166,2\n*E\n"})
public final class VcsToolWindowFactoryKt {
    @NotNull
    private static final Key<Boolean> IS_CONTENT_CREATED;
    @NotNull
    private static final Key<ChangesViewContentEP> CHANGES_VIEW_EXTENSION;

    @NotNull
    public static final Key<ChangesViewContentEP> getCHANGES_VIEW_EXTENSION() {
        return CHANGES_VIEW_EXTENSION;
    }

    private static final ChangesViewContentEP getExtension(Content content) {
        return (ChangesViewContentEP)content.getUserData(CHANGES_VIEW_EXTENSION);
    }

    private static final void updateContentIfCreated(ToolWindow toolWindow) {
        if (ClientProperty.isTrue((Component)toolWindow.getComponent(), IS_CONTENT_CREATED)) {
            VcsToolWindowFactoryKt.updateContent(toolWindow);
        }
    }

    private static final void updateContent(ToolWindow toolWindow) {
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ChangesViewContentI changesViewContentManager = ChangesViewContentManager.Companion.getInstance(project);
        boolean wasEmpty = toolWindow.getContentManager().getContentCount() == 0;
        Sequence<ChangesViewContentEP> $this$forEach$iv = VcsToolWindowFactoryKt.getExtensions(toolWindow);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project2;
            ChangesViewContentEP extension = (ChangesViewContentEP)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindow.getProject(), (String)"getProject(...)");
            Predicate<Project> predicate = extension.newPredicateInstance(project2);
            boolean isVisible = !(predicate != null ? !predicate.test(project2) : false);
            List<Content> list = changesViewContentManager.findContents(arg_0 -> VcsToolWindowFactoryKt.updateContent$lambda$0$0(extension, arg_0));
            Intrinsics.checkNotNullExpressionValue(list, (String)"findContents(...)");
            Content content = (Content)CollectionsKt.firstOrNull(list);
            if (isVisible && content == null) {
                changesViewContentManager.addContent(VcsToolWindowFactoryKt.createExtensionContent(project2, extension));
                continue;
            }
            if (isVisible || content == null) continue;
            changesViewContentManager.removeContent(content);
        }
        if (wasEmpty) {
            ContentManager contentManager = toolWindow.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"getContentManager(...)");
            ChangesViewContentManagerKt.selectFirstContent(contentManager);
        }
    }

    private static final Sequence<ChangesViewContentEP> getExtensions(ToolWindow toolWindow) {
        Project project = toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)ChangesViewContentEP.EP_NAME.getExtensions((AreaInstance)project)), arg_0 -> VcsToolWindowFactoryKt.getExtensions$lambda$0(toolWindow, arg_0));
    }

    private static final Content createExtensionContent(Project project, ChangesViewContentEP extension) {
        Content content;
        block1: {
            String string = extension.getDisplayName(project);
            if (string == null) {
                string = extension.tabName;
            }
            String displayName = string;
            Content content2 = ContentFactory.getInstance().createContent((JComponent)new JPanel(null), displayName, false);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"createContent(...)");
            Content $this$createExtensionContent_u24lambda_u240 = content = content2;
            boolean bl = false;
            $this$createExtensionContent_u24lambda_u240.setCloseable(false);
            $this$createExtensionContent_u24lambda_u240.setTabName(extension.tabName);
            $this$createExtensionContent_u24lambda_u240.putUserData(CHANGES_VIEW_EXTENSION, (Object)extension);
            ToolWindowLazyContent.INSTANCE.setContentSupplier($this$createExtensionContent_u24lambda_u240, arg_0 -> VcsToolWindowFactoryKt.createExtensionContent$lambda$0$0(extension, project, arg_0));
            $this$createExtensionContent_u24lambda_u240.putUserData(ChangesViewContentManager.IS_IN_COMMIT_TOOLWINDOW_KEY, (Object)extension.isInCommitToolWindow);
            ChangesViewContentProvider.Preloader preloader = extension.newPreloaderInstance(project);
            if (preloader == null) break block1;
            preloader.preloadTabContent($this$createExtensionContent_u24lambda_u240);
        }
        return content;
    }

    private static final boolean updateContent$lambda$0$0(ChangesViewContentEP $extension, Content it) {
        Intrinsics.checkNotNull((Object)it);
        return VcsToolWindowFactoryKt.getExtension(it) == $extension;
    }

    private static final boolean getExtensions$lambda$0(ToolWindow $toolWindow, ChangesViewContentEP it) {
        String string = $toolWindow.getId();
        Project project = $toolWindow.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)it);
        return Intrinsics.areEqual((Object)string, (Object)ChangesViewContentManager.Companion.getToolWindowId$intellij_platform_vcs_impl(project, it));
    }

    private static final Unit createExtensionContent$lambda$0$0(ChangesViewContentEP $extension, Project $project, Content content) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            ChangesViewContentProvider changesViewContentProvider = $extension.getInstance($project);
            if (changesViewContentProvider == null) break block0;
            changesViewContentProvider.initTabContent(content);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateContent(ToolWindow toolWindow) {
        VcsToolWindowFactoryKt.updateContent(toolWindow);
    }

    public static final /* synthetic */ Key access$getIS_CONTENT_CREATED$p() {
        return IS_CONTENT_CREATED;
    }

    public static final /* synthetic */ void access$updateContentIfCreated(ToolWindow toolWindow) {
        VcsToolWindowFactoryKt.updateContentIfCreated(toolWindow);
    }

    public static final /* synthetic */ ChangesViewContentEP access$getExtension(Content content) {
        return VcsToolWindowFactoryKt.getExtension(content);
    }

    static {
        Key key = Key.create((String)"ToolWindow.IsContentCreated");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_CONTENT_CREATED = key;
        Key key2 = Key.create((String)"Content.ChangesViewExtension");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        CHANGES_VIEW_EXTENSION = key2;
    }
}

