/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.UsernamePasswordCallback;

public final class ServerUnavailableCallback
extends AuthCallbackCase {
    private static final Pattern PATTERN = Pattern.compile("svn: OPTIONS of '(.+)': ((?:Could not|could not).+)\n? \\(.+\\)|svn: E175002: (.+)\nsvn: E175002: OPTIONS of '.+': (.+)(?:\n.+)?|svn: E\\d{6}: (Unable to connect to a repository at URL .+)\nsvn: E\\d+: (.+)");

    public ServerUnavailableCallback(AuthenticationService service, Url url) {
        super(service, url);
    }

    @Override
    public boolean canHandle(String error) {
        return PATTERN.matcher(error).matches() && !UsernamePasswordCallback.isAuthenticationProblem(error);
    }

    @Override
    public boolean getCredentials(String errText) throws SvnBindException {
        Matcher matcher = PATTERN.matcher(errText);
        boolean matches = matcher.matches();
        assert (matches);
        int offset = 1;
        while (matcher.group(offset) == null) {
            offset += 2;
        }
        throw new SvnBindException(matcher.group(offset) + ":\n" + matcher.group(offset + 1));
    }
}

