/* Generated by re2c 4.3.1 */
#line 1 "../src/parse/conf_lexer.re"
#include <stdint.h>
#include <string>
#include <vector>

#include "src/encoding/enc.h"
#include "src/msg/msg.h"
#include "src/options/opt.h"
#include "src/parse/ast.h"
#include "src/parse/conf_parser.h"
#include "src/parse/input.h"
#include "src/util/file_utils.h"
#include "src/util/string_utils.h"

namespace re2c {

#line 19 "src/parse/conf_lexer.cc"
size_t LexerState::maxfill_conf() { return 32; }
#line 16 "../src/parse/conf_lexer.re"


#define YYFILL(n) do { \
    if (!fill(n)) { \
        RET_FAIL(error_at_cur("unexpected end of input in configuration")); \
    } \
} while(0)

// Immutable options are only allowed in syntax files.
#define SETCONOPT(opt, val) do { \
    if (!in_syntax_file) { \
        RET_FAIL(error_at_cur("this configuration is only allowed in syntax files")); \
    } \
    const_cast<conopt_t&>(opts.glob).init_##opt(val); \
} while (0)

// In syntax file mode do not overwrite user-defined options.
#define SETOPT(opt, val) do { \
    if (in_syntax_file) { \
        opts.init_##opt(val); \
    } else { \
        opts.set_##opt(val); \
    } \
} while (0)

#define RET_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_STXCONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    SETCONOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_FEAT(conf, name) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (tmp_bool && !opts.glob.supported_features_contains(name)) { \
        RET_FAIL(error_at_cur("`%s` feature is not supported for this backend", name)); \
    } \
    SETOPT(conf, tmp_bool); \
    return Ret::OK; \
} while(0)

#define RET_CONF_STR(conf) do { \
    CHECK_RET(lex_conf_string(opts)); \
    SETOPT(conf, tmp_str); \
    return Ret::OK; \
} while(0)

#define RET_CONF_CODE(conf) do { \
    CHECK_RET(lex_conf_code(opts)); \
    SETOPT(conf, tmp_code); \
    return Ret::OK; \
} while(0)

#define RET_CONF_ENC(enc) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    if (in_syntax_file) { \
        opts.init_encoding(enc, tmp_bool); \
    } else { \
        opts.set_encoding(enc, tmp_bool); \
    } \
    return Ret::OK; \
} while(0)

#define RET_CONF_NUM_NONNEG(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    if (tmp_num < 0) RET_FAIL(error_at_cur("expected nonnegative value in configuration")); \
    SETOPT(conf, static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#define RET_CONF_EOF(conf) do { \
    CHECK_RET(lex_conf_number(opts)); \
    SETOPT(conf, tmp_num < 0 ? NOEOF : static_cast<uint32_t>(tmp_num)); \
    return Ret::OK; \
} while(0)

#line 113 "../src/parse/conf_lexer.re"


Ret Input::lex_conf(Opt& opts) {

#line 108 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,  64,   0,   0,   0,  64,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		 64,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,  32,   0,   0,
		160, 160, 160, 160, 160, 160, 160, 160,
		160, 160,  32,   0,   0,   0,   0,   0,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,  32,
		  0,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,  32,  32,  32,  32,  32,
		 32,  32,  32,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0,
		  0,   0,   0,   0,   0,   0,   0,   0
	};
	if ((lim - cur) < 28) YYFILL(28);
	yych = *cur;
	switch (yych) {
		case '-':
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case ':':
		case 'A':
		case 'B':
		case 'C':
		case 'D':
		case 'E':
		case 'F':
		case 'G':
		case 'H':
		case 'I':
		case 'J':
		case 'K':
		case 'L':
		case 'M':
		case 'N':
		case 'O':
		case 'P':
		case 'Q':
		case 'R':
		case 'S':
		case 'T':
		case 'U':
		case 'V':
		case 'W':
		case 'X':
		case 'Z':
		case '_':
		case 'g':
		case 'j':
		case 'k':
		case 'o':
		case 'q':
		case 'r':
		case 'w':
		case 'x':
		case 'z': goto yy2;
		case 'Y': goto yy4;
		case 'a': goto yy5;
		case 'b': goto yy6;
		case 'c': goto yy7;
		case 'd': goto yy8;
		case 'e': goto yy9;
		case 'f': goto yy10;
		case 'h': goto yy11;
		case 'i': goto yy12;
		case 'l': goto yy13;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy16;
		case 's': goto yy17;
		case 't': goto yy18;
		case 'u': goto yy19;
		case 'v': goto yy20;
		case 'y': goto yy21;
		default: goto yy1;
	}
yy1:
#line 302 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok(
                "unrecognized configuration '%.*s'", static_cast<int>(cur - tok), tok));
    }
#line 222 "src/parse/conf_lexer.cc"
yy2:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy3:
	if (yybm[0+yych] & 32) goto yy2;
	goto yy1;
yy4:
	yych = *++cur;
	if (yych == 'Y') goto yy22;
	goto yy3;
yy5:
	yych = *++cur;
	if (yych == 'p') goto yy23;
	goto yy3;
yy6:
	yych = *++cur;
	if (yych == 'i') goto yy24;
	goto yy3;
yy7:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'a') goto yy25;
		goto yy3;
	} else {
		if (yych <= 'g') goto yy26;
		if (yych == 'o') goto yy27;
		goto yy3;
	}
yy8:
	yych = *++cur;
	if (yych == 'a') goto yy28;
	if (yych == 'e') goto yy29;
	goto yy3;
yy9:
	yych = *++cur;
	if (yych <= 'l') goto yy3;
	if (yych <= 'm') goto yy30;
	if (yych <= 'n') goto yy31;
	if (yych <= 'o') goto yy32;
	goto yy3;
yy10:
	yych = *++cur;
	if (yych == 'l') goto yy33;
	goto yy3;
yy11:
	yych = *++cur;
	if (yych == 'e') goto yy34;
	goto yy3;
yy12:
	yych = *++cur;
	if (yych == 'n') goto yy35;
	goto yy3;
yy13:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy36;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy37;
		if (yych == 'i') goto yy38;
		goto yy3;
	}
yy14:
	yych = *++cur;
	if (yych == 'o') goto yy39;
	goto yy3;
yy15:
	yych = *++cur;
	if (yych == 'e') goto yy40;
	goto yy3;
yy16:
	yych = *++cur;
	if (yych == 'o') goto yy41;
	goto yy3;
yy17:
	yych = *++cur;
	if (yych == 'e') goto yy42;
	if (yych == 't') goto yy43;
	goto yy3;
yy18:
	yych = *++cur;
	if (yych == 'a') goto yy44;
	goto yy3;
yy19:
	yych = *++cur;
	if (yych == 'n') goto yy45;
	goto yy3;
yy20:
	yych = *++cur;
	if (yych == 'a') goto yy46;
	if (yych == 'e') goto yy47;
	goto yy3;
yy21:
	yych = *++cur;
	if (yych == 'y') goto yy48;
	goto yy3;
yy22:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy49;
		case 'C': goto yy50;
		case 'D': goto yy51;
		case 'F': goto yy52;
		case 'G': goto yy53;
		case 'I': goto yy54;
		case 'L': goto yy55;
		case 'M': goto yy56;
		case 'P': goto yy57;
		case 'R': goto yy58;
		case 'S': goto yy59;
		default: goto yy3;
	}
yy23:
	yych = *++cur;
	if (yych == 'i') goto yy60;
	goto yy3;
yy24:
	yych = *++cur;
	if (yych == 't') goto yy62;
	goto yy3;
yy25:
	yych = *++cur;
	if (yych == 'p') goto yy63;
	if (yych == 's') goto yy64;
	goto yy3;
yy26:
	yych = *++cur;
	if (yych == 'o') goto yy65;
	goto yy3;
yy27:
	yych = *++cur;
	if (yych <= 'l') {
		if (yych == 'd') goto yy66;
		goto yy3;
	} else {
		if (yych <= 'm') goto yy67;
		if (yych <= 'n') goto yy68;
		goto yy3;
	}
yy28:
	yych = *++cur;
	if (yych == 't') goto yy69;
	goto yy3;
yy29:
	yych = *++cur;
	if (yych == 'b') goto yy70;
	if (yych == 'f') goto yy71;
	goto yy3;
yy30:
	yych = *++cur;
	if (yych == 'p') goto yy72;
	goto yy3;
yy31:
	yych = *++cur;
	if (yych == 'c') goto yy73;
	goto yy3;
yy32:
	yych = *++cur;
	if (yych == 'f') goto yy74;
	goto yy3;
yy33:
	yych = *++cur;
	if (yych == 'a') goto yy75;
	if (yych == 'e') goto yy76;
	goto yy3;
yy34:
	yych = *++cur;
	if (yych == 'a') goto yy77;
	goto yy3;
yy35:
	yych = *++cur;
	if (yych <= 'o') {
		if (yych == 'd') goto yy78;
		goto yy3;
	} else {
		if (yych <= 'p') goto yy79;
		if (yych == 'v') goto yy80;
		goto yy3;
	}
yy36:
	yych = *++cur;
	if (yych == 'b') goto yy81;
	goto yy3;
yy37:
	yych = *++cur;
	if (yych == 'f') goto yy82;
	goto yy3;
yy38:
	yych = *++cur;
	if (yych == 'n') goto yy83;
	goto yy3;
yy39:
	yych = *++cur;
	if (yych == 'n') goto yy84;
	goto yy3;
yy40:
	yych = *++cur;
	if (yych == 's') goto yy85;
	goto yy3;
yy41:
	yych = *++cur;
	if (yych == 's') goto yy86;
	goto yy3;
yy42:
	yych = *++cur;
	if (yych == 'n') goto yy87;
	goto yy3;
yy43:
	yych = *++cur;
	if (yych == 'a') goto yy88;
	if (yych == 'o') goto yy89;
	goto yy3;
yy44:
	yych = *++cur;
	if (yych == 'g') goto yy90;
	if (yych == 'r') goto yy91;
	goto yy3;
yy45:
	yych = *++cur;
	if (yych == 's') goto yy92;
	goto yy3;
yy46:
	yych = *++cur;
	if (yych == 'r') goto yy93;
	goto yy3;
yy47:
	yych = *++cur;
	if (yych == 'r') goto yy94;
	goto yy3;
yy48:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy95;
		case 'b': goto yy96;
		case 'c': goto yy97;
		case 'f': goto yy98;
		case 'n': goto yy99;
		case 'p': goto yy100;
		case 'r': goto yy101;
		case 's': goto yy102;
		case 't': goto yy103;
		default: goto yy3;
	}
yy49:
	yych = *++cur;
	if (yych == 'A') goto yy104;
	goto yy3;
yy50:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy105;
		goto yy3;
	} else {
		if (yych <= 'T') goto yy106;
		if (yych <= 'U') goto yy107;
		goto yy3;
	}
yy51:
	yych = *++cur;
	if (yych == 'E') goto yy108;
	goto yy3;
yy52:
	yych = *++cur;
	if (yych == 'I') goto yy109;
	if (yych == 'N') goto yy110;
	goto yy3;
yy53:
	yych = *++cur;
	if (yych == 'E') goto yy111;
	goto yy3;
yy54:
	yych = *++cur;
	if (yych == 'N') goto yy112;
	goto yy3;
yy55:
	yych = *++cur;
	if (yych == 'E') goto yy113;
	if (yych == 'I') goto yy114;
	goto yy3;
yy56:
	yych = *++cur;
	if (yych == 'A') goto yy115;
	if (yych == 'T') goto yy116;
	goto yy3;
yy57:
	yych = *++cur;
	if (yych == 'E') goto yy117;
	goto yy3;
yy58:
	yych = *++cur;
	if (yych == 'E') goto yy118;
	goto yy3;
yy59:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy119;
		case 'H': goto yy120;
		case 'K': goto yy121;
		case 'T': goto yy122;
		default: goto yy3;
	}
yy60:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy123;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy61;
			if (yych <= 'z') goto yy2;
		}
	}
yy61:
#line 132 "../src/parse/conf_lexer.re"
	{ goto input; }
#line 546 "src/parse/conf_lexer.cc"
yy62:
	yych = *++cur;
	if (yych == '-') goto yy124;
	goto yy3;
yy63:
	yych = *++cur;
	if (yych == 't') goto yy125;
	goto yy3;
yy64:
	yych = *++cur;
	if (yych == 'e') goto yy126;
	goto yy3;
yy65:
	yych = *++cur;
	if (yych == 't') goto yy127;
	goto yy3;
yy66:
	yych = *++cur;
	if (yych == 'e') goto yy128;
	goto yy3;
yy67:
	yych = *++cur;
	if (yych == 'p') goto yy129;
	goto yy3;
yy68:
	yych = *++cur;
	if (yych == 'd') goto yy130;
	goto yy3;
yy69:
	yych = *++cur;
	if (yych == 'e') goto yy131;
	goto yy3;
yy70:
	yych = *++cur;
	if (yych == 'u') goto yy132;
	goto yy3;
yy71:
	yych = *++cur;
	if (yych == 'i') goto yy133;
	goto yy3;
yy72:
	yych = *++cur;
	if (yych == 't') goto yy134;
	goto yy3;
yy73:
	yych = *++cur;
	if (yych == 'o') goto yy135;
	goto yy3;
yy74:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 147 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_eof); }
#line 600 "src/parse/conf_lexer.cc"
yy75:
	yych = *++cur;
	if (yych == 'g') goto yy136;
	goto yy3;
yy76:
	yych = *++cur;
	if (yych == 'x') goto yy137;
	goto yy3;
yy77:
	yych = *++cur;
	if (yych == 'd') goto yy138;
	goto yy3;
yy78:
	yych = *++cur;
	if (yych == 'e') goto yy139;
	goto yy3;
yy79:
	yych = *++cur;
	if (yych == 'u') goto yy140;
	goto yy3;
yy80:
	yych = *++cur;
	if (yych == 'e') goto yy141;
	goto yy3;
yy81:
	yych = *++cur;
	if (yych == 'e') goto yy142;
	goto yy3;
yy82:
	yych = *++cur;
	if (yych == 't') goto yy143;
	goto yy3;
yy83:
	yych = *++cur;
	if (yych == 'e') goto yy144;
	goto yy3;
yy84:
	yych = *++cur;
	if (yych == 'a') goto yy145;
	goto yy3;
yy85:
	yych = *++cur;
	if (yych == 't') goto yy146;
	goto yy3;
yy86:
	yych = *++cur;
	if (yych == 'i') goto yy147;
	goto yy3;
yy87:
	yych = *++cur;
	if (yych == 't') goto yy148;
	goto yy3;
yy88:
	yych = *++cur;
	if (yych == 'r') goto yy149;
	if (yych == 't') goto yy150;
	goto yy3;
yy89:
	yych = *++cur;
	if (yych == 'r') goto yy151;
	goto yy3;
yy90:
	yych = *++cur;
	if (yych == 's') goto yy152;
	goto yy3;
yy91:
	yych = *++cur;
	if (yych == 'g') goto yy154;
	goto yy3;
yy92:
	yych = *++cur;
	if (yych == 'a') goto yy155;
	goto yy3;
yy93:
	yych = *++cur;
	if (yych == 'i') goto yy156;
	goto yy3;
yy94:
	yych = *++cur;
	if (yych == 'b') goto yy157;
	if (yych == 's') goto yy158;
	goto yy3;
yy95:
	yych = *++cur;
	if (yych == 'c') goto yy159;
	goto yy3;
yy96:
	yych = *++cur;
	if (yych == 'm') goto yy160;
	goto yy3;
yy97:
	yych = *++cur;
	if (yych <= 'n') {
		if (yych == 'h') goto yy162;
		goto yy3;
	} else {
		if (yych <= 'o') goto yy164;
		if (yych == 't') goto yy165;
		goto yy3;
	}
yy98:
	yych = *++cur;
	if (yych == 'i') goto yy166;
	if (yych == 'n') goto yy167;
	goto yy3;
yy99:
	yych = *++cur;
	if (yych == 'm') goto yy168;
	goto yy3;
yy100:
	yych = *++cur;
	if (yych == 'm') goto yy169;
	goto yy3;
yy101:
	yych = *++cur;
	if (yych == 'e') goto yy170;
	goto yy3;
yy102:
	yych = *++cur;
	if (yych == 't') goto yy171;
	goto yy3;
yy103:
	yych = *++cur;
	if (yych == 'a') goto yy172;
	goto yy3;
yy104:
	yych = *++cur;
	if (yych == 'C') goto yy173;
	goto yy3;
yy105:
	yych = *++cur;
	if (yych == 'N') goto yy174;
	if (yych == 'P') goto yy175;
	goto yy3;
yy106:
	yych = *++cur;
	if (yych <= 'W') goto yy3;
	if (yych <= 'X') goto yy176;
	if (yych <= 'Y') goto yy177;
	goto yy3;
yy107:
	yych = *++cur;
	if (yych == 'R') goto yy178;
	goto yy3;
yy108:
	yych = *++cur;
	if (yych == 'B') goto yy179;
	goto yy3;
yy109:
	yych = *++cur;
	if (yych == 'L') goto yy180;
	goto yy3;
yy110:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 233 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_list(opts));
        if (tmp_list.size() < 1) {
            RET_FAIL(error_at_tok(
                "`re2c:YYFN` configuration value should be a nonempty list of strings"));
        }
        SETOPT(api_fn, tmp_list);
        return Ret::OK;
    }
#line 766 "src/parse/conf_lexer.cc"
yy111:
	yych = *++cur;
	if (yych == 'T') goto yy181;
	goto yy3;
yy112:
	yych = *++cur;
	if (yych == 'P') goto yy182;
	goto yy3;
yy113:
	yych = *++cur;
	if (yych == 'S') goto yy183;
	goto yy3;
yy114:
	yych = *++cur;
	if (yych == 'M') goto yy184;
	goto yy3;
yy115:
	yych = *++cur;
	if (yych == 'R') goto yy185;
	if (yych == 'X') goto yy186;
	goto yy3;
yy116:
	yych = *++cur;
	if (yych == 'A') goto yy187;
	goto yy3;
yy117:
	yych = *++cur;
	if (yych == 'E') goto yy188;
	goto yy3;
yy118:
	yych = *++cur;
	if (yych == 'S') goto yy189;
	goto yy3;
yy119:
	yych = *++cur;
	if (yych == 'T') goto yy190;
	goto yy3;
yy120:
	yych = *++cur;
	if (yych == 'I') goto yy191;
	goto yy3;
yy121:
	yych = *++cur;
	if (yych == 'I') goto yy192;
	goto yy3;
yy122:
	yych = *++cur;
	if (yych == 'A') goto yy193;
	goto yy3;
yy123:
	yych = *++cur;
	if (yych == 's') goto yy194;
	goto yy3;
yy124:
	yych = *++cur;
	if (yych == 'v') goto yy195;
	goto yy3;
yy125:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy196;
	if (yych <= 'v') goto yy197;
	goto yy3;
yy126:
	yych = *++cur;
	if (yych == '-') goto yy198;
	goto yy3;
yy127:
	yych = *++cur;
	if (yych == 'o') goto yy199;
	goto yy3;
yy128:
	yych = *++cur;
	if (yych == '-') goto yy200;
	goto yy3;
yy129:
	yych = *++cur;
	if (yych == 'u') goto yy201;
	goto yy3;
yy130:
	yych = *++cur;
	if (yych <= 'e') {
		if (yych == ':') goto yy202;
		if (yych <= 'd') goto yy3;
		goto yy203;
	} else {
		if (yych <= 'i') {
			if (yych <= 'h') goto yy3;
			goto yy204;
		} else {
			if (yych == 'p') goto yy205;
			goto yy3;
		}
	}
yy131:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 122 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(date); }
#line 866 "src/parse/conf_lexer.cc"
yy132:
	yych = *++cur;
	if (yych == 'g') goto yy206;
	goto yy3;
yy133:
	yych = *++cur;
	if (yych == 'n') goto yy207;
	goto yy3;
yy134:
	yych = *++cur;
	if (yych == 'y') goto yy208;
	goto yy3;
yy135:
	yych = *++cur;
	if (yych == 'd') goto yy209;
	goto yy3;
yy136:
	yych = *++cur;
	if (yych == 's') goto yy210;
	goto yy3;
yy137:
	yych = *++cur;
	if (yych == '-') goto yy211;
	goto yy3;
yy138:
	yych = *++cur;
	if (yych == 'e') goto yy212;
	goto yy3;
yy139:
	yych = *++cur;
	if (yych == 'n') goto yy213;
	goto yy3;
yy140:
	yych = *++cur;
	if (yych == 't') goto yy214;
	goto yy3;
yy141:
	yych = *++cur;
	if (yych == 'r') goto yy215;
	goto yy3;
yy142:
	yych = *++cur;
	if (yych == 'l') goto yy216;
	goto yy3;
yy143:
	yych = *++cur;
	if (yych == 'm') goto yy217;
	goto yy3;
yy144:
	yych = *++cur;
	if (yych == '-') goto yy218;
	goto yy3;
yy145:
	yych = *++cur;
	if (yych == 'd') goto yy219;
	goto yy3;
yy146:
	yych = *++cur;
	if (yych == 'e') goto yy220;
	goto yy3;
yy147:
	yych = *++cur;
	if (yych == 'x') goto yy221;
	goto yy3;
yy148:
	yych = *++cur;
	if (yych == 'i') goto yy222;
	goto yy3;
yy149:
	yych = *++cur;
	if (yych == 't') goto yy223;
	goto yy3;
yy150:
	yych = *++cur;
	if (yych == 'e') goto yy224;
	goto yy3;
yy151:
	yych = *++cur;
	if (yych == 'a') goto yy225;
	goto yy3;
yy152:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy226;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy153;
			if (yych <= 'z') goto yy2;
		}
	}
yy153:
#line 157 "../src/parse/conf_lexer.re"
	{
        RET_CONF_BOOL(tags);
    }
#line 970 "src/parse/conf_lexer.cc"
yy154:
	yych = *++cur;
	if (yych == 'e') goto yy227;
	goto yy3;
yy155:
	yych = *++cur;
	if (yych == 'f') goto yy228;
	goto yy3;
yy156:
	yych = *++cur;
	if (yych == 'a') goto yy229;
	goto yy3;
yy157:
	yych = *++cur;
	if (yych == 'o') goto yy230;
	goto yy3;
yy158:
	yych = *++cur;
	if (yych == 'i') goto yy231;
	goto yy3;
yy159:
	yych = *++cur;
	if (yych == 'c') goto yy232;
	goto yy3;
yy160:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy233;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy161;
			if (yych <= 'z') goto yy2;
		}
	}
yy161:
#line 255 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_bitmaps); }
#line 1016 "src/parse/conf_lexer.cc"
yy162:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy234;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy163;
			if (yych <= 'z') goto yy2;
		}
	}
yy163:
#line 251 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_char); }
#line 1038 "src/parse/conf_lexer.cc"
yy164:
	yych = *++cur;
	if (yych == 'n') goto yy235;
	goto yy3;
yy165:
	yych = *++cur;
	if (yych == 'a') goto yy236;
	goto yy3;
yy166:
	yych = *++cur;
	if (yych == 'l') goto yy237;
	goto yy3;
yy167:
	yych = *++cur;
	if (yych == ':') goto yy238;
	goto yy3;
yy168:
	yych = *++cur;
	if (yych == 'a') goto yy239;
	goto yy3;
yy169:
	yych = *++cur;
	if (yych == 'a') goto yy240;
	goto yy3;
yy170:
	yych = *++cur;
	if (yych == 'c') goto yy241;
	goto yy3;
yy171:
	yych = *++cur;
	if (yych == 'a') goto yy242;
	goto yy3;
yy172:
	yych = *++cur;
	if (yych == 'r') goto yy243;
	goto yy3;
yy173:
	yych = *++cur;
	if (yych == 'K') goto yy244;
	goto yy3;
yy174:
	yych = *++cur;
	if (yych == 'D') goto yy245;
	goto yy3;
yy175:
	yych = *++cur;
	if (yych == 'Y') goto yy246;
	goto yy3;
yy176:
	yych = *++cur;
	if (yych == 'M') goto yy247;
	goto yy3;
yy177:
	yych = *++cur;
	if (yych == 'P') goto yy248;
	goto yy3;
yy178:
	yych = *++cur;
	if (yych == 'S') goto yy249;
	goto yy3;
yy179:
	yych = *++cur;
	if (yych == 'U') goto yy250;
	goto yy3;
yy180:
	yych = *++cur;
	if (yych == 'L') goto yy251;
	goto yy3;
yy181:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy253;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy254;
		if (yych == 'S') goto yy255;
		goto yy3;
	}
yy182:
	yych = *++cur;
	if (yych == 'U') goto yy256;
	goto yy3;
yy183:
	yych = *++cur;
	if (yych == 'S') goto yy257;
	goto yy3;
yy184:
	yych = *++cur;
	if (yych == 'I') goto yy258;
	goto yy3;
yy185:
	yych = *++cur;
	if (yych == 'K') goto yy259;
	goto yy3;
yy186:
	yych = *++cur;
	if (yych == 'F') goto yy260;
	if (yych == 'N') goto yy261;
	goto yy3;
yy187:
	yych = *++cur;
	if (yych == 'G') goto yy262;
	goto yy3;
yy188:
	yych = *++cur;
	if (yych == 'K') goto yy263;
	goto yy3;
yy189:
	yych = *++cur;
	if (yych == 'T') goto yy264;
	goto yy3;
yy190:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy265;
		goto yy3;
	} else {
		if (yych <= 'C') goto yy266;
		if (yych == 'S') goto yy267;
		goto yy3;
	}
yy191:
	yych = *++cur;
	if (yych == 'F') goto yy268;
	goto yy3;
yy192:
	yych = *++cur;
	if (yych == 'P') goto yy269;
	goto yy3;
yy193:
	yych = *++cur;
	if (yych == 'G') goto yy270;
	goto yy3;
yy194:
	yych = *++cur;
	if (yych == 'i') goto yy271;
	if (yych == 't') goto yy272;
	goto yy3;
yy195:
	yych = *++cur;
	if (yych == 'e') goto yy273;
	goto yy3;
yy196:
	yych = *++cur;
	if (yych == 'r') goto yy274;
	goto yy3;
yy197:
	yych = *++cur;
	if (yych == 'a') goto yy275;
	goto yy3;
yy198:
	yych = *++cur;
	if (yych == 'i') goto yy276;
	if (yych == 'r') goto yy277;
	goto yy3;
yy199:
	yych = *++cur;
	if (yych == ':') goto yy278;
	goto yy3;
yy200:
	yych = *++cur;
	if (yych == 'm') goto yy279;
	goto yy3;
yy201:
	yych = *++cur;
	if (yych == 't') goto yy280;
	goto yy3;
yy202:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy281;
		case 'd': goto yy282;
		case 'e': goto yy203;
		case 'g': goto yy283;
		case 'p': goto yy205;
		default: goto yy3;
	}
yy203:
	yych = *++cur;
	if (yych == 'n') goto yy284;
	goto yy3;
yy204:
	yych = *++cur;
	if (yych == 't') goto yy285;
	goto yy3;
yy205:
	yych = *++cur;
	if (yych == 'r') goto yy286;
	goto yy3;
yy206:
	yych = *++cur;
	if (yych == '-') goto yy287;
	goto yy3;
yy207:
	yych = *++cur;
	if (yych == 'e') goto yy288;
	goto yy3;
yy208:
	yych = *++cur;
	if (yych == '-') goto yy289;
	goto yy3;
yy209:
	yych = *++cur;
	if (yych == 'i') goto yy290;
	goto yy3;
yy210:
	yych = *++cur;
	if (yych == ':') goto yy291;
	goto yy3;
yy211:
	yych = *++cur;
	if (yych == 's') goto yy292;
	goto yy3;
yy212:
	yych = *++cur;
	if (yych == 'r') goto yy293;
	goto yy3;
yy213:
	yych = *++cur;
	if (yych == 't') goto yy295;
	goto yy3;
yy214:
	yych = *++cur;
	if (yych == '-') goto yy296;
	goto yy3;
yy215:
	yych = *++cur;
	if (yych == 't') goto yy297;
	goto yy3;
yy216:
	yych = *++cur;
	if (yych == ':') goto yy298;
	if (yych == 'p') goto yy299;
	goto yy3;
yy217:
	yych = *++cur;
	if (yych == 'o') goto yy300;
	goto yy3;
yy218:
	yych = *++cur;
	if (yych == 'd') goto yy301;
	goto yy3;
yy219:
	yych = *++cur;
	if (yych == 'i') goto yy302;
	goto yy3;
yy220:
	yych = *++cur;
	if (yych == 'd') goto yy303;
	goto yy3;
yy221:
	yych = *++cur;
	if (yych == '-') goto yy304;
	goto yy3;
yy222:
	yych = *++cur;
	if (yych == 'n') goto yy305;
	goto yy3;
yy223:
	yych = *++cur;
	if (yych == 'l') goto yy306;
	goto yy3;
yy224:
	yych = *++cur;
	if (yych == ':') goto yy307;
	goto yy3;
yy225:
	yych = *++cur;
	if (yych == 'b') goto yy308;
	goto yy3;
yy226:
	yych = *++cur;
	if (yych <= 'm') {
		if (yych == 'e') goto yy309;
		goto yy3;
	} else {
		if (yych <= 'n') goto yy310;
		if (yych == 'p') goto yy311;
		goto yy3;
	}
yy227:
	yych = *++cur;
	if (yych == 't') goto yy312;
	goto yy3;
yy228:
	yych = *++cur;
	if (yych == 'e') goto yy313;
	goto yy3;
yy229:
	yych = *++cur;
	if (yych == 'b') goto yy314;
	goto yy3;
yy230:
	yych = *++cur;
	if (yych == 's') goto yy315;
	goto yy3;
yy231:
	yych = *++cur;
	if (yych == 'o') goto yy316;
	goto yy3;
yy232:
	yych = *++cur;
	if (yych == 'e') goto yy317;
	goto yy3;
yy233:
	yych = *++cur;
	if (yych == 'h') goto yy318;
	goto yy3;
yy234:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy319;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy320;
		if (yych == 'l') goto yy321;
		goto yy3;
	}
yy235:
	yych = *++cur;
	if (yych == 'd') goto yy322;
	goto yy3;
yy236:
	yych = *++cur;
	if (yych == 'b') goto yy323;
	goto yy3;
yy237:
	yych = *++cur;
	if (yych == 'l') goto yy324;
	goto yy3;
yy238:
	yych = *++cur;
	if (yych <= 'r') goto yy3;
	if (yych <= 's') goto yy326;
	if (yych <= 't') goto yy327;
	goto yy3;
yy239:
	yych = *++cur;
	if (yych == 't') goto yy328;
	goto yy3;
yy240:
	yych = *++cur;
	if (yych == 't') goto yy329;
	goto yy3;
yy241:
	yych = *++cur;
	if (yych == 'o') goto yy330;
	goto yy3;
yy242:
	yych = *++cur;
	if (yych == 'b') goto yy331;
	if (yych == 't') goto yy332;
	goto yy3;
yy243:
	yych = *++cur;
	if (yych == 'g') goto yy333;
	goto yy3;
yy244:
	yych = *++cur;
	if (yych == 'U') goto yy334;
	goto yy3;
yy245:
	yych = *++cur;
	if (yych == 'T') goto yy335;
	goto yy3;
yy246:
	yych = *++cur;
	if (yych == 'M') goto yy336;
	if (yych == 'S') goto yy337;
	goto yy3;
yy247:
	yych = *++cur;
	if (yych == 'A') goto yy338;
	goto yy3;
yy248:
	yych = *++cur;
	if (yych == 'E') goto yy339;
	goto yy3;
yy249:
	yych = *++cur;
	if (yych == 'O') goto yy340;
	goto yy3;
yy250:
	yych = *++cur;
	if (yych == 'G') goto yy341;
	goto yy3;
yy251:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy342;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy343;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy252;
			if (yych <= 'z') goto yy2;
		}
	}
yy252:
#line 201 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_fill); }
#line 1447 "src/parse/conf_lexer.cc"
yy253:
	yych = *++cur;
	if (yych == 'C') goto yy345;
	goto yy3;
yy254:
	yych = *++cur;
	if (yych == 'O') goto yy346;
	goto yy3;
yy255:
	yych = *++cur;
	if (yych == 'T') goto yy347;
	goto yy3;
yy256:
	yych = *++cur;
	if (yych == 'T') goto yy348;
	goto yy3;
yy257:
	yych = *++cur;
	if (yych == 'T') goto yy349;
	goto yy3;
yy258:
	yych = *++cur;
	if (yych == 'T') goto yy350;
	goto yy3;
yy259:
	yych = *++cur;
	if (yych == 'E') goto yy351;
	goto yy3;
yy260:
	yych = *++cur;
	if (yych == 'I') goto yy352;
	goto yy3;
yy261:
	yych = *++cur;
	if (yych == 'M') goto yy353;
	goto yy3;
yy262:
	yych = *++cur;
	if (yych == 'N') goto yy354;
	if (yych == 'P') goto yy355;
	goto yy3;
yy263:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 216 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_peek); }
#line 1494 "src/parse/conf_lexer.cc"
yy264:
	yych = *++cur;
	if (yych == 'O') goto yy356;
	goto yy3;
yy265:
	yych = *++cur;
	if (yych == 'C') goto yy357;
	goto yy3;
yy266:
	yych = *++cur;
	if (yych == 'O') goto yy358;
	goto yy3;
yy267:
	yych = *++cur;
	if (yych == 'T') goto yy359;
	goto yy3;
yy268:
	yych = *++cur;
	if (yych == 'T') goto yy360;
	goto yy3;
yy269:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 230 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_skip); }
#line 1520 "src/parse/conf_lexer.cc"
yy270:
	yych = *++cur;
	if (yych == 'N') goto yy362;
	if (yych == 'P') goto yy363;
	goto yy3;
yy271:
	yych = *++cur;
	if (yych == 'g') goto yy364;
	goto yy3;
yy272:
	yych = *++cur;
	if (yych == 'y') goto yy365;
	goto yy3;
yy273:
	yych = *++cur;
	if (yych == 'c') goto yy366;
	goto yy3;
yy274:
	yych = *++cur;
	if (yych == 'e') goto yy367;
	goto yy3;
yy275:
	yych = *++cur;
	if (yych == 'r') goto yy368;
	goto yy3;
yy276:
	yych = *++cur;
	if (yych == 'n') goto yy369;
	goto yy3;
yy277:
	yych = *++cur;
	if (yych == 'a') goto yy370;
	goto yy3;
yy278:
	yych = *++cur;
	if (yych == 'r') goto yy371;
	if (yych == 't') goto yy372;
	goto yy3;
yy279:
	yych = *++cur;
	if (yych == 'o') goto yy373;
	goto yy3;
yy280:
	yych = *++cur;
	if (yych == 'e') goto yy374;
	goto yy3;
yy281:
	yych = *++cur;
	if (yych == 'b') goto yy375;
	goto yy3;
yy282:
	yych = *++cur;
	if (yych == 'i') goto yy376;
	goto yy3;
yy283:
	yych = *++cur;
	if (yych == 'o') goto yy377;
	goto yy3;
yy284:
	yych = *++cur;
	if (yych == 'u') goto yy378;
	goto yy3;
yy285:
	yych = *++cur;
	if (yych == 'i') goto yy379;
	goto yy3;
yy286:
	yych = *++cur;
	if (yych == 'e') goto yy380;
	goto yy3;
yy287:
	yych = *++cur;
	if (yych == 'o') goto yy381;
	goto yy3;
yy288:
	yych = *++cur;
	if (yych == ':') goto yy382;
	goto yy3;
yy289:
	yych = *++cur;
	if (yych == 'c') goto yy383;
	goto yy3;
yy290:
	yych = *++cur;
	if (yych == 'n') goto yy384;
	goto yy3;
yy291:
	yych = *++cur;
	switch (yych) {
		case '8': goto yy385;
		case 'P': goto yy386;
		case 'T': goto yy387;
		case 'b': goto yy388;
		case 'c': goto yy390;
		case 'd': goto yy391;
		case 'e': goto yy393;
		case 'g': goto yy395;
		case 'i': goto yy397;
		case 'l': goto yy398;
		case 'm': goto yy14;
		case 'n': goto yy15;
		case 'p': goto yy399;
		case 's': goto yy400;
		case 't': goto yy401;
		case 'u': goto yy402;
		case 'w': goto yy404;
		case 'x': goto yy406;
		default: goto yy3;
	}
yy292:
	yych = *++cur;
	if (yych == 'y') goto yy407;
	goto yy3;
yy293:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy294:
#line 137 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_string(opts));
        if (!tmp_str.empty()) {
            std::string path(opts.glob.output_file);
            get_dir(path);
            SETOPT(header_file, path + tmp_str);
        }
        return Ret::OK;
    }
#line 1648 "src/parse/conf_lexer.cc"
yy295:
	yych = *++cur;
	if (yych == ':') goto yy408;
	goto yy3;
yy296:
	yych = *++cur;
	if (yych == 'e') goto yy409;
	goto yy3;
yy297:
	yych = *++cur;
	if (yych == '-') goto yy410;
	goto yy3;
yy298:
	yych = *++cur;
	if (yych <= 'r') {
		if (yych != 'p') goto yy3;
	} else {
		if (yych <= 's') goto yy411;
		if (yych == 'y') goto yy412;
		goto yy3;
	}
yy299:
	yych = *++cur;
	if (yych == 'r') goto yy413;
	goto yy3;
yy300:
	yych = *++cur;
	if (yych == 's') goto yy414;
	goto yy3;
yy301:
	yych = *++cur;
	if (yych == 'i') goto yy415;
	goto yy3;
yy302:
	yych = *++cur;
	if (yych == 'c') goto yy416;
	goto yy3;
yy303:
	yych = *++cur;
	if (yych == '-') goto yy417;
	goto yy3;
yy304:
	yych = *++cur;
	if (yych == 'c') goto yy418;
	goto yy3;
yy305:
	yych = *++cur;
	if (yych == 'e') goto yy419;
	goto yy3;
yy306:
	yych = *++cur;
	if (yych == 'a') goto yy420;
	goto yy3;
yy307:
	yych = *++cur;
	if (yych == 'a') goto yy421;
	if (yych == 'n') goto yy422;
	goto yy3;
yy308:
	yych = *++cur;
	if (yych == 'l') goto yy423;
	goto yy3;
yy309:
	yych = *++cur;
	if (yych == 'x') goto yy424;
	goto yy3;
yy310:
	yych = *++cur;
	if (yych == 'e') goto yy425;
	goto yy3;
yy311:
	yych = *++cur;
	if (yych == 'r') goto yy426;
	goto yy3;
yy312:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 119 "../src/parse/conf_lexer.re"
	{ goto target; }
#line 1728 "src/parse/conf_lexer.cc"
yy313:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 280 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(unsafe); }
#line 1734 "src/parse/conf_lexer.cc"
yy314:
	yych = *++cur;
	if (yych == 'l') goto yy427;
	goto yy3;
yy315:
	yych = *++cur;
	if (yych == 'e') goto yy428;
	goto yy3;
yy316:
	yych = *++cur;
	if (yych == 'n') goto yy429;
	goto yy3;
yy317:
	yych = *++cur;
	if (yych == 'p') goto yy430;
	goto yy3;
yy318:
	yych = *++cur;
	if (yych == 'e') goto yy431;
	goto yy3;
yy319:
	yych = *++cur;
	if (yych == 'o') goto yy432;
	goto yy3;
yy320:
	yych = *++cur;
	if (yych == 'm') goto yy433;
	goto yy3;
yy321:
	yych = *++cur;
	if (yych == 'i') goto yy434;
	goto yy3;
yy322:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 243 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond); }
#line 1772 "src/parse/conf_lexer.cc"
yy323:
	yych = *++cur;
	if (yych == 'l') goto yy435;
	goto yy3;
yy324:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy436;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy325;
			if (yych <= 'z') goto yy2;
		}
	}
yy325:
#line 257 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_fill); }
#line 1798 "src/parse/conf_lexer.cc"
yy326:
	yych = *++cur;
	if (yych == 'e') goto yy437;
	goto yy3;
yy327:
	yych = *++cur;
	if (yych == 'h') goto yy438;
	goto yy3;
yy328:
	yych = *++cur;
	if (yych == 'c') goto yy439;
	goto yy3;
yy329:
	yych = *++cur;
	if (yych == 'c') goto yy440;
	goto yy3;
yy330:
	yych = *++cur;
	if (yych == 'r') goto yy441;
	goto yy3;
yy331:
	yych = *++cur;
	if (yych == 'l') goto yy442;
	goto yy3;
yy332:
	yych = *++cur;
	if (yych == 'e') goto yy443;
	goto yy3;
yy333:
	yych = *++cur;
	if (yych == 'e') goto yy444;
	goto yy3;
yy334:
	yych = *++cur;
	if (yych == 'P') goto yy445;
	goto yy3;
yy335:
	yych = *++cur;
	if (yych == 'Y') goto yy447;
	goto yy3;
yy336:
	yych = *++cur;
	if (yych == 'T') goto yy448;
	goto yy3;
yy337:
	yych = *++cur;
	if (yych == 'T') goto yy449;
	goto yy3;
yy338:
	yych = *++cur;
	if (yych == 'R') goto yy450;
	goto yy3;
yy339:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 196 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_char_type); }
#line 1856 "src/parse/conf_lexer.cc"
yy340:
	yych = *++cur;
	if (yych == 'R') goto yy451;
	goto yy3;
yy341:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 200 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_debug); }
#line 1866 "src/parse/conf_lexer.cc"
yy342:
	yych = *++cur;
	if (yych == 'n') goto yy452;
	goto yy3;
yy343:
	yych = *++cur;
	if (yych == 'l') goto yy453;
yy344:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy252;
			else goto yy556;
		} else {
			goto yy573;
		}
	} else {
		if (yyaccept <= 4) {
			if (yyaccept == 3) goto yy644;
			else goto yy690;
		} else {
			goto yy790;
		}
	}
yy345:
	yych = *++cur;
	if (yych == 'C') goto yy454;
	goto yy3;
yy346:
	yych = *++cur;
	if (yych == 'N') goto yy455;
	goto yy3;
yy347:
	yych = *++cur;
	if (yych == 'A') goto yy456;
	goto yy3;
yy348:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 198 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_input); }
#line 1908 "src/parse/conf_lexer.cc"
yy349:
	yych = *++cur;
	if (yych == 'H') goto yy457;
	goto yy3;
yy350:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 210 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_limit); }
#line 1918 "src/parse/conf_lexer.cc"
yy351:
	yych = *++cur;
	if (yych == 'R') goto yy458;
	goto yy3;
yy352:
	yych = *++cur;
	if (yych == 'L') goto yy459;
	goto yy3;
yy353:
	yych = *++cur;
	if (yych == 'A') goto yy460;
	goto yy3;
yy354:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 214 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_neg); }
#line 1936 "src/parse/conf_lexer.cc"
yy355:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 215 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_pos); }
#line 1942 "src/parse/conf_lexer.cc"
yy356:
	yych = *++cur;
	if (yych == 'R') goto yy461;
	goto yy3;
yy357:
	yych = *++cur;
	if (yych == 'C') goto yy462;
	goto yy3;
yy358:
	yych = *++cur;
	if (yych == 'N') goto yy463;
	goto yy3;
yy359:
	yych = *++cur;
	if (yych == 'A') goto yy464;
	goto yy3;
yy360:
	yych = *++cur;
	if (yych <= 'M') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy361;
			if (yych <= 'L') goto yy2;
			goto yy465;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'S') goto yy466;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy361;
			if (yych <= 'z') goto yy2;
		}
	}
yy361:
#line 227 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_shift); }
#line 1982 "src/parse/conf_lexer.cc"
yy362:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 231 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_neg); }
#line 1988 "src/parse/conf_lexer.cc"
yy363:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 232 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_pos); }
#line 1994 "src/parse/conf_lexer.cc"
yy364:
	yych = *++cur;
	if (yych == 'i') goto yy467;
	goto yy3;
yy365:
	yych = *++cur;
	if (yych == 'l') goto yy468;
	goto yy3;
yy366:
	yych = *++cur;
	if (yych == 't') goto yy469;
	goto yy3;
yy367:
	yych = *++cur;
	if (yych == 's') goto yy470;
	goto yy3;
yy368:
	yych = *++cur;
	if (yych == 's') goto yy471;
	goto yy3;
yy369:
	yych = *++cur;
	if (yych == 's') goto yy472;
	if (yych == 'v') goto yy473;
	goto yy3;
yy370:
	yych = *++cur;
	if (yych == 'n') goto yy474;
	goto yy3;
yy371:
	yych = *++cur;
	if (yych == 'e') goto yy475;
	goto yy3;
yy372:
	yych = *++cur;
	if (yych == 'h') goto yy476;
	goto yy3;
yy373:
	yych = *++cur;
	if (yych == 'd') goto yy477;
	goto yy3;
yy374:
	yych = *++cur;
	if (yych == 'd') goto yy478;
	goto yy3;
yy375:
	yych = *++cur;
	if (yych == 'o') goto yy479;
	goto yy3;
yy376:
	yych = *++cur;
	if (yych == 'v') goto yy480;
	goto yy3;
yy377:
	yych = *++cur;
	if (yych == 't') goto yy481;
	goto yy3;
yy378:
	yych = *++cur;
	if (yych == 'm') goto yy482;
	goto yy3;
yy379:
	yych = *++cur;
	if (yych == 'o') goto yy483;
	goto yy3;
yy380:
	yych = *++cur;
	if (yych == 'f') goto yy484;
	goto yy3;
yy381:
	yych = *++cur;
	if (yych == 'u') goto yy485;
	goto yy3;
yy382:
	yych = *++cur;
	if (yych == 'Y') goto yy4;
	goto yy3;
yy383:
	yych = *++cur;
	if (yych == 'l') goto yy486;
	goto yy3;
yy384:
	yych = *++cur;
	if (yych == 'g') goto yy487;
	goto yy3;
yy385:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 287 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF8); }
#line 2085 "src/parse/conf_lexer.cc"
yy386:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 166 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2097 "src/parse/conf_lexer.cc"
yy387:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy153;
yy388:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy24;
			if (yych <= 'z') goto yy2;
		}
	}
yy389:
#line 271 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(bitmaps, "bitmaps"); }
#line 2122 "src/parse/conf_lexer.cc"
yy390:
	yych = *++cur;
	if (yych == 'a') goto yy488;
	if (yych == 'o') goto yy489;
	goto yy3;
yy391:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'e') goto yy490;
			if (yych <= 'z') goto yy2;
		}
	}
yy392:
#line 272 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(debug); }
#line 2148 "src/parse/conf_lexer.cc"
yy393:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= ':') {
			if (yych == '-') goto yy2;
			if (yych >= '0') goto yy2;
		} else {
			if (yych <= '@') goto yy394;
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		}
	} else {
		if (yych <= 'l') {
			if (yych <= '`') goto yy394;
			if (yych == 'c') goto yy491;
			goto yy2;
		} else {
			if (yych <= 'm') goto yy30;
			if (yych <= 'n') goto yy492;
			if (yych <= 'z') goto yy2;
		}
	}
yy394:
#line 283 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::EBCDIC); }
#line 2174 "src/parse/conf_lexer.cc"
yy395:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
yy396:
#line 273 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(computed_gotos, "computed-gotos"); }
#line 2181 "src/parse/conf_lexer.cc"
yy397:
	yych = *++cur;
	if (yych == 'n') goto yy493;
	goto yy3;
yy398:
	yych = *++cur;
	if (yych == 'e') goto yy494;
	goto yy3;
yy399:
	yych = *++cur;
	if (yych == 'o') goto yy495;
	goto yy3;
yy400:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 276 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(nested_ifs, "nested-ifs"); }
#line 2199 "src/parse/conf_lexer.cc"
yy401:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy294;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy294;
			if (yych <= 'Z') goto yy2;
			goto yy294;
		}
	} else {
		if (yych <= 'a') {
			if (yych <= '_') goto yy2;
			if (yych <= '`') goto yy294;
			goto yy496;
		} else {
			if (yych == 'y') goto yy497;
			if (yych <= 'z') goto yy2;
			goto yy294;
		}
	}
yy402:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy403;
			if (yych <= 'Z') goto yy2;
		}
	} else {
		if (yych <= 'n') {
			if (yych == '`') goto yy403;
			if (yych <= 'm') goto yy2;
			goto yy498;
		} else {
			if (yych == 't') goto yy499;
			if (yych <= 'z') goto yy2;
		}
	}
yy403:
#line 284 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF32); }
#line 2246 "src/parse/conf_lexer.cc"
yy404:
	yych = *++cur;
	if (yych <= 'Z') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '`') {
			if (yych == '_') goto yy2;
		} else {
			if (yych == 'i') goto yy500;
			if (yych <= 'z') goto yy2;
		}
	}
yy405:
#line 285 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UCS2); }
#line 2267 "src/parse/conf_lexer.cc"
yy406:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 286 "../src/parse/conf_lexer.re"
	{ RET_CONF_ENC(Enc::Type::UTF16); }
#line 2273 "src/parse/conf_lexer.cc"
yy407:
	yych = *++cur;
	if (yych == 'n') goto yy501;
	goto yy3;
yy408:
	yych = *++cur;
	if (yych <= 'r') goto yy3;
	if (yych <= 's') goto yy502;
	if (yych <= 't') goto yy503;
	goto yy3;
yy409:
	yych = *++cur;
	if (yych == 'n') goto yy504;
	goto yy3;
yy410:
	yych = *++cur;
	if (yych == 'c') goto yy505;
	goto yy3;
yy411:
	yych = *++cur;
	if (yych == 't') goto yy506;
	goto yy3;
yy412:
	yych = *++cur;
	if (yych == 'y') goto yy507;
	goto yy3;
yy413:
	yych = *++cur;
	if (yych == 'e') goto yy508;
	goto yy3;
yy414:
	yych = *++cur;
	if (yych == 't') goto yy509;
	goto yy3;
yy415:
	yych = *++cur;
	if (yych == 'r') goto yy510;
	goto yy3;
yy416:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 281 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(monadic); }
#line 2317 "src/parse/conf_lexer.cc"
yy417:
	yych = *++cur;
	if (yych == 'i') goto yy511;
	goto yy3;
yy418:
	yych = *++cur;
	if (yych == 'a') goto yy512;
	goto yy3;
yy419:
	yych = *++cur;
	if (yych == 'l') goto yy513;
	goto yy3;
yy420:
	yych = *++cur;
	if (yych == 'b') goto yy514;
	goto yy3;
yy421:
	yych = *++cur;
	if (yych == 'b') goto yy515;
	goto yy3;
yy422:
	yych = *++cur;
	if (yych == 'e') goto yy516;
	goto yy3;
yy423:
	yych = *++cur;
	if (yych == 'e') goto yy517;
	goto yy3;
yy424:
	yych = *++cur;
	if (yych == 'p') goto yy518;
	goto yy3;
yy425:
	yych = *++cur;
	if (yych == 'g') goto yy519;
	goto yy3;
yy426:
	yych = *++cur;
	if (yych == 'e') goto yy520;
	goto yy3;
yy427:
	yych = *++cur;
	if (yych == 'e') goto yy521;
	goto yy3;
yy428:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 127 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(verbose); }
#line 2367 "src/parse/conf_lexer.cc"
yy429:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 123 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(version); }
#line 2373 "src/parse/conf_lexer.cc"
yy430:
	yych = *++cur;
	if (yych == 't') goto yy522;
	goto yy3;
yy431:
	yych = *++cur;
	if (yych == 'x') goto yy523;
	goto yy3;
yy432:
	yych = *++cur;
	if (yych == 'n') goto yy524;
	goto yy3;
yy433:
	yych = *++cur;
	if (yych == 'i') goto yy525;
	goto yy3;
yy434:
	yych = *++cur;
	if (yych == 't') goto yy526;
	goto yy3;
yy435:
	yych = *++cur;
	if (yych == 'e') goto yy527;
	goto yy3;
yy436:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'c') goto yy528;
		goto yy3;
	} else {
		if (yych <= 'e') goto yy529;
		if (yych == 'p') goto yy530;
		goto yy3;
	}
yy437:
	yych = *++cur;
	if (yych == 'p') goto yy531;
	goto yy3;
yy438:
	yych = *++cur;
	if (yych == 'r') goto yy532;
	goto yy3;
yy439:
	yych = *++cur;
	if (yych == 'h') goto yy533;
	goto yy3;
yy440:
	yych = *++cur;
	if (yych == 'h') goto yy534;
	goto yy3;
yy441:
	yych = *++cur;
	if (yych == 'd') goto yy535;
	goto yy3;
yy442:
	yych = *++cur;
	if (yych == 'e') goto yy536;
	goto yy3;
yy443:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 247 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_state); }
#line 2437 "src/parse/conf_lexer.cc"
yy444:
	yych = *++cur;
	if (yych == 't') goto yy537;
	goto yy3;
yy445:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'C') goto yy538;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy446;
			if (yych <= 'z') goto yy2;
		}
	}
yy446:
#line 191 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup); }
#line 2463 "src/parse/conf_lexer.cc"
yy447:
	yych = *++cur;
	if (yych == 'P') goto yy539;
	goto yy3;
yy448:
	yych = *++cur;
	if (yych == 'A') goto yy540;
	goto yy3;
yy449:
	yych = *++cur;
	if (yych == 'A') goto yy541;
	goto yy3;
yy450:
	yych = *++cur;
	if (yych == 'K') goto yy542;
	goto yy3;
yy451:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 199 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cursor); }
#line 2485 "src/parse/conf_lexer.cc"
yy452:
	yych = *++cur;
	if (yych == 'a') goto yy543;
	goto yy3;
yy453:
	yych = *++cur;
	if (yych == 'e') goto yy544;
	goto yy344;
yy454:
	yych = *++cur;
	if (yych == 'E') goto yy545;
	goto yy3;
yy455:
	yych = *++cur;
	if (yych == 'D') goto yy546;
	goto yy3;
yy456:
	yych = *++cur;
	if (yych == 'T') goto yy548;
	goto yy3;
yy457:
	yych = *++cur;
	if (yych == 'A') goto yy549;
	goto yy3;
yy458:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 211 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_marker); }
#line 2515 "src/parse/conf_lexer.cc"
yy459:
	yych = *++cur;
	if (yych == 'L') goto yy550;
	goto yy3;
yy460:
	yych = *++cur;
	if (yych == 'T') goto yy551;
	goto yy3;
yy461:
	yych = *++cur;
	if (yych == 'E') goto yy552;
	goto yy3;
yy462:
	yych = *++cur;
	if (yych == 'E') goto yy554;
	goto yy3;
yy463:
	yych = *++cur;
	if (yych == 'D') goto yy555;
	goto yy3;
yy464:
	yych = *++cur;
	if (yych == 'T') goto yy557;
	goto yy3;
yy465:
	yych = *++cur;
	if (yych == 'T') goto yy558;
	goto yy3;
yy466:
	yych = *++cur;
	if (yych == 'T') goto yy559;
	goto yy3;
yy467:
	yych = *++cur;
	if (yych == 'l') goto yy560;
	goto yy3;
yy468:
	yych = *++cur;
	if (yych == 'e') goto yy561;
	goto yy3;
yy469:
	yych = *++cur;
	if (yych == 'o') goto yy562;
	goto yy3;
yy470:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 160 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, true);
        return Ret::OK;
    }
#line 2570 "src/parse/conf_lexer.cc"
yy471:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 173 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 2581 "src/parse/conf_lexer.cc"
yy472:
	yych = *++cur;
	if (yych == 'e') goto yy563;
	goto yy3;
yy473:
	yych = *++cur;
	if (yych == 'e') goto yy564;
	goto yy3;
yy474:
	yych = *++cur;
	if (yych == 'g') goto yy565;
	goto yy3;
yy475:
	yych = *++cur;
	if (yych == 'l') goto yy566;
	goto yy3;
yy476:
	yych = *++cur;
	if (yych == 'r') goto yy567;
	goto yy3;
yy477:
	yych = *++cur;
	if (yych == 'e') goto yy568;
	goto yy3;
yy478:
	yych = *++cur;
	if (yych == '-') goto yy569;
	goto yy3;
yy479:
	yych = *++cur;
	if (yych == 'r') goto yy570;
	goto yy3;
yy480:
	yych = *++cur;
	if (yych == 'i') goto yy571;
	goto yy3;
yy481:
	yych = *++cur;
	if (yych == 'o') goto yy572;
	goto yy3;
yy482:
	yych = *++cur;
	if (yych == 'p') goto yy574;
	goto yy3;
yy483:
	yych = *++cur;
	if (yych == 'n') goto yy575;
	goto yy3;
yy484:
	yych = *++cur;
	if (yych == 'i') goto yy576;
	goto yy3;
yy485:
	yych = *++cur;
	if (yych == 't') goto yy577;
	goto yy3;
yy486:
	yych = *++cur;
	if (yych == 'a') goto yy578;
	goto yy3;
yy487:
	yych = *++cur;
	if (yych == '-') goto yy579;
	if (yych == ':') goto yy580;
	goto yy3;
yy488:
	yych = *++cur;
	if (yych == 'p') goto yy581;
	if (yych == 's') goto yy64;
	goto yy3;
yy489:
	yych = *++cur;
	if (yych == 'm') goto yy582;
	goto yy3;
yy490:
	yych = *++cur;
	if (yych == 'b') goto yy70;
	goto yy3;
yy491:
	yych = *++cur;
	if (yych == 'b') goto yy583;
	goto yy3;
yy492:
	yych = *++cur;
	if (yych == 'c') goto yy584;
	goto yy3;
yy493:
	yych = *++cur;
	if (yych == 'p') goto yy585;
	goto yy3;
yy494:
	yych = *++cur;
	if (yych == 'f') goto yy586;
	goto yy3;
yy495:
	yych = *++cur;
	if (yych == 's') goto yy587;
	goto yy3;
yy496:
	yych = *++cur;
	if (yych == 'g') goto yy588;
	goto yy3;
yy497:
	yych = *++cur;
	if (yych == 'p') goto yy589;
	goto yy3;
yy498:
	yych = *++cur;
	if (yych == 'i') goto yy590;
	if (yych == 's') goto yy92;
	goto yy3;
yy499:
	yych = *++cur;
	if (yych == 'f') goto yy591;
	goto yy3;
yy500:
	yych = *++cur;
	if (yych == 'd') goto yy592;
	goto yy3;
yy501:
	yych = *++cur;
	if (yych == 't') goto yy593;
	goto yy3;
yy502:
	yych = *++cur;
	if (yych == 't') goto yy594;
	goto yy3;
yy503:
	yych = *++cur;
	if (yych == 'o') goto yy595;
	goto yy3;
yy504:
	yych = *++cur;
	if (yych == 'c') goto yy596;
	goto yy3;
yy505:
	yych = *++cur;
	if (yych == 'a') goto yy597;
	goto yy3;
yy506:
	yych = *++cur;
	if (yych == 'a') goto yy598;
	goto yy3;
yy507:
	yych = *++cur;
	if (yych <= 'N') {
		if (yych == 'F') goto yy599;
		if (yych <= 'M') goto yy3;
		goto yy600;
	} else {
		if (yych <= 'f') {
			if (yych <= 'e') goto yy3;
			goto yy601;
		} else {
			if (yych == 'l') goto yy602;
			goto yy3;
		}
	}
yy508:
	yych = *++cur;
	if (yych == 'f') goto yy603;
	goto yy3;
yy509:
	yych = *++cur;
	if (yych == '-') goto yy604;
	goto yy3;
yy510:
	yych = *++cur;
	if (yych == 's') goto yy605;
	goto yy3;
yy511:
	yych = *++cur;
	if (yych == 'f') goto yy606;
	goto yy3;
yy512:
	yych = *++cur;
	if (yych == 'p') goto yy607;
	goto yy3;
yy513:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 148 "../src/parse/conf_lexer.re"
	{ RET_CONF_EOF(fill_sentinel); }
#line 2765 "src/parse/conf_lexer.cc"
yy514:
	yych = *++cur;
	if (yych == 'e') goto yy608;
	goto yy3;
yy515:
	yych = *++cur;
	if (yych == 'o') goto yy609;
	goto yy3;
yy516:
	yych = *++cur;
	if (yych == 'x') goto yy610;
	goto yy3;
yy517:
	yych = *++cur;
	if (yych == '-') goto yy611;
	goto yy3;
yy518:
	yych = *++cur;
	if (yych == 'r') goto yy612;
	goto yy3;
yy519:
	yych = *++cur;
	if (yych == 'a') goto yy613;
	goto yy3;
yy520:
	yych = *++cur;
	if (yych == 'f') goto yy614;
	goto yy3;
yy521:
	yych = *++cur;
	if (yych == ':') goto yy615;
	goto yy3;
yy522:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 245 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_accept); }
#line 2803 "src/parse/conf_lexer.cc"
yy523:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 256 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(bitmaps_hex); }
#line 2809 "src/parse/conf_lexer.cc"
yy524:
	yych = *++cur;
	if (yych == 'v') goto yy616;
	goto yy3;
yy525:
	yych = *++cur;
	if (yych == 't') goto yy617;
	goto yy3;
yy526:
	yych = *++cur;
	if (yych == 'e') goto yy618;
	goto yy3;
yy527:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 244 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cond_table); }
#line 2827 "src/parse/conf_lexer.cc"
yy528:
	yych = *++cur;
	if (yych == 'h') goto yy619;
	goto yy3;
yy529:
	yych = *++cur;
	if (yych == 'n') goto yy620;
	goto yy3;
yy530:
	yych = *++cur;
	if (yych == 'a') goto yy621;
	goto yy3;
yy531:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 154 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fn_sep); }
#line 2845 "src/parse/conf_lexer.cc"
yy532:
	yych = *++cur;
	if (yych == 'o') goto yy622;
	goto yy3;
yy533:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 248 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_nmatch); }
#line 2855 "src/parse/conf_lexer.cc"
yy534:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 249 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_pmatch); }
#line 2861 "src/parse/conf_lexer.cc"
yy535:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 250 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_record); }
#line 2867 "src/parse/conf_lexer.cc"
yy536:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 258 "../src/parse/conf_lexer.re"
	{ return lex_conf_string(opts); }
#line 2873 "src/parse/conf_lexer.cc"
yy537:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 246 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(var_cgoto_table); }
#line 2879 "src/parse/conf_lexer.cc"
yy538:
	yych = *++cur;
	if (yych == 'T') goto yy623;
	goto yy3;
yy539:
	yych = *++cur;
	if (yych == 'E') goto yy624;
	goto yy3;
yy540:
	yych = *++cur;
	if (yych == 'G') goto yy625;
	goto yy3;
yy541:
	yych = *++cur;
	if (yych == 'G') goto yy626;
	goto yy3;
yy542:
	yych = *++cur;
	if (yych == 'E') goto yy627;
	goto yy3;
yy543:
	yych = *++cur;
	if (yych == 'k') goto yy628;
	goto yy3;
yy544:
	yych = *++cur;
	if (yych == 'n') goto yy629;
	goto yy344;
yy545:
	yych = *++cur;
	if (yych == 'P') goto yy630;
	goto yy3;
yy546:
	yych = *++cur;
	if (yych <= 'H') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy631;
			if (yych >= 'A') goto yy2;
		}
	} else {
		if (yych <= '^') {
			if (yych <= 'I') goto yy632;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy547;
			if (yych <= 'z') goto yy2;
		}
	}
yy547:
#line 205 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_get); }
#line 2934 "src/parse/conf_lexer.cc"
yy548:
	yych = *++cur;
	if (yych == 'E') goto yy633;
	goto yy3;
yy549:
	yych = *++cur;
	if (yych == 'N') goto yy635;
	goto yy3;
yy550:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 212 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxfill); }
#line 2948 "src/parse/conf_lexer.cc"
yy551:
	yych = *++cur;
	if (yych == 'C') goto yy636;
	goto yy3;
yy552:
	yych = *++cur;
	if (yych <= 'C') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= ':') goto yy2;
			if (yych <= '@') goto yy553;
			if (yych <= 'B') goto yy2;
			goto yy637;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'T') goto yy638;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy553;
			if (yych <= 'z') goto yy2;
		}
	}
yy553:
#line 217 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore); }
#line 2976 "src/parse/conf_lexer.cc"
yy554:
	yych = *++cur;
	if (yych == 'P') goto yy639;
	goto yy3;
yy555:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy640;
			if (yych >= '@') goto yy641;
		}
	} else {
		if (yych <= '^') {
			if (yych == 'I') goto yy642;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy556;
			if (yych <= 'z') goto yy2;
		}
	}
yy556:
#line 221 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_set); }
#line 3004 "src/parse/conf_lexer.cc"
yy557:
	yych = *++cur;
	if (yych == 'E') goto yy643;
	goto yy3;
yy558:
	yych = *++cur;
	if (yych == 'A') goto yy645;
	goto yy3;
yy559:
	yych = *++cur;
	if (yych == 'A') goto yy646;
	goto yy3;
yy560:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 134 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(api_sigil); }
#line 3022 "src/parse/conf_lexer.cc"
yy561:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 133 "../src/parse/conf_lexer.re"
	{ goto api_style; }
#line 3028 "src/parse/conf_lexer.cc"
yy562:
	yych = *++cur;
	if (yych == 'r') goto yy647;
	goto yy3;
yy563:
	yych = *++cur;
	if (yych == 'n') goto yy648;
	goto yy3;
yy564:
	yych = *++cur;
	if (yych == 'r') goto yy649;
	goto yy3;
yy565:
	yych = *++cur;
	if (yych == 'e') goto yy650;
	goto yy3;
yy566:
	yych = *++cur;
	if (yych == 'a') goto yy651;
	goto yy3;
yy567:
	yych = *++cur;
	if (yych == 'e') goto yy652;
	goto yy3;
yy568:
	yych = *++cur;
	if (yych == 'l') goto yy653;
	goto yy3;
yy569:
	yych = *++cur;
	if (yych == 'g') goto yy654;
	goto yy3;
yy570:
	yych = *++cur;
	if (yych == 't') goto yy655;
	goto yy3;
yy571:
	yych = *++cur;
	if (yych == 'd') goto yy656;
	goto yy3;
yy572:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy657;
yy573:
#line 265 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_goto); }
#line 3077 "src/parse/conf_lexer.cc"
yy574:
	yych = *++cur;
	if (yych == 'r') goto yy658;
	goto yy3;
yy575:
	yych = *++cur;
	if (yych == 's') goto yy659;
	goto yy3;
yy576:
	yych = *++cur;
	if (yych == 'x') goto yy660;
	goto yy3;
yy577:
	yych = *++cur;
	if (yych == 'p') goto yy661;
	goto yy3;
yy578:
	yych = *++cur;
	if (yych == 's') goto yy662;
	goto yy3;
yy579:
	yych = *++cur;
	if (yych == 'p') goto yy663;
	goto yy3;
yy580:
	yych = *++cur;
	if (yych == 'e') goto yy664;
	if (yych == 'u') goto yy665;
	goto yy3;
yy581:
	yych = *++cur;
	if (yych == 't') goto yy666;
	goto yy3;
yy582:
	yych = *++cur;
	if (yych == 'p') goto yy667;
	goto yy3;
yy583:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy394;
yy584:
	yych = *++cur;
	if (yych == 'o') goto yy668;
	goto yy3;
yy585:
	yych = *++cur;
	if (yych == 'u') goto yy669;
	goto yy3;
yy586:
	yych = *++cur;
	if (yych == 't') goto yy670;
	goto yy3;
yy587:
	yych = *++cur;
	if (yych == 'i') goto yy671;
	goto yy3;
yy588:
	yych = *++cur;
	if (yych == 's') goto yy387;
	goto yy3;
yy589:
	yych = *++cur;
	if (yych == 'e') goto yy672;
	goto yy3;
yy590:
	yych = *++cur;
	if (yych == 'c') goto yy673;
	goto yy3;
yy591:
	yych = *++cur;
	if (yych == '-') goto yy674;
	goto yy3;
yy592:
	yych = *++cur;
	if (yych == 'e') goto yy675;
	goto yy3;
yy593:
	yych = *++cur;
	if (yych == 'a') goto yy676;
	goto yy3;
yy594:
	yych = *++cur;
	if (yych == 'r') goto yy677;
	goto yy3;
yy595:
	yych = *++cur;
	if (yych == 'p') goto yy678;
	goto yy3;
yy596:
	yych = *++cur;
	if (yych == 'o') goto yy679;
	goto yy3;
yy597:
	yych = *++cur;
	if (yych == 'p') goto yy680;
	goto yy3;
yy598:
	yych = *++cur;
	if (yych == 'r') goto yy681;
	goto yy3;
yy599:
	yych = *++cur;
	if (yych == 'i') goto yy682;
	goto yy3;
yy600:
	yych = *++cur;
	if (yych == 'e') goto yy683;
	goto yy3;
yy601:
	yych = *++cur;
	if (yych == 'i') goto yy684;
	goto yy3;
yy602:
	yych = *++cur;
	if (yych == 'o') goto yy685;
	goto yy3;
yy603:
	yych = *++cur;
	if (yych == 'i') goto yy686;
	goto yy3;
yy604:
	yych = *++cur;
	if (yych == 'c') goto yy687;
	goto yy3;
yy605:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 128 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(line_dirs); }
#line 3208 "src/parse/conf_lexer.cc"
yy606:
	yych = *++cur;
	if (yych == 's') goto yy400;
	goto yy3;
yy607:
	yych = *++cur;
	if (yych == 't') goto yy688;
	goto yy3;
yy608:
	yych = *++cur;
	if (yych == 'l') goto yy689;
	goto yy3;
yy609:
	yych = *++cur;
	if (yych == 'r') goto yy691;
	goto yy3;
yy610:
	yych = *++cur;
	if (yych == 't') goto yy692;
	goto yy3;
yy611:
	yych = *++cur;
	if (yych == 's') goto yy693;
	goto yy3;
yy612:
	yych = *++cur;
	if (yych == 'e') goto yy694;
	goto yy3;
yy613:
	yych = *++cur;
	if (yych == 't') goto yy695;
	goto yy3;
yy614:
	yych = *++cur;
	if (yych == 'i') goto yy696;
	goto yy3;
yy615:
	yych = *++cur;
	if (yych == 'y') goto yy697;
	goto yy3;
yy616:
	yych = *++cur;
	if (yych == 'e') goto yy698;
	goto yy3;
yy617:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 254 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_emit); }
#line 3258 "src/parse/conf_lexer.cc"
yy618:
	yych = *++cur;
	if (yych == 'r') goto yy699;
	goto yy3;
yy619:
	yych = *++cur;
	if (yych == 'e') goto yy700;
	goto yy3;
yy620:
	yych = *++cur;
	if (yych == 'a') goto yy701;
	goto yy3;
yy621:
	yych = *++cur;
	if (yych == 'r') goto yy702;
	goto yy3;
yy622:
	yych = *++cur;
	if (yych == 'w') goto yy703;
	goto yy3;
yy623:
	yych = *++cur;
	if (yych == 'X') goto yy704;
	goto yy3;
yy624:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 193 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_cond_type); }
#line 3288 "src/parse/conf_lexer.cc"
yy625:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 194 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_copy); }
#line 3294 "src/parse/conf_lexer.cc"
yy626:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 195 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_copy); }
#line 3300 "src/parse/conf_lexer.cc"
yy627:
	yych = *++cur;
	if (yych == 'R') goto yy705;
	goto yy3;
yy628:
	yych = *++cur;
	if (yych == 'e') goto yy706;
	goto yy3;
yy629:
	++cur;
#line 202 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fill_param); }
#line 3313 "src/parse/conf_lexer.cc"
yy630:
	yych = *++cur;
	if (yych == 'T') goto yy707;
	goto yy3;
yy631:
	yych = *++cur;
	if (yych == 'n') goto yy708;
	goto yy3;
yy632:
	yych = *++cur;
	if (yych == 'T') goto yy709;
	goto yy3;
yy633:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy710;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych >= '_') goto yy2;
		} else {
			if (yych <= '`') goto yy634;
			if (yych <= 'z') goto yy2;
		}
	}
yy634:
#line 207 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_get); }
#line 3347 "src/parse/conf_lexer.cc"
yy635:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 209 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_less_than); }
#line 3353 "src/parse/conf_lexer.cc"
yy636:
	yych = *++cur;
	if (yych == 'H') goto yy711;
	goto yy3;
yy637:
	yych = *++cur;
	if (yych == 'T') goto yy712;
	goto yy3;
yy638:
	yych = *++cur;
	if (yych == 'A') goto yy713;
	goto yy3;
yy639:
	yych = *++cur;
	if (yych == 'T') goto yy714;
	goto yy3;
yy640:
	yych = *++cur;
	if (yych == 'n') goto yy715;
	goto yy3;
yy641:
	yych = *++cur;
	if (yych == 'c') goto yy716;
	goto yy344;
yy642:
	yych = *++cur;
	if (yych == 'T') goto yy717;
	goto yy3;
yy643:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy718;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy719;
			if (yych <= 'Z') goto yy2;
		} else {
			if (yych == '`') goto yy644;
			if (yych <= 'z') goto yy2;
		}
	}
yy644:
#line 224 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_state_set); }
#line 3404 "src/parse/conf_lexer.cc"
yy645:
	yych = *++cur;
	if (yych == 'G') goto yy720;
	goto yy3;
yy646:
	yych = *++cur;
	if (yych == 'G') goto yy721;
	goto yy3;
yy647:
	yych = *++cur;
	if (yych == 's') goto yy722;
	goto yy3;
yy648:
	yych = *++cur;
	if (yych == 's') goto yy723;
	goto yy3;
yy649:
	yych = *++cur;
	if (yych == 't') goto yy724;
	goto yy3;
yy650:
	yych = *++cur;
	if (yych == 's') goto yy725;
	goto yy3;
yy651:
	yych = *++cur;
	if (yych == 't') goto yy726;
	goto yy3;
yy652:
	yych = *++cur;
	if (yych == 's') goto yy727;
	goto yy3;
yy653:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 120 "../src/parse/conf_lexer.re"
	{ goto code_model; }
#line 3442 "src/parse/conf_lexer.cc"
yy654:
	yych = *++cur;
	if (yych == 'o') goto yy728;
	goto yy3;
yy655:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 260 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_abort); }
#line 3452 "src/parse/conf_lexer.cc"
yy656:
	yych = *++cur;
	if (yych == 'e') goto yy729;
	goto yy3;
yy657:
	yych = *++cur;
	if (yych == 'c') goto yy730;
	goto yy344;
yy658:
	yych = *++cur;
	if (yych == 'e') goto yy731;
	goto yy3;
yy659:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 124 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(start_conditions); }
#line 3470 "src/parse/conf_lexer.cc"
yy660:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 261 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_label_prefix); }
#line 3476 "src/parse/conf_lexer.cc"
yy661:
	yych = *++cur;
	if (yych == 'u') goto yy732;
	goto yy3;
yy662:
	yych = *++cur;
	if (yych == 's') goto yy733;
	goto yy3;
yy663:
	yych = *++cur;
	if (yych == 'o') goto yy734;
	goto yy3;
yy664:
	yych = *++cur;
	if (yych == 'b') goto yy735;
	goto yy3;
yy665:
	yych = *++cur;
	if (yych == 'c') goto yy736;
	if (yych == 't') goto yy737;
	goto yy3;
yy666:
	yych = *++cur;
	if (yych == 'u') goto yy196;
	goto yy3;
yy667:
	yych = *++cur;
	if (yych == 'u') goto yy738;
	goto yy3;
yy668:
	yych = *++cur;
	if (yych == 'd') goto yy739;
	goto yy3;
yy669:
	yych = *++cur;
	if (yych == 't') goto yy740;
	goto yy3;
yy670:
	yych = *++cur;
	if (yych == 'm') goto yy741;
	goto yy3;
yy671:
	yych = *++cur;
	if (yych == 'x') goto yy742;
	goto yy3;
yy672:
	yych = *++cur;
	if (yych == '-') goto yy743;
	goto yy3;
yy673:
	yych = *++cur;
	if (yych == 'o') goto yy744;
	goto yy3;
yy674:
	yych = *++cur;
	if (yych == '1') goto yy745;
	if (yych == '8') goto yy385;
	goto yy3;
yy675:
	yych = *++cur;
	if (yych == '-') goto yy746;
	goto yy3;
yy676:
	yych = *++cur;
	if (yych == 'x') goto yy747;
	goto yy3;
yy677:
	yych = *++cur;
	if (yych == 'i') goto yy748;
	goto yy3;
yy678:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 293 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(indent_top); }
#line 3552 "src/parse/conf_lexer.cc"
yy679:
	yych = *++cur;
	if (yych == 'd') goto yy749;
	goto yy3;
yy680:
	yych = *++cur;
	if (yych == 't') goto yy750;
	goto yy3;
yy681:
	yych = *++cur;
	if (yych == 't') goto yy689;
	goto yy3;
yy682:
	yych = *++cur;
	if (yych == 'l') goto yy751;
	goto yy3;
yy683:
	yych = *++cur;
	if (yych == 'x') goto yy752;
	goto yy3;
yy684:
	yych = *++cur;
	if (yych == 'l') goto yy753;
	goto yy3;
yy685:
	yych = *++cur;
	if (yych == 'o') goto yy754;
	goto yy3;
yy686:
	yych = *++cur;
	if (yych == 'x') goto yy755;
	goto yy3;
yy687:
	yych = *++cur;
	if (yych == 'a') goto yy756;
	goto yy3;
yy688:
	yych = *++cur;
	if (yych <= 't') goto yy3;
	if (yych <= 'u') goto yy757;
	if (yych <= 'v') goto yy758;
	goto yy3;
yy689:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych <= '\r') {
		if (yych == '\t') {
			ctx = cur;
			goto yy759;
		}
		if (yych >= '\r') {
			ctx = cur;
			goto yy759;
		}
	} else {
		if (yych <= ' ') {
			if (yych >= ' ') {
				ctx = cur;
				goto yy759;
			}
		} else {
			if (yych == '=') {
				ctx = cur;
				goto yy760;
			}
		}
	}
yy690:
#line 300 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_start); }
#line 3624 "src/parse/conf_lexer.cc"
yy691:
	yych = *++cur;
	if (yych == 't') goto yy761;
	goto yy3;
yy692:
	yych = *++cur;
	if (yych == 'l') goto yy762;
	goto yy3;
yy693:
	yych = *++cur;
	if (yych == 't') goto yy763;
	goto yy3;
yy694:
	yych = *++cur;
	if (yych == 's') goto yy764;
	goto yy3;
yy695:
	yych = *++cur;
	if (yych == 'i') goto yy765;
	goto yy3;
yy696:
	yych = *++cur;
	if (yych == 'x') goto yy766;
	goto yy3;
yy697:
	yych = *++cur;
	if (yych == 'y') goto yy767;
	goto yy3;
yy698:
	yych = *++cur;
	if (yych == 'r') goto yy768;
	goto yy3;
yy699:
	yych = *++cur;
	if (yych == 'a') goto yy769;
	goto yy3;
yy700:
	yych = *++cur;
	if (yych == 'c') goto yy770;
	goto yy3;
yy701:
	yych = *++cur;
	if (yych == 'b') goto yy771;
	goto yy3;
yy702:
	yych = *++cur;
	if (yych == 'a') goto yy772;
	goto yy3;
yy703:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 155 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(fn_throw); }
#line 3678 "src/parse/conf_lexer.cc"
yy704:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 192 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_backup_ctx); }
#line 3684 "src/parse/conf_lexer.cc"
yy705:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 197 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_ctxmarker); }
#line 3690 "src/parse/conf_lexer.cc"
yy706:
	yych = *++cur;
	if (yych == 'd') goto yy773;
	goto yy3;
yy707:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 204 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_get); }
#line 3700 "src/parse/conf_lexer.cc"
yy708:
	yych = *++cur;
	if (yych == 'a') goto yy774;
	goto yy3;
yy709:
	yych = *++cur;
	if (yych == 'I') goto yy775;
	goto yy3;
yy710:
	yych = *++cur;
	if (yych == 'n') goto yy776;
	goto yy3;
yy711:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 213 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_maxnmatch); }
#line 3718 "src/parse/conf_lexer.cc"
yy712:
	yych = *++cur;
	if (yych == 'X') goto yy777;
	goto yy3;
yy713:
	yych = *++cur;
	if (yych == 'G') goto yy778;
	goto yy3;
yy714:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 220 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_accept_set); }
#line 3732 "src/parse/conf_lexer.cc"
yy715:
	yych = *++cur;
	if (yych == 'a') goto yy779;
	goto yy3;
yy716:
	yych = *++cur;
	if (yych == 'o') goto yy780;
	goto yy344;
yy717:
	yych = *++cur;
	if (yych == 'I') goto yy781;
	goto yy3;
yy718:
	yych = *++cur;
	if (yych == 'n') goto yy782;
	goto yy3;
yy719:
	yych = *++cur;
	if (yych == 's') goto yy783;
	goto yy344;
yy720:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 229 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_mtag_shift); }
#line 3758 "src/parse/conf_lexer.cc"
yy721:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 228 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_stag_shift); }
#line 3764 "src/parse/conf_lexer.cc"
yy722:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy389;
yy723:
	yych = *++cur;
	if (yych == 'i') goto yy784;
	goto yy3;
yy724:
	yych = *++cur;
	if (yych == 'e') goto yy785;
	goto yy3;
yy725:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 279 "../src/parse/conf_lexer.re"
	{ RET_CONF_FEAT(case_ranges, "case-ranges"); }
#line 3782 "src/parse/conf_lexer.cc"
yy726:
	yych = *++cur;
	if (yych == 'i') goto yy786;
	goto yy3;
yy727:
	yych = *++cur;
	if (yych == 'h') goto yy787;
	goto yy3;
yy728:
	yych = *++cur;
	if (yych == 't') goto yy788;
	goto yy3;
yy729:
	yych = *++cur;
	if (yych == 'r') goto yy789;
	goto yy3;
yy730:
	yych = *++cur;
	if (yych == 'o') goto yy791;
	goto yy344;
yy731:
	yych = *++cur;
	if (yych == 'f') goto yy792;
	goto yy3;
yy732:
	yych = *++cur;
	if (yych == 't') goto yy793;
	goto yy3;
yy733:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 290 "../src/parse/conf_lexer.re"
	{ goto empty_class; }
#line 3816 "src/parse/conf_lexer.cc"
yy734:
	yych = *++cur;
	if (yych == 'l') goto yy794;
	goto yy3;
yy735:
	yych = *++cur;
	if (yych == 'c') goto yy795;
	goto yy3;
yy736:
	yych = *++cur;
	if (yych == 's') goto yy796;
	goto yy3;
yy737:
	yych = *++cur;
	if (yych == 'f') goto yy797;
	goto yy3;
yy738:
	yych = *++cur;
	if (yych == 't') goto yy798;
	goto yy3;
yy739:
	yych = *++cur;
	if (yych == 'i') goto yy799;
	goto yy3;
yy740:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy61;
yy741:
	yych = *++cur;
	if (yych == 'o') goto yy800;
	goto yy3;
yy742:
	yych = *++cur;
	if (yych == '-') goto yy801;
	goto yy3;
yy743:
	yych = *++cur;
	if (yych == 'h') goto yy11;
	goto yy3;
yy744:
	yych = *++cur;
	if (yych == 'd') goto yy802;
	goto yy3;
yy745:
	yych = *++cur;
	if (yych == '6') goto yy406;
	goto yy3;
yy746:
	yych = *++cur;
	if (yych == 'c') goto yy803;
	goto yy3;
yy747:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 126 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(flex_syntax); }
#line 3874 "src/parse/conf_lexer.cc"
yy748:
	yych = *++cur;
	if (yych == 'n') goto yy804;
	goto yy3;
yy749:
	yych = *++cur;
	if (yych == 'i') goto yy805;
	goto yy3;
yy750:
	yych = *++cur;
	if (yych == 'u') goto yy806;
	goto yy3;
yy751:
	yych = *++cur;
	if (yych == 'l') goto yy807;
	goto yy3;
yy752:
	yych = *++cur;
	if (yych == 't') goto yy808;
	goto yy3;
yy753:
	yych = *++cur;
	if (yych == 'l') goto yy809;
	goto yy3;
yy754:
	yych = *++cur;
	if (yych == 'p') goto yy810;
	goto yy3;
yy755:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 295 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_prefix); }
#line 3908 "src/parse/conf_lexer.cc"
yy756:
	yych = *++cur;
	if (yych == 'p') goto yy63;
	goto yy3;
yy757:
	yych = *++cur;
	if (yych == 'r') goto yy811;
	goto yy3;
yy758:
	yych = *++cur;
	if (yych == 'a') goto yy812;
	goto yy3;
yy759:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy759;
	if (yych != '=') goto yy344;
yy760:
	++cur;
	if ((lim - cur) < 2) YYFILL(2);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\f') {
			if (yych == '\t') goto yy760;
			goto yy344;
		} else {
			if (yych <= '\r') goto yy760;
			if (yych <= 0x1F) goto yy344;
			goto yy760;
		}
	} else {
		if (yych <= '/') {
			if (yych == '-') goto yy813;
			goto yy344;
		} else {
			if (yych <= '0') goto yy814;
			if (yych <= '9') goto yy816;
			goto yy344;
		}
	}
yy761:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 268 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_abort); }
#line 3955 "src/parse/conf_lexer.cc"
yy762:
	yych = *++cur;
	if (yych == 'a') goto yy817;
	goto yy3;
yy763:
	yych = *++cur;
	if (yych == 'a') goto yy818;
	goto yy3;
yy764:
	yych = *++cur;
	if (yych == 's') goto yy819;
	goto yy3;
yy765:
	yych = *++cur;
	if (yych == 'v') goto yy820;
	goto yy3;
yy766:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 186 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(tags_prefix); }
#line 3977 "src/parse/conf_lexer.cc"
yy767:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy95;
		case 'b': goto yy96;
		case 'c': goto yy97;
		case 'f': goto yy821;
		case 'n': goto yy99;
		case 'p': goto yy100;
		case 'r': goto yy101;
		case 's': goto yy102;
		case 't': goto yy103;
		default: goto yy3;
	}
yy768:
	yych = *++cur;
	if (yych == 's') goto yy822;
	goto yy3;
yy769:
	yych = *++cur;
	if (yych == 'l') goto yy823;
	goto yy3;
yy770:
	yych = *++cur;
	if (yych == 'k') goto yy824;
	goto yy3;
yy771:
	yych = *++cur;
	if (yych == 'l') goto yy825;
	goto yy3;
yy772:
	yych = *++cur;
	if (yych == 'm') goto yy826;
	goto yy3;
yy773:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 203 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_naked); }
#line 4017 "src/parse/conf_lexer.cc"
yy774:
	yych = *++cur;
	if (yych == 'k') goto yy827;
	goto yy3;
yy775:
	yych = *++cur;
	if (yych == 'O') goto yy828;
	goto yy3;
yy776:
	yych = *++cur;
	if (yych == 'a') goto yy829;
	goto yy3;
yy777:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 218 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_ctx); }
#line 4035 "src/parse/conf_lexer.cc"
yy778:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 219 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(api_restore_tag); }
#line 4041 "src/parse/conf_lexer.cc"
yy779:
	yych = *++cur;
	if (yych == 'k') goto yy830;
	goto yy3;
yy780:
	yych = *++cur;
	if (yych == 'n') goto yy831;
	goto yy344;
yy781:
	yych = *++cur;
	if (yych == 'O') goto yy832;
	goto yy3;
yy782:
	yych = *++cur;
	if (yych == 'a') goto yy833;
	goto yy3;
yy783:
	yych = *++cur;
	if (yych == 't') goto yy834;
	goto yy344;
yy784:
	yych = *++cur;
	if (yych == 't') goto yy835;
	goto yy3;
yy785:
	yych = *++cur;
	if (yych == 'd') goto yy836;
	goto yy3;
yy786:
	yych = *++cur;
	if (yych == 'v') goto yy837;
	goto yy3;
yy787:
	yych = *++cur;
	if (yych == 'o') goto yy838;
	goto yy3;
yy788:
	yych = *++cur;
	if (yych == 'o') goto yy839;
	goto yy3;
yy789:
	yyaccept = 5;
	yych = *(mar = ++cur);
	if (yybm[0+yych] & 32) goto yy2;
	if (yych == '@') goto yy840;
yy790:
#line 263 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(cond_div); }
#line 4090 "src/parse/conf_lexer.cc"
yy791:
	yych = *++cur;
	if (yych == 'n') goto yy841;
	goto yy344;
yy792:
	yych = *++cur;
	if (yych == 'i') goto yy842;
	goto yy3;
yy793:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy392;
yy794:
	yych = *++cur;
	if (yych == 'i') goto yy843;
	goto yy3;
yy795:
	yych = *++cur;
	if (yych == 'd') goto yy844;
	goto yy3;
yy796:
	yych = *++cur;
	if (yych == '2') goto yy845;
	goto yy3;
yy797:
	yych = *++cur;
	if (yych <= '2') {
		if (yych == '1') goto yy745;
		goto yy3;
	} else {
		if (yych <= '3') goto yy846;
		if (yych == '8') goto yy385;
		goto yy3;
	}
yy798:
	yych = *++cur;
	if (yych == 'e') goto yy847;
	goto yy3;
yy799:
	yych = *++cur;
	if (yych == 'n') goto yy848;
	goto yy3;
yy800:
	yych = *++cur;
	if (yych == 's') goto yy849;
	goto yy3;
yy801:
	yych = *++cur;
	if (yych == 'c') goto yy850;
	goto yy3;
yy802:
	yych = *++cur;
	if (yych == 'e') goto yy851;
	goto yy3;
yy803:
	yych = *++cur;
	if (yych == 'h') goto yy852;
	goto yy3;
yy804:
	yych = *++cur;
	if (yych == 'g') goto yy853;
	goto yy3;
yy805:
	yych = *++cur;
	if (yych == 'n') goto yy854;
	goto yy3;
yy806:
	yych = *++cur;
	if (yych == 'r') goto yy855;
	goto yy3;
yy807:
	yych = *++cur;
	if (yych == 'L') goto yy856;
	goto yy3;
yy808:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 298 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_next); }
#line 4170 "src/parse/conf_lexer.cc"
yy809:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 296 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_fill); }
#line 4176 "src/parse/conf_lexer.cc"
yy810:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 297 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(label_loop); }
#line 4182 "src/parse/conf_lexer.cc"
yy811:
	yych = *++cur;
	if (yych == 'e') goto yy857;
	goto yy3;
yy812:
	yych = *++cur;
	if (yych == 'r') goto yy858;
	goto yy3;
yy813:
	yych = *++cur;
	if (yych <= '0') goto yy344;
	if (yych <= '9') goto yy816;
	goto yy344;
yy814:
	++cur;
yy815:
	cur = ctx;
#line 299 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(label_start_force); }
#line 4202 "src/parse/conf_lexer.cc"
yy816:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy816;
	goto yy815;
yy817:
	yych = *++cur;
	if (yych == 'b') goto yy859;
	goto yy3;
yy818:
	yych = *++cur;
	if (yych == 't') goto yy860;
	goto yy3;
yy819:
	yych = *++cur;
	if (yych == 'i') goto yy861;
	goto yy3;
yy820:
	yych = *++cur;
	if (yych == 'e') goto yy862;
	goto yy3;
yy821:
	yych = *++cur;
	if (yych == 'i') goto yy863;
	goto yy3;
yy822:
	yych = *++cur;
	if (yych == 'i') goto yy864;
	goto yy3;
yy823:
	yych = *++cur;
	if (yych == 's') goto yy865;
	goto yy3;
yy824:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 152 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_check); }
#line 4242 "src/parse/conf_lexer.cc"
yy825:
	yych = *++cur;
	if (yych == 'e') goto yy866;
	goto yy3;
yy826:
	yych = *++cur;
	if (yych == 'e') goto yy867;
	goto yy3;
yy827:
	yych = *++cur;
	if (yych == 'e') goto yy868;
	goto yy3;
yy828:
	yych = *++cur;
	if (yych == 'N') goto yy869;
	goto yy3;
yy829:
	yych = *++cur;
	if (yych == 'k') goto yy870;
	goto yy3;
yy830:
	yych = *++cur;
	if (yych == 'e') goto yy871;
	goto yy3;
yy831:
	yych = *++cur;
	if (yych == 'd') goto yy872;
	goto yy344;
yy832:
	yych = *++cur;
	if (yych == 'N') goto yy873;
	goto yy3;
yy833:
	yych = *++cur;
	if (yych == 'k') goto yy874;
	goto yy3;
yy834:
	yych = *++cur;
	if (yych == 'a') goto yy875;
	goto yy344;
yy835:
	yych = *++cur;
	if (yych == 'i') goto yy876;
	goto yy3;
yy836:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 278 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_inverted); }
#line 4292 "src/parse/conf_lexer.cc"
yy837:
	yych = *++cur;
	if (yych == 'e') goto yy877;
	goto yy3;
yy838:
	yych = *++cur;
	if (yych == 'l') goto yy878;
	goto yy3;
yy839:
	yych = *++cur;
	if (yych == 's') goto yy879;
	goto yy3;
yy840:
	yych = *++cur;
	if (yych == 'c') goto yy880;
	goto yy344;
yy841:
	yych = *++cur;
	if (yych == 'd') goto yy881;
	goto yy344;
yy842:
	yych = *++cur;
	if (yych == 'x') goto yy882;
	goto yy3;
yy843:
	yych = *++cur;
	if (yych == 'c') goto yy883;
	goto yy3;
yy844:
	yych = *++cur;
	if (yych == 'i') goto yy884;
	goto yy3;
yy845:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy405;
yy846:
	yych = *++cur;
	if (yych == '2') goto yy851;
	goto yy3;
yy847:
	yych = *++cur;
	if (yych == 'd') goto yy885;
	goto yy3;
yy848:
	yych = *++cur;
	if (yych == 'g') goto yy886;
	goto yy3;
yy849:
	yych = *++cur;
	if (yych == 't') goto yy887;
	goto yy3;
yy850:
	yych = *++cur;
	if (yych == 'a') goto yy888;
	goto yy3;
yy851:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy403;
yy852:
	yych = *++cur;
	if (yych == 'a') goto yy889;
	goto yy3;
yy853:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 292 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(indent_str); }
#line 4362 "src/parse/conf_lexer.cc"
yy854:
	yych = *++cur;
	if (yych == 'g') goto yy890;
	goto yy3;
yy855:
	yych = *++cur;
	if (yych == 'e') goto yy891;
	goto yy3;
yy856:
	yych = *++cur;
	if (yych == 'a') goto yy892;
	goto yy3;
yy857:
	yych = *++cur;
	if (yych == 's') goto yy386;
	goto yy3;
yy858:
	yych = *++cur;
	if (yych == 's') goto yy893;
	goto yy3;
yy859:
	yych = *++cur;
	if (yych == 'e') goto yy894;
	goto yy3;
yy860:
	yych = *++cur;
	if (yych == 'e') goto yy895;
	goto yy3;
yy861:
	yych = *++cur;
	if (yych == 'o') goto yy896;
	goto yy3;
yy862:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 188 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_negative); }
#line 4400 "src/parse/conf_lexer.cc"
yy863:
	yych = *++cur;
	if (yych == 'l') goto yy897;
	goto yy3;
yy864:
	yych = *++cur;
	if (yych == 'o') goto yy898;
	goto yy3;
yy865:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 253 "../src/parse/conf_lexer.re"
	{ goto char_lit; }
#line 4414 "src/parse/conf_lexer.cc"
yy866:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 150 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_enable); }
#line 4420 "src/parse/conf_lexer.cc"
yy867:
	yych = *++cur;
	if (yych == 't') goto yy899;
	goto yy3;
yy868:
	yych = *++cur;
	if (yych == 'd') goto yy900;
	goto yy3;
yy869:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy547;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy631;
			goto yy547;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy547;
			goto yy2;
		} else {
			if (yych <= '`') goto yy547;
			if (yych <= 'z') goto yy2;
			goto yy547;
		}
	}
yy870:
	yych = *++cur;
	if (yych == 'e') goto yy901;
	goto yy3;
yy871:
	yych = *++cur;
	if (yych == 'd') goto yy902;
	goto yy3;
yy872:
	++cur;
#line 222 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_set_param); }
#line 4463 "src/parse/conf_lexer.cc"
yy873:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych <= '?') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy556;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy640;
			goto yy556;
		}
	} else {
		if (yych <= '^') {
			if (yych <= '@') goto yy641;
			if (yych <= 'Z') goto yy2;
			goto yy556;
		} else {
			if (yych == '`') goto yy556;
			if (yych <= 'z') goto yy2;
			goto yy556;
		}
	}
yy874:
	yych = *++cur;
	if (yych == 'e') goto yy903;
	goto yy3;
yy875:
	yych = *++cur;
	if (yych == 't') goto yy904;
	goto yy344;
yy876:
	yych = *++cur;
	if (yych == 'v') goto yy905;
	goto yy3;
yy877:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 275 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(computed_gotos_relative); }
#line 4504 "src/parse/conf_lexer.cc"
yy878:
	yych = *++cur;
	if (yych == 'd') goto yy906;
	goto yy3;
yy879:
	yych = *++cur;
	if (yych <= '@') {
		if (yych <= '/') {
			if (yych == '-') goto yy2;
			goto yy396;
		} else {
			if (yych <= '9') goto yy2;
			if (yych <= ':') goto yy278;
			goto yy396;
		}
	} else {
		if (yych <= '_') {
			if (yych <= 'Z') goto yy2;
			if (yych <= '^') goto yy396;
			goto yy2;
		} else {
			if (yych <= '`') goto yy396;
			if (yych <= 'z') goto yy2;
			goto yy396;
		}
	}
yy880:
	yych = *++cur;
	if (yych == 'o') goto yy907;
	goto yy344;
yy881:
	++cur;
#line 266 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_goto_param); }
#line 4539 "src/parse/conf_lexer.cc"
yy882:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 262 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_enum_prefix); }
#line 4545 "src/parse/conf_lexer.cc"
yy883:
	yych = *++cur;
	if (yych == 'y') goto yy908;
	goto yy3;
yy884:
	yych = *++cur;
	if (yych == 'c') goto yy583;
	goto yy3;
yy885:
	yych = *++cur;
	if (yych == '-') goto yy909;
	goto yy3;
yy886:
	yych = *++cur;
	if (yych == '-') goto yy579;
	goto yy3;
yy887:
	yych = *++cur;
	if (yych == '-') goto yy910;
	goto yy3;
yy888:
	yych = *++cur;
	if (yych == 'p') goto yy911;
	goto yy3;
yy889:
	yych = *++cur;
	if (yych == 'r') goto yy912;
	goto yy3;
yy890:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 121 "../src/parse/conf_lexer.re"
	{ goto input_enc; }
#line 4579 "src/parse/conf_lexer.cc"
yy891:
	yych = *++cur;
	if (yych == 's') goto yy913;
	goto yy3;
yy892:
	yych = *++cur;
	if (yych == 'b') goto yy914;
	goto yy3;
yy893:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 179 "../src/parse/conf_lexer.re"
	{
        CHECK_RET(lex_conf_bool(opts));
        SETOPT(captures, tmp_bool);
        SETOPT(captures_posix, tmp_bool);
        SETOPT(captures_array, false);
        return Ret::OK;
    }
#line 4599 "src/parse/conf_lexer.cc"
yy894:
	yych = *++cur;
	if (yych == 'l') goto yy915;
	goto yy3;
yy895:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 125 "../src/parse/conf_lexer.re"
	{ RET_STXCONF_BOOL(storable_state); }
#line 4609 "src/parse/conf_lexer.cc"
yy896:
	yych = *++cur;
	if (yych == 'n') goto yy916;
	goto yy3;
yy897:
	yych = *++cur;
	if (yych == 'l') goto yy917;
	goto yy3;
yy898:
	yych = *++cur;
	if (yych == 'n') goto yy918;
	goto yy3;
yy899:
	yych = *++cur;
	if (yych == 'e') goto yy919;
	goto yy3;
yy900:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 206 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_get_naked); }
#line 4631 "src/parse/conf_lexer.cc"
yy901:
	yych = *++cur;
	if (yych == 'd') goto yy920;
	goto yy3;
yy902:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 223 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(cond_set_naked); }
#line 4641 "src/parse/conf_lexer.cc"
yy903:
	yych = *++cur;
	if (yych == 'd') goto yy921;
	goto yy3;
yy904:
	yych = *++cur;
	if (yych == 'e') goto yy922;
	goto yy344;
yy905:
	yych = *++cur;
	if (yych == 'e') goto yy923;
	goto yy3;
yy906:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 274 "../src/parse/conf_lexer.re"
	{ RET_CONF_NUM_NONNEG(computed_gotos_threshold); }
#line 4659 "src/parse/conf_lexer.cc"
yy907:
	yych = *++cur;
	if (yych == 'n') goto yy924;
	goto yy344;
yy908:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 289 "../src/parse/conf_lexer.re"
	{ goto encoding_policy; }
#line 4669 "src/parse/conf_lexer.cc"
yy909:
	yych = *++cur;
	if (yych == 'g') goto yy925;
	goto yy3;
yy910:
	yych = *++cur;
	if (yych == 'c') goto yy926;
	goto yy3;
yy911:
	yych = *++cur;
	if (yych == 't') goto yy927;
	goto yy3;
yy912:
	yych = *++cur;
	if (yych == 's') goto yy845;
	goto yy3;
yy913:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 189 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(captures_invert); }
#line 4691 "src/parse/conf_lexer.cc"
yy914:
	yych = *++cur;
	if (yych == 'e') goto yy753;
	goto yy3;
yy915:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 269 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_next); }
#line 4701 "src/parse/conf_lexer.cc"
yy916:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 187 "../src/parse/conf_lexer.re"
	{ RET_CONF_CODE(tags_expression); }
#line 4707 "src/parse/conf_lexer.cc"
yy917:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
	goto yy325;
yy918:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 252 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(char_conv); }
#line 4717 "src/parse/conf_lexer.cc"
yy919:
	yych = *++cur;
	if (yych == 'r') goto yy928;
	goto yy3;
yy920:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 208 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_get_naked); }
#line 4727 "src/parse/conf_lexer.cc"
yy921:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 225 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(state_set_naked); }
#line 4733 "src/parse/conf_lexer.cc"
yy922:
	++cur;
#line 226 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(state_set_param); }
#line 4738 "src/parse/conf_lexer.cc"
yy923:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 277 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(case_insensitive); }
#line 4744 "src/parse/conf_lexer.cc"
yy924:
	yych = *++cur;
	if (yych == 'd') goto yy929;
	goto yy344;
yy925:
	yych = *++cur;
	if (yych == 'o') goto yy930;
	goto yy3;
yy926:
	yych = *++cur;
	if (yych == 'a') goto yy931;
	goto yy3;
yy927:
	yych = *++cur;
	if (yych == 'u') goto yy757;
	goto yy3;
yy928:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy2;
#line 151 "../src/parse/conf_lexer.re"
	{ RET_CONF_BOOL(fill_param_enable); }
#line 4766 "src/parse/conf_lexer.cc"
yy929:
	++cur;
#line 264 "../src/parse/conf_lexer.re"
	{ RET_CONF_STR(cond_div_param); }
#line 4771 "src/parse/conf_lexer.cc"
yy930:
	yych = *++cur;
	if (yych == 't') goto yy932;
	goto yy3;
yy931:
	yych = *++cur;
	if (yych == 'p') goto yy581;
	goto yy3;
yy932:
	yych = *++cur;
	if (yych != 'o') goto yy3;
	yych = *++cur;
	if (yych == 's') goto yy395;
	goto yy3;
}
#line 306 "../src/parse/conf_lexer.re"


target:
    CHECK_RET(lex_conf_assign());

#line 4793 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 8) YYFILL(8);
	yych = *cur;
	if (yych <= 'd') {
		if (yych <= 'b') goto yy934;
		if (yych <= 'c') goto yy936;
		goto yy937;
	} else {
		if (yych == 's') goto yy938;
	}
yy934:
	++cur;
yy935:
#line 311 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'code', 'skeleton', 'dot')"));
    }
#line 4812 "src/parse/conf_lexer.cc"
yy936:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy939;
	goto yy935;
yy937:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy941;
	goto yy935;
yy938:
	yych = *(mar = ++cur);
	if (yych == 'k') goto yy942;
	goto yy935;
yy939:
	yych = *++cur;
	if (yych == 'd') goto yy943;
yy940:
	cur = mar;
	goto yy935;
yy941:
	yych = *++cur;
	if (yych == 't') goto yy944;
	goto yy940;
yy942:
	yych = *++cur;
	if (yych == 'e') goto yy945;
	goto yy940;
yy943:
	yych = *++cur;
	if (yych == 'e') goto yy946;
	goto yy940;
yy944:
	++cur;
#line 316 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::DOT);      goto end; }
#line 4847 "src/parse/conf_lexer.cc"
yy945:
	yych = *++cur;
	if (yych == 'l') goto yy947;
	goto yy940;
yy946:
	++cur;
#line 314 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::CODE);     goto end; }
#line 4856 "src/parse/conf_lexer.cc"
yy947:
	yych = *++cur;
	if (yych != 'e') goto yy940;
	yych = *++cur;
	if (yych != 't') goto yy940;
	yych = *++cur;
	if (yych != 'o') goto yy940;
	yych = *++cur;
	if (yych != 'n') goto yy940;
	++cur;
#line 315 "../src/parse/conf_lexer.re"
	{ SETCONOPT(target, Target::SKELETON); goto end; }
#line 4869 "src/parse/conf_lexer.cc"
}
#line 317 "../src/parse/conf_lexer.re"


code_model:
    CHECK_RET(lex_conf_assign());

#line 4877 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 19) YYFILL(19);
	yych = *cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy950;
	} else {
		if (yych <= 'l') goto yy951;
		if (yych == 'r') goto yy952;
	}
	++cur;
yy949:
#line 322 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value"
            " (expected: 'goto-label', 'loop-switch', 'recursive-functions')"));
    }
#line 4895 "src/parse/conf_lexer.cc"
yy950:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy953;
	goto yy949;
yy951:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy955;
	goto yy949;
yy952:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy956;
	goto yy949;
yy953:
	yych = *++cur;
	if (yych == 't') goto yy957;
yy954:
	cur = mar;
	goto yy949;
yy955:
	yych = *++cur;
	if (yych == 'o') goto yy958;
	goto yy954;
yy956:
	yych = *++cur;
	if (yych == 'c') goto yy959;
	goto yy954;
yy957:
	yych = *++cur;
	if (yych == 'o') goto yy960;
	goto yy954;
yy958:
	yych = *++cur;
	if (yych == 'p') goto yy961;
	goto yy954;
yy959:
	yych = *++cur;
	if (yych == 'u') goto yy962;
	goto yy954;
yy960:
	yych = *++cur;
	if (yych == '-') goto yy963;
	goto yy954;
yy961:
	yych = *++cur;
	if (yych == '-') goto yy964;
	goto yy954;
yy962:
	yych = *++cur;
	if (yych == 'r') goto yy965;
	goto yy954;
yy963:
	yych = *++cur;
	if (yych == 'l') goto yy966;
	goto yy954;
yy964:
	yych = *++cur;
	if (yych == 's') goto yy967;
	goto yy954;
yy965:
	yych = *++cur;
	if (yych == 's') goto yy968;
	goto yy954;
yy966:
	yych = *++cur;
	if (yych == 'a') goto yy969;
	goto yy954;
yy967:
	yych = *++cur;
	if (yych == 'w') goto yy970;
	goto yy954;
yy968:
	yych = *++cur;
	if (yych == 'i') goto yy971;
	goto yy954;
yy969:
	yych = *++cur;
	if (yych == 'b') goto yy972;
	goto yy954;
yy970:
	yych = *++cur;
	if (yych == 'i') goto yy973;
	goto yy954;
yy971:
	yych = *++cur;
	if (yych == 'v') goto yy974;
	goto yy954;
yy972:
	yych = *++cur;
	if (yych == 'e') goto yy975;
	goto yy954;
yy973:
	yych = *++cur;
	if (yych == 't') goto yy976;
	goto yy954;
yy974:
	yych = *++cur;
	if (yych == 'e') goto yy977;
	goto yy954;
yy975:
	yych = *++cur;
	if (yych == 'l') goto yy978;
	goto yy954;
yy976:
	yych = *++cur;
	if (yych == 'c') goto yy979;
	goto yy954;
yy977:
	yych = *++cur;
	if (yych == '-') goto yy980;
	goto yy954;
yy978:
	++cur;
#line 326 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::GOTO_LABEL);  goto end; }
#line 5010 "src/parse/conf_lexer.cc"
yy979:
	yych = *++cur;
	if (yych == 'h') goto yy981;
	goto yy954;
yy980:
	yych = *++cur;
	if (yych == 'f') goto yy982;
	goto yy954;
yy981:
	++cur;
#line 327 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::LOOP_SWITCH); goto end; }
#line 5023 "src/parse/conf_lexer.cc"
yy982:
	yych = *++cur;
	if (yych != 'u') goto yy954;
	yych = *++cur;
	if (yych != 'n') goto yy954;
	yych = *++cur;
	if (yych != 'c') goto yy954;
	yych = *++cur;
	if (yych != 't') goto yy954;
	yych = *++cur;
	if (yych != 'i') goto yy954;
	yych = *++cur;
	if (yych != 'o') goto yy954;
	yych = *++cur;
	if (yych != 'n') goto yy954;
	yych = *++cur;
	if (yych != 's') goto yy954;
	++cur;
#line 328 "../src/parse/conf_lexer.re"
	{ SETCONOPT(code_model, CodeModel::REC_FUNC);    goto end; }
#line 5044 "src/parse/conf_lexer.cc"
}
#line 329 "../src/parse/conf_lexer.re"


input_enc:
    CHECK_RET(lex_conf_assign());

#line 5052 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 5) YYFILL(5);
	yych = *cur;
	if (yych == 'a') goto yy985;
	if (yych == 'u') goto yy986;
	++cur;
yy984:
#line 334 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'ascii', 'utf8')"));
    }
#line 5065 "src/parse/conf_lexer.cc"
yy985:
	yych = *(mar = ++cur);
	if (yych == 's') goto yy987;
	goto yy984;
yy986:
	yych = *(mar = ++cur);
	if (yych == 't') goto yy989;
	goto yy984;
yy987:
	yych = *++cur;
	if (yych == 'c') goto yy990;
yy988:
	cur = mar;
	goto yy984;
yy989:
	yych = *++cur;
	if (yych == 'f') goto yy991;
	goto yy988;
yy990:
	yych = *++cur;
	if (yych == 'i') goto yy992;
	goto yy988;
yy991:
	yych = *++cur;
	if (yych == '8') goto yy993;
	goto yy988;
yy992:
	yych = *++cur;
	if (yych == 'i') goto yy994;
	goto yy988;
yy993:
	++cur;
#line 338 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::UTF8);  goto end; }
#line 5100 "src/parse/conf_lexer.cc"
yy994:
	++cur;
#line 337 "../src/parse/conf_lexer.re"
	{ SETCONOPT(input_encoding, Enc::Type::ASCII); goto end; }
#line 5105 "src/parse/conf_lexer.cc"
}
#line 339 "../src/parse/conf_lexer.re"


input:
    CHECK_RET(lex_conf_assign());

#line 5113 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 7) YYFILL(7);
	yych = *cur;
	switch (yych) {
		case 'c': goto yy998;
		case 'd': goto yy999;
		case 'g': goto yy1000;
		case 'r': goto yy1001;
		case 's': goto yy1002;
		default: goto yy996;
	}
yy996:
	++cur;
yy997:
#line 344 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'simple', 'generic', 'record')"));
    }
#line 5133 "src/parse/conf_lexer.cc"
yy998:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1003;
	goto yy997;
yy999:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1005;
	goto yy997;
yy1000:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1006;
	goto yy997;
yy1001:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1007;
	goto yy997;
yy1002:
	yych = *(mar = ++cur);
	if (yych == 'i') goto yy1008;
	goto yy997;
yy1003:
	yych = *++cur;
	if (yych == 's') goto yy1009;
yy1004:
	cur = mar;
	goto yy997;
yy1005:
	yych = *++cur;
	if (yych == 'f') goto yy1010;
	goto yy1004;
yy1006:
	yych = *++cur;
	if (yych == 'n') goto yy1011;
	goto yy1004;
yy1007:
	yych = *++cur;
	if (yych == 'c') goto yy1012;
	goto yy1004;
yy1008:
	yych = *++cur;
	if (yych == 'm') goto yy1013;
	goto yy1004;
yy1009:
	yych = *++cur;
	if (yych == 't') goto yy1014;
	goto yy1004;
yy1010:
	yych = *++cur;
	if (yych == 'a') goto yy1015;
	goto yy1004;
yy1011:
	yych = *++cur;
	if (yych == 'e') goto yy1016;
	goto yy1004;
yy1012:
	yych = *++cur;
	if (yych == 'o') goto yy1017;
	goto yy1004;
yy1013:
	yych = *++cur;
	if (yych == 'p') goto yy1018;
	goto yy1004;
yy1014:
	yych = *++cur;
	if (yych == 'o') goto yy1019;
	goto yy1004;
yy1015:
	yych = *++cur;
	if (yych == 'u') goto yy1020;
	goto yy1004;
yy1016:
	yych = *++cur;
	if (yych == 'r') goto yy1021;
	goto yy1004;
yy1017:
	yych = *++cur;
	if (yych == 'r') goto yy1022;
	goto yy1004;
yy1018:
	yych = *++cur;
	if (yych == 'l') goto yy1023;
	goto yy1004;
yy1019:
	yych = *++cur;
	if (yych == 'm') goto yy1024;
	goto yy1004;
yy1020:
	yych = *++cur;
	if (yych == 'l') goto yy1025;
	goto yy1004;
yy1021:
	yych = *++cur;
	if (yych == 'i') goto yy1026;
	goto yy1004;
yy1022:
	yych = *++cur;
	if (yych == 'd') goto yy1027;
	goto yy1004;
yy1023:
	yych = *++cur;
	if (yych == 'e') goto yy1028;
	goto yy1004;
yy1024:
	++cur;
#line 348 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::GENERIC); goto end; }
#line 5240 "src/parse/conf_lexer.cc"
yy1025:
	yych = *++cur;
	if (yych == 't') goto yy1028;
	goto yy1004;
yy1026:
	yych = *++cur;
	if (yych == 'c') goto yy1024;
	goto yy1004;
yy1027:
	++cur;
#line 349 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::RECORD);  goto end; }
#line 5253 "src/parse/conf_lexer.cc"
yy1028:
	++cur;
#line 347 "../src/parse/conf_lexer.re"
	{ SETOPT(api, Api::SIMPLE);  goto end; }
#line 5258 "src/parse/conf_lexer.cc"
}
#line 350 "../src/parse/conf_lexer.re"


api_style:
    CHECK_RET(lex_conf_assign());

#line 5266 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 9) YYFILL(9);
	yych = *cur;
	if (yych == 'f') goto yy1031;
	++cur;
yy1030:
#line 355 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'functions', 'free-form')"));
    }
#line 5278 "src/parse/conf_lexer.cc"
yy1031:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1032;
	if (yych == 'u') goto yy1034;
	goto yy1030;
yy1032:
	yych = *++cur;
	if (yych == 'e') goto yy1035;
yy1033:
	cur = mar;
	goto yy1030;
yy1034:
	yych = *++cur;
	if (yych == 'n') goto yy1036;
	goto yy1033;
yy1035:
	yych = *++cur;
	if (yych == 'e') goto yy1037;
	goto yy1033;
yy1036:
	yych = *++cur;
	if (yych == 'c') goto yy1038;
	goto yy1033;
yy1037:
	yych = *++cur;
	if (yych == '-') goto yy1039;
	goto yy1033;
yy1038:
	yych = *++cur;
	if (yych == 't') goto yy1040;
	goto yy1033;
yy1039:
	yych = *++cur;
	if (yych == 'f') goto yy1041;
	goto yy1033;
yy1040:
	yych = *++cur;
	if (yych == 'i') goto yy1042;
	goto yy1033;
yy1041:
	yych = *++cur;
	if (yych == 'o') goto yy1043;
	goto yy1033;
yy1042:
	yych = *++cur;
	if (yych == 'o') goto yy1044;
	goto yy1033;
yy1043:
	yych = *++cur;
	if (yych == 'r') goto yy1045;
	goto yy1033;
yy1044:
	yych = *++cur;
	if (yych == 'n') goto yy1046;
	goto yy1033;
yy1045:
	yych = *++cur;
	if (yych == 'm') goto yy1047;
	goto yy1033;
yy1046:
	yych = *++cur;
	if (yych == 's') goto yy1048;
	goto yy1033;
yy1047:
	++cur;
#line 359 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FREEFORM);  goto end; }
#line 5346 "src/parse/conf_lexer.cc"
yy1048:
	++cur;
#line 358 "../src/parse/conf_lexer.re"
	{ SETOPT(api_style, ApiStyle::FUNCTIONS); goto end; }
#line 5351 "src/parse/conf_lexer.cc"
}
#line 360 "../src/parse/conf_lexer.re"


encoding_policy:
    CHECK_RET(lex_conf_assign());

#line 5359 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 10) YYFILL(10);
	yych = *cur;
	if (yych <= 'h') {
		if (yych == 'f') goto yy1051;
	} else {
		if (yych <= 'i') goto yy1052;
		if (yych == 's') goto yy1053;
	}
	++cur;
yy1050:
#line 365 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'ignore', 'substitute', 'fail')"));
    }
#line 5377 "src/parse/conf_lexer.cc"
yy1051:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1054;
	goto yy1050;
yy1052:
	yych = *(mar = ++cur);
	if (yych == 'g') goto yy1056;
	goto yy1050;
yy1053:
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1057;
	goto yy1050;
yy1054:
	yych = *++cur;
	if (yych == 'i') goto yy1058;
yy1055:
	cur = mar;
	goto yy1050;
yy1056:
	yych = *++cur;
	if (yych == 'n') goto yy1059;
	goto yy1055;
yy1057:
	yych = *++cur;
	if (yych == 'b') goto yy1060;
	goto yy1055;
yy1058:
	yych = *++cur;
	if (yych == 'l') goto yy1061;
	goto yy1055;
yy1059:
	yych = *++cur;
	if (yych == 'o') goto yy1062;
	goto yy1055;
yy1060:
	yych = *++cur;
	if (yych == 's') goto yy1063;
	goto yy1055;
yy1061:
	++cur;
#line 371 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::FAIL);       goto end; }
#line 5420 "src/parse/conf_lexer.cc"
yy1062:
	yych = *++cur;
	if (yych == 'r') goto yy1064;
	goto yy1055;
yy1063:
	yych = *++cur;
	if (yych == 't') goto yy1065;
	goto yy1055;
yy1064:
	yych = *++cur;
	if (yych == 'e') goto yy1066;
	goto yy1055;
yy1065:
	yych = *++cur;
	if (yych == 'i') goto yy1067;
	goto yy1055;
yy1066:
	++cur;
#line 369 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::IGNORE);     goto end; }
#line 5441 "src/parse/conf_lexer.cc"
yy1067:
	yych = *++cur;
	if (yych != 't') goto yy1055;
	yych = *++cur;
	if (yych != 'u') goto yy1055;
	yych = *++cur;
	if (yych != 't') goto yy1055;
	yych = *++cur;
	if (yych != 'e') goto yy1055;
	++cur;
#line 370 "../src/parse/conf_lexer.re"
	{ SETOPT(encoding_policy, Enc::Policy::SUBSTITUTE); goto end; }
#line 5454 "src/parse/conf_lexer.cc"
}
#line 372 "../src/parse/conf_lexer.re"


empty_class:
    CHECK_RET(lex_conf_assign());

#line 5462 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'e') goto yy1070;
	if (yych == 'm') goto yy1071;
	++cur;
yy1069:
#line 377 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur(
                "bad configuration value (expected: 'match-empty', 'match-none', 'error')"));
    }
#line 5476 "src/parse/conf_lexer.cc"
yy1070:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy1072;
	goto yy1069;
yy1071:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy1074;
	goto yy1069;
yy1072:
	yych = *++cur;
	if (yych == 'r') goto yy1075;
yy1073:
	cur = mar;
	goto yy1069;
yy1074:
	yych = *++cur;
	if (yych == 't') goto yy1076;
	goto yy1073;
yy1075:
	yych = *++cur;
	if (yych == 'o') goto yy1077;
	goto yy1073;
yy1076:
	yych = *++cur;
	if (yych == 'c') goto yy1078;
	goto yy1073;
yy1077:
	yych = *++cur;
	if (yych == 'r') goto yy1079;
	goto yy1073;
yy1078:
	yych = *++cur;
	if (yych == 'h') goto yy1080;
	goto yy1073;
yy1079:
	++cur;
#line 383 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::ERROR);       goto end; }
#line 5515 "src/parse/conf_lexer.cc"
yy1080:
	yych = *++cur;
	if (yych != '-') goto yy1073;
	yych = *++cur;
	if (yych == 'e') goto yy1081;
	if (yych == 'n') goto yy1082;
	goto yy1073;
yy1081:
	yych = *++cur;
	if (yych == 'm') goto yy1083;
	goto yy1073;
yy1082:
	yych = *++cur;
	if (yych == 'o') goto yy1084;
	goto yy1073;
yy1083:
	yych = *++cur;
	if (yych == 'p') goto yy1085;
	goto yy1073;
yy1084:
	yych = *++cur;
	if (yych == 'n') goto yy1086;
	goto yy1073;
yy1085:
	yych = *++cur;
	if (yych == 't') goto yy1087;
	goto yy1073;
yy1086:
	yych = *++cur;
	if (yych == 'e') goto yy1088;
	goto yy1073;
yy1087:
	yych = *++cur;
	if (yych == 'y') goto yy1089;
	goto yy1073;
yy1088:
	++cur;
#line 382 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_NONE);  goto end; }
#line 5555 "src/parse/conf_lexer.cc"
yy1089:
	++cur;
#line 381 "../src/parse/conf_lexer.re"
	{ SETOPT(empty_class, EmptyClass::MATCH_EMPTY); goto end; }
#line 5560 "src/parse/conf_lexer.cc"
}
#line 384 "../src/parse/conf_lexer.re"


char_lit:
    CHECK_RET(lex_conf_assign());

#line 5568 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	if ((lim - cur) < 11) YYFILL(11);
	yych = *cur;
	if (yych == 'c') goto yy1092;
	if (yych == 'h') goto yy1093;
	++cur;
yy1091:
#line 389 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_cur("bad configuration value (expected: 'char', 'hex', 'char-or-hex')"));
    }
#line 5582 "src/parse/conf_lexer.cc"
yy1092:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'h') goto yy1094;
	goto yy1091;
yy1093:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy1096;
	goto yy1091;
yy1094:
	yych = *++cur;
	if (yych == 'a') goto yy1097;
yy1095:
	cur = mar;
	if (yyaccept == 0) goto yy1091;
	else goto yy1100;
yy1096:
	yych = *++cur;
	if (yych == 'x') goto yy1098;
	goto yy1095;
yy1097:
	yych = *++cur;
	if (yych == 'r') goto yy1099;
	goto yy1095;
yy1098:
	++cur;
#line 393 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::HEX);         goto end; }
#line 5612 "src/parse/conf_lexer.cc"
yy1099:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == '-') goto yy1101;
yy1100:
#line 392 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR);        goto end; }
#line 5620 "src/parse/conf_lexer.cc"
yy1101:
	yych = *++cur;
	if (yych != 'o') goto yy1095;
	yych = *++cur;
	if (yych != 'r') goto yy1095;
	yych = *++cur;
	if (yych != '-') goto yy1095;
	yych = *++cur;
	if (yych != 'h') goto yy1095;
	yych = *++cur;
	if (yych != 'e') goto yy1095;
	yych = *++cur;
	if (yych != 'x') goto yy1095;
	++cur;
#line 394 "../src/parse/conf_lexer.re"
	{ SETOPT(char_literals, CharLit::CHAR_OR_HEX); goto end; }
#line 5637 "src/parse/conf_lexer.cc"
}
#line 395 "../src/parse/conf_lexer.re"


end:
    return lex_conf_semicolon();
}

#undef SETOPT
#undef RET_CONF_BOOL
#undef RET_CONF_FEAT
#undef RET_CONF_STR
#undef RET_CONF_ENC
#undef RET_CONF_NUM_NONNEG
#undef RET_CONF_EOF

Ret Input::lex_spaces() {
loop: 
#line 5656 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy1103;
		if (yych <= '\t') goto yy1104;
		if (yych <= '\n') goto yy1105;
	} else {
		if (yych <= '\r') goto yy1104;
		if (yych == ' ') goto yy1104;
	}
yy1103:
#line 413 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5672 "src/parse/conf_lexer.cc"
yy1104:
	++cur;
#line 412 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5677 "src/parse/conf_lexer.cc"
yy1105:
	++cur;
#line 411 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5682 "src/parse/conf_lexer.cc"
}
#line 414 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_assign() {
    CHECK_RET(lex_spaces());

#line 5691 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == '=') goto yy1107;
	++cur;
#line 421 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing '=' in configuration")); }
#line 5700 "src/parse/conf_lexer.cc"
yy1107:
	++cur;
#line 420 "../src/parse/conf_lexer.re"
	{ return lex_spaces(); }
#line 5705 "src/parse/conf_lexer.cc"
}
#line 422 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_semicolon() {
    CHECK_RET(lex_spaces());

#line 5714 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych == ';') goto yy1109;
	++cur;
#line 429 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("missing ending ';' in configuration")); }
#line 5723 "src/parse/conf_lexer.cc"
yy1109:
	++cur;
#line 428 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 5728 "src/parse/conf_lexer.cc"
}
#line 430 "../src/parse/conf_lexer.re"

}

Ret Input::lex_conf_number(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a number"));
    }
    return Ret::OK;
}

inline Ret Input::lex_conf_bool(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::NUM) {
        RET_FAIL(error_at_tok("configuration value should be a boolean value 0 or 1"));
    }
    return Ret::OK;
}

// Historically re2c allowed raw (unquoted) strings containing special symbols as configuration
// values in source files. In syntax files this is not allowed, as it would conflict with other
// parts of grammar (e.g. parentheses and question mark are used for conditionals). Therefore we
// have a legacy method for string configurations in source files.
Ret Input::lex_conf_string_legacy() {
    CHECK_RET(lex_conf_assign());
    tok = cur;

#line 5758 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128,   0,   0, 128, 128,   0, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128,   0, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= ' ') {
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy1111;
			if (yych <= 0x08) goto yy1112;
		} else {
			if (yych == '\r') goto yy1111;
			if (yych <= 0x1F) goto yy1112;
		}
	} else {
		if (yych <= '&') {
			if (yych == '"') goto yy1113;
			goto yy1112;
		} else {
			if (yych <= '\'') goto yy1113;
			if (yych != ';') goto yy1112;
		}
	}
yy1111:
#line 459 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto end; }
#line 5817 "src/parse/conf_lexer.cc"
yy1112:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1112;
#line 457 "../src/parse/conf_lexer.re"
	{ tmp_str.assign(tok, cur); goto end; }
#line 5825 "src/parse/conf_lexer.cc"
yy1113:
	++cur;
	cur -= 1;
#line 458 "../src/parse/conf_lexer.re"
	{ tmp_str.clear(); goto loop; }
#line 5831 "src/parse/conf_lexer.cc"
}
#line 460 "../src/parse/conf_lexer.re"

loop: // lex one or more double-quoted strings separated with spaces or newlines
    tok = cur;

#line 5838 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= 0x1F) {
		if (yych <= '\n') {
			if (yych <= 0x08) goto yy1115;
			if (yych <= '\t') goto yy1116;
			goto yy1117;
		} else {
			if (yych == '\r') goto yy1116;
		}
	} else {
		if (yych <= '"') {
			if (yych <= ' ') goto yy1116;
			if (yych >= '"') goto yy1118;
		} else {
			if (yych == '\'') goto yy1118;
		}
	}
yy1115:
#line 467 "../src/parse/conf_lexer.re"
	{ goto end; }
#line 5862 "src/parse/conf_lexer.cc"
yy1116:
	++cur;
#line 466 "../src/parse/conf_lexer.re"
	{ goto loop; }
#line 5867 "src/parse/conf_lexer.cc"
yy1117:
	++cur;
#line 465 "../src/parse/conf_lexer.re"
	{ next_line(); goto loop; }
#line 5872 "src/parse/conf_lexer.cc"
yy1118:
	++cur;
#line 464 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf_string_quoted(tok[0])); goto loop; }
#line 5877 "src/parse/conf_lexer.cc"
}
#line 468 "../src/parse/conf_lexer.re"

end:
    return lex_conf_semicolon();
}

Ret Input::lex_conf_string(Opt& opts) {
    if (!in_syntax_file) {
        return lex_conf_string_legacy();
    }

    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::STR) {
        RET_FAIL(error_at_tok("configuration value should be a string"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_list(Opt& opts) {
    CHECK_RET(parse_conf(opts));
    if (conf_kind != ConfKind::LIST) {
        RET_FAIL(error_at_tok("configuration value should be a list"));
    }
    return Ret::OK;
}

Ret Input::lex_conf_string_quoted(uint8_t quote) {
    AstChar c;
    bool stop;
    for (;;) {
        CHECK_RET(lex_str_chr(quote, c, stop));
        if (stop) return Ret::OK;
        if (c.chr > 0xFF) {
            RET_FAIL(error_at(c.loc, "multibyte character in configuration string: 0x%X", c.chr));
        } else if (c.chr == '\n' && in_syntax_file && !allow_raw_nl) {
            RET_FAIL(error_at(c.loc, "newline in a string literal (use `nl` variable instead)"));
        }
        tmp_str += static_cast<char>(c.chr);
    }
}

Ret Input::lex_conf_code(Opt& opts) {
    if (in_syntax_file) {
        conf_kind = ConfKind::CODE;
        allow_raw_nl = false;
        CHECK_RET(parse_conf(opts));
        allow_raw_nl = true;
    } else {
        CHECK_RET(lex_conf_string(opts));
        tmp_code = opts.make_api(tmp_str);
    }
    return Ret::OK;
}

#define RET_TOK(t) do { \
    token = t; \
    return Ret::OK; \
} while(0)

#define RET_COND(c) do { \
    token = CONF_COND; \
    yylval->cond = (c); \
    return Ret::OK; \
} while(0)

#define RET_GOPT(opt) do { \
    token = CONF_GOPT; \
    yylval->gopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_LOPT(opt) do { \
    token = CONF_LOPT; \
    yylval->lopt = opt; \
    return Ret::OK; \
} while(0)

#define RET_VAR(v) do { \
    token = CONF_VAR; \
    yylval->var = v; \
    return Ret::OK; \
} while(0)

#define RET_CODE(conf) do { \
    token = CONF_CODE; \
    yylval->codeptr = const_cast<const StxCodes**>(&opts.glob.conf); \
    return Ret::OK; \
} while(0)

Ret Input::lex_conf_token(CONF_STYPE* yylval, int& token, Opt& opts) {
    if (conf_kind == ConfKind::CODE) { // one of pre-lexed `conf:` configuratins
        conf_kind = ConfKind::NONE;
        yylval->codeptr = &tmp_code;
        RET_TOK(CONF_CODE);
    }
start:
    tok = cur;

#line 5977 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	unsigned int yyaccept = 0;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 136,   0, 128, 128, 136, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		136, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 192, 128,
		240, 240, 240, 240, 240, 240, 240, 240,
		240, 240, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 224,
		128, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 224, 224, 224, 224, 224,
		224, 224, 224, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 32) YYFILL(32);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1123;
	switch (yych) {
		case 0x00: goto yy1120;
		case '\t':
		case '\n': goto yy1124;
		case ' ':
		case '!':
		case '&':
		case '(':
		case ')':
		case ',':
		case ':':
		case '=':
		case '?':
		case '[':
		case ']':
		case '{':
		case '|':
		case '}': goto yy1125;
		case '"':
		case '\'': goto yy1126;
		case '-': goto yy1127;
		case '.': goto yy1128;
		case '/': goto yy1129;
		case '0': goto yy1130;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9': goto yy1132;
		case ';': goto yy1133;
		case '<': goto yy1134;
		case 'Y': goto yy1135;
		case '_':
		case 'g':
		case 'h':
		case 'j':
		case 'k':
		case 'p':
		case 'q':
		case 'u':
		case 'w':
		case 'x':
		case 'z': goto yy1136;
		case 'a': goto yy1139;
		case 'b': goto yy1140;
		case 'c': goto yy1141;
		case 'd': goto yy1142;
		case 'e': goto yy1143;
		case 'f': goto yy1144;
		case 'i': goto yy1145;
		case 'l': goto yy1146;
		case 'm': goto yy1147;
		case 'n': goto yy1148;
		case 'o': goto yy1149;
		case 'r': goto yy1150;
		case 's': goto yy1151;
		case 't': goto yy1152;
		case 'v': goto yy1153;
		case 'y': goto yy1154;
		default: goto yy1121;
	}
yy1120:
	++cur;
#line 567 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_cur("unexpected end of input in configuration")); }
#line 6087 "src/parse/conf_lexer.cc"
yy1121:
	++cur;
yy1122:
#line 811 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 6093 "src/parse/conf_lexer.cc"
yy1123:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 8) goto yy1123;
#line 571 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 6101 "src/parse/conf_lexer.cc"
yy1124:
	++cur;
#line 569 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 6106 "src/parse/conf_lexer.cc"
yy1125:
	++cur;
#line 587 "../src/parse/conf_lexer.re"
	{ RET_TOK(cur[-1]); }
#line 6111 "src/parse/conf_lexer.cc"
yy1126:
	++cur;
#line 580 "../src/parse/conf_lexer.re"
	{
        tmp_str.clear();
        CHECK_RET(lex_conf_string_quoted(cur[-1]));
        yylval->str = copystr(tmp_str, alc);
        RET_TOK(CONF_STRING);
    }
#line 6121 "src/parse/conf_lexer.cc"
yy1127:
	yych = *++cur;
	if (yych <= '0') goto yy1122;
	if (yych <= '9') goto yy1155;
	goto yy1122;
yy1128:
	yych = *++cur;
	if (yych <= 'i') {
		if (yych <= '_') {
			if (yych <= '/') {
				if (yych == '.') goto yy1156;
				goto yy1122;
			} else {
				if (yych <= '9') goto yy1156;
				if (yych <= '^') goto yy1122;
				goto yy1156;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= '`') goto yy1122;
				if (yych <= 'a') goto yy1158;
				goto yy1156;
			} else {
				if (yych <= 'c') goto yy1159;
				if (yych <= 'd') goto yy1160;
				if (yych <= 'h') goto yy1156;
				goto yy1161;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'm') {
				if (yych <= 'k') goto yy1156;
				if (yych <= 'l') goto yy1162;
				goto yy1163;
			} else {
				if (yych <= 'n') goto yy1164;
				if (yych <= 'q') goto yy1156;
				if (yych <= 'r') goto yy1165;
				goto yy1166;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 't') goto yy1167;
				if (yych <= 'u') goto yy1168;
				goto yy1169;
			} else {
				if (yych == 'y') goto yy1170;
				if (yych <= 'z') goto yy1156;
				goto yy1122;
			}
		}
	}
yy1129:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == '/') goto yy1171;
	goto yy1122;
yy1130:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
yy1131:
#line 573 "../src/parse/conf_lexer.re"
	{
        if (!s_to_i32_unsafe(tok, cur, yylval->num)) {
            RET_FAIL(error_at_cur("configuration value overflow"));
        }
        RET_TOK(CONF_NUMBER);
    }
#line 6191 "src/parse/conf_lexer.cc"
yy1132:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 16) goto yy1132;
	if (yych == '_') goto yy1136;
	if (yych <= '`') goto yy1131;
	if (yych <= 'z') goto yy1136;
	goto yy1131;
yy1133:
	++cur;
#line 565 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_EOF); }
#line 6205 "src/parse/conf_lexer.cc"
yy1134:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'u') goto yy1173;
	goto yy1122;
yy1135:
	yyaccept = 0;
	yych = *(mar = ++cur);
	if (yych == 'Y') goto yy1174;
	goto yy1122;
yy1136:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1137:
	if (yybm[0+yych] & 32) goto yy1136;
yy1138:
#line 807 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown variable: '%.*s'", int(cur - tok), tok));
    }
#line 6227 "src/parse/conf_lexer.cc"
yy1139:
	yych = *++cur;
	if (yych == 'r') goto yy1175;
	goto yy1137;
yy1140:
	yych = *++cur;
	if (yych == 'a') goto yy1176;
	if (yych == 'r') goto yy1177;
	goto yy1137;
yy1141:
	yych = *++cur;
	if (yych == 'a') goto yy1178;
	if (yych == 'o') goto yy1179;
	goto yy1137;
yy1142:
	yych = *++cur;
	if (yych == 'a') goto yy1180;
	if (yych == 'e') goto yy1181;
	goto yy1137;
yy1143:
	yych = *++cur;
	if (yych == 'l') goto yy1182;
	if (yych == 'x') goto yy1183;
	goto yy1137;
yy1144:
	yych = *++cur;
	if (yych == 'i') goto yy1184;
	if (yych == 'n') goto yy1185;
	goto yy1137;
yy1145:
	yych = *++cur;
	if (yych == 'n') goto yy1187;
	goto yy1137;
yy1146:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1188;
		goto yy1137;
	} else {
		if (yych <= 'h') goto yy1189;
		if (yych <= 'i') goto yy1190;
		goto yy1137;
	}
yy1147:
	yych = *++cur;
	if (yych == 'a') goto yy1191;
	goto yy1137;
yy1148:
	yych = *++cur;
	if (yych <= 'd') {
		if (yych == 'a') goto yy1192;
		goto yy1137;
	} else {
		if (yych <= 'e') goto yy1193;
		if (yych == 'l') goto yy1194;
		goto yy1137;
	}
yy1149:
	yych = *++cur;
	if (yych == 'f') goto yy1195;
	goto yy1137;
yy1150:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'e') goto yy1196;
		goto yy1137;
	} else {
		if (yych <= 'h') goto yy1197;
		if (yych == 'o') goto yy1198;
		goto yy1137;
	}
yy1151:
	yych = *++cur;
	if (yych == 'i') goto yy1199;
	if (yych == 't') goto yy1200;
	goto yy1137;
yy1152:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych == 'a') goto yy1201;
		if (yych <= 'g') goto yy1137;
		goto yy1202;
	} else {
		if (yych <= 'o') {
			if (yych <= 'n') goto yy1137;
			goto yy1203;
		} else {
			if (yych == 'y') goto yy1204;
			goto yy1137;
		}
	}
yy1153:
	yych = *++cur;
	if (yych == 'a') goto yy1205;
	if (yych == 'e') goto yy1206;
	goto yy1137;
yy1154:
	yych = *++cur;
	if (yych == 'y') goto yy1207;
	goto yy1137;
yy1155:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yych <= '/') goto yy1131;
	if (yych <= '9') goto yy1155;
	goto yy1131;
yy1156:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1157:
	if (yybm[0+yych] & 64) goto yy1156;
#line 803 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown conditional: '%.*s'", int(cur - tok), tok));
    }
#line 6345 "src/parse/conf_lexer.cc"
yy1158:
	yych = *++cur;
	if (yych == 'p') goto yy1208;
	if (yych == 'r') goto yy1209;
	goto yy1157;
yy1159:
	yych = *++cur;
	if (yych <= 'g') {
		if (yych == 'a') goto yy1210;
		if (yych <= 'f') goto yy1157;
		goto yy1211;
	} else {
		if (yych <= 'h') goto yy1212;
		if (yych == 'o') goto yy1213;
		goto yy1157;
	}
yy1160:
	yych = *++cur;
	if (yych == 'a') goto yy1214;
	goto yy1157;
yy1161:
	yych = *++cur;
	if (yych == 'n') goto yy1215;
	goto yy1157;
yy1162:
	yych = *++cur;
	if (yych == 'o') goto yy1216;
	goto yy1157;
yy1163:
	yych = *++cur;
	if (yych == 'a') goto yy1217;
	if (yych == 'o') goto yy1218;
	goto yy1157;
yy1164:
	yych = *++cur;
	if (yych == 'e') goto yy1219;
	goto yy1157;
yy1165:
	yych = *++cur;
	if (yych == 'e') goto yy1220;
	goto yy1157;
yy1166:
	yych = *++cur;
	if (yych == 't') goto yy1221;
	goto yy1157;
yy1167:
	yych = *++cur;
	if (yych == 'y') goto yy1222;
	goto yy1157;
yy1168:
	yych = *++cur;
	if (yych == 'n') goto yy1223;
	goto yy1157;
yy1169:
	yych = *++cur;
	if (yych == 'e') goto yy1224;
	goto yy1157;
yy1170:
	yych = *++cur;
	if (yych == 'y') goto yy1225;
	goto yy1157;
yy1171:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy1171;
	if (yych >= 0x01) goto yy1124;
yy1172:
	cur = mar;
	if (yyaccept <= 2) {
		if (yyaccept <= 1) {
			if (yyaccept == 0) goto yy1122;
			else goto yy1138;
		} else {
			goto yy1516;
		}
	} else {
		if (yyaccept == 3) goto yy1559;
		else goto yy1628;
	}
yy1173:
	yych = *++cur;
	if (yych == 'n') goto yy1226;
	goto yy1172;
yy1174:
	yych = *++cur;
	switch (yych) {
		case 'B': goto yy1227;
		case 'C': goto yy1228;
		case 'D': goto yy1229;
		case 'G': goto yy1230;
		case 'I': goto yy1231;
		case 'L': goto yy1232;
		case 'M': goto yy1233;
		case 'P': goto yy1234;
		case 'R': goto yy1235;
		case 'S': goto yy1236;
		default: goto yy1172;
	}
yy1175:
	yych = *++cur;
	if (yych == 'g') goto yy1237;
	if (yych == 'r') goto yy1238;
	goto yy1137;
yy1176:
	yych = *++cur;
	if (yych == 's') goto yy1239;
	goto yy1137;
yy1177:
	yych = *++cur;
	if (yych == 'a') goto yy1240;
	goto yy1137;
yy1178:
	yych = *++cur;
	if (yych == 's') goto yy1241;
	goto yy1137;
yy1179:
	yych = *++cur;
	if (yych == 'd') goto yy1242;
	if (yych == 'n') goto yy1243;
	goto yy1137;
yy1180:
	yych = *++cur;
	if (yych == 't') goto yy1244;
	goto yy1137;
yy1181:
	yych = *++cur;
	if (yych == 'd') goto yy1245;
	goto yy1137;
yy1182:
	yych = *++cur;
	if (yych == 'e') goto yy1246;
	goto yy1137;
yy1183:
	yych = *++cur;
	if (yych == 'p') goto yy1247;
	goto yy1137;
yy1184:
	yych = *++cur;
	if (yych == 'l') goto yy1248;
	goto yy1137;
yy1185:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1186;
		if (yych <= '9') goto yy1136;
		if (yych >= '_') goto yy1136;
	} else {
		if (yych <= 'c') {
			if (yych >= 'a') goto yy1136;
		} else {
			if (yych <= 'd') goto yy1249;
			if (yych <= 'z') goto yy1136;
		}
	}
yy1186:
#line 681 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FN); }
#line 6504 "src/parse/conf_lexer.cc"
yy1187:
	yych = *++cur;
	if (yych == 'd') goto yy1250;
	if (yych == 'i') goto yy1251;
	goto yy1137;
yy1188:
	yych = *++cur;
	if (yych == 'b') goto yy1252;
	goto yy1137;
yy1189:
	yych = *++cur;
	if (yych == 's') goto yy1253;
	goto yy1137;
yy1190:
	yych = *++cur;
	if (yych == 'n') goto yy1254;
	goto yy1137;
yy1191:
	yych = *++cur;
	if (yych == 's') goto yy1255;
	goto yy1137;
yy1192:
	yych = *++cur;
	if (yych == 'm') goto yy1256;
	goto yy1137;
yy1193:
	yych = *++cur;
	if (yych == 'e') goto yy1257;
	if (yych == 'g') goto yy1258;
	goto yy1137;
yy1194:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 744 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEWLINE); }
#line 6540 "src/parse/conf_lexer.cc"
yy1195:
	yych = *++cur;
	if (yych == 'f') goto yy1259;
	goto yy1137;
yy1196:
	yych = *++cur;
	if (yych == 't') goto yy1260;
	goto yy1137;
yy1197:
	yych = *++cur;
	if (yych == 's') goto yy1261;
	goto yy1137;
yy1198:
	yych = *++cur;
	if (yych == 'w') goto yy1262;
	goto yy1137;
yy1199:
	yych = *++cur;
	if (yych == 'g') goto yy1263;
	if (yych == 'z') goto yy1264;
	goto yy1137;
yy1200:
	yych = *++cur;
	if (yych == 'a') goto yy1265;
	if (yych == 'm') goto yy1266;
	goto yy1137;
yy1201:
	yych = *++cur;
	if (yych == 'g') goto yy1267;
	goto yy1137;
yy1202:
	yych = *++cur;
	if (yych == 'r') goto yy1268;
	goto yy1137;
yy1203:
	yych = *++cur;
	if (yych == 'p') goto yy1269;
	goto yy1137;
yy1204:
	yych = *++cur;
	if (yych == 'p') goto yy1270;
	goto yy1137;
yy1205:
	yych = *++cur;
	if (yych == 'l') goto yy1271;
	if (yych == 'r') goto yy1272;
	goto yy1137;
yy1206:
	yych = *++cur;
	if (yych == 'r') goto yy1273;
	goto yy1137;
yy1207:
	yych = *++cur;
	if (yych <= 'c') {
		if (yych <= 'a') goto yy1137;
		if (yych <= 'b') goto yy1274;
		goto yy1275;
	} else {
		if (yych == 'r') goto yy1276;
		goto yy1137;
	}
yy1208:
	yych = *++cur;
	if (yych == 'i') goto yy1277;
	goto yy1157;
yy1209:
	yych = *++cur;
	if (yych == 'g') goto yy1278;
	goto yy1157;
yy1210:
	yych = *++cur;
	if (yych == 's') goto yy1279;
	goto yy1157;
yy1211:
	yych = *++cur;
	if (yych == 'o') goto yy1280;
	goto yy1157;
yy1212:
	yych = *++cur;
	if (yych == 'a') goto yy1281;
	goto yy1157;
yy1213:
	yych = *++cur;
	if (yych == 'd') goto yy1282;
	if (yych == 'n') goto yy1283;
	goto yy1157;
yy1214:
	yych = *++cur;
	if (yych == 't') goto yy1284;
	goto yy1157;
yy1215:
	yych = *++cur;
	if (yych == 'i') goto yy1285;
	goto yy1157;
yy1216:
	yych = *++cur;
	if (yych == 'o') goto yy1286;
	goto yy1157;
yy1217:
	yych = *++cur;
	if (yych == 'n') goto yy1287;
	goto yy1157;
yy1218:
	yych = *++cur;
	if (yych == 'n') goto yy1288;
	goto yy1157;
yy1219:
	yych = *++cur;
	if (yych == 's') goto yy1289;
	goto yy1157;
yy1220:
	yych = *++cur;
	if (yych == 't') goto yy1290;
	goto yy1157;
yy1221:
	yych = *++cur;
	if (yych == 'a') goto yy1291;
	if (yych == 'o') goto yy1292;
	goto yy1157;
yy1222:
	yych = *++cur;
	if (yych == 'p') goto yy1293;
	goto yy1157;
yy1223:
	yych = *++cur;
	if (yych == 's') goto yy1294;
	goto yy1157;
yy1224:
	yych = *++cur;
	if (yych == 'r') goto yy1295;
	goto yy1157;
yy1225:
	yych = *++cur;
	if (yych == 'f') goto yy1296;
	goto yy1157;
yy1226:
	yych = *++cur;
	if (yych == 'd') goto yy1297;
	goto yy1172;
yy1227:
	yych = *++cur;
	if (yych == 'A') goto yy1298;
	goto yy1172;
yy1228:
	yych = *++cur;
	if (yych <= 'S') {
		if (yych == 'O') goto yy1299;
		goto yy1172;
	} else {
		if (yych <= 'T') goto yy1300;
		if (yych <= 'U') goto yy1301;
		goto yy1172;
	}
yy1229:
	yych = *++cur;
	if (yych == 'E') goto yy1302;
	goto yy1172;
yy1230:
	yych = *++cur;
	if (yych == 'E') goto yy1303;
	goto yy1172;
yy1231:
	yych = *++cur;
	if (yych == 'N') goto yy1304;
	goto yy1172;
yy1232:
	yych = *++cur;
	if (yych == 'E') goto yy1305;
	if (yych == 'I') goto yy1306;
	goto yy1172;
yy1233:
	yych = *++cur;
	if (yych == 'A') goto yy1307;
	if (yych == 'T') goto yy1308;
	goto yy1172;
yy1234:
	yych = *++cur;
	if (yych == 'E') goto yy1309;
	goto yy1172;
yy1235:
	yych = *++cur;
	if (yych == 'E') goto yy1310;
	goto yy1172;
yy1236:
	yych = *++cur;
	switch (yych) {
		case 'E': goto yy1311;
		case 'H': goto yy1312;
		case 'K': goto yy1313;
		case 'T': goto yy1314;
		default: goto yy1172;
	}
yy1237:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1136;
		} else {
			if (yych == '_') goto yy1136;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'n') goto yy1315;
			goto yy1136;
		} else {
			if (yych <= 't') goto yy1316;
			if (yych <= 'z') goto yy1136;
		}
	}
#line 670 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARG); }
#line 6752 "src/parse/conf_lexer.cc"
yy1238:
	yych = *++cur;
	if (yych == 'a') goto yy1317;
	goto yy1137;
yy1239:
	yych = *++cur;
	if (yych == 'e') goto yy1318;
	goto yy1137;
yy1240:
	yych = *++cur;
	if (yych == 'n') goto yy1319;
	goto yy1137;
yy1241:
	yych = *++cur;
	if (yych == 'e') goto yy1320;
	goto yy1137;
yy1242:
	yych = *++cur;
	if (yych == 'e') goto yy1321;
	goto yy1137;
yy1243:
	yych = *++cur;
	if (yych == 'd') goto yy1322;
	goto yy1137;
yy1244:
	yych = *++cur;
	if (yych == 'e') goto yy1323;
	goto yy1137;
yy1245:
	yych = *++cur;
	if (yych == 'e') goto yy1324;
	goto yy1137;
yy1246:
	yych = *++cur;
	if (yych == 'm') goto yy1325;
	goto yy1137;
yy1247:
	yych = *++cur;
	if (yych == 'r') goto yy1326;
	goto yy1137;
yy1248:
	yych = *++cur;
	if (yych == 'e') goto yy1327;
	goto yy1137;
yy1249:
	yych = *++cur;
	if (yych == 'e') goto yy1328;
	goto yy1137;
yy1250:
	yych = *++cur;
	if (yych == 'e') goto yy1329;
	goto yy1137;
yy1251:
	yych = *++cur;
	if (yych == 't') goto yy1330;
	goto yy1137;
yy1252:
	yych = *++cur;
	if (yych == 'e') goto yy1331;
	goto yy1137;
yy1253:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 688 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LHS); }
#line 6818 "src/parse/conf_lexer.cc"
yy1254:
	yych = *++cur;
	if (yych == 'e') goto yy1332;
	goto yy1137;
yy1255:
	yych = *++cur;
	if (yych == 'k') goto yy1333;
	goto yy1137;
yy1256:
	yych = *++cur;
	if (yych == 'e') goto yy1334;
	goto yy1137;
yy1257:
	yych = *++cur;
	if (yych == 'd') goto yy1335;
	goto yy1137;
yy1258:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 692 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEG); }
#line 6840 "src/parse/conf_lexer.cc"
yy1259:
	yych = *++cur;
	if (yych == 's') goto yy1336;
	goto yy1137;
yy1260:
	yych = *++cur;
	if (yych == 'v') goto yy1337;
	goto yy1137;
yy1261:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 696 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RHS); }
#line 6854 "src/parse/conf_lexer.cc"
yy1262:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 697 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ROW); }
#line 6860 "src/parse/conf_lexer.cc"
yy1263:
	yych = *++cur;
	if (yych == 'i') goto yy1338;
	goto yy1137;
yy1264:
	yych = *++cur;
	if (yych == 'e') goto yy1339;
	goto yy1137;
yy1265:
	yych = *++cur;
	if (yych == 't') goto yy1340;
	goto yy1137;
yy1266:
	yych = *++cur;
	if (yych == 't') goto yy1341;
	goto yy1137;
yy1267:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 702 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TAG); }
#line 6882 "src/parse/conf_lexer.cc"
yy1268:
	yych = *++cur;
	if (yych == 'o') goto yy1342;
	goto yy1137;
yy1269:
	yych = *++cur;
	if (yych == 'i') goto yy1343;
	goto yy1137;
yy1270:
	yych = *++cur;
	if (yych == 'e') goto yy1344;
	goto yy1137;
yy1271:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 705 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAL); }
#line 6900 "src/parse/conf_lexer.cc"
yy1272:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 706 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VAR); }
#line 6906 "src/parse/conf_lexer.cc"
yy1273:
	yych = *++cur;
	if (yych == 's') goto yy1345;
	goto yy1137;
yy1274:
	yych = *++cur;
	if (yych == 'm') goto yy1346;
	goto yy1137;
yy1275:
	yych = *++cur;
	if (yych == 'h') goto yy1347;
	goto yy1137;
yy1276:
	yych = *++cur;
	if (yych == 'e') goto yy1348;
	goto yy1137;
yy1277:
	yych = *++cur;
	if (yych == '.') goto yy1349;
	if (yych == '_') goto yy1350;
	goto yy1157;
yy1278:
	yych = *++cur;
	if (yych == 's') goto yy1351;
	goto yy1157;
yy1279:
	yych = *++cur;
	if (yych == 'e') goto yy1352;
	if (yych == 't') goto yy1353;
	goto yy1157;
yy1280:
	yych = *++cur;
	if (yych == 't') goto yy1354;
	goto yy1157;
yy1281:
	yych = *++cur;
	if (yych == 'r') goto yy1355;
	goto yy1157;
yy1282:
	yych = *++cur;
	if (yych == 'e') goto yy1356;
	goto yy1157;
yy1283:
	yych = *++cur;
	if (yych == 'd') goto yy1357;
	if (yych == 's') goto yy1358;
	goto yy1157;
yy1284:
	yych = *++cur;
	if (yych == 'e') goto yy1359;
	goto yy1157;
yy1285:
	yych = *++cur;
	if (yych == 't') goto yy1360;
	goto yy1157;
yy1286:
	yych = *++cur;
	if (yych == 'p') goto yy1361;
	goto yy1157;
yy1287:
	yych = *++cur;
	if (yych == 'y') goto yy1362;
	goto yy1157;
yy1288:
	yych = *++cur;
	if (yych == 'a') goto yy1363;
	goto yy1157;
yy1289:
	yych = *++cur;
	if (yych == 't') goto yy1364;
	goto yy1157;
yy1290:
	yych = *++cur;
	if (yych == 'v') goto yy1365;
	goto yy1157;
yy1291:
	yych = *++cur;
	if (yych == 'r') goto yy1366;
	goto yy1157;
yy1292:
	yych = *++cur;
	if (yych == 'r') goto yy1367;
	goto yy1157;
yy1293:
	yych = *++cur;
	if (yych == 'e') goto yy1368;
	goto yy1157;
yy1294:
	yych = *++cur;
	if (yych == 'a') goto yy1369;
	goto yy1157;
yy1295:
	yych = *++cur;
	if (yych == 's') goto yy1370;
	goto yy1157;
yy1296:
	yych = *++cur;
	if (yych == 'n') goto yy1371;
	goto yy1157;
yy1297:
	yych = *++cur;
	if (yych == 'e') goto yy1372;
	goto yy1172;
yy1298:
	yych = *++cur;
	if (yych == 'C') goto yy1373;
	goto yy1172;
yy1299:
	yych = *++cur;
	if (yych == 'P') goto yy1374;
	goto yy1172;
yy1300:
	yych = *++cur;
	if (yych <= 'W') goto yy1172;
	if (yych <= 'X') goto yy1375;
	if (yych <= 'Y') goto yy1376;
	goto yy1172;
yy1301:
	yych = *++cur;
	if (yych == 'R') goto yy1377;
	goto yy1172;
yy1302:
	yych = *++cur;
	if (yych == 'B') goto yy1378;
	goto yy1172;
yy1303:
	yych = *++cur;
	if (yych == 'T') goto yy1379;
	goto yy1172;
yy1304:
	yych = *++cur;
	if (yych == 'P') goto yy1380;
	goto yy1172;
yy1305:
	yych = *++cur;
	if (yych == 'S') goto yy1381;
	goto yy1172;
yy1306:
	yych = *++cur;
	if (yych == 'M') goto yy1382;
	goto yy1172;
yy1307:
	yych = *++cur;
	if (yych == 'R') goto yy1383;
	goto yy1172;
yy1308:
	yych = *++cur;
	if (yych == 'A') goto yy1384;
	goto yy1172;
yy1309:
	yych = *++cur;
	if (yych == 'E') goto yy1385;
	goto yy1172;
yy1310:
	yych = *++cur;
	if (yych == 'S') goto yy1386;
	goto yy1172;
yy1311:
	yych = *++cur;
	if (yych == 'T') goto yy1387;
	goto yy1172;
yy1312:
	yych = *++cur;
	if (yych == 'I') goto yy1388;
	goto yy1172;
yy1313:
	yych = *++cur;
	if (yych == 'I') goto yy1389;
	goto yy1172;
yy1314:
	yych = *++cur;
	if (yych == 'A') goto yy1390;
	goto yy1172;
yy1315:
	yych = *++cur;
	if (yych == 'a') goto yy1391;
	goto yy1137;
yy1316:
	yych = *++cur;
	if (yych == 'y') goto yy1392;
	goto yy1137;
yy1317:
	yych = *++cur;
	if (yych == 'y') goto yy1393;
	goto yy1137;
yy1318:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 675 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BASE); }
#line 7097 "src/parse/conf_lexer.cc"
yy1319:
	yych = *++cur;
	if (yych == 'c') goto yy1394;
	goto yy1137;
yy1320:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 676 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CASE); }
#line 7107 "src/parse/conf_lexer.cc"
yy1321:
	yyaccept = 1;
	yych = *(mar = ++cur);
	if (yych == ':') goto yy1395;
	goto yy1137;
yy1322:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 677 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COND); }
#line 7118 "src/parse/conf_lexer.cc"
yy1323:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 678 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DATE); }
#line 7124 "src/parse/conf_lexer.cc"
yy1324:
	yych = *++cur;
	if (yych == 'n') goto yy1396;
	goto yy1137;
yy1325:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 679 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ELEM); }
#line 7134 "src/parse/conf_lexer.cc"
yy1326:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 680 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::EXPR); }
#line 7140 "src/parse/conf_lexer.cc"
yy1327:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 682 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FILE); }
#line 7146 "src/parse/conf_lexer.cc"
yy1328:
	yych = *++cur;
	if (yych == 'c') goto yy1397;
	if (yych == 'f') goto yy1398;
	goto yy1137;
yy1329:
	yych = *++cur;
	if (yych == 'n') goto yy1399;
	if (yych == 'x') goto yy1400;
	goto yy1137;
yy1330:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 686 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INIT); }
#line 7162 "src/parse/conf_lexer.cc"
yy1331:
	yych = *++cur;
	if (yych == 'l') goto yy1401;
	goto yy1137;
yy1332:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 689 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LINE); }
#line 7172 "src/parse/conf_lexer.cc"
yy1333:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 690 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MASK); }
#line 7178 "src/parse/conf_lexer.cc"
yy1334:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 691 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NAME); }
#line 7184 "src/parse/conf_lexer.cc"
yy1335:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 693 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::NEED); }
#line 7190 "src/parse/conf_lexer.cc"
yy1336:
	yych = *++cur;
	if (yych == 'e') goto yy1402;
	goto yy1137;
yy1337:
	yych = *++cur;
	if (yych == 'a') goto yy1403;
	goto yy1137;
yy1338:
	yych = *++cur;
	if (yych == 'l') goto yy1404;
	goto yy1137;
yy1339:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 699 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIZE); }
#line 7208 "src/parse/conf_lexer.cc"
yy1340:
	yych = *++cur;
	if (yych == 'e') goto yy1405;
	goto yy1137;
yy1341:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 701 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STMT); }
#line 7218 "src/parse/conf_lexer.cc"
yy1342:
	yych = *++cur;
	if (yych == 'w') goto yy1406;
	goto yy1137;
yy1343:
	yych = *++cur;
	if (yych == 'n') goto yy1407;
	goto yy1137;
yy1344:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 704 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TYPE); }
#line 7232 "src/parse/conf_lexer.cc"
yy1345:
	yych = *++cur;
	if (yych == 'i') goto yy1408;
	goto yy1137;
yy1346:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 711 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BITMAP); }
#line 7242 "src/parse/conf_lexer.cc"
yy1347:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 712 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CHAR); }
#line 7248 "src/parse/conf_lexer.cc"
yy1348:
	yych = *++cur;
	if (yych == 'c') goto yy1409;
	goto yy1137;
yy1349:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'g') goto yy1410;
		goto yy1157;
	} else {
		if (yych <= 'r') goto yy1411;
		if (yych <= 's') goto yy1412;
		goto yy1157;
	}
yy1350:
	yych = *++cur;
	if (yych == 's') goto yy1413;
	goto yy1157;
yy1351:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 795 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::ARGS); }
#line 7272 "src/parse/conf_lexer.cc"
yy1352:
	yych = *++cur;
	if (yych == '_') goto yy1414;
	goto yy1157;
yy1353:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 792 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CAST); }
#line 7282 "src/parse/conf_lexer.cc"
yy1354:
	yych = *++cur;
	if (yych == 'o') goto yy1415;
	goto yy1157;
yy1355:
	yych = *++cur;
	if (yych == '_') goto yy1416;
	goto yy1157;
yy1356:
	yych = *++cur;
	if (yych == '_') goto yy1417;
	goto yy1157;
yy1357:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 796 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::COND); }
#line 7300 "src/parse/conf_lexer.cc"
yy1358:
	yych = *++cur;
	if (yych == 't') goto yy1418;
	goto yy1157;
yy1359:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 779 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::DATE); }
#line 7310 "src/parse/conf_lexer.cc"
yy1360:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 797 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::INIT); }
#line 7316 "src/parse/conf_lexer.cc"
yy1361:
	yych = *++cur;
	if (yych == '_') goto yy1419;
	goto yy1157;
yy1362:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 800 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::MANY); }
#line 7326 "src/parse/conf_lexer.cc"
yy1363:
	yych = *++cur;
	if (yych == 'd') goto yy1420;
	goto yy1157;
yy1364:
	yych = *++cur;
	if (yych == 'e') goto yy1421;
	goto yy1157;
yy1365:
	yych = *++cur;
	if (yych == 'a') goto yy1422;
	goto yy1157;
yy1366:
	yych = *++cur;
	if (yych == 't') goto yy1423;
	goto yy1157;
yy1367:
	yych = *++cur;
	if (yych == 'a') goto yy1424;
	goto yy1157;
yy1368:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 799 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::TYPE); }
#line 7352 "src/parse/conf_lexer.cc"
yy1369:
	yych = *++cur;
	if (yych == 'f') goto yy1425;
	goto yy1157;
yy1370:
	yych = *++cur;
	if (yych == 'i') goto yy1426;
	goto yy1157;
yy1371:
	yych = *++cur;
	if (yych == '.') goto yy1427;
	goto yy1157;
yy1372:
	yych = *++cur;
	if (yych == 'f') goto yy1428;
	goto yy1172;
yy1373:
	yych = *++cur;
	if (yych == 'K') goto yy1429;
	goto yy1172;
yy1374:
	yych = *++cur;
	if (yych == 'Y') goto yy1430;
	goto yy1172;
yy1375:
	yych = *++cur;
	if (yych == 'M') goto yy1431;
	goto yy1172;
yy1376:
	yych = *++cur;
	if (yych == 'P') goto yy1432;
	goto yy1172;
yy1377:
	yych = *++cur;
	if (yych == 'S') goto yy1433;
	goto yy1172;
yy1378:
	yych = *++cur;
	if (yych == 'U') goto yy1434;
	goto yy1172;
yy1379:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1435;
		goto yy1172;
	} else {
		if (yych <= 'C') goto yy1436;
		if (yych == 'S') goto yy1437;
		goto yy1172;
	}
yy1380:
	yych = *++cur;
	if (yych == 'U') goto yy1438;
	goto yy1172;
yy1381:
	yych = *++cur;
	if (yych == 'S') goto yy1439;
	goto yy1172;
yy1382:
	yych = *++cur;
	if (yych == 'I') goto yy1440;
	goto yy1172;
yy1383:
	yych = *++cur;
	if (yych == 'K') goto yy1441;
	goto yy1172;
yy1384:
	yych = *++cur;
	if (yych == 'G') goto yy1442;
	goto yy1172;
yy1385:
	yych = *++cur;
	if (yych == 'K') goto yy1443;
	goto yy1172;
yy1386:
	yych = *++cur;
	if (yych == 'T') goto yy1444;
	goto yy1172;
yy1387:
	yych = *++cur;
	if (yych <= 'B') {
		if (yych == 'A') goto yy1445;
		goto yy1172;
	} else {
		if (yych <= 'C') goto yy1446;
		if (yych == 'S') goto yy1447;
		goto yy1172;
	}
yy1388:
	yych = *++cur;
	if (yych == 'F') goto yy1448;
	goto yy1172;
yy1389:
	yych = *++cur;
	if (yych == 'P') goto yy1449;
	goto yy1172;
yy1390:
	yych = *++cur;
	if (yych == 'G') goto yy1450;
	goto yy1172;
yy1391:
	yych = *++cur;
	if (yych == 'm') goto yy1451;
	goto yy1137;
yy1392:
	yych = *++cur;
	if (yych == 'p') goto yy1452;
	goto yy1137;
yy1393:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 673 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARRAY); }
#line 7466 "src/parse/conf_lexer.cc"
yy1394:
	yych = *++cur;
	if (yych == 'h') goto yy1453;
	goto yy1137;
yy1395:
	yych = *++cur;
	if (yych <= 'h') {
		if (yych <= 'a') {
			if (yych <= '^') {
				if (yych <= '/') goto yy1172;
				if (yych <= '9') goto yy1454;
				goto yy1172;
			} else {
				if (yych <= '_') goto yy1454;
				if (yych <= '`') goto yy1172;
				goto yy1457;
			}
		} else {
			if (yych <= 'd') {
				if (yych == 'c') goto yy1458;
				goto yy1454;
			} else {
				if (yych <= 'e') goto yy1459;
				if (yych <= 'f') goto yy1460;
				if (yych <= 'g') goto yy1461;
				goto yy1454;
			}
		}
	} else {
		if (yych <= 's') {
			if (yych <= 'l') {
				if (yych <= 'i') goto yy1462;
				if (yych <= 'k') goto yy1454;
				goto yy1463;
			} else {
				if (yych <= 'q') goto yy1454;
				if (yych <= 'r') goto yy1464;
				goto yy1465;
			}
		} else {
			if (yych <= 'v') {
				if (yych <= 't') goto yy1466;
				if (yych <= 'u') goto yy1454;
				goto yy1467;
			} else {
				if (yych == 'y') goto yy1468;
				if (yych <= 'z') goto yy1454;
				goto yy1172;
			}
		}
	}
yy1396:
	yych = *++cur;
	if (yych == 't') goto yy1469;
	goto yy1137;
yy1397:
	yych = *++cur;
	if (yych == 'l') goto yy1470;
	goto yy1137;
yy1398:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 684 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDEF); }
#line 7531 "src/parse/conf_lexer.cc"
yy1399:
	yych = *++cur;
	if (yych == 't') goto yy1471;
	goto yy1137;
yy1400:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 685 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDEX); }
#line 7541 "src/parse/conf_lexer.cc"
yy1401:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 687 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LABEL); }
#line 7547 "src/parse/conf_lexer.cc"
yy1402:
	yych = *++cur;
	if (yych == 't') goto yy1472;
	goto yy1137;
yy1403:
	yych = *++cur;
	if (yych == 'l') goto yy1473;
	goto yy1137;
yy1404:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 698 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SIGIL); }
#line 7561 "src/parse/conf_lexer.cc"
yy1405:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 700 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STATE); }
#line 7567 "src/parse/conf_lexer.cc"
yy1406:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 703 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::THROW); }
#line 7573 "src/parse/conf_lexer.cc"
yy1407:
	yych = *++cur;
	if (yych == 'd') goto yy1474;
	goto yy1137;
yy1408:
	yych = *++cur;
	if (yych == 'o') goto yy1475;
	goto yy1137;
yy1409:
	yych = *++cur;
	if (yych == 'o') goto yy1476;
	goto yy1137;
yy1410:
	yych = *++cur;
	if (yych == 'e') goto yy1477;
	goto yy1157;
yy1411:
	yych = *++cur;
	if (yych == 'e') goto yy1478;
	goto yy1157;
yy1412:
	yych = *++cur;
	if (yych == 'i') goto yy1479;
	goto yy1157;
yy1413:
	yych = *++cur;
	if (yych == 't') goto yy1480;
	goto yy1157;
yy1414:
	yych = *++cur;
	if (yych == 'r') goto yy1481;
	goto yy1157;
yy1415:
	yych = *++cur;
	if (yych == '.') goto yy1482;
	goto yy1157;
yy1416:
	yych = *++cur;
	if (yych == 'l') goto yy1483;
	goto yy1157;
yy1417:
	yych = *++cur;
	if (yych == 'm') goto yy1484;
	goto yy1157;
yy1418:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 794 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CONST); }
#line 7623 "src/parse/conf_lexer.cc"
yy1419:
	yych = *++cur;
	if (yych == 'l') goto yy1485;
	goto yy1157;
yy1420:
	yych = *++cur;
	if (yych == 'i') goto yy1486;
	goto yy1157;
yy1421:
	yych = *++cur;
	if (yych == 'd') goto yy1487;
	goto yy1157;
yy1422:
	yych = *++cur;
	if (yych == 'l') goto yy1488;
	goto yy1157;
yy1423:
	yych = *++cur;
	if (yych == '_') goto yy1489;
	goto yy1157;
yy1424:
	yych = *++cur;
	if (yych == 'b') goto yy1490;
	goto yy1157;
yy1425:
	yych = *++cur;
	if (yych == 'e') goto yy1491;
	goto yy1157;
yy1426:
	yych = *++cur;
	if (yych == 'o') goto yy1492;
	goto yy1157;
yy1427:
	yych = *++cur;
	if (yych == 't') goto yy1493;
	goto yy1157;
yy1428:
	yych = *++cur;
	if (yych == 'i') goto yy1494;
	goto yy1172;
yy1429:
	yych = *++cur;
	if (yych == 'U') goto yy1495;
	goto yy1172;
yy1430:
	yych = *++cur;
	if (yych == 'M') goto yy1496;
	if (yych == 'S') goto yy1497;
	goto yy1172;
yy1431:
	yych = *++cur;
	if (yych == 'A') goto yy1498;
	goto yy1172;
yy1432:
	yych = *++cur;
	if (yych == 'E') goto yy1499;
	goto yy1172;
yy1433:
	yych = *++cur;
	if (yych == 'O') goto yy1500;
	goto yy1172;
yy1434:
	yych = *++cur;
	if (yych == 'G') goto yy1501;
	goto yy1172;
yy1435:
	yych = *++cur;
	if (yych == 'C') goto yy1502;
	goto yy1172;
yy1436:
	yych = *++cur;
	if (yych == 'O') goto yy1503;
	goto yy1172;
yy1437:
	yych = *++cur;
	if (yych == 'T') goto yy1504;
	goto yy1172;
yy1438:
	yych = *++cur;
	if (yych == 'T') goto yy1505;
	goto yy1172;
yy1439:
	yych = *++cur;
	if (yych == 'T') goto yy1506;
	goto yy1172;
yy1440:
	yych = *++cur;
	if (yych == 'T') goto yy1507;
	goto yy1172;
yy1441:
	yych = *++cur;
	if (yych == 'E') goto yy1508;
	goto yy1172;
yy1442:
	yych = *++cur;
	if (yych == 'N') goto yy1509;
	if (yych == 'P') goto yy1510;
	goto yy1172;
yy1443:
	++cur;
#line 728 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::PEEK); }
#line 7726 "src/parse/conf_lexer.cc"
yy1444:
	yych = *++cur;
	if (yych == 'O') goto yy1511;
	goto yy1172;
yy1445:
	yych = *++cur;
	if (yych == 'C') goto yy1512;
	goto yy1172;
yy1446:
	yych = *++cur;
	if (yych == 'O') goto yy1513;
	goto yy1172;
yy1447:
	yych = *++cur;
	if (yych == 'T') goto yy1514;
	goto yy1172;
yy1448:
	yych = *++cur;
	if (yych == 'T') goto yy1515;
	goto yy1172;
yy1449:
	++cur;
#line 739 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SKIP); }
#line 7751 "src/parse/conf_lexer.cc"
yy1450:
	yych = *++cur;
	if (yych == 'N') goto yy1517;
	if (yych == 'P') goto yy1518;
	goto yy1172;
yy1451:
	yych = *++cur;
	if (yych == 'e') goto yy1519;
	goto yy1137;
yy1452:
	yych = *++cur;
	if (yych == 'e') goto yy1520;
	goto yy1137;
yy1453:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 674 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BRANCH); }
#line 7770 "src/parse/conf_lexer.cc"
yy1454:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
yy1455:
	if (yych <= '^') {
		if (yych <= '/') goto yy1456;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1456;
		if (yych <= 'z') goto yy1454;
	}
yy1456:
#line 665 "../src/parse/conf_lexer.re"
	{
        RET_FAIL(error_at_tok("unknown code template: '%.*s'", int(cur - tok), tok));
    }
#line 7788 "src/parse/conf_lexer.cc"
yy1457:
	yych = *++cur;
	if (yych <= 'q') {
		if (yych == 'b') goto yy1521;
		goto yy1455;
	} else {
		if (yych <= 'r') goto yy1522;
		if (yych <= 's') goto yy1523;
		goto yy1455;
	}
yy1458:
	yych = *++cur;
	if (yych <= 'l') {
		if (yych == 'g') goto yy1524;
		goto yy1455;
	} else {
		if (yych <= 'm') goto yy1525;
		if (yych == 'o') goto yy1526;
		goto yy1455;
	}
yy1459:
	yych = *++cur;
	if (yych == 'n') goto yy1527;
	goto yy1455;
yy1460:
	yych = *++cur;
	if (yych == 'i') goto yy1528;
	if (yych == 'n') goto yy1529;
	goto yy1455;
yy1461:
	yych = *++cur;
	if (yych == 'o') goto yy1530;
	goto yy1455;
yy1462:
	yych = *++cur;
	if (yych == 'f') goto yy1531;
	goto yy1455;
yy1463:
	yych = *++cur;
	if (yych == 'i') goto yy1532;
	if (yych == 'o') goto yy1533;
	goto yy1455;
yy1464:
	yych = *++cur;
	if (yych == 'e') goto yy1534;
	goto yy1455;
yy1465:
	yych = *++cur;
	if (yych == 'w') goto yy1535;
	goto yy1455;
yy1466:
	yych = *++cur;
	if (yych == 'a') goto yy1536;
	if (yych == 'y') goto yy1537;
	goto yy1455;
yy1467:
	yych = *++cur;
	if (yych == 'a') goto yy1538;
	goto yy1455;
yy1468:
	yych = *++cur;
	if (yych == 'y') goto yy1539;
	goto yy1455;
yy1469:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 746 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEDENT); }
#line 7857 "src/parse/conf_lexer.cc"
yy1470:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 683 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::FNDECL); }
#line 7863 "src/parse/conf_lexer.cc"
yy1471:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 745 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INDENT); }
#line 7869 "src/parse/conf_lexer.cc"
yy1472:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 694 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::OFFSET); }
#line 7875 "src/parse/conf_lexer.cc"
yy1473:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 695 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RETVAL); }
#line 7881 "src/parse/conf_lexer.cc"
yy1474:
	yych = *++cur;
	if (yych == 'e') goto yy1540;
	goto yy1137;
yy1475:
	yych = *++cur;
	if (yych == 'n') goto yy1541;
	goto yy1137;
yy1476:
	yych = *++cur;
	if (yych == 'r') goto yy1542;
	goto yy1137;
yy1477:
	yych = *++cur;
	if (yych == 'n') goto yy1543;
	goto yy1157;
yy1478:
	yych = *++cur;
	if (yych == 'c') goto yy1544;
	goto yy1157;
yy1479:
	yych = *++cur;
	if (yych == 'm') goto yy1545;
	goto yy1157;
yy1480:
	yych = *++cur;
	if (yych == 'y') goto yy1546;
	goto yy1157;
yy1481:
	yych = *++cur;
	if (yych == 'a') goto yy1547;
	goto yy1157;
yy1482:
	yych = *++cur;
	if (yych == 'r') goto yy1548;
	goto yy1157;
yy1483:
	yych = *++cur;
	if (yych == 'i') goto yy1549;
	goto yy1157;
yy1484:
	yych = *++cur;
	if (yych == 'o') goto yy1550;
	goto yy1157;
yy1485:
	yych = *++cur;
	if (yych == 'a') goto yy1551;
	goto yy1157;
yy1486:
	yych = *++cur;
	if (yych == 'c') goto yy1552;
	goto yy1157;
yy1487:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 801 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::NESTED); }
#line 7939 "src/parse/conf_lexer.cc"
yy1488:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 798 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::RETVAL); }
#line 7945 "src/parse/conf_lexer.cc"
yy1489:
	yych = *++cur;
	if (yych == 'c') goto yy1553;
	goto yy1157;
yy1490:
	yych = *++cur;
	if (yych == 'l') goto yy1554;
	goto yy1157;
yy1491:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 782 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::UNSAFE); }
#line 7959 "src/parse/conf_lexer.cc"
yy1492:
	yych = *++cur;
	if (yych == 'n') goto yy1555;
	goto yy1157;
yy1493:
	yych = *++cur;
	if (yych == 'h') goto yy1556;
	goto yy1157;
yy1494:
	yych = *++cur;
	if (yych == 'n') goto yy1557;
	goto yy1172;
yy1495:
	yych = *++cur;
	if (yych == 'P') goto yy1558;
	goto yy1172;
yy1496:
	yych = *++cur;
	if (yych == 'T') goto yy1560;
	goto yy1172;
yy1497:
	yych = *++cur;
	if (yych == 'T') goto yy1561;
	goto yy1172;
yy1498:
	yych = *++cur;
	if (yych == 'R') goto yy1562;
	goto yy1172;
yy1499:
	++cur;
#line 715 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTYPE); }
#line 7992 "src/parse/conf_lexer.cc"
yy1500:
	yych = *++cur;
	if (yych == 'R') goto yy1563;
	goto yy1172;
yy1501:
	++cur;
#line 718 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::DEBUG); }
#line 8001 "src/parse/conf_lexer.cc"
yy1502:
	yych = *++cur;
	if (yych == 'C') goto yy1564;
	goto yy1172;
yy1503:
	yych = *++cur;
	if (yych == 'N') goto yy1565;
	goto yy1172;
yy1504:
	yych = *++cur;
	if (yych == 'A') goto yy1566;
	goto yy1172;
yy1505:
	++cur;
#line 722 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::INPUT); }
#line 8018 "src/parse/conf_lexer.cc"
yy1506:
	yych = *++cur;
	if (yych == 'H') goto yy1567;
	goto yy1172;
yy1507:
	++cur;
#line 724 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LIMIT); }
#line 8027 "src/parse/conf_lexer.cc"
yy1508:
	yych = *++cur;
	if (yych == 'R') goto yy1568;
	goto yy1172;
yy1509:
	++cur;
#line 726 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGN); }
#line 8036 "src/parse/conf_lexer.cc"
yy1510:
	++cur;
#line 727 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MTAGP); }
#line 8041 "src/parse/conf_lexer.cc"
yy1511:
	yych = *++cur;
	if (yych == 'R') goto yy1569;
	goto yy1172;
yy1512:
	yych = *++cur;
	if (yych == 'C') goto yy1570;
	goto yy1172;
yy1513:
	yych = *++cur;
	if (yych == 'N') goto yy1571;
	goto yy1172;
yy1514:
	yych = *++cur;
	if (yych == 'A') goto yy1572;
	goto yy1172;
yy1515:
	yyaccept = 2;
	yych = *(mar = ++cur);
	if (yych == 'M') goto yy1573;
	if (yych == 'S') goto yy1574;
yy1516:
#line 736 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFT); }
#line 8066 "src/parse/conf_lexer.cc"
yy1517:
	++cur;
#line 740 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGN); }
#line 8071 "src/parse/conf_lexer.cc"
yy1518:
	++cur;
#line 741 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::STAGP); }
#line 8076 "src/parse/conf_lexer.cc"
yy1519:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 671 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGNAME); }
#line 8082 "src/parse/conf_lexer.cc"
yy1520:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 672 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::ARGTYPE); }
#line 8088 "src/parse/conf_lexer.cc"
yy1521:
	yych = *++cur;
	if (yych == 'o') goto yy1575;
	goto yy1455;
yy1522:
	yych = *++cur;
	if (yych == 'r') goto yy1576;
	goto yy1455;
yy1523:
	yych = *++cur;
	if (yych == 's') goto yy1577;
	goto yy1455;
yy1524:
	yych = *++cur;
	if (yych == 'o') goto yy1578;
	goto yy1455;
yy1525:
	yych = *++cur;
	if (yych == 'p') goto yy1579;
	goto yy1455;
yy1526:
	yych = *++cur;
	if (yych == 'n') goto yy1580;
	goto yy1455;
yy1527:
	yych = *++cur;
	if (yych == 'u') goto yy1581;
	goto yy1455;
yy1528:
	yych = *++cur;
	if (yych == 'n') goto yy1582;
	goto yy1455;
yy1529:
	yych = *++cur;
	if (yych <= 'b') goto yy1455;
	if (yych <= 'c') goto yy1583;
	if (yych <= 'd') goto yy1584;
	goto yy1455;
yy1530:
	yych = *++cur;
	if (yych == 't') goto yy1585;
	goto yy1455;
yy1531:
	yych = *++cur;
	if (yych == '_') goto yy1586;
	goto yy1455;
yy1532:
	yych = *++cur;
	if (yych == 'n') goto yy1587;
	goto yy1455;
yy1533:
	yych = *++cur;
	if (yych == 'o') goto yy1588;
	goto yy1455;
yy1534:
	yych = *++cur;
	if (yych == 'c') goto yy1589;
	goto yy1455;
yy1535:
	yych = *++cur;
	if (yych == 'i') goto yy1590;
	goto yy1455;
yy1536:
	yych = *++cur;
	if (yych == 'i') goto yy1591;
	goto yy1455;
yy1537:
	yych = *++cur;
	if (yych == 'p') goto yy1592;
	goto yy1455;
yy1538:
	yych = *++cur;
	if (yych == 'r') goto yy1593;
	goto yy1455;
yy1539:
	yych = *++cur;
	switch (yych) {
		case 'b': goto yy1594;
		case 'c': goto yy1595;
		case 'd': goto yy1596;
		case 'g': goto yy1597;
		case 'l': goto yy1598;
		case 'm': goto yy1599;
		case 'p': goto yy1600;
		case 'r': goto yy1601;
		case 's': goto yy1602;
		case 't': goto yy1603;
		default: goto yy1455;
	}
yy1540:
	yych = *++cur;
	if (yych == 'n') goto yy1604;
	goto yy1137;
yy1541:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 707 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::VER); }
#line 8187 "src/parse/conf_lexer.cc"
yy1542:
	yych = *++cur;
	if (yych == 'd') goto yy1605;
	goto yy1137;
yy1543:
	yych = *++cur;
	if (yych == 'e') goto yy1606;
	goto yy1157;
yy1544:
	yych = *++cur;
	if (yych == 'o') goto yy1607;
	goto yy1157;
yy1545:
	yych = *++cur;
	if (yych == 'p') goto yy1608;
	goto yy1157;
yy1546:
	yych = *++cur;
	if (yych == 'l') goto yy1609;
	goto yy1157;
yy1547:
	yych = *++cur;
	if (yych == 'n') goto yy1610;
	goto yy1157;
yy1548:
	yych = *++cur;
	if (yych == 'e') goto yy1611;
	goto yy1157;
yy1549:
	yych = *++cur;
	if (yych == 't') goto yy1612;
	goto yy1157;
yy1550:
	yych = *++cur;
	if (yych == 'd') goto yy1613;
	goto yy1157;
yy1551:
	yych = *++cur;
	if (yych == 'b') goto yy1614;
	goto yy1157;
yy1552:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 783 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::MONADIC); }
#line 8233 "src/parse/conf_lexer.cc"
yy1553:
	yych = *++cur;
	if (yych == 'o') goto yy1615;
	goto yy1157;
yy1554:
	yych = *++cur;
	if (yych == 'e') goto yy1616;
	goto yy1157;
yy1555:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 780 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::VER); }
#line 8247 "src/parse/conf_lexer.cc"
yy1556:
	yych = *++cur;
	if (yych == 'r') goto yy1617;
	goto yy1157;
yy1557:
	yych = *++cur;
	if (yych == 'e') goto yy1618;
	goto yy1172;
yy1558:
	yyaccept = 3;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1619;
yy1559:
#line 709 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUP); }
#line 8263 "src/parse/conf_lexer.cc"
yy1560:
	yych = *++cur;
	if (yych == 'A') goto yy1620;
	goto yy1172;
yy1561:
	yych = *++cur;
	if (yych == 'A') goto yy1621;
	goto yy1172;
yy1562:
	yych = *++cur;
	if (yych == 'K') goto yy1622;
	goto yy1172;
yy1563:
	++cur;
#line 717 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CURSOR); }
#line 8280 "src/parse/conf_lexer.cc"
yy1564:
	yych = *++cur;
	if (yych == 'E') goto yy1623;
	goto yy1172;
yy1565:
	yych = *++cur;
	if (yych == 'D') goto yy1624;
	goto yy1172;
yy1566:
	yych = *++cur;
	if (yych == 'T') goto yy1625;
	goto yy1172;
yy1567:
	yych = *++cur;
	if (yych == 'A') goto yy1626;
	goto yy1172;
yy1568:
	++cur;
#line 725 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::MARKER); }
#line 8301 "src/parse/conf_lexer.cc"
yy1569:
	yych = *++cur;
	if (yych == 'E') goto yy1627;
	goto yy1172;
yy1570:
	yych = *++cur;
	if (yych == 'E') goto yy1629;
	goto yy1172;
yy1571:
	yych = *++cur;
	if (yych == 'D') goto yy1630;
	goto yy1172;
yy1572:
	yych = *++cur;
	if (yych == 'T') goto yy1631;
	goto yy1172;
yy1573:
	yych = *++cur;
	if (yych == 'T') goto yy1632;
	goto yy1172;
yy1574:
	yych = *++cur;
	if (yych == 'T') goto yy1633;
	goto yy1172;
yy1575:
	yych = *++cur;
	if (yych == 'r') goto yy1634;
	goto yy1455;
yy1576:
	yych = *++cur;
	if (yych == 'a') goto yy1635;
	goto yy1455;
yy1577:
	yych = *++cur;
	if (yych == 'i') goto yy1636;
	goto yy1455;
yy1578:
	yych = *++cur;
	if (yych == 't') goto yy1637;
	goto yy1455;
yy1579:
	yych = *++cur;
	if (yych == '_') goto yy1638;
	goto yy1455;
yy1580:
	yych = *++cur;
	if (yych <= 'r') goto yy1455;
	if (yych <= 's') goto yy1639;
	if (yych <= 't') goto yy1640;
	goto yy1455;
yy1581:
	yych = *++cur;
	if (yych == 'm') goto yy1641;
	goto yy1455;
yy1582:
	yych = *++cur;
	if (yych == 'g') goto yy1643;
	goto yy1455;
yy1583:
	yych = *++cur;
	if (yych == 'a') goto yy1644;
	goto yy1455;
yy1584:
	yych = *++cur;
	if (yych == 'e') goto yy1645;
	goto yy1455;
yy1585:
	yych = *++cur;
	if (yych == 'o') goto yy1646;
	goto yy1455;
yy1586:
	yych = *++cur;
	if (yych == 't') goto yy1648;
	goto yy1455;
yy1587:
	yych = *++cur;
	if (yych == 'e') goto yy1649;
	goto yy1455;
yy1588:
	yych = *++cur;
	if (yych == 'p') goto yy1650;
	goto yy1455;
yy1589:
	yych = *++cur;
	if (yych == 'u') goto yy1652;
	goto yy1455;
yy1590:
	yych = *++cur;
	if (yych == 't') goto yy1653;
	goto yy1455;
yy1591:
	yych = *++cur;
	if (yych == 'l') goto yy1654;
	goto yy1455;
yy1592:
	yych = *++cur;
	if (yych == 'e') goto yy1655;
	goto yy1455;
yy1593:
	yych = *++cur;
	if (yych == '_') goto yy1656;
	goto yy1455;
yy1594:
	yych = *++cur;
	if (yych == 'a') goto yy1657;
	if (yych == 'm') goto yy1658;
	goto yy1455;
yy1595:
	yych = *++cur;
	if (yych == 'o') goto yy1659;
	goto yy1455;
yy1596:
	yych = *++cur;
	if (yych == 'e') goto yy1660;
	goto yy1455;
yy1597:
	yych = *++cur;
	if (yych == 'e') goto yy1661;
	goto yy1455;
yy1598:
	yych = *++cur;
	if (yych == 'e') goto yy1662;
	goto yy1455;
yy1599:
	yych = *++cur;
	if (yych == 't') goto yy1663;
	goto yy1455;
yy1600:
	yych = *++cur;
	if (yych == 'e') goto yy1664;
	goto yy1455;
yy1601:
	yych = *++cur;
	if (yych == 'e') goto yy1665;
	goto yy1455;
yy1602:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1666;
		case 'h': goto yy1667;
		case 'k': goto yy1668;
		case 't': goto yy1669;
		default: goto yy1455;
	}
yy1603:
	yych = *++cur;
	if (yych == 'a') goto yy1670;
	goto yy1455;
yy1604:
	yych = *++cur;
	if (yych == 't') goto yy1671;
	goto yy1137;
yy1605:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 729 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RECORD); }
#line 8459 "src/parse/conf_lexer.cc"
yy1606:
	yych = *++cur;
	if (yych == 'r') goto yy1672;
	goto yy1157;
yy1607:
	yych = *++cur;
	if (yych == 'r') goto yy1673;
	goto yy1157;
yy1608:
	yych = *++cur;
	if (yych == 'l') goto yy1674;
	goto yy1157;
yy1609:
	yych = *++cur;
	if (yych == 'e') goto yy1675;
	goto yy1157;
yy1610:
	yych = *++cur;
	if (yych == 'g') goto yy1676;
	goto yy1157;
yy1611:
	yych = *++cur;
	if (yych == 'l') goto yy1677;
	goto yy1157;
yy1612:
	yych = *++cur;
	if (yych == 'e') goto yy1678;
	goto yy1157;
yy1613:
	yych = *++cur;
	if (yych == 'e') goto yy1679;
	goto yy1157;
yy1614:
	yych = *++cur;
	if (yych == 'e') goto yy1680;
	goto yy1157;
yy1615:
	yych = *++cur;
	if (yych == 'n') goto yy1681;
	goto yy1157;
yy1616:
	yych = *++cur;
	if (yych == '_') goto yy1682;
	goto yy1157;
yy1617:
	yych = *++cur;
	if (yych == 'o') goto yy1683;
	goto yy1157;
yy1618:
	yych = *++cur;
	if (yych == 'd') goto yy1684;
	goto yy1172;
yy1619:
	yych = *++cur;
	if (yych == 'T') goto yy1685;
	goto yy1172;
yy1620:
	yych = *++cur;
	if (yych == 'G') goto yy1686;
	goto yy1172;
yy1621:
	yych = *++cur;
	if (yych == 'G') goto yy1687;
	goto yy1172;
yy1622:
	yych = *++cur;
	if (yych == 'E') goto yy1688;
	goto yy1172;
yy1623:
	yych = *++cur;
	if (yych == 'P') goto yy1689;
	goto yy1172;
yy1624:
	++cur;
#line 720 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETCOND); }
#line 8536 "src/parse/conf_lexer.cc"
yy1625:
	yych = *++cur;
	if (yych == 'E') goto yy1690;
	goto yy1172;
yy1626:
	yych = *++cur;
	if (yych == 'N') goto yy1691;
	goto yy1172;
yy1627:
	yyaccept = 4;
	yych = *(mar = ++cur);
	if (yych == 'C') goto yy1692;
	if (yych == 'T') goto yy1693;
yy1628:
#line 730 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORE); }
#line 8553 "src/parse/conf_lexer.cc"
yy1629:
	yych = *++cur;
	if (yych == 'P') goto yy1694;
	goto yy1172;
yy1630:
	++cur;
#line 734 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETCOND); }
#line 8562 "src/parse/conf_lexer.cc"
yy1631:
	yych = *++cur;
	if (yych == 'E') goto yy1695;
	goto yy1172;
yy1632:
	yych = *++cur;
	if (yych == 'A') goto yy1696;
	goto yy1172;
yy1633:
	yych = *++cur;
	if (yych == 'A') goto yy1697;
	goto yy1172;
yy1634:
	yych = *++cur;
	if (yych == 't') goto yy1698;
	goto yy1455;
yy1635:
	yych = *++cur;
	if (yych == 'y') goto yy1700;
	goto yy1455;
yy1636:
	yych = *++cur;
	if (yych == 'g') goto yy1701;
	goto yy1455;
yy1637:
	yych = *++cur;
	if (yych == 'o') goto yy1702;
	goto yy1455;
yy1638:
	yych = *++cur;
	switch (yych) {
		case 'e': goto yy1704;
		case 'g': goto yy1705;
		case 'l': goto yy1706;
		case 'n': goto yy1707;
		default: goto yy1455;
	}
yy1639:
	yych = *++cur;
	if (yych == 't') goto yy1708;
	goto yy1455;
yy1640:
	yych = *++cur;
	if (yych == 'i') goto yy1709;
	goto yy1455;
yy1641:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1642;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy1710;
		if (yych <= '`') goto yy1642;
		if (yych <= 'z') goto yy1454;
	}
yy1642:
#line 620 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum); }
#line 8621 "src/parse/conf_lexer.cc"
yy1643:
	yych = *++cur;
	if (yych == 'e') goto yy1711;
	goto yy1455;
yy1644:
	yych = *++cur;
	if (yych == 'l') goto yy1712;
	goto yy1455;
yy1645:
	yych = *++cur;
	if (yych == 'c') goto yy1713;
	if (yych == 'f') goto yy1714;
	goto yy1455;
yy1646:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1647;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1647;
		if (yych <= 'z') goto yy1454;
	}
yy1647:
#line 617 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_goto); }
#line 8647 "src/parse/conf_lexer.cc"
yy1648:
	yych = *++cur;
	if (yych == 'h') goto yy1716;
	goto yy1455;
yy1649:
	yych = *++cur;
	if (yych == '_') goto yy1717;
	goto yy1455;
yy1650:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1651;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1651;
		if (yych <= 'z') goto yy1454;
	}
yy1651:
#line 615 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_loop); }
#line 8668 "src/parse/conf_lexer.cc"
yy1652:
	yych = *++cur;
	if (yych == 'r') goto yy1718;
	goto yy1455;
yy1653:
	yych = *++cur;
	if (yych == 'c') goto yy1719;
	goto yy1455;
yy1654:
	yych = *++cur;
	if (yych == 'c') goto yy1720;
	goto yy1455;
yy1655:
	yych = *++cur;
	if (yych == '_') goto yy1721;
	goto yy1455;
yy1656:
	yych = *++cur;
	if (yych == 'g') goto yy1722;
	if (yych == 'l') goto yy1723;
	goto yy1455;
yy1657:
	yych = *++cur;
	if (yych == 'c') goto yy1724;
	goto yy1455;
yy1658:
	yych = *++cur;
	if (yych == '_') goto yy1725;
	goto yy1455;
yy1659:
	yych = *++cur;
	if (yych == 'p') goto yy1726;
	goto yy1455;
yy1660:
	yych = *++cur;
	if (yych == 'b') goto yy1727;
	goto yy1455;
yy1661:
	yych = *++cur;
	if (yych == 't') goto yy1728;
	goto yy1455;
yy1662:
	yych = *++cur;
	if (yych == 's') goto yy1729;
	goto yy1455;
yy1663:
	yych = *++cur;
	if (yych == 'a') goto yy1730;
	goto yy1455;
yy1664:
	yych = *++cur;
	if (yych == 'e') goto yy1731;
	goto yy1455;
yy1665:
	yych = *++cur;
	if (yych == 's') goto yy1732;
	goto yy1455;
yy1666:
	yych = *++cur;
	if (yych == 't') goto yy1733;
	goto yy1455;
yy1667:
	yych = *++cur;
	if (yych == 'i') goto yy1734;
	goto yy1455;
yy1668:
	yych = *++cur;
	if (yych == 'i') goto yy1735;
	goto yy1455;
yy1669:
	yych = *++cur;
	if (yych == 'a') goto yy1736;
	goto yy1455;
yy1670:
	yych = *++cur;
	if (yych == 'r') goto yy1737;
	goto yy1455;
yy1671:
	yych = *++cur;
	if (yybm[0+yych] & 32) goto yy1136;
#line 747 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::TOPINDENT); }
#line 8751 "src/parse/conf_lexer.cc"
yy1672:
	yych = *++cur;
	if (yych == 'i') goto yy1738;
	goto yy1157;
yy1673:
	yych = *++cur;
	if (yych == 'd') goto yy1739;
	goto yy1157;
yy1674:
	yych = *++cur;
	if (yych == 'e') goto yy1740;
	goto yy1157;
yy1675:
	yych = *++cur;
	if (yych == '.') goto yy1741;
	goto yy1157;
yy1676:
	yych = *++cur;
	if (yych == 'e') goto yy1742;
	goto yy1157;
yy1677:
	yych = *++cur;
	if (yych == 'a') goto yy1743;
	goto yy1157;
yy1678:
	yych = *++cur;
	if (yych == 'r') goto yy1744;
	goto yy1157;
yy1679:
	yych = *++cur;
	if (yych == 'l') goto yy1745;
	goto yy1157;
yy1680:
	yych = *++cur;
	if (yych == 'l') goto yy1746;
	goto yy1157;
yy1681:
	yych = *++cur;
	if (yych == 'd') goto yy1747;
	goto yy1157;
yy1682:
	yych = *++cur;
	if (yych == 's') goto yy1748;
	goto yy1157;
yy1683:
	yych = *++cur;
	if (yych == 'w') goto yy1749;
	goto yy1157;
yy1684:
	yych = *++cur;
	if (yych == '>') goto yy1750;
	goto yy1172;
yy1685:
	yych = *++cur;
	if (yych == 'X') goto yy1751;
	goto yy1172;
yy1686:
	++cur;
#line 713 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYMTAG); }
#line 8812 "src/parse/conf_lexer.cc"
yy1687:
	++cur;
#line 714 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::COPYSTAG); }
#line 8817 "src/parse/conf_lexer.cc"
yy1688:
	yych = *++cur;
	if (yych == 'R') goto yy1752;
	goto yy1172;
yy1689:
	yych = *++cur;
	if (yych == 'T') goto yy1753;
	goto yy1172;
yy1690:
	++cur;
#line 721 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETSTATE); }
#line 8830 "src/parse/conf_lexer.cc"
yy1691:
	++cur;
#line 723 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::LESSTHAN); }
#line 8835 "src/parse/conf_lexer.cc"
yy1692:
	yych = *++cur;
	if (yych == 'T') goto yy1754;
	goto yy1172;
yy1693:
	yych = *++cur;
	if (yych == 'A') goto yy1755;
	goto yy1172;
yy1694:
	yych = *++cur;
	if (yych == 'T') goto yy1756;
	goto yy1172;
yy1695:
	++cur;
#line 735 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETSTATE); }
#line 8852 "src/parse/conf_lexer.cc"
yy1696:
	yych = *++cur;
	if (yych == 'G') goto yy1757;
	goto yy1172;
yy1697:
	yych = *++cur;
	if (yych == 'G') goto yy1758;
	goto yy1172;
yy1698:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1699;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1699;
		if (yych <= 'z') goto yy1454;
	}
yy1699:
#line 629 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_abort); }
#line 8873 "src/parse/conf_lexer.cc"
yy1700:
	yych = *++cur;
	if (yych == '_') goto yy1759;
	goto yy1455;
yy1701:
	yych = *++cur;
	if (yych == 'n') goto yy1760;
	goto yy1455;
yy1702:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1703;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy1762;
		if (yych <= '`') goto yy1703;
		if (yych <= 'z') goto yy1454;
	}
yy1703:
#line 618 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cgoto); }
#line 8895 "src/parse/conf_lexer.cc"
yy1704:
	yych = *++cur;
	if (yych == 'q') goto yy1763;
	goto yy1455;
yy1705:
	yych = *++cur;
	if (yych == 'e') goto yy1765;
	if (yych == 't') goto yy1767;
	goto yy1455;
yy1706:
	yych = *++cur;
	if (yych == 'e') goto yy1769;
	if (yych == 't') goto yy1771;
	goto yy1455;
yy1707:
	yych = *++cur;
	if (yych == 'e') goto yy1773;
	goto yy1455;
yy1708:
	yych = *++cur;
	if (yych == '_') goto yy1775;
	goto yy1455;
yy1709:
	yych = *++cur;
	if (yych == 'n') goto yy1776;
	goto yy1455;
yy1710:
	yych = *++cur;
	if (yych == 'e') goto yy1777;
	goto yy1455;
yy1711:
	yych = *++cur;
	if (yych == 'r') goto yy1778;
	goto yy1455;
yy1712:
	yych = *++cur;
	if (yych == 'l') goto yy1779;
	goto yy1455;
yy1713:
	yych = *++cur;
	if (yych == 'l') goto yy1781;
	goto yy1455;
yy1714:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1715;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1715;
		if (yych <= 'z') goto yy1454;
	}
yy1715:
#line 623 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndef); }
#line 8950 "src/parse/conf_lexer.cc"
yy1716:
	yych = *++cur;
	if (yych == 'e') goto yy1783;
	goto yy1455;
yy1717:
	yych = *++cur;
	if (yych == 'i') goto yy1784;
	goto yy1455;
yy1718:
	yych = *++cur;
	if (yych == 's') goto yy1785;
	goto yy1455;
yy1719:
	yych = *++cur;
	if (yych == 'h') goto yy1786;
	goto yy1455;
yy1720:
	yych = *++cur;
	if (yych == 'a') goto yy1788;
	goto yy1455;
yy1721:
	yych = *++cur;
	if (yych <= 't') {
		if (yych == 'i') goto yy1789;
		goto yy1455;
	} else {
		if (yych <= 'u') goto yy1790;
		if (yych == 'y') goto yy1791;
		goto yy1455;
	}
yy1722:
	yych = *++cur;
	if (yych == 'l') goto yy1792;
	goto yy1455;
yy1723:
	yych = *++cur;
	if (yych == 'o') goto yy1793;
	goto yy1455;
yy1724:
	yych = *++cur;
	if (yych == 'k') goto yy1794;
	goto yy1455;
yy1725:
	yych = *++cur;
	if (yych == 'f') goto yy1795;
	if (yych == 'm') goto yy1796;
	goto yy1455;
yy1726:
	yych = *++cur;
	if (yych == 'y') goto yy1797;
	goto yy1455;
yy1727:
	yych = *++cur;
	if (yych == 'u') goto yy1798;
	goto yy1455;
yy1728:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1799;
		goto yy1455;
	} else {
		if (yych <= 'c') goto yy1800;
		if (yych == 's') goto yy1801;
		goto yy1455;
	}
yy1729:
	yych = *++cur;
	if (yych == 's') goto yy1802;
	goto yy1455;
yy1730:
	yych = *++cur;
	if (yych == 'g') goto yy1803;
	goto yy1455;
yy1731:
	yych = *++cur;
	if (yych == 'k') goto yy1804;
	goto yy1455;
yy1732:
	yych = *++cur;
	if (yych == 't') goto yy1806;
	goto yy1455;
yy1733:
	yych = *++cur;
	if (yych <= 'b') {
		if (yych == 'a') goto yy1807;
		goto yy1455;
	} else {
		if (yych <= 'c') goto yy1808;
		if (yych == 's') goto yy1809;
		goto yy1455;
	}
yy1734:
	yych = *++cur;
	if (yych == 'f') goto yy1810;
	goto yy1455;
yy1735:
	yych = *++cur;
	if (yych == 'p') goto yy1811;
	goto yy1455;
yy1736:
	yych = *++cur;
	if (yych == 'g') goto yy1813;
	goto yy1455;
yy1737:
	yych = *++cur;
	if (yych == 'g') goto yy1814;
	goto yy1455;
yy1738:
	yych = *++cur;
	if (yych == 'c') goto yy1815;
	goto yy1157;
yy1739:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 774 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_RECORD); }
#line 9067 "src/parse/conf_lexer.cc"
yy1740:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 772 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_SIMPLE); }
#line 9073 "src/parse/conf_lexer.cc"
yy1741:
	yych = *++cur;
	if (yych == 'f') goto yy1816;
	goto yy1157;
yy1742:
	yych = *++cur;
	if (yych == 's') goto yy1817;
	goto yy1157;
yy1743:
	yych = *++cur;
	if (yych == 't') goto yy1818;
	goto yy1157;
yy1744:
	yych = *++cur;
	if (yych == 'a') goto yy1819;
	goto yy1157;
yy1745:
	yych = *++cur;
	if (yych == '.') goto yy1820;
	goto yy1157;
yy1746:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 784 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::LOOP_LABEL); }
#line 9099 "src/parse/conf_lexer.cc"
yy1747:
	yych = *++cur;
	if (yych == 'i') goto yy1821;
	goto yy1157;
yy1748:
	yych = *++cur;
	if (yych == 't') goto yy1822;
	goto yy1157;
yy1749:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 786 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::FN_THROW); }
#line 9113 "src/parse/conf_lexer.cc"
yy1750:
	++cur;
#line 750 "../src/parse/conf_lexer.re"
	{ RET_TOK(CONF_UD); }
#line 9118 "src/parse/conf_lexer.cc"
yy1751:
	++cur;
#line 710 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::BACKUPCTX); }
#line 9123 "src/parse/conf_lexer.cc"
yy1752:
	++cur;
#line 716 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::CTXMARKER); }
#line 9128 "src/parse/conf_lexer.cc"
yy1753:
	++cur;
#line 719 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::GETACCEPT); }
#line 9133 "src/parse/conf_lexer.cc"
yy1754:
	yych = *++cur;
	if (yych == 'X') goto yy1823;
	goto yy1172;
yy1755:
	yych = *++cur;
	if (yych == 'G') goto yy1824;
	goto yy1172;
yy1756:
	++cur;
#line 733 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SETACCEPT); }
#line 9146 "src/parse/conf_lexer.cc"
yy1757:
	++cur;
#line 737 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTMTAG); }
#line 9151 "src/parse/conf_lexer.cc"
yy1758:
	++cur;
#line 738 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::SHIFTSTAG); }
#line 9156 "src/parse/conf_lexer.cc"
yy1759:
	yych = *++cur;
	if (yych <= 'f') {
		if (yych == 'e') goto yy1825;
		goto yy1455;
	} else {
		if (yych <= 'g') goto yy1826;
		if (yych == 'l') goto yy1827;
		goto yy1455;
	}
yy1760:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1761;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1761;
		if (yych <= 'z') goto yy1454;
	}
yy1761:
#line 601 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_assign); }
#line 9179 "src/parse/conf_lexer.cc"
yy1762:
	yych = *++cur;
	if (yych == 'd') goto yy1828;
	goto yy1455;
yy1763:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1764;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1764;
		if (yych <= 'z') goto yy1454;
	}
yy1764:
#line 602 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_eq); }
#line 9196 "src/parse/conf_lexer.cc"
yy1765:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1766;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1766;
		if (yych <= 'z') goto yy1454;
	}
yy1766:
#line 607 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ge); }
#line 9209 "src/parse/conf_lexer.cc"
yy1767:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1768;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1768;
		if (yych <= 'z') goto yy1454;
	}
yy1768:
#line 605 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_gt); }
#line 9222 "src/parse/conf_lexer.cc"
yy1769:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1770;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1770;
		if (yych <= 'z') goto yy1454;
	}
yy1770:
#line 606 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_le); }
#line 9235 "src/parse/conf_lexer.cc"
yy1771:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1772;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1772;
		if (yych <= 'z') goto yy1454;
	}
yy1772:
#line 604 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_lt); }
#line 9248 "src/parse/conf_lexer.cc"
yy1773:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1774;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1774;
		if (yych <= 'z') goto yy1454;
	}
yy1774:
#line 603 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cmp_ne); }
#line 9261 "src/parse/conf_lexer.cc"
yy1775:
	yych = *++cur;
	if (yych == 'g') goto yy1829;
	if (yych == 'l') goto yy1830;
	goto yy1455;
yy1776:
	yych = *++cur;
	if (yych == 'u') goto yy1831;
	goto yy1455;
yy1777:
	yych = *++cur;
	if (yych == 'l') goto yy1832;
	goto yy1455;
yy1778:
	yych = *++cur;
	if (yych == 'p') goto yy1833;
	goto yy1455;
yy1779:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1780;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1780;
		if (yych <= 'z') goto yy1454;
	}
yy1780:
#line 624 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fncall); }
#line 9291 "src/parse/conf_lexer.cc"
yy1781:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1782;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1782;
		if (yych <= 'z') goto yy1454;
	}
yy1782:
#line 622 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fndecl); }
#line 9304 "src/parse/conf_lexer.cc"
yy1783:
	yych = *++cur;
	if (yych == 'n') goto yy1834;
	goto yy1455;
yy1784:
	yych = *++cur;
	if (yych == 'n') goto yy1835;
	goto yy1455;
yy1785:
	yych = *++cur;
	if (yych == 'i') goto yy1836;
	goto yy1455;
yy1786:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1787;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy1837;
		if (yych <= '`') goto yy1787;
		if (yych <= 'z') goto yy1454;
	}
yy1787:
#line 610 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch); }
#line 9330 "src/parse/conf_lexer.cc"
yy1788:
	yych = *++cur;
	if (yych == 'l') goto yy1838;
	goto yy1455;
yy1789:
	yych = *++cur;
	if (yych == 'n') goto yy1839;
	goto yy1455;
yy1790:
	yych = *++cur;
	if (yych == 'i') goto yy1840;
	goto yy1455;
yy1791:
	yych = *++cur;
	if (yych == 'y') goto yy1841;
	goto yy1455;
yy1792:
	yych = *++cur;
	if (yych == 'o') goto yy1842;
	goto yy1455;
yy1793:
	yych = *++cur;
	if (yych == 'c') goto yy1843;
	goto yy1455;
yy1794:
	yych = *++cur;
	if (yych == 'u') goto yy1844;
	goto yy1455;
yy1795:
	yych = *++cur;
	if (yych == 'i') goto yy1845;
	goto yy1455;
yy1796:
	yych = *++cur;
	if (yych == 'a') goto yy1846;
	goto yy1455;
yy1797:
	yych = *++cur;
	if (yych == 'm') goto yy1847;
	if (yych == 's') goto yy1848;
	goto yy1455;
yy1798:
	yych = *++cur;
	if (yych == 'g') goto yy1849;
	goto yy1455;
yy1799:
	yych = *++cur;
	if (yych == 'c') goto yy1851;
	goto yy1455;
yy1800:
	yych = *++cur;
	if (yych == 'o') goto yy1852;
	goto yy1455;
yy1801:
	yych = *++cur;
	if (yych == 't') goto yy1853;
	goto yy1455;
yy1802:
	yych = *++cur;
	if (yych == 't') goto yy1854;
	goto yy1455;
yy1803:
	yych = *++cur;
	if (yych == 'n') goto yy1855;
	if (yych == 'p') goto yy1857;
	goto yy1455;
yy1804:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1805;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy1859;
		if (yych <= '`') goto yy1805;
		if (yych <= 'z') goto yy1454;
	}
yy1805:
#line 631 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek); }
#line 9410 "src/parse/conf_lexer.cc"
yy1806:
	yych = *++cur;
	if (yych == 'o') goto yy1860;
	goto yy1455;
yy1807:
	yych = *++cur;
	if (yych == 'c') goto yy1861;
	goto yy1455;
yy1808:
	yych = *++cur;
	if (yych == 'o') goto yy1862;
	goto yy1455;
yy1809:
	yych = *++cur;
	if (yych == 't') goto yy1863;
	goto yy1455;
yy1810:
	yych = *++cur;
	if (yych == 't') goto yy1864;
	goto yy1455;
yy1811:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1812;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy1865;
		if (yych <= '`') goto yy1812;
		if (yych <= 'z') goto yy1454;
	}
yy1812:
#line 632 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip); }
#line 9444 "src/parse/conf_lexer.cc"
yy1813:
	yych = *++cur;
	if (yych == 'n') goto yy1866;
	if (yych == 'p') goto yy1868;
	goto yy1455;
yy1814:
	yych = *++cur;
	if (yych == 'e') goto yy1870;
	goto yy1455;
yy1815:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 773 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_GENERIC); }
#line 9459 "src/parse/conf_lexer.cc"
yy1816:
	yych = *++cur;
	if (yych == 'r') goto yy1871;
	if (yych == 'u') goto yy1872;
	goto yy1157;
yy1817:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 781 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::CASE_RANGES); }
#line 9470 "src/parse/conf_lexer.cc"
yy1818:
	yych = *++cur;
	if (yych == 'i') goto yy1873;
	goto yy1157;
yy1819:
	yych = *++cur;
	if (yych == 'l') goto yy1874;
	goto yy1157;
yy1820:
	yych = *++cur;
	if (yych <= 'k') {
		if (yych == 'g') goto yy1875;
		goto yy1157;
	} else {
		if (yych <= 'l') goto yy1876;
		if (yych == 'r') goto yy1877;
		goto yy1157;
	}
yy1821:
	yych = *++cur;
	if (yych == 't') goto yy1878;
	goto yy1157;
yy1822:
	yych = *++cur;
	if (yych == 'a') goto yy1879;
	goto yy1157;
yy1823:
	++cur;
#line 731 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORECTX); }
#line 9501 "src/parse/conf_lexer.cc"
yy1824:
	++cur;
#line 732 "../src/parse/conf_lexer.re"
	{ RET_VAR(StxVarId::RESTORETAG); }
#line 9506 "src/parse/conf_lexer.cc"
yy1825:
	yych = *++cur;
	if (yych == 'l') goto yy1880;
	goto yy1455;
yy1826:
	yych = *++cur;
	if (yych == 'l') goto yy1881;
	goto yy1455;
yy1827:
	yych = *++cur;
	if (yych == 'o') goto yy1882;
	goto yy1455;
yy1828:
	yych = *++cur;
	if (yych == 'a') goto yy1883;
	goto yy1455;
yy1829:
	yych = *++cur;
	if (yych == 'l') goto yy1884;
	goto yy1455;
yy1830:
	yych = *++cur;
	if (yych == 'o') goto yy1885;
	goto yy1455;
yy1831:
	yych = *++cur;
	if (yych == 'e') goto yy1886;
	goto yy1455;
yy1832:
	yych = *++cur;
	if (yych == 'e') goto yy1888;
	goto yy1455;
yy1833:
	yych = *++cur;
	if (yych == 'r') goto yy1889;
	goto yy1455;
yy1834:
	yych = *++cur;
	if (yych == '_') goto yy1890;
	goto yy1455;
yy1835:
	yych = *++cur;
	if (yych == 'f') goto yy1891;
	goto yy1455;
yy1836:
	yych = *++cur;
	if (yych == 'v') goto yy1892;
	goto yy1455;
yy1837:
	yych = *++cur;
	if (yych == 'c') goto yy1893;
	goto yy1455;
yy1838:
	yych = *++cur;
	if (yych == 'l') goto yy1894;
	goto yy1455;
yy1839:
	yych = *++cur;
	if (yych == 't') goto yy1896;
	goto yy1455;
yy1840:
	yych = *++cur;
	if (yych == 'n') goto yy1898;
	goto yy1455;
yy1841:
	yych = *++cur;
	if (yych <= 'c') {
		if (yych <= 'a') goto yy1455;
		if (yych <= 'b') goto yy1899;
		goto yy1900;
	} else {
		if (yych == 't') goto yy1901;
		goto yy1455;
	}
yy1842:
	yych = *++cur;
	if (yych == 'b') goto yy1902;
	goto yy1455;
yy1843:
	yych = *++cur;
	if (yych == 'a') goto yy1903;
	goto yy1455;
yy1844:
	yych = *++cur;
	if (yych == 'p') goto yy1904;
	goto yy1455;
yy1845:
	yych = *++cur;
	if (yych == 'l') goto yy1906;
	goto yy1455;
yy1846:
	yych = *++cur;
	if (yych == 't') goto yy1907;
	goto yy1455;
yy1847:
	yych = *++cur;
	if (yych == 't') goto yy1908;
	goto yy1455;
yy1848:
	yych = *++cur;
	if (yych == 't') goto yy1909;
	goto yy1455;
yy1849:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1850;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1850;
		if (yych <= 'z') goto yy1454;
	}
yy1850:
#line 630 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yydebug); }
#line 9621 "src/parse/conf_lexer.cc"
yy1851:
	yych = *++cur;
	if (yych == 'c') goto yy1910;
	goto yy1455;
yy1852:
	yych = *++cur;
	if (yych == 'n') goto yy1911;
	goto yy1455;
yy1853:
	yych = *++cur;
	if (yych == 'a') goto yy1912;
	goto yy1455;
yy1854:
	yych = *++cur;
	if (yych == 'h') goto yy1913;
	goto yy1455;
yy1855:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1856;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1856;
		if (yych <= 'z') goto yy1454;
	}
yy1856:
#line 642 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagn); }
#line 9650 "src/parse/conf_lexer.cc"
yy1857:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1858;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1858;
		if (yych <= 'z') goto yy1454;
	}
yy1858:
#line 644 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yymtagp); }
#line 9663 "src/parse/conf_lexer.cc"
yy1859:
	yych = *++cur;
	if (yych == 'y') goto yy1914;
	goto yy1455;
yy1860:
	yych = *++cur;
	if (yych == 'r') goto yy1915;
	goto yy1455;
yy1861:
	yych = *++cur;
	if (yych == 'c') goto yy1916;
	goto yy1455;
yy1862:
	yych = *++cur;
	if (yych == 'n') goto yy1917;
	goto yy1455;
yy1863:
	yych = *++cur;
	if (yych == 'a') goto yy1918;
	goto yy1455;
yy1864:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1454;
		} else {
			if (yych == '_') goto yy1454;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'm') goto yy1919;
			goto yy1454;
		} else {
			if (yych <= 's') goto yy1920;
			if (yych <= 'z') goto yy1454;
		}
	}
#line 638 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshift); }
#line 9703 "src/parse/conf_lexer.cc"
yy1865:
	yych = *++cur;
	if (yych == 'y') goto yy1921;
	goto yy1455;
yy1866:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1867;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1867;
		if (yych <= 'z') goto yy1454;
	}
yy1867:
#line 641 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagn); }
#line 9720 "src/parse/conf_lexer.cc"
yy1868:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1869;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1869;
		if (yych <= 'z') goto yy1454;
	}
yy1869:
#line 643 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yystagp); }
#line 9733 "src/parse/conf_lexer.cc"
yy1870:
	yych = *++cur;
	if (yych == 't') goto yy1922;
	goto yy1455;
yy1871:
	yych = *++cur;
	if (yych == 'e') goto yy1923;
	goto yy1157;
yy1872:
	yych = *++cur;
	if (yych == 'n') goto yy1924;
	goto yy1157;
yy1873:
	yych = *++cur;
	if (yych == 'v') goto yy1925;
	goto yy1157;
yy1874:
	yych = *++cur;
	if (yych == 's') goto yy1926;
	goto yy1157;
yy1875:
	yych = *++cur;
	if (yych == 'o') goto yy1927;
	goto yy1157;
yy1876:
	yych = *++cur;
	if (yych == 'o') goto yy1928;
	goto yy1157;
yy1877:
	yych = *++cur;
	if (yych == 'e') goto yy1929;
	goto yy1157;
yy1878:
	yych = *++cur;
	if (yych == 'i') goto yy1930;
	goto yy1157;
yy1879:
	yych = *++cur;
	if (yych == 't') goto yy1931;
	goto yy1157;
yy1880:
	yych = *++cur;
	if (yych == 'e') goto yy1932;
	goto yy1455;
yy1881:
	yych = *++cur;
	if (yych == 'o') goto yy1933;
	goto yy1455;
yy1882:
	yych = *++cur;
	if (yych == 'c') goto yy1934;
	goto yy1455;
yy1883:
	yych = *++cur;
	if (yych == 't') goto yy1935;
	goto yy1455;
yy1884:
	yych = *++cur;
	if (yych == 'o') goto yy1936;
	goto yy1455;
yy1885:
	yych = *++cur;
	if (yych == 'c') goto yy1937;
	goto yy1455;
yy1886:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1887;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1887;
		if (yych <= 'z') goto yy1454;
	}
yy1887:
#line 616 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_continue); }
#line 9810 "src/parse/conf_lexer.cc"
yy1888:
	yych = *++cur;
	if (yych == 'm') goto yy1938;
	goto yy1455;
yy1889:
	yych = *++cur;
	if (yych == 'i') goto yy1940;
	goto yy1455;
yy1890:
	yych = *++cur;
	if (yych == 'e') goto yy1941;
	goto yy1455;
yy1891:
	yych = *++cur;
	if (yych == 'o') goto yy1942;
	goto yy1455;
yy1892:
	yych = *++cur;
	if (yych == 'e') goto yy1944;
	goto yy1455;
yy1893:
	yych = *++cur;
	if (yych == 'a') goto yy1945;
	goto yy1455;
yy1894:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1895;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1895;
		if (yych <= 'z') goto yy1454;
	}
yy1895:
#line 625 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_tailcall); }
#line 9847 "src/parse/conf_lexer.cc"
yy1896:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1897;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1897;
		if (yych <= 'z') goto yy1454;
	}
yy1897:
#line 596 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_int); }
#line 9860 "src/parse/conf_lexer.cc"
yy1898:
	yych = *++cur;
	if (yych == 't') goto yy1946;
	goto yy1455;
yy1899:
	yych = *++cur;
	if (yych == 'm') goto yy1948;
	goto yy1455;
yy1900:
	yych = *++cur;
	if (yych == 't') goto yy1950;
	goto yy1455;
yy1901:
	yych = *++cur;
	if (yych == 'a') goto yy1951;
	goto yy1455;
yy1902:
	yych = *++cur;
	if (yych == 'a') goto yy1952;
	goto yy1455;
yy1903:
	yych = *++cur;
	if (yych == 'l') goto yy1953;
	goto yy1455;
yy1904:
	yych = *++cur;
	if (yych <= '_') {
		if (yych <= '/') goto yy1905;
		if (yych <= '9') goto yy1454;
		if (yych >= '_') goto yy1955;
	} else {
		if (yych <= 'b') {
			if (yych >= 'a') goto yy1454;
		} else {
			if (yych <= 'c') goto yy1956;
			if (yych <= 'z') goto yy1454;
		}
	}
yy1905:
#line 633 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup); }
#line 9902 "src/parse/conf_lexer.cc"
yy1906:
	yych = *++cur;
	if (yych == 't') goto yy1957;
	goto yy1455;
yy1907:
	yych = *++cur;
	if (yych == 'c') goto yy1958;
	goto yy1455;
yy1908:
	yych = *++cur;
	if (yych == 'a') goto yy1959;
	goto yy1455;
yy1909:
	yych = *++cur;
	if (yych == 'a') goto yy1960;
	goto yy1455;
yy1910:
	yych = *++cur;
	if (yych == 'e') goto yy1961;
	goto yy1455;
yy1911:
	yych = *++cur;
	if (yych == 'd') goto yy1962;
	goto yy1455;
yy1912:
	yych = *++cur;
	if (yych == 't') goto yy1964;
	goto yy1455;
yy1913:
	yych = *++cur;
	if (yych == 'a') goto yy1965;
	goto yy1455;
yy1914:
	yych = *++cur;
	if (yych == 'y') goto yy1966;
	goto yy1455;
yy1915:
	yych = *++cur;
	if (yych == 'e') goto yy1967;
	goto yy1455;
yy1916:
	yych = *++cur;
	if (yych == 'e') goto yy1968;
	goto yy1455;
yy1917:
	yych = *++cur;
	if (yych == 'd') goto yy1969;
	goto yy1455;
yy1918:
	yych = *++cur;
	if (yych == 't') goto yy1971;
	goto yy1455;
yy1919:
	yych = *++cur;
	if (yych == 't') goto yy1972;
	goto yy1455;
yy1920:
	yych = *++cur;
	if (yych == 't') goto yy1973;
	goto yy1455;
yy1921:
	yych = *++cur;
	if (yych == 'y') goto yy1974;
	goto yy1455;
yy1922:
	yych = *++cur;
	if (yych == '_') goto yy1975;
	goto yy1455;
yy1923:
	yych = *++cur;
	if (yych == 'e') goto yy1976;
	goto yy1157;
yy1924:
	yych = *++cur;
	if (yych == 'c') goto yy1977;
	goto yy1157;
yy1925:
	yych = *++cur;
	if (yych == 'e') goto yy1978;
	goto yy1157;
yy1926:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 793 "../src/parse/conf_lexer.re"
	{ RET_LOPT(StxLOpt::CHAR_LITERALS); }
#line 9988 "src/parse/conf_lexer.cc"
yy1927:
	yych = *++cur;
	if (yych == 't') goto yy1979;
	goto yy1157;
yy1928:
	yych = *++cur;
	if (yych == 'o') goto yy1980;
	goto yy1157;
yy1929:
	yych = *++cur;
	if (yych == 'c') goto yy1981;
	goto yy1157;
yy1930:
	yych = *++cur;
	if (yych == 'o') goto yy1982;
	goto yy1157;
yy1931:
	yych = *++cur;
	if (yych == 'e') goto yy1983;
	goto yy1157;
yy1932:
	yych = *++cur;
	if (yych == 'm') goto yy1984;
	goto yy1455;
yy1933:
	yych = *++cur;
	if (yych == 'b') goto yy1986;
	goto yy1455;
yy1934:
	yych = *++cur;
	if (yych == 'a') goto yy1987;
	goto yy1455;
yy1935:
	yych = *++cur;
	if (yych == 'a') goto yy1988;
	goto yy1455;
yy1936:
	yych = *++cur;
	if (yych == 'b') goto yy1990;
	goto yy1455;
yy1937:
	yych = *++cur;
	if (yych == 'a') goto yy1991;
	goto yy1455;
yy1938:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1939;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1939;
		if (yych <= 'z') goto yy1454;
	}
yy1939:
#line 621 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_enum_elem); }
#line 10045 "src/parse/conf_lexer.cc"
yy1940:
	yych = *++cur;
	if (yych == 'n') goto yy1992;
	goto yy1455;
yy1941:
	yych = *++cur;
	if (yych == 'l') goto yy1993;
	goto yy1455;
yy1942:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1943;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1943;
		if (yych <= 'z') goto yy1454;
	}
yy1943:
#line 628 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_line_info); }
#line 10066 "src/parse/conf_lexer.cc"
yy1944:
	yych = *++cur;
	if (yych == '_') goto yy1994;
	goto yy1455;
yy1945:
	yych = *++cur;
	if (yych == 's') goto yy1995;
	goto yy1455;
yy1946:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1947;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1947;
		if (yych <= 'z') goto yy1454;
	}
yy1947:
#line 597 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_uint); }
#line 10087 "src/parse/conf_lexer.cc"
yy1948:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1949;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1949;
		if (yych <= 'z') goto yy1454;
	}
yy1949:
#line 598 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yybm); }
#line 10100 "src/parse/conf_lexer.cc"
yy1950:
	yych = *++cur;
	if (yych == 'a') goto yy1996;
	goto yy1455;
yy1951:
	yych = *++cur;
	if (yych == 'r') goto yy1997;
	goto yy1455;
yy1952:
	yych = *++cur;
	if (yych == 'l') goto yy1998;
	goto yy1455;
yy1953:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1954;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1954;
		if (yych <= 'z') goto yy1454;
	}
yy1954:
#line 589 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_local); }
#line 10125 "src/parse/conf_lexer.cc"
yy1955:
	yych = *++cur;
	if (yych == 'y') goto yy2000;
	goto yy1455;
yy1956:
	yych = *++cur;
	if (yych == 't') goto yy2001;
	goto yy1455;
yy1957:
	yych = *++cur;
	if (yych == 'e') goto yy2002;
	goto yy1455;
yy1958:
	yych = *++cur;
	if (yych == 'h') goto yy2003;
	goto yy1455;
yy1959:
	yych = *++cur;
	if (yych == 'g') goto yy2005;
	goto yy1455;
yy1960:
	yych = *++cur;
	if (yych == 'g') goto yy2007;
	goto yy1455;
yy1961:
	yych = *++cur;
	if (yych == 'p') goto yy2009;
	goto yy1455;
yy1962:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1963;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1963;
		if (yych <= 'z') goto yy1454;
	}
yy1963:
#line 656 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetcond); }
#line 10166 "src/parse/conf_lexer.cc"
yy1964:
	yych = *++cur;
	if (yych == 'e') goto yy2010;
	goto yy1455;
yy1965:
	yych = *++cur;
	if (yych == 'n') goto yy2012;
	goto yy1455;
yy1966:
	yych = *++cur;
	if (yych == 's') goto yy2014;
	goto yy1455;
yy1967:
	yych = *++cur;
	if (yych <= '`') {
		if (yych <= '9') {
			if (yych >= '0') goto yy1454;
		} else {
			if (yych == '_') goto yy1454;
		}
	} else {
		if (yych <= 's') {
			if (yych == 'c') goto yy2015;
			goto yy1454;
		} else {
			if (yych <= 't') goto yy2016;
			if (yych <= 'z') goto yy1454;
		}
	}
#line 635 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestore); }
#line 10198 "src/parse/conf_lexer.cc"
yy1968:
	yych = *++cur;
	if (yych == 'p') goto yy2017;
	goto yy1455;
yy1969:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1970;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1970;
		if (yych <= 'z') goto yy1454;
	}
yy1970:
#line 657 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetcond); }
#line 10215 "src/parse/conf_lexer.cc"
yy1971:
	yych = *++cur;
	if (yych == 'e') goto yy2018;
	goto yy1455;
yy1972:
	yych = *++cur;
	if (yych == 'a') goto yy2020;
	goto yy1455;
yy1973:
	yych = *++cur;
	if (yych == 'a') goto yy2021;
	goto yy1455;
yy1974:
	yych = *++cur;
	if (yych == 'b') goto yy2022;
	if (yych == 'p') goto yy2023;
	goto yy1455;
yy1975:
	yych = *++cur;
	if (yych == 'f') goto yy2024;
	goto yy1455;
yy1976:
	yych = *++cur;
	if (yych == 'f') goto yy2025;
	goto yy1157;
yy1977:
	yych = *++cur;
	if (yych == 't') goto yy2026;
	goto yy1157;
yy1978:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 785 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::CGOTO_RELATIVE); }
#line 10250 "src/parse/conf_lexer.cc"
yy1979:
	yych = *++cur;
	if (yych == 'o') goto yy2027;
	goto yy1157;
yy1980:
	yych = *++cur;
	if (yych == 'p') goto yy2028;
	goto yy1157;
yy1981:
	yych = *++cur;
	if (yych == 'u') goto yy2029;
	goto yy1157;
yy1982:
	yych = *++cur;
	if (yych == 'n') goto yy2030;
	goto yy1157;
yy1983:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 778 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::STORABLE_STATE); }
#line 10272 "src/parse/conf_lexer.cc"
yy1984:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1985;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1985;
		if (yych <= 'z') goto yy1454;
	}
yy1985:
#line 595 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_elem); }
#line 10285 "src/parse/conf_lexer.cc"
yy1986:
	yych = *++cur;
	if (yych == 'a') goto yy2031;
	goto yy1455;
yy1987:
	yych = *++cur;
	if (yych == 'l') goto yy2032;
	goto yy1455;
yy1988:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1989;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1989;
		if (yych <= 'z') goto yy1454;
	}
yy1989:
#line 619 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_cgoto_data); }
#line 10306 "src/parse/conf_lexer.cc"
yy1990:
	yych = *++cur;
	if (yych == 'a') goto yy2034;
	goto yy1455;
yy1991:
	yych = *++cur;
	if (yych == 'l') goto yy2035;
	goto yy1455;
yy1992:
	yych = *++cur;
	if (yych == 't') goto yy2037;
	goto yy1455;
yy1993:
	yych = *++cur;
	if (yych == 's') goto yy2039;
	goto yy1455;
yy1994:
	yych = *++cur;
	if (yych == 'f') goto yy2040;
	goto yy1455;
yy1995:
	yych = *++cur;
	if (yych == 'e') goto yy2041;
	goto yy1455;
yy1996:
	yych = *++cur;
	if (yych == 'b') goto yy2042;
	goto yy1455;
yy1997:
	yych = *++cur;
	if (yych == 'g') goto yy2043;
	goto yy1455;
yy1998:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy1999;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy1999;
		if (yych <= 'z') goto yy1454;
	}
yy1999:
#line 590 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_var_global); }
#line 10351 "src/parse/conf_lexer.cc"
yy2000:
	yych = *++cur;
	if (yych == 'y') goto yy2044;
	goto yy1455;
yy2001:
	yych = *++cur;
	if (yych == 'x') goto yy2045;
	goto yy1455;
yy2002:
	yych = *++cur;
	if (yych == 'r') goto yy2047;
	goto yy1455;
yy2003:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2004;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2004;
		if (yych <= 'z') goto yy1454;
	}
yy2004:
#line 662 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_match); }
#line 10376 "src/parse/conf_lexer.cc"
yy2005:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2006;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2006;
		if (yych <= 'z') goto yy1454;
	}
yy2006:
#line 645 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopymtag); }
#line 10389 "src/parse/conf_lexer.cc"
yy2007:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2008;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2008;
		if (yych <= 'z') goto yy1454;
	}
yy2008:
#line 646 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yycopystag); }
#line 10402 "src/parse/conf_lexer.cc"
yy2009:
	yych = *++cur;
	if (yych == 't') goto yy2049;
	goto yy1455;
yy2010:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2011;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2011;
		if (yych <= 'z') goto yy1454;
	}
yy2011:
#line 658 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetstate); }
#line 10419 "src/parse/conf_lexer.cc"
yy2012:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2013;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2013;
		if (yych <= 'z') goto yy1454;
	}
yy2013:
#line 660 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yylessthan); }
#line 10432 "src/parse/conf_lexer.cc"
yy2014:
	yych = *++cur;
	if (yych == 'k') goto yy2051;
	goto yy1455;
yy2015:
	yych = *++cur;
	if (yych == 't') goto yy2052;
	goto yy1455;
yy2016:
	yych = *++cur;
	if (yych == 'a') goto yy2053;
	goto yy1455;
yy2017:
	yych = *++cur;
	if (yych == 't') goto yy2054;
	goto yy1455;
yy2018:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2019;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2019;
		if (yych <= 'z') goto yy1454;
	}
yy2019:
#line 659 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetstate); }
#line 10461 "src/parse/conf_lexer.cc"
yy2020:
	yych = *++cur;
	if (yych == 'g') goto yy2056;
	goto yy1455;
yy2021:
	yych = *++cur;
	if (yych == 'g') goto yy2058;
	goto yy1455;
yy2022:
	yych = *++cur;
	if (yych == 'a') goto yy2060;
	goto yy1455;
yy2023:
	yych = *++cur;
	if (yych == 'e') goto yy2061;
	goto yy1455;
yy2024:
	yych = *++cur;
	if (yych == 'i') goto yy2062;
	goto yy1455;
yy2025:
	yych = *++cur;
	if (yych == 'o') goto yy2063;
	goto yy1157;
yy2026:
	yych = *++cur;
	if (yych == 'i') goto yy2064;
	goto yy1157;
yy2027:
	yych = *++cur;
	if (yych == '_') goto yy2065;
	goto yy1157;
yy2028:
	yych = *++cur;
	if (yych == '_') goto yy2066;
	goto yy1157;
yy2029:
	yych = *++cur;
	if (yych == 'r') goto yy2067;
	goto yy1157;
yy2030:
	yych = *++cur;
	if (yych == 's') goto yy2068;
	goto yy1157;
yy2031:
	yych = *++cur;
	if (yych == 'l') goto yy2069;
	goto yy1455;
yy2032:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2033;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2033;
		if (yych <= 'z') goto yy1454;
	}
yy2033:
#line 593 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_local); }
#line 10522 "src/parse/conf_lexer.cc"
yy2034:
	yych = *++cur;
	if (yych == 'l') goto yy2071;
	goto yy1455;
yy2035:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2036;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2036;
		if (yych <= 'z') goto yy1454;
	}
yy2036:
#line 591 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_local); }
#line 10539 "src/parse/conf_lexer.cc"
yy2037:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2038;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2038;
		if (yych <= 'z') goto yy1454;
	}
yy2038:
#line 627 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_fingerprint); }
#line 10552 "src/parse/conf_lexer.cc"
yy2039:
	yych = *++cur;
	if (yych == 'e') goto yy2073;
	goto yy1455;
yy2040:
	yych = *++cur;
	if (yych == 'u') goto yy2075;
	goto yy1455;
yy2041:
	yych = *++cur;
	if (yych == '_') goto yy2076;
	if (yych == 's') goto yy2077;
	goto yy1455;
yy2042:
	yych = *++cur;
	if (yych == 'l') goto yy2079;
	goto yy1455;
yy2043:
	yych = *++cur;
	if (yych == 'e') goto yy2080;
	goto yy1455;
yy2044:
	yych = *++cur;
	if (yych == 'p') goto yy2081;
	if (yych == 's') goto yy2082;
	goto yy1455;
yy2045:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2046;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2046;
		if (yych <= 'z') goto yy1454;
	}
yy2046:
#line 634 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackupctx); }
#line 10591 "src/parse/conf_lexer.cc"
yy2047:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2048;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2048;
		if (yych <= 'z') goto yy1454;
	}
yy2048:
#line 661 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybm_filter); }
#line 10604 "src/parse/conf_lexer.cc"
yy2049:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2050;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2050;
		if (yych <= 'z') goto yy1454;
	}
yy2050:
#line 654 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yygetaccept); }
#line 10617 "src/parse/conf_lexer.cc"
yy2051:
	yych = *++cur;
	if (yych == 'i') goto yy2083;
	goto yy1455;
yy2052:
	yych = *++cur;
	if (yych == 'x') goto yy2084;
	goto yy1455;
yy2053:
	yych = *++cur;
	if (yych == 'g') goto yy2086;
	goto yy1455;
yy2054:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2055;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2055;
		if (yych <= 'z') goto yy1454;
	}
yy2055:
#line 655 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yysetaccept); }
#line 10642 "src/parse/conf_lexer.cc"
yy2056:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2057;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2057;
		if (yych <= 'z') goto yy1454;
	}
yy2057:
#line 639 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftmtag); }
#line 10655 "src/parse/conf_lexer.cc"
yy2058:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2059;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2059;
		if (yych <= 'z') goto yy1454;
	}
yy2059:
#line 640 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyshiftstag); }
#line 10668 "src/parse/conf_lexer.cc"
yy2060:
	yych = *++cur;
	if (yych == 'c') goto yy2088;
	goto yy1455;
yy2061:
	yych = *++cur;
	if (yych == 'e') goto yy2089;
	goto yy1455;
yy2062:
	yych = *++cur;
	if (yych == 'l') goto yy2090;
	goto yy1455;
yy2063:
	yych = *++cur;
	if (yych == 'r') goto yy2091;
	goto yy1157;
yy2064:
	yych = *++cur;
	if (yych == 'o') goto yy2092;
	goto yy1157;
yy2065:
	yych = *++cur;
	if (yych == 'l') goto yy2093;
	goto yy1157;
yy2066:
	yych = *++cur;
	if (yych == 's') goto yy2094;
	goto yy1157;
yy2067:
	yych = *++cur;
	if (yych == 's') goto yy2095;
	goto yy1157;
yy2068:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 777 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::START_CONDITIONS); }
#line 10706 "src/parse/conf_lexer.cc"
yy2069:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2070;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2070;
		if (yych <= 'z') goto yy1454;
	}
yy2070:
#line 594 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_array_global); }
#line 10719 "src/parse/conf_lexer.cc"
yy2071:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2072;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2072;
		if (yych <= 'z') goto yy1454;
	}
yy2072:
#line 592 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_const_global); }
#line 10732 "src/parse/conf_lexer.cc"
yy2073:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2074;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy2096;
		if (yych <= '`') goto yy2074;
		if (yych <= 'z') goto yy1454;
	}
yy2074:
#line 608 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else); }
#line 10746 "src/parse/conf_lexer.cc"
yy2075:
	yych = *++cur;
	if (yych == 'n') goto yy2097;
	goto yy1455;
yy2076:
	yych = *++cur;
	if (yych == 'd') goto yy2098;
	if (yych == 'r') goto yy2099;
	goto yy1455;
yy2077:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2078;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy2100;
		if (yych <= '`') goto yy2078;
		if (yych <= 'z') goto yy1454;
	}
yy2078:
#line 611 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases); }
#line 10769 "src/parse/conf_lexer.cc"
yy2079:
	yych = *++cur;
	if (yych == 'e') goto yy2101;
	goto yy1455;
yy2080:
	yych = *++cur;
	if (yych == 't') goto yy2103;
	goto yy1455;
yy2081:
	yych = *++cur;
	if (yych == 'e') goto yy2105;
	goto yy1455;
yy2082:
	yych = *++cur;
	if (yych == 'k') goto yy2106;
	goto yy1455;
yy2083:
	yych = *++cur;
	if (yych == 'p') goto yy2107;
	goto yy1455;
yy2084:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2085;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2085;
		if (yych <= 'z') goto yy1454;
	}
yy2085:
#line 636 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestorectx); }
#line 10802 "src/parse/conf_lexer.cc"
yy2086:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2087;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2087;
		if (yych <= 'z') goto yy1454;
	}
yy2087:
#line 637 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyrestoretag); }
#line 10815 "src/parse/conf_lexer.cc"
yy2088:
	yych = *++cur;
	if (yych == 'k') goto yy2109;
	goto yy1455;
yy2089:
	yych = *++cur;
	if (yych == 'k') goto yy2110;
	goto yy1455;
yy2090:
	yych = *++cur;
	if (yych == 't') goto yy2112;
	goto yy1455;
yy2091:
	yych = *++cur;
	if (yych == 'm') goto yy2113;
	goto yy1157;
yy2092:
	yych = *++cur;
	if (yych == 'n') goto yy2114;
	goto yy1157;
yy2093:
	yych = *++cur;
	if (yych == 'a') goto yy2115;
	goto yy1157;
yy2094:
	yych = *++cur;
	if (yych == 'w') goto yy2116;
	goto yy1157;
yy2095:
	yych = *++cur;
	if (yych == 'i') goto yy2117;
	goto yy1157;
yy2096:
	yych = *++cur;
	if (yych == 'o') goto yy2118;
	goto yy1455;
yy2097:
	yych = *++cur;
	if (yych == 'c') goto yy2119;
	goto yy1455;
yy2098:
	yych = *++cur;
	if (yych == 'e') goto yy2120;
	goto yy1455;
yy2099:
	yych = *++cur;
	if (yych == 'a') goto yy2121;
	goto yy1455;
yy2100:
	yych = *++cur;
	if (yych == 'o') goto yy2122;
	goto yy1455;
yy2101:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2102;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2102;
		if (yych <= 'z') goto yy1454;
	}
yy2102:
#line 600 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yyctable); }
#line 10880 "src/parse/conf_lexer.cc"
yy2103:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2104;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2104;
		if (yych <= 'z') goto yy1454;
	}
yy2104:
#line 599 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_type_yytarget); }
#line 10893 "src/parse/conf_lexer.cc"
yy2105:
	yych = *++cur;
	if (yych == 'e') goto yy2123;
	goto yy1455;
yy2106:
	yych = *++cur;
	if (yych == 'i') goto yy2124;
	goto yy1455;
yy2107:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2108;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2108;
		if (yych <= 'z') goto yy1454;
	}
yy2108:
#line 648 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yypeek_yyskip); }
#line 10914 "src/parse/conf_lexer.cc"
yy2109:
	yych = *++cur;
	if (yych == 'u') goto yy2125;
	goto yy1455;
yy2110:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2111;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2111;
		if (yych <= 'z') goto yy1454;
	}
yy2111:
#line 647 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yypeek); }
#line 10931 "src/parse/conf_lexer.cc"
yy2112:
	yych = *++cur;
	if (yych == 'e') goto yy2126;
	goto yy1455;
yy2113:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 776 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FREEFORM); }
#line 10941 "src/parse/conf_lexer.cc"
yy2114:
	yych = *++cur;
	if (yych == 's') goto yy2127;
	goto yy1157;
yy2115:
	yych = *++cur;
	if (yych == 'b') goto yy2128;
	goto yy1157;
yy2116:
	yych = *++cur;
	if (yych == 'i') goto yy2129;
	goto yy1157;
yy2117:
	yych = *++cur;
	if (yych == 'v') goto yy2130;
	goto yy1157;
yy2118:
	yych = *++cur;
	if (yych == 'n') goto yy2131;
	goto yy1455;
yy2119:
	yych = *++cur;
	if (yych == 't') goto yy2132;
	goto yy1455;
yy2120:
	yych = *++cur;
	if (yych == 'f') goto yy2133;
	goto yy1455;
yy2121:
	yych = *++cur;
	if (yych == 'n') goto yy2134;
	goto yy1455;
yy2122:
	yych = *++cur;
	if (yych == 'n') goto yy2135;
	goto yy1455;
yy2123:
	yych = *++cur;
	if (yych == 'k') goto yy2136;
	goto yy1455;
yy2124:
	yych = *++cur;
	if (yych == 'p') goto yy2138;
	goto yy1455;
yy2125:
	yych = *++cur;
	if (yych == 'p') goto yy2140;
	goto yy1455;
yy2126:
	yych = *++cur;
	if (yych == 'r') goto yy2142;
	goto yy1455;
yy2127:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 775 "../src/parse/conf_lexer.re"
	{ RET_GOPT(StxGOpt::API_STYLE_FUNCTIONS); }
#line 10999 "src/parse/conf_lexer.cc"
yy2128:
	yych = *++cur;
	if (yych == 'e') goto yy2144;
	goto yy1157;
yy2129:
	yych = *++cur;
	if (yych == 't') goto yy2145;
	goto yy1157;
yy2130:
	yych = *++cur;
	if (yych == 'e') goto yy2146;
	goto yy1157;
yy2131:
	yych = *++cur;
	if (yych == 'e') goto yy2147;
	goto yy1455;
yy2132:
	yych = *++cur;
	if (yych == 'i') goto yy2148;
	goto yy1455;
yy2133:
	yych = *++cur;
	if (yych == 'a') goto yy2149;
	goto yy1455;
yy2134:
	yych = *++cur;
	if (yych == 'g') goto yy2150;
	goto yy1455;
yy2135:
	yych = *++cur;
	if (yych == 'e') goto yy2151;
	goto yy1455;
yy2136:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2137;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy2152;
		if (yych <= '`') goto yy2137;
		if (yych <= 'z') goto yy1454;
	}
yy2137:
#line 651 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek); }
#line 11045 "src/parse/conf_lexer.cc"
yy2138:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2139;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2139;
		if (yych <= 'z') goto yy1454;
	}
yy2139:
#line 650 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yyskip); }
#line 11058 "src/parse/conf_lexer.cc"
yy2140:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2141;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych <= '_') goto yy2153;
		if (yych <= '`') goto yy2141;
		if (yych <= 'z') goto yy1454;
	}
yy2141:
#line 649 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup); }
#line 11072 "src/parse/conf_lexer.cc"
yy2142:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2143;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2143;
		if (yych <= 'z') goto yy1454;
	}
yy2143:
#line 663 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yytarget_filter); }
#line 11085 "src/parse/conf_lexer.cc"
yy2144:
	yych = *++cur;
	if (yych == 'l') goto yy2154;
	goto yy1157;
yy2145:
	yych = *++cur;
	if (yych == 'c') goto yy2155;
	goto yy1157;
yy2146:
	yych = *++cur;
	if (yych == '_') goto yy2156;
	goto yy1157;
yy2147:
	yych = *++cur;
	if (yych == 'l') goto yy2157;
	goto yy1455;
yy2148:
	yych = *++cur;
	if (yych == 'o') goto yy2158;
	goto yy1455;
yy2149:
	yych = *++cur;
	if (yych == 'u') goto yy2159;
	goto yy1455;
yy2150:
	yych = *++cur;
	if (yych == 'e') goto yy2160;
	goto yy1455;
yy2151:
	yych = *++cur;
	if (yych == 'l') goto yy2162;
	goto yy1455;
yy2152:
	yych = *++cur;
	if (yych == 'y') goto yy2163;
	goto yy1455;
yy2153:
	yych = *++cur;
	if (yych == 'y') goto yy2164;
	goto yy1455;
yy2154:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 760 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::GOTO_LABEL); }
#line 11131 "src/parse/conf_lexer.cc"
yy2155:
	yych = *++cur;
	if (yych == 'h') goto yy2165;
	goto yy1157;
yy2156:
	yych = *++cur;
	if (yych == 'f') goto yy2166;
	goto yy1157;
yy2157:
	yych = *++cur;
	if (yych == 'i') goto yy2167;
	goto yy1455;
yy2158:
	yych = *++cur;
	if (yych == 'n') goto yy2168;
	goto yy1455;
yy2159:
	yych = *++cur;
	if (yych == 'l') goto yy2169;
	goto yy1455;
yy2160:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2161;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2161;
		if (yych <= 'z') goto yy1454;
	}
yy2161:
#line 613 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_range); }
#line 11164 "src/parse/conf_lexer.cc"
yy2162:
	yych = *++cur;
	if (yych == 'i') goto yy2170;
	goto yy1455;
yy2163:
	yych = *++cur;
	if (yych == 'y') goto yy2171;
	goto yy1455;
yy2164:
	yych = *++cur;
	if (yych == 'y') goto yy2172;
	goto yy1455;
yy2165:
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 761 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::LOOP_SWITCH); }
#line 11182 "src/parse/conf_lexer.cc"
yy2166:
	yych = *++cur;
	if (yych == 'u') goto yy2173;
	goto yy1157;
yy2167:
	yych = *++cur;
	if (yych == 'n') goto yy2174;
	goto yy1455;
yy2168:
	yych = *++cur;
	if (yych == 's') goto yy2175;
	goto yy1455;
yy2169:
	yych = *++cur;
	if (yych == 't') goto yy2177;
	goto yy1455;
yy2170:
	yych = *++cur;
	if (yych == 'n') goto yy2179;
	goto yy1455;
yy2171:
	yych = *++cur;
	if (yych == 's') goto yy2180;
	goto yy1455;
yy2172:
	yych = *++cur;
	if (yych == 'p') goto yy2181;
	goto yy1455;
yy2173:
	yych = *++cur;
	if (yych == 'n') goto yy2182;
	goto yy1157;
yy2174:
	yych = *++cur;
	if (yych == 'e') goto yy2183;
	goto yy1455;
yy2175:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2176;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2176;
		if (yych <= 'z') goto yy1454;
	}
yy2176:
#line 626 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_recursive_functions); }
#line 11231 "src/parse/conf_lexer.cc"
yy2177:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2178;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2178;
		if (yych <= 'z') goto yy1454;
	}
yy2178:
#line 614 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_case_default); }
#line 11244 "src/parse/conf_lexer.cc"
yy2179:
	yych = *++cur;
	if (yych == 'e') goto yy2185;
	goto yy1455;
yy2180:
	yych = *++cur;
	if (yych == 'k') goto yy2187;
	goto yy1455;
yy2181:
	yych = *++cur;
	if (yych == 'e') goto yy2188;
	goto yy1455;
yy2182:
	yych = *++cur;
	if (yych == 'c') goto yy2189;
	goto yy1157;
yy2183:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2184;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2184;
		if (yych <= 'z') goto yy1454;
	}
yy2184:
#line 609 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_if_then_else_oneline); }
#line 11273 "src/parse/conf_lexer.cc"
yy2185:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2186;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2186;
		if (yych <= 'z') goto yy1454;
	}
yy2186:
#line 612 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_switch_cases_oneline); }
#line 11286 "src/parse/conf_lexer.cc"
yy2187:
	yych = *++cur;
	if (yych == 'i') goto yy2190;
	goto yy1455;
yy2188:
	yych = *++cur;
	if (yych == 'e') goto yy2191;
	goto yy1455;
yy2189:
	yych = *++cur;
	if (yych == 't') goto yy2192;
	goto yy1157;
yy2190:
	yych = *++cur;
	if (yych == 'p') goto yy2193;
	goto yy1455;
yy2191:
	yych = *++cur;
	if (yych == 'k') goto yy2195;
	goto yy1455;
yy2192:
	yych = *++cur;
	if (yych == 'i') goto yy2197;
	goto yy1157;
yy2193:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2194;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2194;
		if (yych <= 'z') goto yy1454;
	}
yy2194:
#line 653 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yybackup_yypeek_yyskip); }
#line 11323 "src/parse/conf_lexer.cc"
yy2195:
	yych = *++cur;
	if (yych <= '^') {
		if (yych <= '/') goto yy2196;
		if (yych <= '9') goto yy1454;
	} else {
		if (yych == '`') goto yy2196;
		if (yych <= 'z') goto yy1454;
	}
yy2196:
#line 652 "../src/parse/conf_lexer.re"
	{ RET_CODE(code_yyskip_yybackup_yypeek); }
#line 11336 "src/parse/conf_lexer.cc"
yy2197:
	yych = *++cur;
	if (yych != 'o') goto yy1157;
	yych = *++cur;
	if (yych != 'n') goto yy1157;
	yych = *++cur;
	if (yych != 's') goto yy1157;
	yych = *++cur;
	if (yybm[0+yych] & 64) goto yy1156;
#line 762 "../src/parse/conf_lexer.re"
	{ RET_COND(globopts->code_model == CodeModel::REC_FUNC); }
#line 11348 "src/parse/conf_lexer.cc"
}
#line 812 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL; // unreachable
}

#undef RET_TOK
#undef RET_OPT
#undef RET_GOPT
#undef RET_LOPT
#undef RET_VAR
#undef RET_CODE

#define SAVE_CONF_BOOL(conf) do { \
    CHECK_RET(lex_conf_bool(opts)); \
    opts.set_##conf(tmp_bool); \
    goto start; \
} while(0)

#define SAVE_CONF_STR(conf) do { \
    CHECK_RET(lex_conf_string(opts)); \
    opts.set_##conf(tmp_str); \
    goto start; \
} while(0)

#define SAVE_CONF_LIST(conf) do { \
    CHECK_RET(lex_conf_list(opts)); \
    opts.set_##conf(tmp_list); \
    CHECK_RET(opts.check_##conf()); \
    tmp_list.clear(); \
    goto start; \
} while(0)

Ret Input::lex_syntax_file(Opt& opts) {
start:
    tok = cur;
    location = cur_loc();

#line 11389 "src/parse/conf_lexer.cc"
{
	uint8_t yych;
	static const unsigned char yybm[256] = {
		  0, 128, 128, 128, 128, 128, 128, 128,
		128, 192,   0, 128, 128, 192, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		192, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128,
		128, 128, 128, 128, 128, 128, 128, 128
	};
	if ((lim - cur) < 23) YYFILL(23);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2202;
	if (yych <= 'c') {
		if (yych <= '.') {
			if (yych <= 0x00) goto yy2199;
			if (yych <= 0x08) goto yy2200;
			if (yych <= '\n') goto yy2203;
			goto yy2200;
		} else {
			if (yych <= '/') goto yy2204;
			if (yych <= 'a') goto yy2200;
			if (yych <= 'b') goto yy2205;
			goto yy2206;
		}
	} else {
		if (yych <= 'r') {
			if (yych == 'i') goto yy2207;
			if (yych <= 'q') goto yy2200;
			goto yy2208;
		} else {
			if (yych <= 's') goto yy2209;
			if (yych == 'w') goto yy2210;
			goto yy2200;
		}
	}
yy2199:
	++cur;
#line 850 "../src/parse/conf_lexer.re"
	{ return Ret::OK; }
#line 11456 "src/parse/conf_lexer.cc"
yy2200:
	++cur;
yy2201:
#line 878 "../src/parse/conf_lexer.re"
	{ RET_FAIL(error_at_tok("unexpected character: '%c'", cur[-1])); }
#line 11462 "src/parse/conf_lexer.cc"
yy2202:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 64) goto yy2202;
#line 854 "../src/parse/conf_lexer.re"
	{ goto start; }
#line 11470 "src/parse/conf_lexer.cc"
yy2203:
	++cur;
#line 852 "../src/parse/conf_lexer.re"
	{ next_line(); goto start; }
#line 11475 "src/parse/conf_lexer.cc"
yy2204:
	yych = *(mar = ++cur);
	if (yych == '/') goto yy2211;
	goto yy2201;
yy2205:
	yych = *(mar = ++cur);
	if (yych == 'a') goto yy2213;
	goto yy2201;
yy2206:
	yych = *(mar = ++cur);
	if (yych == 'o') goto yy2214;
	goto yy2201;
yy2207:
	yych = *(mar = ++cur);
	if (yych == 'n') goto yy2215;
	goto yy2201;
yy2208:
	yych = *(mar = ++cur);
	if (yych == 'e') goto yy2216;
	goto yy2201;
yy2209:
	yych = *(mar = ++cur);
	switch (yych) {
		case 'e': goto yy2217;
		case 'i': goto yy2218;
		case 'p': goto yy2219;
		case 'u': goto yy2220;
		default: goto yy2201;
	}
yy2210:
	yych = *(mar = ++cur);
	if (yych == 'r') goto yy2221;
	goto yy2201;
yy2211:
	++cur;
	if (lim <= cur) YYFILL(1);
	yych = *cur;
	if (yybm[0+yych] & 128) goto yy2211;
	if (yych >= 0x01) goto yy2203;
yy2212:
	cur = mar;
	goto yy2201;
yy2213:
	yych = *++cur;
	if (yych == 'c') goto yy2222;
	goto yy2212;
yy2214:
	yych = *++cur;
	if (yych == 'd') goto yy2223;
	goto yy2212;
yy2215:
	yych = *++cur;
	if (yych == 'd') goto yy2224;
	goto yy2212;
yy2216:
	yych = *++cur;
	if (yych == '2') goto yy2225;
	goto yy2212;
yy2217:
	yych = *++cur;
	if (yych == 'm') goto yy2226;
	goto yy2212;
yy2218:
	yych = *++cur;
	if (yych == 'n') goto yy2227;
	goto yy2212;
yy2219:
	yych = *++cur;
	if (yych == 'e') goto yy2228;
	goto yy2212;
yy2220:
	yych = *++cur;
	if (yych == 'p') goto yy2229;
	goto yy2212;
yy2221:
	yych = *++cur;
	if (yych == 'a') goto yy2230;
	goto yy2212;
yy2222:
	yych = *++cur;
	if (yych == 'k') goto yy2231;
	goto yy2212;
yy2223:
	yych = *++cur;
	if (yych == 'e') goto yy2232;
	goto yy2212;
yy2224:
	yych = *++cur;
	if (yych == 'e') goto yy2233;
	goto yy2212;
yy2225:
	yych = *++cur;
	if (yych == 'c') goto yy2234;
	goto yy2212;
yy2226:
	yych = *++cur;
	if (yych == 'i') goto yy2235;
	goto yy2212;
yy2227:
	yych = *++cur;
	if (yych == 'g') goto yy2236;
	goto yy2212;
yy2228:
	yych = *++cur;
	if (yych == 'c') goto yy2237;
	goto yy2212;
yy2229:
	yych = *++cur;
	if (yych == 'p') goto yy2238;
	goto yy2212;
yy2230:
	yych = *++cur;
	if (yych == 'p') goto yy2239;
	goto yy2212;
yy2231:
	yych = *++cur;
	if (yych == 't') goto yy2240;
	goto yy2212;
yy2232:
	yych = *++cur;
	if (yych == ':') goto yy2241;
	goto yy2212;
yy2233:
	yych = *++cur;
	if (yych == 'n') goto yy2242;
	goto yy2212;
yy2234:
	yych = *++cur;
	if (yych == ':') goto yy2243;
	goto yy2212;
yy2235:
	yych = *++cur;
	if (yych == 'c') goto yy2244;
	goto yy2212;
yy2236:
	yych = *++cur;
	if (yych == 'l') goto yy2245;
	goto yy2212;
yy2237:
	yych = *++cur;
	if (yych == 'i') goto yy2246;
	goto yy2212;
yy2238:
	yych = *++cur;
	if (yych == 'o') goto yy2247;
	goto yy2212;
yy2239:
	yych = *++cur;
	if (yych == '_') goto yy2248;
	goto yy2212;
yy2240:
	yych = *++cur;
	if (yych == 'i') goto yy2249;
	goto yy2212;
yy2241:
	++cur;
	cur -= 5;
#line 858 "../src/parse/conf_lexer.re"
	{
        allow_raw_nl = false;
        if (conf_parse(*this, opts) != 0) return Ret::FAIL;
        allow_raw_nl = true;
        goto start;
    }
#line 11640 "src/parse/conf_lexer.cc"
yy2242:
	yych = *++cur;
	if (yych == 't') goto yy2250;
	goto yy2212;
yy2243:
	++cur;
#line 856 "../src/parse/conf_lexer.re"
	{ CHECK_RET(lex_conf(opts)); goto start; }
#line 11649 "src/parse/conf_lexer.cc"
yy2244:
	yych = *++cur;
	if (yych == 'o') goto yy2251;
	goto yy2212;
yy2245:
	yych = *++cur;
	if (yych == 'e') goto yy2252;
	goto yy2212;
yy2246:
	yych = *++cur;
	if (yych == 'a') goto yy2253;
	goto yy2212;
yy2247:
	yych = *++cur;
	if (yych == 'r') goto yy2254;
	goto yy2212;
yy2248:
	yych = *++cur;
	if (yych == 'b') goto yy2255;
	goto yy2212;
yy2249:
	yych = *++cur;
	if (yych == 'c') goto yy2256;
	goto yy2212;
yy2250:
	yych = *++cur;
	if (yych == 'a') goto yy2257;
	goto yy2212;
yy2251:
	yych = *++cur;
	if (yych == 'l') goto yy2258;
	goto yy2212;
yy2252:
	yych = *++cur;
	if (yych == '_') goto yy2259;
	goto yy2212;
yy2253:
	yych = *++cur;
	if (yych == 'l') goto yy2260;
	goto yy2212;
yy2254:
	yych = *++cur;
	if (yych == 't') goto yy2261;
	goto yy2212;
yy2255:
	yych = *++cur;
	if (yych == 'l') goto yy2262;
	goto yy2212;
yy2256:
	yych = *++cur;
	if (yych == 'k') goto yy2263;
	goto yy2212;
yy2257:
	yych = *++cur;
	if (yych == 't') goto yy2264;
	goto yy2212;
yy2258:
	yych = *++cur;
	if (yych == 'o') goto yy2265;
	goto yy2212;
yy2259:
	yych = *++cur;
	if (yych == 'q') goto yy2266;
	goto yy2212;
yy2260:
	yych = *++cur;
	if (yych == '_') goto yy2267;
	goto yy2212;
yy2261:
	yych = *++cur;
	if (yych == 'e') goto yy2268;
	goto yy2212;
yy2262:
	yych = *++cur;
	if (yych == 'o') goto yy2269;
	goto yy2212;
yy2263:
	yych = *++cur;
	if (yych == '_') goto yy2270;
	goto yy2212;
yy2264:
	yych = *++cur;
	if (yych == 'i') goto yy2271;
	goto yy2212;
yy2265:
	yych = *++cur;
	if (yych == 'n') goto yy2272;
	goto yy2212;
yy2266:
	yych = *++cur;
	if (yych == 'u') goto yy2273;
	goto yy2212;
yy2267:
	yych = *++cur;
	if (yych == 'e') goto yy2274;
	goto yy2212;
yy2268:
	yych = *++cur;
	if (yych == 'd') goto yy2275;
	goto yy2212;
yy2269:
	yych = *++cur;
	if (yych == 'c') goto yy2276;
	goto yy2212;
yy2270:
	yych = *++cur;
	if (yych == 'q') goto yy2277;
	goto yy2212;
yy2271:
	yych = *++cur;
	if (yych == 'o') goto yy2278;
	goto yy2212;
yy2272:
	yych = *++cur;
	if (yych == 's') goto yy2279;
	goto yy2212;
yy2273:
	yych = *++cur;
	if (yych == 'o') goto yy2280;
	goto yy2212;
yy2274:
	yych = *++cur;
	if (yych == 's') goto yy2281;
	goto yy2212;
yy2275:
	yych = *++cur;
	if (yych == '_') goto yy2282;
	goto yy2212;
yy2276:
	yych = *++cur;
	if (yych == 'k') goto yy2283;
	goto yy2212;
yy2277:
	yych = *++cur;
	if (yych == 'u') goto yy2284;
	goto yy2212;
yy2278:
	yych = *++cur;
	if (yych == 'n') goto yy2285;
	goto yy2212;
yy2279:
	++cur;
#line 871 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(semicolons); }
#line 11794 "src/parse/conf_lexer.cc"
yy2280:
	yych = *++cur;
	if (yych == 't') goto yy2286;
	goto yy2212;
yy2281:
	yych = *++cur;
	if (yych == 'c') goto yy2287;
	goto yy2212;
yy2282:
	yych = *++cur;
	switch (yych) {
		case 'a': goto yy2288;
		case 'c': goto yy2289;
		case 'f': goto yy2290;
		case 't': goto yy2291;
		default: goto yy2212;
	}
yy2283:
	yych = *++cur;
	if (yych == 's') goto yy2292;
	goto yy2212;
yy2284:
	yych = *++cur;
	if (yych == 'o') goto yy2293;
	goto yy2212;
yy2285:
	yych = *++cur;
	if (yych == '_') goto yy2294;
	goto yy2212;
yy2286:
	yych = *++cur;
	if (yych == 'e') goto yy2295;
	goto yy2212;
yy2287:
	yych = *++cur;
	if (yych == 'a') goto yy2296;
	goto yy2212;
yy2288:
	yych = *++cur;
	if (yych == 'p') goto yy2297;
	goto yy2212;
yy2289:
	yych = *++cur;
	if (yych == 'o') goto yy2298;
	goto yy2212;
yy2290:
	yych = *++cur;
	if (yych == 'e') goto yy2299;
	goto yy2212;
yy2291:
	yych = *++cur;
	if (yych == 'a') goto yy2300;
	goto yy2212;
yy2292:
	yych = *++cur;
	if (yych == '_') goto yy2301;
	goto yy2212;
yy2293:
	yych = *++cur;
	if (yych == 't') goto yy2302;
	goto yy2212;
yy2294:
	yych = *++cur;
	if (yych == 's') goto yy2303;
	goto yy2212;
yy2295:
	yych = *++cur;
	if (yych == 'd') goto yy2304;
	goto yy2212;
yy2296:
	yych = *++cur;
	if (yych == 'p') goto yy2305;
	goto yy2212;
yy2297:
	yych = *++cur;
	if (yych == 'i') goto yy2306;
	goto yy2212;
yy2298:
	yych = *++cur;
	if (yych == 'd') goto yy2307;
	goto yy2212;
yy2299:
	yych = *++cur;
	if (yych == 'a') goto yy2308;
	goto yy2212;
yy2300:
	yych = *++cur;
	if (yych == 'r') goto yy2309;
	goto yy2212;
yy2301:
	yych = *++cur;
	if (yych == 'i') goto yy2310;
	goto yy2212;
yy2302:
	yych = *++cur;
	if (yych == 'e') goto yy2311;
	goto yy2212;
yy2303:
	yych = *++cur;
	if (yych == 'e') goto yy2312;
	goto yy2212;
yy2304:
	yych = *++cur;
	if (yych == '_') goto yy2313;
	goto yy2212;
yy2305:
	yych = *++cur;
	if (yych == 'e') goto yy2314;
	goto yy2212;
yy2306:
	yych = *++cur;
	if (yych == '_') goto yy2315;
	if (yych == 's') goto yy2316;
	goto yy2212;
yy2307:
	yych = *++cur;
	if (yych == 'e') goto yy2317;
	goto yy2212;
yy2308:
	yych = *++cur;
	if (yych == 't') goto yy2318;
	goto yy2212;
yy2309:
	yych = *++cur;
	if (yych == 'g') goto yy2319;
	goto yy2212;
yy2310:
	yych = *++cur;
	if (yych == 'n') goto yy2320;
	goto yy2212;
yy2311:
	yych = *++cur;
	if (yych == 'd') goto yy2321;
	goto yy2212;
yy2312:
	yych = *++cur;
	if (yych == 'n') goto yy2322;
	goto yy2212;
yy2313:
	yych = *++cur;
	if (yych == 's') goto yy2323;
	goto yy2212;
yy2314:
	yych = *++cur;
	if (yych == 's') goto yy2324;
	goto yy2212;
yy2315:
	yych = *++cur;
	if (yych == 's') goto yy2325;
	goto yy2212;
yy2316:
	++cur;
#line 865 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_apis); }
#line 11949 "src/parse/conf_lexer.cc"
yy2317:
	yych = *++cur;
	if (yych == '_') goto yy2326;
	goto yy2212;
yy2318:
	yych = *++cur;
	if (yych == 'u') goto yy2327;
	goto yy2212;
yy2319:
	yych = *++cur;
	if (yych == 'e') goto yy2328;
	goto yy2212;
yy2320:
	yych = *++cur;
	if (yych == '_') goto yy2329;
	goto yy2212;
yy2321:
	yych = *++cur;
	if (yych == '_') goto yy2330;
	goto yy2212;
yy2322:
	yych = *++cur;
	if (yych == 's') goto yy2331;
	goto yy2212;
yy2323:
	yych = *++cur;
	if (yych == 't') goto yy2332;
	goto yy2212;
yy2324:
	++cur;
#line 876 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_STR(special_escapes); }
#line 11982 "src/parse/conf_lexer.cc"
yy2325:
	yych = *++cur;
	if (yych == 't') goto yy2333;
	goto yy2212;
yy2326:
	yych = *++cur;
	if (yych == 'm') goto yy2334;
	goto yy2212;
yy2327:
	yych = *++cur;
	if (yych == 'r') goto yy2335;
	goto yy2212;
yy2328:
	yych = *++cur;
	if (yych == 't') goto yy2336;
	goto yy2212;
yy2329:
	yych = *++cur;
	if (yych == 'b') goto yy2337;
	goto yy2212;
yy2330:
	yych = *++cur;
	if (yych == 's') goto yy2338;
	goto yy2212;
yy2331:
	yych = *++cur;
	if (yych == 'i') goto yy2339;
	goto yy2212;
yy2332:
	yych = *++cur;
	if (yych == 'r') goto yy2340;
	goto yy2212;
yy2333:
	yych = *++cur;
	if (yych == 'y') goto yy2341;
	goto yy2212;
yy2334:
	yych = *++cur;
	if (yych == 'o') goto yy2342;
	goto yy2212;
yy2335:
	yych = *++cur;
	if (yych == 'e') goto yy2343;
	goto yy2212;
yy2336:
	yych = *++cur;
	if (yych == 's') goto yy2344;
	goto yy2212;
yy2337:
	yych = *++cur;
	if (yych == 'r') goto yy2345;
	goto yy2212;
yy2338:
	yych = *++cur;
	if (yych == 't') goto yy2346;
	goto yy2212;
yy2339:
	yych = *++cur;
	if (yych == 't') goto yy2347;
	goto yy2212;
yy2340:
	yych = *++cur;
	if (yych == 'i') goto yy2348;
	goto yy2212;
yy2341:
	yych = *++cur;
	if (yych == 'l') goto yy2349;
	goto yy2212;
yy2342:
	yych = *++cur;
	if (yych == 'd') goto yy2350;
	goto yy2212;
yy2343:
	yych = *++cur;
	if (yych == 's') goto yy2351;
	goto yy2212;
yy2344:
	++cur;
#line 868 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_targets); }
#line 12063 "src/parse/conf_lexer.cc"
yy2345:
	yych = *++cur;
	if (yych == 'a') goto yy2352;
	goto yy2212;
yy2346:
	yych = *++cur;
	if (yych == 'r') goto yy2353;
	goto yy2212;
yy2347:
	yych = *++cur;
	if (yych == 'i') goto yy2354;
	goto yy2212;
yy2348:
	yych = *++cur;
	if (yych == 'n') goto yy2355;
	goto yy2212;
yy2349:
	yych = *++cur;
	if (yych == 'e') goto yy2356;
	goto yy2212;
yy2350:
	yych = *++cur;
	if (yych == 'e') goto yy2357;
	goto yy2212;
yy2351:
	++cur;
#line 869 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_features); }
#line 12092 "src/parse/conf_lexer.cc"
yy2352:
	yych = *++cur;
	if (yych == 'c') goto yy2358;
	goto yy2212;
yy2353:
	yych = *++cur;
	if (yych == 'i') goto yy2359;
	goto yy2212;
yy2354:
	yych = *++cur;
	if (yych == 'v') goto yy2360;
	goto yy2212;
yy2355:
	yych = *++cur;
	if (yych == 'g') goto yy2361;
	goto yy2212;
yy2356:
	yych = *++cur;
	if (yych == 's') goto yy2362;
	goto yy2212;
yy2357:
	yych = *++cur;
	if (yych == 'l') goto yy2363;
	goto yy2212;
yy2358:
	yych = *++cur;
	if (yych == 'e') goto yy2364;
	goto yy2212;
yy2359:
	yych = *++cur;
	if (yych == 'n') goto yy2365;
	goto yy2212;
yy2360:
	yych = *++cur;
	if (yych == 'e') goto yy2366;
	goto yy2212;
yy2361:
	yych = *++cur;
	if (yych == 's') goto yy2367;
	goto yy2212;
yy2362:
	++cur;
#line 866 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_api_styles); }
#line 12137 "src/parse/conf_lexer.cc"
yy2363:
	yych = *++cur;
	if (yych == 's') goto yy2368;
	goto yy2212;
yy2364:
	yych = *++cur;
	if (yych == 's') goto yy2369;
	goto yy2212;
yy2365:
	yych = *++cur;
	if (yych == 'g') goto yy2370;
	goto yy2212;
yy2366:
	++cur;
#line 874 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(indentation_sensitive); }
#line 12154 "src/parse/conf_lexer.cc"
yy2367:
	++cur;
#line 873 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(single_quoted_strings); }
#line 12159 "src/parse/conf_lexer.cc"
yy2368:
	++cur;
#line 867 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_LIST(supported_code_models); }
#line 12164 "src/parse/conf_lexer.cc"
yy2369:
	++cur;
#line 875 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(wrap_blocks_in_braces); }
#line 12169 "src/parse/conf_lexer.cc"
yy2370:
	yych = *++cur;
	if (yych != 's') goto yy2212;
	++cur;
#line 872 "../src/parse/conf_lexer.re"
	{ SAVE_CONF_BOOL(backtick_quoted_strings); }
#line 12176 "src/parse/conf_lexer.cc"
}
#line 879 "../src/parse/conf_lexer.re"


    UNREACHABLE();
    return Ret::FAIL;
}

#undef SAVE_CONF_BOOL
#undef SAVE_CONF_STR
#undef SAVE_CONF_LIST

#undef YYFILL

} // namespace re2c
