// re2rust $INPUT -o $OUTPUT --api simple

#[derive(Debug, PartialEq)]
struct SemVer(u32, u32, u32); // version: (major, minor, patch)

const NONE: usize = std::usize::MAX;

fn s2n(str: &[u8]) -> u32 { // convert a pre-parsed string to a number
    let mut n = 0;
    for i in str { n = n * 10 + *i as u32 - 48; }
    return n;
}

fn parse(yyinput: &[u8]) -> Option<SemVer> {
    assert_eq!(yyinput.last(), Some(&0)); // expect null-terminated input

    let (mut yycursor, mut yymarker) = (0, 0);

    // Final tag variables available in semantic action.
    /*!stags:re2c format = 'let mut @@ = NONE;'; */

    // Intermediate tag variables used by the lexer (must be autogenerated).
    /*!svars:re2c format = '#[allow(unused_mut)]\nlet mut @@;\n'; */

    /*!re2c
        re2c:YYCTYPE = u8;
        re2c:yyfill:enable = 0;
        re2c:captvars = 1;

        num = [0-9]+;

        (num) "." (num) ("." num)? [\x00] {
            assert!(yytl0 == 0 && yytr0 == yyinput.len());
            let major = s2n(&yyinput[yytl1..yytr1]);
            let minor = s2n(&yyinput[yytl2..yytr2]);
            let patch = if yytl3 == NONE {0} else {s2n(&yyinput[yytl3 + 1..yytr3])};
            return Some(SemVer(major, minor, patch));
        }
        * { return None; }
    */
}

fn main() {
    assert_eq!(parse(b"23.34\0"), Some(SemVer(23, 34, 0)));
    assert_eq!(parse(b"1.2.99999\0"), Some(SemVer(1, 2, 99999)));
    assert_eq!(parse(b"1.a\0"), None);
}
