
## Configuration

### npm

Install this extension

``` bash
npm i -D @cppalliance/antora-cpp-reference-extension
```

### Requirements

Before building the Antora playbook, make sure you have the following
installed:

-   

-   `7z` (Windows) or `tar` (Linux)

-   `git`

### Playbook

Append the following in your `playbook.yaml`:

``` yaml
antora:
  extensions:
    - require: '@cppalliance/antora-cpp-reference-extension' # 
      dependencies: # 
        - name: 'boost'
          repo: 'https://github.com/boostorg/boost.git'
          tag: 'develop'
          variable: 'BOOST_SRC_ROOT'
          system-env: 'BOOST_SRC_ROOT' # 
```

-   \<1\> `npm` package name:
    `@cppalliance/antora-cpp-reference-extension` (required)

-   \<2\> List of dependencies to be downloaded and extracted. The
    directory where these dependencies are extracted will be available
    to all components as an environment variable.

-   \<3\> The name of the environment variable describing where the path
    can be found. If this path exists and is a valid directory, it will
    be used as the source root for the dependency, skipping the download
    and extraction steps. If this is different from `variable`, the
    extension will set the value of `variable` to the path where the
    dependency is already located.

Besides the `dependencies` configuration, you can also set the following
options:

+-----------------------+-----------------------+-----------------------+
| Option                | Description           | Default               |
+-----------------------+-----------------------+-----------------------+
| `version`             | A semver range that   | `*`                   |
|                       | specifies the version |                       |
|                       | of MrDocs to use.     |                       |
+-----------------------+-----------------------+-----------------------+
| `allow-master`        | If `true`, the        | `true`                |
|                       | extension will allow  |                       |
|                       | the use of the        |                       |
|                       | `master` branch for   |                       |
|                       | MrDocs if `version`   |                       |
|                       | is `*`.               |                       |
+-----------------------+-----------------------+-----------------------+
| `allow-develop`       | If `true`, the        | `true`                |
|                       | extension will allow  |                       |
|                       | the use of the        |                       |
|                       | `develop` branch for  |                       |
|                       | MrDocs if `version`   |                       |
|                       | is `*`.               |                       |
+-----------------------+-----------------------+-----------------------+
| `module`              | Antora module that    | `reference`           |
|                       | will receive the      |                       |
|                       | generated pages       |                       |
|                       | (`modu                |                       |
|                       | les/<module>/pages`). |                       |
+-----------------------+-----------------------+-----------------------+

### Components

Components that will include reference documentation should set the path
of the MrDocs configuration file. Append following in your
`antora.yaml`:

``` yaml
ext:
  cpp-reference:
    config: doc/mrdocs.yml # 
    module: api-ref        # 
```

-   \<1\> The path to the MrDocs configuration file relative to the
    worktree.

-   \<2\> (Optional) Override the Antora module used for the generated
    pages. If omitted the component inherits the module set at the
    playbook level (or `reference` when neither level specifies a
    value).

For more information about MrDocs, see <https://www.mrdocs.com/docs>

### References in the component

To include links to the reference module, the prefix `xref:reference:`
should be used.

You would usually include a link to the main reference page in the
component's `nav.adoc`:

``` asciidoc
* xref:reference:index.adoc[Reference]
```

### Coordinating with the tagfiles extension

When the tagfiles extension
(<https://github.com/cppalliance/antora-cpp-tagfiles-extension>) is also
listed in your playbook, the reference tagfile is registered
automatically and picked up within the same Antora run---even if you
change the module name.

``` yaml
antora:
  extensions:
    - require: '@cppalliance/antora-cpp-reference-extension'
    - require: '@cppalliance/antora-cpp-tagfiles-extension'
```

With this configuration, you don't need to copy tagfiles into your
repository or commit them to source control to satisfy `cpp:` macros.

## Example

The `example` directory contains an example project with a component
that uses the extension.
