# see https://gcc.gnu.org/onlinedocs/gcc/AArch64-Options.html#index-march
function(ocv_set_platform_flags VAR)
  unset(flags)
  if(ENABLE_SVE)
   set(flags "${flags}+sve")
  endif()
  if(ENABLE_BF16)
    set(flags "${flags}+bf16")
  endif()
  if(ENABLE_DOTPROD)
    set(flags "${flags}+dotprod")
  endif()
  if(ENABLE_FP16)
    set(flags "${flags}+fp16")
  endif()
  if(DEFINED ENABLE_NEON AND NOT ENABLE_NEON)
    set(flags "${flags}+nosimd")
  endif()
  if(flags)
    set(${VAR} "-march=armv8.2-a${flags}" PARENT_SCOPE)
  endif()
endfunction()
