# Protocol Buffers - Protobuf Editions design documents

This directory contains historical design documents that describe plans for
implementing Protobuf Editions. For an up-to-date overview of this feature of
Protocol Buffers, see
[Protobuf Editions Overview](https://protobuf.dev/editions/overview/).

These files represent the state that the original documents were in at the time
that they were published to this repository. While some updates *may* be made to
the files after their initial upload, you should consider the possibility that
they are outdated as you read them. These are purely for historical value and
should not be treated as documentation of the current state.

Note that the authors listed in the topics were the authors of the *original*
version of the document; it may have changed since they last worked on the
document.

## Design Documents

The following topics are in this repository:

*   [What are Protobuf Editions?](what-are-protobuf-editions.md)
*   [Life of an Edition](life-of-an-edition.md)
*   [Edition Lifetimes](edition-lifetimes.md)
*   [Protobuf Editions Design: Features](protobuf-editions-design-features.md)
*   [Editions: Life of a Featureset](editions-life-of-a-featureset.md)
*   [Edition Zero Features](edition-zero-features.md)
*   [Minimum Required Edition](minimum-required-edition.md)
*   [Protobuf Editions for Schema Producers](protobuf-editions-for-schema-producers.md)
*   [Stricter Schemas with Editions](stricter-schemas-with-editions.md)
*   [Edition Zero: JSON Handling](edition-zero-json-handling.md)
*   [Edition Zero: Converged Semantics](edition-zero-converged-semantics.md)
*   [Edition Zero Feature: Enum Field Closedness](edition-zero-feature-enum-field-closedness.md)
*   [C++ APIs for Edition Zero](cpp-apis-for-edition-zero.md)
*   [Java Lite For Editions](java-lite-for-editions.md)
*   [Edition Evolution](edition-evolution.md)
*   [Edition Naming](edition-naming.md)
*   [Editions Feature Visibility](editions-feature-visibility.md)
*   [Legacy Syntax Editions](legacy-syntax-editions.md)
*   [Editions: Feature Extension Layout](editions-feature-extension-layout.md)
*   [Editions: Group Migration Issues](group-migration-issues.md)