/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.executor.etree.temptable.column;

import com.amazon.sqlengine.executor.etree.temptable.column.ColumnSizeCalculator;
import com.amazon.sqlengine.executor.etree.temptable.column.DefaultColumnSlice;
import com.amazon.sqlengine.executor.etree.temptable.column.IColumnSlice;
import java.math.BigDecimal;

public final class BooleanColumnSlice
extends DefaultColumnSlice {
    private static final long serialVersionUID = 8879043950764226178L;
    private boolean[] m_data;
    private int m_size;
    private final int m_columnNumber;

    public BooleanColumnSlice(int n, int n2) {
        this.m_size = n;
        this.m_data = new boolean[n * 2];
        this.m_columnNumber = n2;
    }

    @Override
    public int columnNumber() {
        return this.m_columnNumber;
    }

    @Override
    public boolean isNull(int n) {
        return this.m_data[2 * n + 1];
    }

    @Override
    public void setNull(int n) {
        this.m_data[2 * n + 1] = true;
    }

    @Override
    public boolean getBoolean(int n) {
        return this.m_data[2 * n];
    }

    @Override
    public long getBigInt(int n) {
        return this.getBoolean(n) ? 1L : 0L;
    }

    @Override
    public BigDecimal getExactNum(int n) {
        return this.getBoolean(n) ? BigDecimal.ONE : BigDecimal.ZERO;
    }

    @Override
    public double getDouble(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public float getReal(int n) {
        return this.getBoolean(n) ? 1.0f : 0.0f;
    }

    @Override
    public int getInteger(int n) {
        return this.getBoolean(n) ? 1 : 0;
    }

    @Override
    public short getSmallInt(int n) {
        return this.getBoolean(n) ? (short)1 : 0;
    }

    @Override
    public byte getTinyInt(int n) {
        return this.getBoolean(n) ? (byte)1 : 0;
    }

    @Override
    public IColumnSlice.ColumnSliceType getType() {
        return IColumnSlice.ColumnSliceType.BOOLEAN;
    }

    @Override
    public void setBoolean(int n, boolean bl) {
        this.m_data[2 * n] = bl;
        this.m_data[2 * n + 1] = false;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public void copy(IColumnSlice iColumnSlice, int n, int n2, int n3) {
        if (!(iColumnSlice instanceof BooleanColumnSlice)) {
            throw new IllegalArgumentException("Unknown column slice type");
        }
        BooleanColumnSlice booleanColumnSlice = (BooleanColumnSlice)iColumnSlice;
        System.arraycopy(booleanColumnSlice.m_data, n * 2, this.m_data, n3 * 2, n2 * 2);
    }

    static double estimateRowSize(ColumnSizeCalculator.JavaSize javaSize) {
        return 0.0;
    }

    static double estimateRowOverhead(ColumnSizeCalculator.JavaSize javaSize) {
        return 2 * javaSize.getBooleanSize();
    }
}

