/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.rosuda.JGR.JGRObjectManager;
import org.rosuda.JGR.robjects.RModel;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.util.TableSorter;

public class ModelBrowserTable
extends JTable
implements MouseListener,
DragGestureListener,
DragSourceListener {
    private static final long serialVersionUID = -7841580144147512452L;
    private final String[] colnames = new String[]{"Name", "Data", "Type", "family", "df", "r.squared", "aic", "deviance"};
    public FilterPanel filter;
    private Vector models;
    private Vector fmodels;
    private TableSorter sorter;
    private JGRObjectManager objmgr;
    private DragSource dragSource;

    public ModelBrowserTable(JGRObjectManager parent, Vector models) {
        this.models = models;
        this.fmodels = new Vector(this.models);
        this.objmgr = parent;
        this.setColumnModel(new ModelTableColumnModel());
        this.sorter = new TableSorter(new ModelTableModel());
        this.setShowGrid(true);
        this.setModel(this.sorter);
        this.setAutoResizeMode(1);
        FontTracker.current.add(this);
        this.setRowHeight((int)((double)JGRPrefs.FontSize * 1.5));
        this.getTableHeader().setReorderingAllowed(false);
        this.sorter.setTableHeader(this.getTableHeader());
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        ToolTipManager.sharedInstance().setReshowDelay(0);
        this.filter = new FilterPanel(this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 1, this);
        this.addMouseListener(this);
    }

    public void refresh() {
        int i;
        int[] st = new int[this.sorter.getColumnCount()];
        for (i = 0; i < st.length; ++i) {
            st[i] = this.sorter.getSortingStatus(i);
        }
        this.sorter = new TableSorter(new ModelTableModel());
        this.sorter.setTableHeader(this.getTableHeader());
        for (i = 0; i < st.length; ++i) {
            this.sorter.setSortingStatus(i, st[i]);
        }
        this.setModel(this.sorter);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (e.isAltDown()) {
            this.objmgr.setWorking(true);
            RModel m = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(e.getPoint())));
            if (m == null || m.getToolTip().trim().length() == 0) {
                return null;
            }
            String tip = m.getToolTip();
            if (tip != null) {
                this.objmgr.setWorking(false);
                return tip;
            }
            return null;
        }
        this.objmgr.setWorking(false);
        return null;
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        RModel m = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(evt.getDragOrigin())));
        if (m == null || m.getCall().trim().length() == 0) {
            return;
        }
        StringSelection t = new StringSelection(m.getName() + " <- " + m.getTypeName() + "(" + m.getCall() + (m.getFamily() != null ? ",family=" + m.getFamily() : "") + (m.getData() != null ? ",data=" + m.getData() : "") + ")");
        this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.objmgr.summary != null) {
            this.objmgr.summary.hide();
        }
        if (e.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            JToolTip call = new JToolTip();
            RModel m = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(e.getPoint())));
            if (m == null || m.getToolTip().trim().length() == 0) {
                return;
            }
            String tip = m.getToolTip();
            if (tip == null) {
                this.objmgr.setWorking(false);
                return;
            }
            call.setTipText(m.getToolTip());
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, call, p.x + 20, p.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.objmgr.setWorking(true);
            JToolTip call = new JToolTip();
            RModel m = (RModel)this.fmodels.elementAt(this.sorter.modelIndex(this.rowAtPoint(e.getPoint())));
            if (m == null || m.getToolTip().trim().length() == 0) {
                return;
            }
            String tip = m.getToolTip();
            if (tip == null) {
                this.objmgr.setWorking(false);
                return;
            }
            call.setTipText(m.getToolTip());
            Point p = e.getPoint();
            SwingUtilities.convertPointToScreen(p, this);
            this.objmgr.summary = PopupFactory.getSharedInstance().getPopup(this, call, p.x + 20, p.y + 25);
            this.objmgr.summary.show();
            this.objmgr.setWorking(false);
        }
    }

    class FilterPanel
    extends JPanel
    implements KeyListener {
        private static final long serialVersionUID = -4159489679875254193L;
        JTextField name = new JTextField();
        JTextField data = new JTextField();
        JTextField type = new JTextField();
        JTextField family = new JTextField();
        JTextField[] filters = new JTextField[]{this.name, this.data, this.type, this.family};
        ModelBrowserTable table;

        public FilterPanel(ModelBrowserTable table) {
            FlowLayout fl = new FlowLayout(0);
            fl.setVgap(0);
            fl.setHgap(0);
            this.setLayout(fl);
            this.table = table;
            this.add(this.name);
            this.add(this.data);
            this.add(this.type);
            this.add(this.family);
            this.name.addKeyListener(this);
            this.data.addKeyListener(this);
            this.type.addKeyListener(this);
            this.family.addKeyListener(this);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    FilterPanel.this.resizeFields();
                }
            });
        }

        public void resizeFields() {
            this.name.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[0]).getWidth(), 25));
            this.data.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[1]).getWidth(), 25));
            this.type.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[2]).getWidth(), 25));
            this.family.setPreferredSize(new Dimension(this.table.getColumn(ModelBrowserTable.this.colnames[3]).getWidth(), 25));
        }

        @Override
        public void setSize(Dimension d) {
            this.resizeFields();
            super.setSize(d);
        }

        @Override
        public void setSize(int w, int h) {
            this.resizeFields();
            super.setSize(w, h);
        }

        private void filterModels() {
            ModelBrowserTable.this.fmodels.clear();
            for (RModel r : ModelBrowserTable.this.models) {
                if (!this.matches(r.getInfo())) continue;
                ModelBrowserTable.this.fmodels.add(r);
            }
            this.table.refresh();
        }

        private boolean matches(Vector v) {
            for (int i = 0; i < this.filters.length; ++i) {
                String f = this.filters[i].getText();
                String m = (String)v.elementAt(i);
                if (f != null && f.trim().length() > 0 && (m == null || m.trim().length() == 0)) {
                    return false;
                }
                if (f == null || m == null || this.compareF(m.trim(), f.trim())) continue;
                return false;
            }
            return true;
        }

        private boolean compareF(String s1, String s2) {
            if (s1.startsWith(s2)) {
                return true;
            }
            try {
                if (s1.matches(s2)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.filterModels();
        }
    }

    class ModelTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1243689917922294377L;

        @Override
        public void addColumn(TableColumn col) {
            col.setCellRenderer(new DefaultTableCellRenderer());
            if (col.getModelIndex() == 0) {
                col.setPreferredWidth(100);
            } else if (col.getModelIndex() == 1) {
                col.setPreferredWidth(80);
            } else if (col.getModelIndex() == 2) {
                col.setPreferredWidth(50);
            } else if (col.getModelIndex() == 4) {
                col.setPreferredWidth(40);
            }
            super.addColumn(col);
        }

        @Override
        public TableColumn getColumn(int index) {
            return super.getColumn(index < 0 ? 0 : index);
        }
    }

    class ModelTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -1098695966813872521L;

        ModelTableModel() {
        }

        @Override
        public int getColumnCount() {
            return ModelBrowserTable.this.colnames.length;
        }

        @Override
        public int getRowCount() {
            return ModelBrowserTable.this.fmodels.size();
        }

        @Override
        public String getColumnName(int col) {
            return ModelBrowserTable.this.colnames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return ((RModel)ModelBrowserTable.this.fmodels.elementAt(row)).getInfo().elementAt(col);
        }

        public Class getColumnClass(int col) {
            int i = 0;
            while (((RModel)ModelBrowserTable.this.fmodels.elementAt(i)).getInfo().elementAt(col) == null) {
                ++i;
            }
            if (i > this.getRowCount()) {
                return null;
            }
            return ((RModel)ModelBrowserTable.this.fmodels.elementAt(i)).getInfo().elementAt(col).getClass();
        }
    }
}

