/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.Iterator;
import opennlp.model.Event;
import opennlp.model.Sequence;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameSample;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameSampleSequenceIterator
implements Iterator<Sequence> {
    private Iterator<NameSample> psi;
    private NameContextGenerator cg;

    public NameSampleSequenceIterator(Iterator<NameSample> psi) {
        this.psi = psi;
        this.cg = new DefaultNameContextGenerator(null);
    }

    @Override
    public boolean hasNext() {
        return this.psi.hasNext();
    }

    @Override
    public Sequence<NameSample> next() {
        NameSample sample = this.psi.next();
        String[] sentence = sample.getSentence();
        String[] tags = NameFinderEventStream.generateOutcomes(sample.getNames(), null, sentence.length);
        Event[] events = new Event[sentence.length];
        for (int i = 0; i < sentence.length; ++i) {
            String[] context = this.cg.getContext(i, sentence, tags, null);
            events[i] = new Event(tags[i], context);
        }
        Sequence<NameSample> sequence = new Sequence<NameSample>(events, sample);
        return sequence;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

