/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.connectivity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.UndirectedGraphVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.ESat;
import org.chocosolver.util.graphOperations.connectivity.ConnectivityFinder;
import org.chocosolver.util.objects.graphs.IGraph;
import org.chocosolver.util.objects.graphs.UndirectedGraph;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropSizeMaxCC
extends Propagator<Variable> {
    private final UndirectedGraphVar g;
    private final IntVar sizeMaxCC;
    private final ConnectivityFinder GLBCCFinder;
    private final ConnectivityFinder GUBCCFinder;

    public PropSizeMaxCC(UndirectedGraphVar graph, IntVar sizeMaxCC) {
        super(new Variable[]{graph, sizeMaxCC}, (Priority)PropagatorPriority.QUADRATIC, false);
        this.g = graph;
        this.sizeMaxCC = sizeMaxCC;
        this.GLBCCFinder = new ConnectivityFinder((IGraph)this.g.getLB());
        this.GUBCCFinder = new ConnectivityFinder((IGraph)this.g.getUB());
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return 255;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.GLBCCFinder.findAllCC();
        this.GUBCCFinder.findAllCC();
        int nbCC_GLB = this.GLBCCFinder.getNBCC();
        int maxNCC_LB = this.GLBCCFinder.getSizeMaxCC();
        int maxNCC_UB = this.GUBCCFinder.getSizeMaxCC();
        if (this.sizeMaxCC.getLB() > ((UndirectedGraph)this.g.getUB()).getNodes().size()) {
            this.fails();
        }
        if (maxNCC_UB < this.sizeMaxCC.getLB()) {
            this.fails();
        }
        if (maxNCC_LB > this.sizeMaxCC.getUB()) {
            this.fails();
        }
        this.sizeMaxCC.updateLowerBound(maxNCC_LB, this);
        this.sizeMaxCC.updateUpperBound(maxNCC_UB, this);
        if (maxNCC_UB > this.sizeMaxCC.getUB()) {
            int i;
            ISetIterator iSetIterator;
            boolean recomputeMaxNCC_UB = false;
            if (this.sizeMaxCC.getUB() == 1) {
                iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    i = (Integer)iSetIterator.next();
                    ISetIterator iSetIterator2 = this.g.getPotentialNeighborsOf(i).iterator();
                    while (iSetIterator2.hasNext()) {
                        int j = (Integer)iSetIterator2.next();
                        this.g.removeEdge(i, j, this);
                    }
                }
            }
            if (this.sizeMaxCC.getUB() == 0) {
                iSetIterator = this.g.getPotentialNodes().iterator();
                while (iSetIterator.hasNext()) {
                    i = (Integer)iSetIterator.next();
                    this.g.removeNode(i, this);
                }
            }
            for (int cc = 0; cc < nbCC_GLB; ++cc) {
                int[] sizeCC = this.GLBCCFinder.getSizeCC();
                if (sizeCC[cc] == this.sizeMaxCC.getUB()) {
                    Map<Integer, Set<Integer>> ccPotentialNeighbors = this.getGLBCCPotentialNeighbors(cc);
                    for (int i2 : ccPotentialNeighbors.keySet()) {
                        for (int j : ccPotentialNeighbors.get(i2)) {
                            this.g.removeEdge(i2, j, this);
                        }
                    }
                    continue;
                }
                for (int cc2 = cc + 1; cc2 < nbCC_GLB; ++cc2) {
                    if (sizeCC[cc] + sizeCC[cc2] <= this.sizeMaxCC.getUB()) continue;
                    Map<Integer, Set<Integer>> ccPotentialNeighbors = this.getGLBCCPotentialNeighbors(cc);
                    for (int i3 : ccPotentialNeighbors.keySet()) {
                        for (int j : ccPotentialNeighbors.get(i3)) {
                            if (!this.getGLBCCNodes(cc2).contains(j)) continue;
                            recomputeMaxNCC_UB = true;
                            this.g.removeEdge(i3, j, this);
                        }
                    }
                }
            }
            if (recomputeMaxNCC_UB) {
                this.GUBCCFinder.findAllCC();
                maxNCC_UB = this.GUBCCFinder.getSizeMaxCC();
                if (maxNCC_UB < this.sizeMaxCC.getLB()) {
                    this.fails();
                }
                if (this.sizeMaxCC.getUB() > maxNCC_UB) {
                    this.sizeMaxCC.updateUpperBound(maxNCC_UB, this);
                }
            }
        }
        int nb_candidates = 0;
        int candidate = -1;
        int size = 0;
        for (int cc = 0; cc < this.GUBCCFinder.getNBCC(); ++cc) {
            int s = this.GUBCCFinder.getSizeCC()[cc];
            if (s >= this.sizeMaxCC.getLB()) {
                ++nb_candidates;
                candidate = cc;
                size = s;
            }
            if (nb_candidates > 1) break;
        }
        if (nb_candidates == 1 && size == this.sizeMaxCC.getLB()) {
            int i = this.GUBCCFinder.getCCFirstNode()[candidate];
            while (i != -1) {
                this.g.enforceNode(i, this);
                i = this.GUBCCFinder.getCCNextNode()[i];
            }
            this.sizeMaxCC.instantiateTo(this.sizeMaxCC.getLB(), this);
        }
    }

    private Set<Integer> getGLBCCNodes(int cc) {
        HashSet<Integer> ccNodes = new HashSet<Integer>();
        int i = this.GLBCCFinder.getCCFirstNode()[cc];
        while (i >= 0) {
            ccNodes.add(i);
            i = this.GLBCCFinder.getCCNextNode()[i];
        }
        return ccNodes;
    }

    private Map<Integer, Set<Integer>> getGLBCCPotentialNeighbors(int cc) {
        HashMap<Integer, Set<Integer>> ccPotentialNeighbors = new HashMap<Integer, Set<Integer>>();
        Set<Integer> ccNodes = this.getGLBCCNodes(cc);
        for (int i : ccNodes) {
            HashSet<Integer> outNeighbors = new HashSet<Integer>();
            ISetIterator iSetIterator = this.g.getPotentialNeighborsOf(i).iterator();
            while (iSetIterator.hasNext()) {
                int j = (Integer)iSetIterator.next();
                if (ccNodes.contains(j)) continue;
                outNeighbors.add(j);
            }
            if (outNeighbors.size() <= 0) continue;
            ccPotentialNeighbors.put(i, outNeighbors);
        }
        return ccPotentialNeighbors;
    }

    @Override
    public ESat isEntailed() {
        this.GLBCCFinder.findAllCC();
        this.GUBCCFinder.findAllCC();
        int maxNCC_LB = this.GLBCCFinder.getSizeMaxCC();
        int maxNCC_UB = this.GUBCCFinder.getSizeMaxCC();
        if (maxNCC_UB < this.sizeMaxCC.getLB() || maxNCC_LB > this.sizeMaxCC.getUB()) {
            return ESat.FALSE;
        }
        if (this.isCompletelyInstantiated()) {
            if (maxNCC_LB == this.sizeMaxCC.getValue()) {
                return ESat.TRUE;
            }
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }
}

