/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class EqualityConstraintModel
extends AbstractModel {
    public static final String EQUALITY_CONSTRAINT = "equalityConstraint";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(Parameter.class, 2, Integer.MAX_VALUE)};

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            int n = -1;
            double[] dArray = null;
            ArrayList<Variable> arrayList = new ArrayList<Variable>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                Parameter parameter = (Parameter)xMLObject.getChild(i);
                if (i == 0) {
                    n = parameter.getDimension();
                    dArray = parameter.getParameterValues();
                } else {
                    if (parameter.getDimension() != n) {
                        throw new XMLParseException("All parameters must have the same dimension.");
                    }
                    for (int j = 0; j < n; ++j) {
                        parameter.setParameterValue(j, dArray[j]);
                    }
                }
                arrayList.add(parameter);
            }
            return new EqualityConstraintModel(EqualityConstraintModel.EQUALITY_CONSTRAINT, arrayList);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "Forces a set of variables to have equal values";
        }

        @Override
        public Class getReturnType() {
            return EqualityConstraintModel.class;
        }

        @Override
        public String getParserName() {
            return EqualityConstraintModel.EQUALITY_CONSTRAINT;
        }
    };
    private final List<Variable> parameterList;
    private boolean noReentry = false;

    public EqualityConstraintModel(String string, List<Variable> list) {
        super(string);
        this.parameterList = list;
        for (Variable variable : list) {
            this.addVariable(variable);
        }
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (this.noReentry) {
            return;
        }
        this.noReentry = true;
        if (changeType == Variable.ChangeType.ALL_VALUES_CHANGED) {
            V[] VArray = variable.getValues();
            for (Variable variable2 : this.parameterList) {
                if (variable2 == variable) continue;
                for (int i = 0; i < VArray.length; ++i) {
                    variable2.setValue(i, VArray[i]);
                }
            }
        } else if (changeType == Variable.ChangeType.VALUE_CHANGED) {
            Object v = variable.getValue(n);
            for (Variable variable3 : this.parameterList) {
                if (variable3 == variable) continue;
                variable3.setValue(n, v);
            }
        } else {
            throw new IllegalArgumentException("Variable dimensional updates are not yet implemented.");
        }
        this.noReentry = false;
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    private static void setEqual(List<Variable> list) {
        int n = list.get(0).getSize();
        if (list.get(0) instanceof Parameter) {
            int n2;
            Parameter parameter;
            double[] dArray = new double[n];
            for (Variable variable : list) {
                parameter = (Parameter)variable;
                for (n2 = 0; n2 < n; ++n2) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + parameter.getParameterValue(n2);
                }
            }
            int n4 = 0;
            while (n4 < n) {
                int n5 = n4++;
                dArray[n5] = dArray[n5] / (double)list.size();
            }
            for (Variable variable : list) {
                parameter = (Parameter)variable;
                for (n2 = 0; n2 < n; ++n2) {
                    parameter.setParameterValue(n2, dArray[n2]);
                }
            }
        }
    }

    private static int checkDimensions(List<Parameter> list) {
        int n = list.get(0).getDimension();
        for (Parameter parameter : list) {
            if (parameter.getDimension() == n) continue;
            return -1;
        }
        return n;
    }
}

