/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.Parameter;
import dr.inference.model.TransformedMultivariateParameter;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class TransformedVectorSumTransform
extends Transform.MultivariateTransform {
    private static final String NAME = "transformedVectorSumTransform";
    private static final String PARSER_NAME2 = "vectorScanTransformedParameter";
    private final Transform incrementTransform;
    public static final AbstractXMLObjectParser PARSER = new AbstractXMLObjectParser(){
        public static final String INCREMENT_TRANSFORM = "incrementTransformType";

        @Override
        public TransformedMultivariateParameter parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Transform.UnivariableTransform univariableTransform;
            String string;
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            int n = parameter.getDimension();
            double d = Double.POSITIVE_INFINITY;
            double d2 = Double.NEGATIVE_INFINITY;
            if (xMLObject.hasAttribute("upper") && xMLObject.hasAttribute("lower")) {
                d = xMLObject.getDoubleAttribute("upper");
                d2 = xMLObject.getDoubleAttribute("lower");
            }
            if ((string = (String)xMLObject.getAttribute(INCREMENT_TRANSFORM)).equalsIgnoreCase("log")) {
                univariableTransform = Transform.LOG;
            } else if (string.equalsIgnoreCase("logit")) {
                univariableTransform = new Transform.ScaledLogitTransform(d, d2);
            } else if (string.equalsIgnoreCase("none")) {
                univariableTransform = new Transform.NoTransform();
            } else {
                throw new RuntimeException("Invalid transform type");
            }
            TransformedVectorSumTransform transformedVectorSumTransform = new TransformedVectorSumTransform(n, univariableTransform);
            return new TransformedMultivariateParameter(parameter, transformedVectorSumTransform);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[0];
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return TransformedMultivariateParameter.class;
        }

        @Override
        public String getParserName() {
            return TransformedVectorSumTransform.NAME;
        }

        @Override
        public String[] getParserNames() {
            return new String[]{TransformedVectorSumTransform.NAME, TransformedVectorSumTransform.PARSER_NAME2};
        }
    };

    public TransformedVectorSumTransform(int n, Transform transform) {
        super(n);
        this.incrementTransform = transform;
    }

    @Override
    public double[] inverse(double[] dArray, int n, int n2, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[] gradient(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[] gradientInverse(double[] dArray, int n, int n2) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public String getTransformName() {
        return NAME;
    }

    @Override
    protected double[] updateGradientLogDensity(double[] dArray, double[] dArray2) {
        int n = dArray2.length;
        double[] dArray3 = this.transform(dArray2);
        double[] dArray4 = new double[n];
        dArray4[n - 1] = dArray[n - 1] * this.incrementTransform.gradient(dArray3[n - 1]);
        for (int i = n - 2; i >= 0; --i) {
            dArray4[i] = dArray[i] * this.incrementTransform.gradient(dArray3[i]) + dArray4[i + 1];
        }
        return dArray4;
    }

    @Override
    protected double[] transform(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i] = dArray2[i - 1] + dArray[i];
        }
        return this.incrementTransform.inverse(dArray2, 0, dArray.length);
    }

    @Override
    protected double[] inverse(double[] dArray) {
        dArray = this.incrementTransform.transform(dArray, 0, dArray.length);
        double[] dArray2 = new double[dArray.length];
        dArray2[0] = dArray[0];
        for (int i = 1; i < dArray.length; ++i) {
            dArray2[i] = dArray[i] - dArray[i - 1];
        }
        return dArray2;
    }

    @Override
    protected double getLogJacobian(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected double[] getGradientLogJacobianInverse(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double[][] computeJacobianMatrixInverse(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    protected boolean isInInteriorDomain(double[] dArray) {
        throw new RuntimeException("Not yet implemented.");
    }
}

