/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.memory.structure;

import org.chocosolver.memory.IEnvironment;
import org.chocosolver.memory.IStateBitSet;
import org.chocosolver.memory.IStateInt;

public class OneWordS32BitSet
implements IStateBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 5;
    private static final int BITS_PER_WORD = 32;
    private static final int WORD_MASK = -1;
    private final IStateInt word;

    public OneWordS32BitSet(IEnvironment environment) {
        this.word = environment.makeInt(0);
    }

    private static void checkIndex(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("fromIndex < 0: " + index);
        }
        if (index > 31) {
            throw new IndexOutOfBoundsException("fromIndex > 31: " + index);
        }
    }

    private static void checkRange(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkIndex(fromIndex);
        OneWordS32BitSet.checkIndex(toIndex);
        if (fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " > toIndex: " + toIndex);
        }
    }

    @Override
    public void set(int bitIndex) {
        OneWordS32BitSet.checkIndex(bitIndex);
        this.word.set(this.word.get() | 1 << bitIndex);
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.word.set(this.word.get() | firstWordMask & lastWordMask);
    }

    @Override
    public void clear(int bitIndex) {
        OneWordS32BitSet.checkIndex(bitIndex);
        this.word.set(this.word.get() & ~(1 << bitIndex));
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        OneWordS32BitSet.checkRange(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int firstWordMask = -1 << fromIndex;
        int lastWordMask = -1 >>> -toIndex;
        this.word.set(this.word.get() & ~(firstWordMask & lastWordMask));
    }

    @Override
    public void clear() {
        this.word.set(0);
    }

    @Override
    public final boolean get(int bitIndex) {
        return bitIndex < 32 && (this.word.get() & 1 << bitIndex) != 0;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 32) {
            return -1;
        }
        int word = this.word.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return -1;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex >= 32) {
            return fromIndex;
        }
        int word = ~this.word.get() & -1 << fromIndex;
        if (word != 0) {
            return Integer.numberOfTrailingZeros(word);
        }
        return 32;
    }

    @Override
    public int prevSetBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 32) {
            return this.length() - 1;
        }
        int word = this.word.get() & -1 >>> -(fromIndex + 1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    @Override
    public int prevClearBit(int fromIndex) {
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex >= 32) {
            return fromIndex;
        }
        int word = ~this.word.get() & -1 >>> -(fromIndex + 1);
        if (word != 0) {
            return 31 - Integer.numberOfLeadingZeros(word);
        }
        return -1;
    }

    public int length() {
        return 32 - Integer.numberOfLeadingZeros(this.word.get());
    }

    @Override
    public boolean isEmpty() {
        return this.word.get() == 0;
    }

    @Override
    public int cardinality() {
        return Integer.bitCount(this.word.get());
    }

    public int hashCode() {
        int h = 1234;
        return (h ^= this.word.get()) >> 14 ^ h;
    }

    @Override
    public int size() {
        return 32;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OneWordS32BitSet)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneWordS32BitSet set = (OneWordS32BitSet)obj;
        return this.word == set.word;
    }

    public String toString() {
        StringBuilder b = new StringBuilder(194);
        b.append('{');
        int i = this.nextSetBit(0);
        if (i != -1) {
            b.append(i);
            i = this.nextSetBit(i + 1);
            while (i >= 0) {
                int endOfRun = this.nextClearBit(i);
                do {
                    b.append(", ").append(i);
                } while (++i < endOfRun);
                i = this.nextSetBit(i + 1);
            }
        }
        b.append('}');
        return b.toString();
    }
}

