/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LinearRegression
extends Classifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -3364580862046573747L;
    private double[] m_Coefficients;
    private boolean[] m_SelectedAttributes;
    private Instances m_TransformedData;
    private ReplaceMissingValues m_MissingFilter;
    private NominalToBinary m_TransformFilter;
    private double m_ClassStdDev;
    private double m_ClassMean;
    private int m_ClassIndex;
    private double[] m_Means;
    private double[] m_StdDevs;
    private boolean b_Debug;
    private int m_AttributeSelection;
    public static final int SELECTION_M5 = 0;
    public static final int SELECTION_NONE = 1;
    public static final int SELECTION_GREEDY = 2;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(1, "No attribute selection"), new Tag(0, "M5 method"), new Tag(2, "Greedy method")};
    private boolean m_EliminateColinearAttributes = true;
    private boolean m_checksTurnedOff = false;
    private double m_Ridge = 1.0E-8;

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    public String globalInfo() {
        return "Class for using linear regression for prediction. Uses the Akaike criterion for model selection, and is able to deal with weighted instances.";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        int n;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(instances);
            instances = new Instances(instances);
            instances.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_TransformFilter = new NominalToBinary();
            this.m_TransformFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_TransformFilter);
            this.m_MissingFilter = new ReplaceMissingValues();
            this.m_MissingFilter.setInputFormat(instances);
            instances = Filter.useFilter(instances, this.m_MissingFilter);
            instances.deleteWithMissingClass();
        } else {
            this.m_TransformFilter = null;
            this.m_MissingFilter = null;
        }
        this.m_ClassIndex = instances.classIndex();
        this.m_TransformedData = instances;
        this.m_SelectedAttributes = new boolean[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == this.m_ClassIndex) continue;
            this.m_SelectedAttributes[n] = true;
        }
        this.m_Coefficients = null;
        this.m_Means = new double[instances.numAttributes()];
        this.m_StdDevs = new double[instances.numAttributes()];
        for (n = 0; n < instances.numAttributes(); ++n) {
            if (n == instances.classIndex()) continue;
            this.m_Means[n] = instances.meanOrMode(n);
            this.m_StdDevs[n] = Math.sqrt(instances.variance(n));
            if (this.m_StdDevs[n] != 0.0) continue;
            this.m_SelectedAttributes[n] = false;
        }
        this.m_ClassStdDev = Math.sqrt(instances.variance(this.m_TransformedData.classIndex()));
        this.m_ClassMean = instances.meanOrMode(this.m_TransformedData.classIndex());
        this.findBestModel();
        this.m_TransformedData = new Instances(instances, 0);
    }

    public double classifyInstance(Instance instance) throws Exception {
        Instance instance2 = instance;
        if (!this.m_checksTurnedOff) {
            this.m_TransformFilter.input(instance2);
            this.m_TransformFilter.batchFinished();
            instance2 = this.m_TransformFilter.output();
            this.m_MissingFilter.input(instance2);
            this.m_MissingFilter.batchFinished();
            instance2 = this.m_MissingFilter.output();
        }
        return this.regressionPrediction(instance2, this.m_SelectedAttributes, this.m_Coefficients);
    }

    public String toString() {
        if (this.m_TransformedData == null) {
            return "Linear Regression: No model built yet.";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            boolean bl = true;
            stringBuffer.append("\nLinear Regression Model\n\n");
            stringBuffer.append(this.m_TransformedData.classAttribute().name() + " =\n\n");
            for (int i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
                if (i == this.m_ClassIndex || !this.m_SelectedAttributes[i]) continue;
                if (!bl) {
                    stringBuffer.append(" +\n");
                } else {
                    bl = false;
                }
                stringBuffer.append(Utils.doubleToString(this.m_Coefficients[n], 12, 4) + " * ");
                stringBuffer.append(this.m_TransformedData.attribute(i).name());
                ++n;
            }
            stringBuffer.append(" +\n" + Utils.doubleToString(this.m_Coefficients[n], 12, 4));
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return "Can't print Linear Regression!";
        }
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tProduce debugging output.\n\t(default no debugging output)", "D", 0, "-D"));
        vector.addElement(new Option("\tSet the attribute selection method to use. 1 = None, 2 = Greedy.\n\t(default 0 = M5' method)", "S", 1, "-S <number of selection method>"));
        vector.addElement(new Option("\tDo not try to eliminate colinear attributes.\n", "C", 0, "-C"));
        vector.addElement(new Option("\tSet ridge parameter (default 1.0e-8).\n", "R", 1, "-R <double>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setAttributeSelectionMethod(new SelectedTag(Integer.parseInt(string), TAGS_SELECTION));
        } else {
            this.setAttributeSelectionMethod(new SelectedTag(0, TAGS_SELECTION));
        }
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setRidge(new Double(string2));
        } else {
            this.setRidge(1.0E-8);
        }
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setEliminateColinearAttributes(!Utils.getFlag('C', stringArray));
    }

    public double[] coefficients() {
        double[] dArray = new double[this.m_SelectedAttributes.length + 1];
        int n = 0;
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            if (!this.m_SelectedAttributes[i] || i == this.m_ClassIndex) continue;
            dArray[i] = this.m_Coefficients[n++];
        }
        dArray[this.m_SelectedAttributes.length] = this.m_Coefficients[n];
        return dArray;
    }

    public String[] getOptions() {
        String[] stringArray = new String[6];
        int n = 0;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.getAttributeSelectionMethod().getSelectedTag().getID();
        if (this.getDebug()) {
            stringArray[n++] = "-D";
        }
        if (!this.getEliminateColinearAttributes()) {
            stringArray[n++] = "-C";
        }
        stringArray[n++] = "-R";
        stringArray[n++] = "" + this.getRidge();
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public String ridgeTipText() {
        return "The value of the Ridge parameter.";
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public void setRidge(double d) {
        this.m_Ridge = d;
    }

    public String eliminateColinearAttributesTipText() {
        return "Eliminate colinear attributes.";
    }

    public boolean getEliminateColinearAttributes() {
        return this.m_EliminateColinearAttributes;
    }

    public void setEliminateColinearAttributes(boolean bl) {
        this.m_EliminateColinearAttributes = bl;
    }

    public int numParameters() {
        return this.m_Coefficients.length - 1;
    }

    public String attributeSelectionMethodTipText() {
        return "Set the method used to select attributes for use in the linear regression. Available methods are: no attribute selection, attribute selection using M5's method (step through the attributes removing the one with the smallest standardised coefficient until no improvement is observed in the estimate of the error given by the Akaike information criterion), and a greedy selection using the Akaike information metric.";
    }

    public void setAttributeSelectionMethod(SelectedTag selectedTag) {
        if (selectedTag.getTags() == TAGS_SELECTION) {
            this.m_AttributeSelection = selectedTag.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeSelectionMethod() {
        return new SelectedTag(this.m_AttributeSelection, TAGS_SELECTION);
    }

    public String debugTipText() {
        return "Outputs debug information to the console.";
    }

    public void setDebug(boolean bl) {
        this.b_Debug = bl;
    }

    public boolean getDebug() {
        return this.b_Debug;
    }

    private boolean deselectColinearAttributes(boolean[] blArray, double[] dArray) {
        double d = 1.5;
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            double d2 = Math.abs(dArray[n2] * this.m_StdDevs[i] / this.m_ClassStdDev);
            if (d2 > d) {
                d = d2;
                n = i;
            }
            ++n2;
        }
        if (n >= 0) {
            blArray[n] = false;
            if (this.b_Debug) {
                System.out.println("Deselected colinear attribute:" + (n + 1) + " with standardised coefficient: " + d);
            }
            return true;
        }
        return false;
    }

    private void findBestModel() throws Exception {
        int n = this.m_TransformedData.numInstances();
        if (this.b_Debug) {
            System.out.println(new Instances(this.m_TransformedData, 0).toString());
        }
        do {
            this.m_Coefficients = this.doRegression(this.m_SelectedAttributes);
        } while (this.m_EliminateColinearAttributes && this.deselectColinearAttributes(this.m_SelectedAttributes, this.m_Coefficients));
        int n2 = 1;
        for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
            if (!this.m_SelectedAttributes[i]) continue;
            ++n2;
        }
        double d = this.calculateSE(this.m_SelectedAttributes, this.m_Coefficients);
        double d2 = n - n2 + 2 * n2;
        if (this.b_Debug) {
            System.out.println("Initial Akaike value: " + d2);
        }
        int n3 = n2;
        switch (this.m_AttributeSelection) {
            case 2: {
                boolean bl;
                do {
                    boolean[] blArray = (boolean[])this.m_SelectedAttributes.clone();
                    bl = false;
                    --n3;
                    for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                        if (!blArray[i]) continue;
                        blArray[i] = false;
                        double[] dArray = this.doRegression(blArray);
                        double d3 = this.calculateSE(blArray, dArray);
                        double d4 = d3 / d * (double)(n - n2) + (double)(2 * n3);
                        if (this.b_Debug) {
                            System.out.println("(akaike: " + d4);
                        }
                        if (d4 < d2) {
                            if (this.b_Debug) {
                                System.err.println("Removing attribute " + (i + 1) + " improved Akaike: " + d4);
                            }
                            bl = true;
                            d2 = d4;
                            System.arraycopy(blArray, 0, this.m_SelectedAttributes, 0, this.m_SelectedAttributes.length);
                            this.m_Coefficients = dArray;
                        }
                        blArray[i] = true;
                    }
                } while (bl);
                break;
            }
            case 0: {
                boolean bl;
                do {
                    double d5;
                    bl = false;
                    --n3;
                    double d6 = 0.0;
                    int n4 = -1;
                    int n5 = 0;
                    for (int i = 0; i < this.m_SelectedAttributes.length; ++i) {
                        if (!this.m_SelectedAttributes[i]) continue;
                        d5 = Math.abs(this.m_Coefficients[n5] * this.m_StdDevs[i] / this.m_ClassStdDev);
                        if (n5 == 0 || d5 < d6) {
                            d6 = d5;
                            n4 = i;
                        }
                        ++n5;
                    }
                    if (n4 < 0) continue;
                    this.m_SelectedAttributes[n4] = false;
                    double[] dArray = this.doRegression(this.m_SelectedAttributes);
                    d5 = this.calculateSE(this.m_SelectedAttributes, dArray);
                    double d7 = d5 / d * (double)(n - n2) + (double)(2 * n3);
                    if (this.b_Debug) {
                        System.out.println("(akaike: " + d7);
                    }
                    if (d7 < d2) {
                        if (this.b_Debug) {
                            System.err.println("Removing attribute " + (n4 + 1) + " improved Akaike: " + d7);
                        }
                        bl = true;
                        d2 = d7;
                        this.m_Coefficients = dArray;
                        continue;
                    }
                    this.m_SelectedAttributes[n4] = true;
                } while (bl);
                break;
            }
        }
    }

    private double calculateSE(boolean[] blArray, double[] dArray) throws Exception {
        double d = 0.0;
        for (int i = 0; i < this.m_TransformedData.numInstances(); ++i) {
            double d2 = this.regressionPrediction(this.m_TransformedData.instance(i), blArray, dArray);
            double d3 = d2 - this.m_TransformedData.instance(i).classValue();
            d += d3 * d3;
        }
        return d;
    }

    private double regressionPrediction(Instance instance, boolean[] blArray, double[] dArray) throws Exception {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (this.m_ClassIndex == i || !blArray[i]) continue;
            d += dArray[n] * instance.value(i);
            ++n;
        }
        return d += dArray[n];
    }

    private double[] doRegression(boolean[] blArray) throws Exception {
        int n;
        Object object;
        int n2;
        if (this.b_Debug) {
            System.out.print("doRegression(");
            for (n2 = 0; n2 < blArray.length; ++n2) {
                System.out.print(" " + blArray[n2]);
            }
            System.out.println(" )");
        }
        n2 = 0;
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            ++n2;
        }
        Matrix matrix = null;
        Matrix matrix2 = null;
        double[] dArray = null;
        if (n2 > 0) {
            int n3;
            matrix = new Matrix(this.m_TransformedData.numInstances(), n2);
            matrix2 = new Matrix(this.m_TransformedData.numInstances(), 1);
            for (n3 = 0; n3 < this.m_TransformedData.numInstances(); ++n3) {
                object = this.m_TransformedData.instance(n3);
                n = 0;
                for (int i = 0; i < this.m_TransformedData.numAttributes(); ++i) {
                    if (i == this.m_ClassIndex) {
                        matrix2.setElement(n3, 0, ((Instance)object).classValue());
                        continue;
                    }
                    if (!blArray[i]) continue;
                    double d = ((Instance)object).value(i) - this.m_Means[i];
                    if (!this.m_checksTurnedOff) {
                        d /= this.m_StdDevs[i];
                    }
                    matrix.setElement(n3, n, d);
                    ++n;
                }
            }
            dArray = new double[this.m_TransformedData.numInstances()];
            for (n3 = 0; n3 < dArray.length; ++n3) {
                dArray[n3] = this.m_TransformedData.instance(n3).weight();
            }
        }
        double[] dArray2 = new double[n2 + 1];
        if (n2 > 0) {
            object = matrix.regression(matrix2, dArray, this.m_Ridge);
            System.arraycopy(object, 0, dArray2, 0, n2);
        }
        dArray2[n2] = this.m_ClassMean;
        int n4 = 0;
        for (n = 0; n < this.m_TransformedData.numAttributes(); ++n) {
            if (n == this.m_TransformedData.classIndex() || !blArray[n]) continue;
            if (!this.m_checksTurnedOff) {
                int n5 = n4;
                dArray2[n5] = dArray2[n5] / this.m_StdDevs[n];
            }
            int n6 = dArray2.length - 1;
            dArray2[n6] = dArray2[n6] - dArray2[n4] * this.m_Means[n];
            ++n4;
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        LinearRegression.runClassifier(new LinearRegression(), stringArray);
    }
}

