/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.solver;

import ilog.concert.IloNumVar;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import ru.itmo.ctlab.virgo.gmwcs.graph.Elem;

public class CplexSolution {
    private List<IloNumVar> variables = new LinkedList<IloNumVar>();
    private List<Double> values = new LinkedList<Double>();

    public IloNumVar[] variables() {
        return this.variables.toArray(new IloNumVar[0]);
    }

    public double[] values() {
        return this.values.stream().mapToDouble(d -> d).toArray();
    }

    <U extends Elem> void addVariable(Map<U, IloNumVar> map, U elem, double val) {
        this.addVariable(map.get(elem), val);
    }

    void addVariable(IloNumVar var, double val) {
        this.variables.add(var);
        this.values.add(val);
    }

    void addNullVariables(IloNumVar ... vars) {
        for (IloNumVar var : vars) {
            this.addVariable(var, 0.0);
        }
    }

    boolean apply(BiFunction<IloNumVar[], double[], Boolean> set) {
        double[] vals = new double[this.values.size()];
        for (int i = 0; i < this.values.size(); ++i) {
            vals[i] = this.values.get(i);
        }
        return set.apply(this.variables.toArray(new IloNumVar[0]), vals);
    }
}

