/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.GL;
import vcf.Marker;
import vcf.Markers;

public class GLSampleHapPairs
implements SampleHapPairs {
    private final GL gl;

    public GLSampleHapPairs(GL gL) {
        if (!gL.isRefData()) {
            throw new IllegalArgumentException("gl.isRefData()==false");
        }
        this.gl = gL;
    }

    @Override
    public Samples samples() {
        return this.gl.samples();
    }

    @Override
    public int nSamples() {
        return this.gl.nSamples();
    }

    @Override
    public int allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.gl.allele1(n, n3);
        }
        return this.gl.allele2(n, n3);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.gl.allele1(n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.gl.allele2(n, n2);
    }

    @Override
    public int nMarkers() {
        return this.gl.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.gl.markers();
    }

    @Override
    public Marker marker(int n) {
        return this.gl.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.gl.nSamples();
    }

    @Override
    public int nHapPairs() {
        return this.gl.nSamples();
    }

    @Override
    public Samples samples(int n) {
        if (n < 0 || n >= this.gl.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.gl.samples();
    }

    @Override
    public int sampleIndex(int n) {
        if (n < 0 || n >= this.gl.nSamples()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return n;
    }

    @Override
    public int nAlleles(int n) {
        return this.gl.marker(n).nAlleles();
    }

    @Override
    public boolean storesNonMajorIndices(int n) {
        return false;
    }

    @Override
    public int majorAllele(int n) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int alleleCount(int n, int n2) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }

    @Override
    public int hapIndex(int n, int n2, int n3) {
        String string = "this.storesNonMajorIndices(marker)==false";
        throw new UnsupportedOperationException(string);
    }
}

