/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.tstoolkit.timeseries.simplets.TsData;

public class CochranTest {
    private final TsData ts_;
    private boolean isMulti_ = false;
    private double[] s_;
    private double tw_;
    private double tt_;
    boolean I1_ = true;
    private int nminNumberOfYears = 0;
    private static final double[] t12 = new double[]{0.541, 0.3934, 0.3264, 0.288, 0.2624, 0.2439, 0.2299, 0.2187, 0.2098, 0.202, 0.198, 0.194, 0.186, 0.182, 0.178, 0.174, 0.17, 0.166, 0.162, 0.158, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.15, 0.1403, 0.14, 0.14, 0.14, 0.14};
    private static final double[] t4 = new double[]{0.9065, 0.7679, 0.6841, 0.6287, 0.5895, 0.5598, 0.5365, 0.5175, 0.5017, 0.4884, 0.48, 0.471, 0.463, 0.454, 0.445, 0.4366, 0.433, 0.43, 0.427, 0.424, 0.421, 0.417, 0.414, 0.411, 0.408, 0.404, 0.401, 0.398, 0.395, 0.391, 0.388, 0.385, 0.382, 0.379, 0.375, 0.372, 0.369, 0.366, 0.362, 0.359};
    private static final double[] t2 = new double[]{0.9985, 0.975, 0.9392, 0.9057, 0.8772, 0.8534, 0.8332, 0.8159, 0.801, 0.788, 0.7765, 0.7662, 0.757, 0.7487, 0.7411, 0.7341, 0.7278, 0.7219, 0.7164, 0.7114, 0.7066, 0.7022, 0.698, 0.6941, 0.6904, 0.6869, 0.6836, 0.6805, 0.6775, 0.6747, 0.672, 0.6694, 0.6669, 0.6646, 0.6623, 0.6601, 0.658, 0.656, 0.6541, 0.6522};

    public CochranTest(TsData tsData, Boolean isMulti) {
        this.ts_ = tsData;
        this.isMulti_ = isMulti;
    }

    public void calcCochranTest() {
        int Ib = this.ts_.getStart().getPosition();
        boolean blngoto = true;
        int Ny = this.ts_.getFrequency().intValue();
        this.s_ = new double[Ny];
        this.tw_ = 0.0;
        double smax = -10.0;
        int nmin = 100;
        double st = 0.0;
        if (this.isMulti_) {
            st = 1.0;
        }
        for (int i = 0; i <= Ny - 1; ++i) {
            int n1 = 1;
            int j = i;
            int iPeriode = i + Ib;
            if (iPeriode > Ny - 1) {
                iPeriode -= Ny;
            }
            this.s_[iPeriode] = 0.0;
            blngoto = true;
            do {
                if (!Double.isNaN(this.ts_.get(j))) {
                    this.s_[iPeriode] = this.s_[iPeriode] + (this.ts_.get(j) - st) * (this.ts_.get(j) - st);
                    ++n1;
                }
                if ((j += Ny) <= this.ts_.getLength() - 1) continue;
                if (nmin > n1 - 3) {
                    nmin = n1 - 3;
                }
                this.s_[iPeriode] = this.s_[iPeriode] / (double)(n1 - 1);
                if (smax < this.s_[iPeriode]) {
                    smax = this.s_[iPeriode];
                }
                this.tw_ += this.s_[iPeriode];
                blngoto = false;
            } while (blngoto);
        }
        if (this.tw_ != 0.0) {
            this.tw_ = smax / this.tw_;
        }
        this.nminNumberOfYears = nmin + 1;
        if (nmin > 39) {
            nmin = 39;
        }
        this.tt_ = t12[nmin];
        if (Ny == 4) {
            this.tt_ = t4[nmin];
        } else if (Ny == 2) {
            this.tt_ = t2[nmin];
        }
        if (this.tw_ >= this.tt_) {
            this.I1_ = false;
        }
    }

    public double getCriticalValue() {
        return this.tt_;
    }

    public double getTestValue() {
        return this.tw_;
    }

    public double[] getS() {
        return this.s_;
    }

    public boolean getTestResult() {
        return this.I1_;
    }

    public int getMinNumberOfYearsPerPeriod() {
        return this.nminNumberOfYears;
    }
}

