/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.ParamValidation;

public class ParametersRange
implements IParametersDomain {
    private int m_np;
    private double m_a;
    private double m_b;
    private boolean m_excluded;
    private double m_eps = 1.0E-6;

    public ParametersRange(double a, double b, boolean excluded) {
        this.m_np = 1;
        this.m_a = a;
        this.m_b = b;
        this.m_excluded = excluded;
    }

    public ParametersRange(int nparams, double a, double b, boolean excluded) {
        this.m_np = nparams;
        this.m_a = a;
        this.m_b = b;
        this.m_excluded = excluded;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock inparams) {
        for (int i = 0; i < this.m_np; ++i) {
            double v = inparams.get(i);
            if (!(this.m_excluded ? v <= this.m_a || v >= this.m_b : v < this.m_a || v > this.m_b)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        double eps = (this.m_b - this.m_a) * this.m_eps;
        if (inparams.get(idx) + eps >= this.m_b) {
            eps = -eps;
        }
        return eps;
    }

    public double getDelta() {
        return this.m_eps;
    }

    @Override
    public int getDim() {
        return this.m_np;
    }

    @Override
    public double lbound(int idx) {
        return this.m_excluded ? this.m_a + this.m_eps : this.m_a;
    }

    public void setDelta(double value) {
        this.m_eps = value;
    }

    @Override
    public double ubound(int idx) {
        return this.m_excluded ? this.m_b - this.m_eps : this.m_b;
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        ParamValidation rslt = ParamValidation.Valid;
        for (int i = 0; i < this.m_np; ++i) {
            double v = ioparams.get(i);
            if (this.m_excluded) {
                double eps;
                if (v <= this.m_a) {
                    eps = (this.m_b - this.m_a) * this.m_eps;
                    ioparams.set(i, this.m_a + eps);
                    rslt = ParamValidation.Changed;
                    continue;
                }
                if (!(v >= this.m_b)) continue;
                eps = (this.m_b - this.m_a) * this.m_eps;
                ioparams.set(i, this.m_b - eps);
                rslt = ParamValidation.Changed;
                continue;
            }
            if (v < this.m_a) {
                ioparams.set(i, this.m_a);
                rslt = ParamValidation.Changed;
                continue;
            }
            if (!(v > this.m_b)) continue;
            ioparams.set(i, this.m_b);
            rslt = ParamValidation.Changed;
        }
        return rslt;
    }

    @Override
    public String getDescription(int idx) {
        return "parameter " + idx;
    }
}

