/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.multiexprtree;

import net.sourceforge.jclec.IConfigure;
import net.sourceforge.jclec.ISpecies;
import net.sourceforge.jclec.base.AbstractRecombinator;
import net.sourceforge.jclec.exprtree.ExprTree;
import net.sourceforge.jclec.exprtree.ExprTreeSchema;
import net.sourceforge.jclec.exprtree.IRecombineExprTree;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeIndividual;
import net.sourceforge.jclec.multiexprtree.MultiExprTreeSpecies;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationRuntimeException;

public class MultiExprTreeRecombinator
extends AbstractRecombinator
implements IConfigure {
    protected int targetTreeIndex = -1;
    protected IRecombineExprTree baseOp;
    protected transient MultiExprTreeSpecies species;
    protected transient ExprTreeSchema[] schema;

    public int getTargetTreeIndex() {
        return this.targetTreeIndex;
    }

    public void setTargetTreeIndex(int targetTreeIndex) {
        this.targetTreeIndex = targetTreeIndex;
    }

    public IRecombineExprTree getBaseOp() {
        return this.baseOp;
    }

    public void setBaseOp(IRecombineExprTree baseOp) {
        this.baseOp = baseOp;
    }

    @Override
    public void configure(Configuration settings) {
        int targetTreeIndex = settings.getInt("target-tree-index", -1);
        this.setTargetTreeIndex(targetTreeIndex);
        try {
            String baseOpClassname = settings.getString("base-op[@type]");
            Class<?> baseOpClass = Class.forName(baseOpClassname);
            IRecombineExprTree baseOp = (IRecombineExprTree)baseOpClass.newInstance();
            if (baseOp instanceof IConfigure) {
                ((IConfigure)((Object)baseOp)).configure(settings.subset("base-op"));
            }
            this.setBaseOp(baseOp);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationRuntimeException("Illegal operator classname");
        }
        catch (InstantiationException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationRuntimeException("Problems creating an instance of operator", e);
        }
    }

    @Override
    protected void setPpl() {
        this.ppl = 2;
    }

    @Override
    protected void setSpl() {
        this.spl = 2;
    }

    @Override
    protected void prepareRecombination() {
        ISpecies spc = this.context.getSpecies();
        if (!(spc instanceof MultiExprTreeSpecies)) {
            throw new IllegalStateException("Illegal species in context");
        }
        this.species = (MultiExprTreeSpecies)spc;
        this.schema = ((MultiExprTreeSpecies)spc).getGenotypeSchema();
    }

    @Override
    protected void recombineNext() {
        int nOfExprTrees = this.species.numberOfExprTrees();
        int actTargetExprIndex = this.targetTreeIndex == -1 ? this.randgen.choose(0, nOfExprTrees) : this.targetTreeIndex;
        ExprTree[] p0_genotype = (ExprTree[])((MultiExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter)).getGenotype();
        ExprTree[] p1_genotype = (ExprTree[])((MultiExprTreeIndividual)this.parentsBuffer.get(this.parentsCounter + 1)).getGenotype();
        ExprTree[] s0_genotype = new ExprTree[nOfExprTrees];
        ExprTree[] s1_genotype = new ExprTree[nOfExprTrees];
        int i = 0;
        while (i < nOfExprTrees) {
            s0_genotype[i] = new ExprTree();
            s1_genotype[i] = new ExprTree();
            ++i;
        }
        i = 0;
        while (i < nOfExprTrees) {
            if (i == actTargetExprIndex) {
                this.baseOp.recombine(p0_genotype[i], p1_genotype[i], s0_genotype[i], s1_genotype[i], this.schema[i], this.randgen);
            } else {
                s0_genotype[i] = p0_genotype[i].copy();
                s1_genotype[i] = p1_genotype[i].copy();
            }
            ++i;
        }
        this.sonsBuffer.add(this.species.createIndividual(s0_genotype));
        this.sonsBuffer.add(this.species.createIndividual(s1_genotype));
    }
}

