## ----echo=FALSE, include=FALSE--------------------------------------------------------------------------------------
opts_chunk$set(opts_fig_wide)
opts_knit$set(concordance=TRUE)
opts_knit$set(unnamed.chunk.label = 'calculator-chunk')


## ----numbers-0------------------------------------------------------------------------------------------------------
(3 + exp(2)) / sin(pi)


## ----numbers-00-----------------------------------------------------------------------------------------------------
1 + 2 * 3
1 + (2 * 3)
(1 + 2) * 3




## ----numbers-2------------------------------------------------------------------------------------------------------
a <- 1
a + 1
a
b <- 10
b <- a + b
b
3e-2 * 2.0


## ----numbers-2a-----------------------------------------------------------------------------------------------------
a
print(a)
a + 1
print(a + 1)




## ----classes-01-----------------------------------------------------------------------------------------------------
mode(1)
a <- 1
is.numeric(a)


## ----classes-02-----------------------------------------------------------------------------------------------------
is.numeric(1L)
is.integer(1L)
is.double(1L)


## ----classes-03-----------------------------------------------------------------------------------------------------
is.numeric(1)
is.integer(1)
is.double(1)


## ----numbers-4------------------------------------------------------------------------------------------------------
a <- c(3, 1, 2)
a
b <- c(4, 5, 0)
b
c <- c(a, b)
c
d <- c(b, a)
d


## ----numbers-4a-----------------------------------------------------------------------------------------------------
append(a, b)


## ----numbers-4b-----------------------------------------------------------------------------------------------------
append(a, values = b, after = 2L)




## ----numbers-6------------------------------------------------------------------------------------------------------
a + 1 # we add one to vector a defined above
(a + 1) * 2
a + b
a - a


## ----numbers-6a-----------------------------------------------------------------------------------------------------
a <- rep(1, 6)
a
a + 1:2
a + 1:3
a + 1:4


## -------------------------------------------------------------------------------------------------------------------
z <- numeric(0)
z
length(z)


## -------------------------------------------------------------------------------------------------------------------
length(c(a, numeric(0), b))
length(c(a, b))


## -------------------------------------------------------------------------------------------------------------------
log(numeric(0))
5 + numeric(0)


## ----numbers-7------------------------------------------------------------------------------------------------------
ls(pattern="^z$")
rm(z)
ls(pattern="^z$")


## ----numbers-8------------------------------------------------------------------------------------------------------
a <- NA
a
-1 / 0
1 / 0
Inf / Inf
Inf + 4
b <- -Inf
b * -1


## ----numbers-8a-----------------------------------------------------------------------------------------------------
A <- NA
A
A + 1
A + Inf




## ----numbers-8b-----------------------------------------------------------------------------------------------------
is.na(c(NA, 1))


## ----numbers-9------------------------------------------------------------------------------------------------------
1 - 1e-20


## ----integers-1-----------------------------------------------------------------------------------------------------
1L + 3L
1L * 3L
1L %/% 3L
1L %% 3L
1L / 3L


## ----integers-1a----------------------------------------------------------------------------------------------------
1000000L * 1000000L


## ----integers-2-----------------------------------------------------------------------------------------------------
is.numeric(1L)
is.integer(1L)
is.double(1L)
is.double(1L / 3L)
is.numeric(1L / 3L)




## ----convert-3, tidy=FALSE------------------------------------------------------------------------------------------
round(0.0124567, digits = 3)
signif(0.0124567, digits = 3)
round(1789.1234, digits = 3)
signif(1789.1234, digits = 3)
round(1789.1234, digits = -1)
a <- 0.12345
b <- round(a, digits = 2)
a == b
a - b
b


## ----convert-3a, tidy=FALSE-----------------------------------------------------------------------------------------
round(0.0124567, digits = 3)
round(0.0124567, 3)


## ----logical-1------------------------------------------------------------------------------------------------------
a <- TRUE
b <- FALSE
mode(a)
a
!a # negation
a && b # logical AND
a || b # logical OR
xor(a, b) # exclusive OR


## ----logical-2------------------------------------------------------------------------------------------------------
a <- c(TRUE,FALSE)
b <- c(TRUE,TRUE)
a
b
a & b # vectorized AND
a | b # vectorized OR
a && b # not vectorized
a || b # not vectorized


## -------------------------------------------------------------------------------------------------------------------
any(a)
all(a)
any(a & b)
all(a & b)


## ----logical-3------------------------------------------------------------------------------------------------------
TRUE || NA
FALSE || NA
TRUE && NA
FALSE && NA
TRUE && FALSE && NA
TRUE && TRUE && NA


## ----logical-4------------------------------------------------------------------------------------------------------
a & b & NA
a & b & c(NA, NA)
a | b | c(NA, NA)




## ----comparison-1---------------------------------------------------------------------------------------------------
1.2 > 1.0
1.2 >= 1.0
1.2 == 1.0 # be aware that here we use two = symbols
1.2 != 1.0
1.2 <= 1.0
1.2 < 1.0
a <- 20
a < 100 && a > 10


## ----comparison-2---------------------------------------------------------------------------------------------------
a <- 1:10
a > 5
a < 5
a == 5
all(a > 5)
any(a > 5)
b <- a > 5
b
any(b)
all(b)


## ----comparison-2a--------------------------------------------------------------------------------------------------
a > 2 + 3
(a > 2) + 3




## ----comparison-3---------------------------------------------------------------------------------------------------
c <- c(a, NA)
c > 5
all(c > 5)
any(c > 5)
all(c < 20)
any(c > 20)
is.na(a)
is.na(c)
any(is.na(c))
all(is.na(c))


## ----comparison-4---------------------------------------------------------------------------------------------------
all(c < 20)
any(c > 20)
all(c < 20, na.rm=TRUE)
any(c > 20, na.rm=TRUE)


## ----numbers-EB9----------------------------------------------------------------------------------------------------
0 - 1e-20
1 - 1e-20


## ----comparison-5---------------------------------------------------------------------------------------------------
1e20 == 1 + 1e20
1 == 1 + 1e-20
0 == 1e-20


## ----machine-eps-01-------------------------------------------------------------------------------------------------
.Machine$double.eps
.Machine$double.neg.eps
.Machine$double.max
.Machine$double.min


## ----machine-eps-02-------------------------------------------------------------------------------------------------
1e1026
1e-1026
Inf + 1
-Inf + 1


## ----machine-eps-03, warning=TRUE-----------------------------------------------------------------------------------
.Machine$integer.max
2147483699L


## ----machine-eps-04-------------------------------------------------------------------------------------------------
2147483600L + 99L
2147483600L + 99
2147483600L * 2147483600L
2147483600L * 2147483600


## ----machine-eps-05-------------------------------------------------------------------------------------------------
2147483600L * 2147483600L
2147483600L^2L


## ----machine-eps-06-------------------------------------------------------------------------------------------------
a == 0.0 # may not always work
abs(a) < 1e-15 # is safer


## ----machine-eps-06a------------------------------------------------------------------------------------------------
sin(pi) == 0.0 # angle in radians, not degrees!
sin(2 * pi) == 0.0
abs(sin(pi)) < 1e-15
abs(sin(2 * pi)) < 1e-15
sin(pi)
sin(2 * pi)


## ----sets-00--------------------------------------------------------------------------------------------------------
fruits <- c("apple", "pear", "orange", "lemon", "tangerine")
bakery <- c("bread", "buns", "cake", "cookies")
dairy <- c("milk", "butter", "cheese")
shopping <- c("bread", "butter", "apple", "cheese", "orange")
intersect(fruits, shopping)
intersect(bakery, shopping)
intersect(dairy, shopping)
"lemon" %in% dairy
"lemon" %in% fruits
setdiff(union(bakery, dairy), shopping)


## ----sets-01--------------------------------------------------------------------------------------------------------
my.set <- c("a", "b", "c", "b")


## ----sets-02--------------------------------------------------------------------------------------------------------
"a" %in% my.set
c("a", "a", "z") %in% my.set


## ----sets-02a-------------------------------------------------------------------------------------------------------
!"a" %in% my.set
!c("a", "a", "z") %in% my.set


## ----sets-PG00, eval=FALSE------------------------------------------------------------------------------------------
## x <- c("a", "a", "z")
## x == "a" | x == "b" | x == "c" | x == "d"


## ----sets-03--------------------------------------------------------------------------------------------------------
unique(my.set)
c("a", "a", "z") %in% unique(my.set)


## ----sets-04--------------------------------------------------------------------------------------------------------
union(c("a", "a", "z"), my.set)


## ----sets-05--------------------------------------------------------------------------------------------------------
intersect(c("a", "a", "z"), my.set)




## ----sets-EB01------------------------------------------------------------------------------------------------------
9L %in% 2L:4L
9L %in% ((2L:4L) * (2L:4L))
c(1L, 16L) %in% ((2L:4L) * (2L:4L))


## ----sets-EB02------------------------------------------------------------------------------------------------------
length(integer())


## ----sets-EB02a-----------------------------------------------------------------------------------------------------
1L %in% integer()
setdiff(1L:4L, union(1L:4L, integer()))


## ----sets-EB03------------------------------------------------------------------------------------------------------
9 %in% (2:4)^2
c(1, 5) %in% (1:10)^2


## ----char-1---------------------------------------------------------------------------------------------------------
a <- "A"
a
b <- 'A'
b
a == b


## ----char-1a--------------------------------------------------------------------------------------------------------
a <- 'A'
b <- "bcdefg"
c <- "123"
d <- c(a, b, c)
d


## ----char-3---------------------------------------------------------------------------------------------------------
a <- "He said 'hello' when he came in"
a
b <- 'He said "hello" when he came in'
b


## ----char-4---------------------------------------------------------------------------------------------------------
c <- "abc\ndef\tx\"yz\"\\\tm"
print(c)
cat(c)


## ----mode-1---------------------------------------------------------------------------------------------------------
my_var <- 1:5
mode(my_var) # no distinction of integer or double
typeof(my_var)
is.numeric(my_var) # no distinction of integer or double
is.double(my_var)
is.integer(my_var)
is.logical(my_var)
is.character(my_var)
my_var <- "abc"
mode(my_var)


## ----mode-2---------------------------------------------------------------------------------------------------------
class(my_var)
inherits(my_var, "character")
inherits(my_var, "numeric")


## ----convert-1------------------------------------------------------------------------------------------------------
as.character(1)
as.numeric("1")
as.logical("TRUE")
as.logical("NA")


## ----convert-1a-----------------------------------------------------------------------------------------------------
TRUE + 10
1 || 0
FALSE | -2:2




## ----convert-2------------------------------------------------------------------------------------------------------
f <- c("1", "2", "3")
length(f)
g <- "123"
length(g)
as.numeric(f)
as.numeric(g)


## ----convert-5------------------------------------------------------------------------------------------------------
x = c(123.4567890, 1.0)
format(x) # using defaults
format(x[1]) # using defaults
format(x[2]) # using defaults
format(x, digits = 3, nsmall = 1)
format(x[1], digits = 3, nsmall = 1)
format(x[2], digits = 3, nsmall = 1)
format(x, digits = 3, scientific = TRUE)


## ----convert-6------------------------------------------------------------------------------------------------------
x = c(123.4567890, 1.0)
sprintf("The numbers are: %4.2f and %.0f", x[1], x[2])
sprintf("The numbers are: %.4g and %.2g", x[1], x[2])
sprintf("The numbers are: %4.2e and %.0e", x[1], x[2])


## ----nas-01---------------------------------------------------------------------------------------------------------
a <- c(1, NA)
is.numeric(a[2])
is.numeric(NA)
b <- c("abc", NA)
is.character(b[2])
is.character(NA)
class(NA)


## ----nas-02---------------------------------------------------------------------------------------------------------
a[3] <- b[2]


## ----vectors-1------------------------------------------------------------------------------------------------------
a <- letters[1:10]
a
a[2]


## ----vectors-2------------------------------------------------------------------------------------------------------
a[c(3,2)]
a[10:1]




## ----vectors-3------------------------------------------------------------------------------------------------------
a[-2]
a[-c(3,2)]
a[-3:-2]




## ----vectors-6------------------------------------------------------------------------------------------------------
a[TRUE]
a[FALSE]
a[c(TRUE, FALSE)]
a[c(FALSE, TRUE)]
a > "c"
a[a > "c"]






## ----vectors-7------------------------------------------------------------------------------------------------------
a <- 1:10
a
a[1] <- 99
a

b <- 1:10
b[c(2,4)] <- -99 # recycling
b

c <- 1:10
c[c(2,4)] <- c(-99, 99)
c

d <- 1:10
d[TRUE] <- 1 # recycling
d

e <- 1:10
e <- 1  # no recycling
e


## ----vectors-8------------------------------------------------------------------------------------------------------
a <- letters[1:10]
a[1:2] <- a[2:1]
a


## ----vectors-8a-----------------------------------------------------------------------------------------------------
a <- letters[1:10]
a[5:1] <- a[c(TRUE,FALSE)]
a


## ----vectors-9------------------------------------------------------------------------------------------------------
b <- LETTERS[1:10]
b[1]
b[1.1]
b[1.9999] # surprise!!
b[2]


## ----vectors-9a-----------------------------------------------------------------------------------------------------
b <- LETTERS[1:10]
b[-1]
b[-1.1]
b[-1.9999]
b[-2]


## ----vectors-10-----------------------------------------------------------------------------------------------------
my.vector <- c(10, 4, 22, 1, 4)
sort(my.vector)
sort(my.vector, decreasing = TRUE)


## ----vectors-11-----------------------------------------------------------------------------------------------------
order(my.vector)
my.vector[order(my.vector)]
another.vector <- c("ab", "aa", "c", "zy", "e")
another.vector[order(my.vector)]


## ----vectors-EB21---------------------------------------------------------------------------------------------------
my.letters <- letters[c(1,5,10,3,1,4,21,1,10)]
my.letters
sort(my.letters)
rle(sort(my.letters))


## ----vector-cleanup, include=FALSE----------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----matrix-01------------------------------------------------------------------------------------------------------
matrix(1:15, ncol = 3)
matrix(1:15, nrow = 3)






## ----matrix-PG00b, eval=FALSE---------------------------------------------------------------------------------------
## matrix(1:15, ncol = 2)


## ----matrix-10------------------------------------------------------------------------------------------------------
A <- matrix(1:20, ncol = 4)
A
A[1, 1]


## ----matrix-11------------------------------------------------------------------------------------------------------
A[1, ]
A[ , 1]
A[2:3, c(1,3)]
A[3, 4] <- 99
A
A[4:3, 2:1] <- A[3:4, 1:2]
A


## ----dimensions-box-01----------------------------------------------------------------------------------------------
my.vector <- 1:6
dim(my.vector)


## ----dimensions-box-02----------------------------------------------------------------------------------------------
one.col.matrix <- matrix(1:6, ncol = 1)
dim(one.col.matrix)
two.col.matrix <- matrix(1:6, ncol = 2)
dim(two.col.matrix)
one.elem.matrix <- matrix(1, ncol = 1)
dim(one.elem.matrix)
no.elem.matrix <- matrix(numeric(), ncol = 0)
dim(no.elem.matrix)


## ----matrix-21------------------------------------------------------------------------------------------------------
B <- array(1:27, dim = c(3, 3, 3))
B
B[2, 2, 2]






## ----matrix-31------------------------------------------------------------------------------------------------------
A <- matrix(1:20, ncol = 4)
A
t(A)


## ----matrix-32------------------------------------------------------------------------------------------------------
A + 2
A * 0:1
A * 1:0


## ----matrix-33------------------------------------------------------------------------------------------------------
B <- matrix(1:16, ncol = 4)
B * B
B %*% B


## ----matrix-cleanup, include=FALSE----------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----factors-1------------------------------------------------------------------------------------------------------
my.vector <- c("treated", "treated", "control", "control", "control", "treated")
my.factor <- factor(my.vector)
my.factor
my.factor <- factor(x = my.vector, levels = c("treated", "control"))
my.factor


## ----factors-1a-----------------------------------------------------------------------------------------------------
my.vector <- c(1, 1, 0, 0, 0, 1)
my.factor <- factor(x = my.vector, levels = c(1, 0), labels = c("treated", "control"))
my.factor


## ----factors-1b-----------------------------------------------------------------------------------------------------
levels(my.factor)
control.factor <- my.factor[my.factor == "control"]
control.factor
control.factor <- factor(control.factor)
control.factor


## ----factors-bx-01--------------------------------------------------------------------------------------------------
gl(2, 5, labels = c("A", "B"))


## ----factors-2------------------------------------------------------------------------------------------------------
my.vector2 <- rep(3:5, 4)
my.vector2
my.factor2 <- factor(my.vector2)
my.factor2
as.numeric(my.factor2)
as.numeric(as.character(my.factor2))


## ----factors-eb2----------------------------------------------------------------------------------------------------
class(my.factor2)
mode(my.factor2)


## ----factors-2a-----------------------------------------------------------------------------------------------------
my.factor1 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
my.factor1
levels(my.factor1) <- c("a", "b", "c", "d")
my.factor1


## ----factors-2b-----------------------------------------------------------------------------------------------------
my.factor1 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
my.factor1
levels(my.factor1) <- list("a" = "A", "d" = "Z", "c" = "B", "b" = "F")
my.factor1


## ----factors-2c-----------------------------------------------------------------------------------------------------
my.factor1 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
my.factor1


## ----factors-2cc----------------------------------------------------------------------------------------------------
levels(my.factor1)[c(1, 4)] <- c("a", "d")
my.factor1


## ----factors-2d-----------------------------------------------------------------------------------------------------
my.factor1 <- gl(4, 3, labels = c("A", "F", "B", "Z"))
my.factor1
factor(my.factor1,
       levels = c("A", "B", "F", "Z"),
       labels = c("A", "B", "C", "C"))


## ----factors-3------------------------------------------------------------------------------------------------------
levels(my.factor2)
my.factor2 <- factor(my.factor2, levels = c("5", "3", "4"))
levels(my.factor2)
my.factor2 <- factor(my.factor2, levels = rev(levels(my.factor2)))
levels(my.factor2)


## ----factors-3a-----------------------------------------------------------------------------------------------------
my.factor2 <- factor(my.factor2,
                     levels = sort(levels(my.factor2), decreasing = TRUE))
levels(my.factor2)
my.factor2 <- factor(my.factor2, levels = levels(my.factor2)[c(2, 1, 3)])
levels(my.factor2)


## ----factors-4------------------------------------------------------------------------------------------------------
my.factor3 <- gl(2, 5, labels = c("A", "B"))
my.vector3 <- c(5.6, 7.3, 3.1, 8.7, 6.9, 2.4, 4.5, 2.1, 1.4, 2.0)
levels(my.factor3)
my.factor3ord <- reorder(my.factor3, my.vector3)
levels(my.factor3ord)
my.factor3rev <- reorder(my.factor3, -my.vector3) # a simple trick
levels(my.factor3rev)






## ----factors-cleanup, include=FALSE---------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----lists-0--------------------------------------------------------------------------------------------------------
a.list <- list(x = 1:6, y = "a", z = c(TRUE, FALSE))
a.list


## ----lists-1--------------------------------------------------------------------------------------------------------
a.list$x
a.list[["x"]]
a.list[[1]]
a.list["x"]
a.list[1]
a.list[c(1,3)]
try(a.list[[c(1,3)]])


## ----lists-1a-------------------------------------------------------------------------------------------------------
str(a.list)


## ----lists-1b-------------------------------------------------------------------------------------------------------
another.list <- append(a.list, list(yy = 1:10, zz = letters[5:1]), 2L)
another.list


## ----lists-1c-------------------------------------------------------------------------------------------------------
a.list$y <- NULL
a.list


## ----lists-2--------------------------------------------------------------------------------------------------------
a.list <- list("a", "aa", "aaa")
b.list <- list("b", "bb")
nested.list <- list(A = a.list, B = b.list)
str(nested.list)


## ----lists-EB1b-----------------------------------------------------------------------------------------------------
str(nested.list, max.level = 1)


## ----lists-3--------------------------------------------------------------------------------------------------------
nested.list <- list(A = list("a", "aa", "aaa"), B = list("b", "bb"))
str(nested.list)


## ----lists-PG4, eval=FALSE------------------------------------------------------------------------------------------
## nested.list <- list(A = list("a", "aa", "aaa"), B = list("b", "bb"))
## str(nested.list)
## nested.list[2:1]
## nested.list[1]
## nested.list[[1]][2]
## nested.list[[1]][[2]]
## nested.list[2]
## nested.list[2][[1]]


## ----lists-5--------------------------------------------------------------------------------------------------------
c.vec <- unlist(nested.list)
c.vec
is.list(nested.list)
is.list(c.vec)
mode(nested.list)
mode(c.vec)
names(nested.list)
names(c.vec)


## ----lists-6--------------------------------------------------------------------------------------------------------
str(c.vec)
c.vec[2]
c.vec["A2"]


## ----lists-7--------------------------------------------------------------------------------------------------------
unname(c.vec)


## ----lists-cleanup, include=FALSE-----------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----data-frames-0--------------------------------------------------------------------------------------------------
a.df <- data.frame(x = 1:6, y = "a", z = c(TRUE, FALSE))
a.df
str(a.df)
class(a.df)
mode(a.df)
is.data.frame(a.df)
is.list(a.df)


## ----data-frames-1--------------------------------------------------------------------------------------------------
a.df$x
a.df[["x"]]
a.df[[1]]
class(a.df)


## ----data-frames-2--------------------------------------------------------------------------------------------------
a.df$x2 <- 6:1
a.df$x3 <- "b"
str(a.df)


## ----data-frames-2a-------------------------------------------------------------------------------------------------
a.ls <- list(x = 1:6, y = "a", z = c(TRUE, FALSE))
str(a.ls)
a.ls$x2 <- 6:1
a.ls$x3 <- "b"
str(a.ls)


## ----data-frames-bx-01----------------------------------------------------------------------------------------------
a.df[[1]][2:3]


## ----data-frames-bx-02----------------------------------------------------------------------------------------------
a.df[["x"]][2:3]


## ----data-frames-bx-03----------------------------------------------------------------------------------------------
a.df[2:3, 1:2]


## ----data-frames-bx-04----------------------------------------------------------------------------------------------
a.df[2:3, 1]


## ----data-frames-3--------------------------------------------------------------------------------------------------
# first column, a.df[[1]] preferred
a.df[ , 1]
# first column, a.df[["x"]] or a.df$x preferred
a.df[ , "x"]
# first row
a.df[1, ]
# first two rows of the third and fourth columns
a.df[1:2, c(FALSE, FALSE, TRUE, TRUE, FALSE)]
# the rows for which z is true
a.df[a.df$z , ]
# the rows for which x > 3 keeping all columns except the third one
a.df[a.df$x > 3, -3]


## ----data-frames-3a-------------------------------------------------------------------------------------------------
a.df[1, 1] <- 99
a.df
a.df[ , 1] <- -99
a.df
a.df[["x"]] <- 123
a.df
a.df[1, 1] <- a.df[6, 4]
a.df


## ----index-partial-1------------------------------------------------------------------------------------------------
x.list <- list(abcd = 123, xyzw = 789)
x.list[["abcd"]]
a.var <- "abcd"
x.list[[a.var]]


## ----index-partial-1a-----------------------------------------------------------------------------------------------
x.list$abcd
x.list$ab
x.list$a


## ----data-frames-4--------------------------------------------------------------------------------------------------
a.df <- data.frame(x = 1:6, y = "a", z = c(TRUE, FALSE))
subset(a.df, x > 3)


## ----data-frames-5--------------------------------------------------------------------------------------------------
subset(a.df, x > 3)[ , -3]
subset(a.df, x > 3)$x


## ----data-frames-5a-------------------------------------------------------------------------------------------------
A <- 1
subset(a.df, A > 3)


## ----data-frames-6--------------------------------------------------------------------------------------------------
aa.df <- a.df
colnames(aa.df)
aa.df[["y"]] <- NULL
colnames(aa.df)


## ----data-frames-6a-------------------------------------------------------------------------------------------------
a.df[ , -which(colnames(a.df) == "y")]




## ----data-frames-EB-10----------------------------------------------------------------------------------------------
my_data_frame.df <- data.frame(A = 1:10, B = 3)
my_data_frame.df$C <-
  (my_data_frame.df$A + my_data_frame.df$B) / my_data_frame.df$A
head(my_data_frame.df, 2)


## ----data-frames-EB-11----------------------------------------------------------------------------------------------
my_data_frame.df$C <- NULL
attach(my_data_frame.df)
my_data_frame.df$C <- (A + B) / A
detach(my_data_frame.df)
head(my_data_frame.df, 2)


## ----data-frames-EB-12----------------------------------------------------------------------------------------------
my_data_frame.df$C <- NULL
my_data_frame.df$C <- with(my_data_frame.df, (A + B) / A)
head(my_data_frame.df, 2)


## ----data-frames-EB-13----------------------------------------------------------------------------------------------
my_data_frame.df$C <- NULL
my_data_frame.df <- within(my_data_frame.df,  C <- (A + B) / A)
head(my_data_frame.df, 2)


## ----data-frames-EB-14----------------------------------------------------------------------------------------------
my_data_frame.df$C <- NULL
my_data_frame.df <- within(my_data_frame.df,
                           {C <- (A + B) / A
                            D <- A * B
                            E <- A / B + 1}
                           )
head(my_data_frame.df, 2)


## ----data-frames-8--------------------------------------------------------------------------------------------------
my_data_frame.df <- data.frame(A = 1:10, B = 3)
head(my_data_frame.df, 2)
my_data_frame.df[ , 1:2] <- my_data_frame.df[ , 2:1]
head(my_data_frame.df, 2)
colnames(my_data_frame.df)[1:2] <- colnames(my_data_frame.df)[2:1]
head(my_data_frame.df, 2)


## ----data-frames-cleanup,echo=FALSE,cache=FALSE---------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----attributes-01--------------------------------------------------------------------------------------------------
a.df <- data.frame(x = 1:6, y = "a", z = c(TRUE, FALSE))
comment(a.df)
comment(a.df) <- "this is stored as a comment"
comment(a.df)


## ----attributes-02--------------------------------------------------------------------------------------------------
names(a.df)
names(a.df) <- toupper(names(a.df))
names(a.df)
attr(a.df, "names") # same as previous line
attr(a.df, "my.attribute") <- "this is stored in my attribute"
attributes(a.df)


## ----attributes_WB1-------------------------------------------------------------------------------------------------
numbers <- 1:10
class(numbers)
attributes(numbers)


## ----attributes_WB1a------------------------------------------------------------------------------------------------
a.factor <- factor(numbers)
class(a.factor)
attributes(a.factor)


## ----attributes-cleanup, include=FALSE------------------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))


## ----data-1---------------------------------------------------------------------------------------------------------
data(cars)


## ----rda-01---------------------------------------------------------------------------------------------------------
my.df <- data.frame(x = 1:5, y = 5:1)
my.df
save(my.df, file = "my-df.rda")


## ----rda-02---------------------------------------------------------------------------------------------------------
rm(my.df)
ls(pattern = "my.df")


## ----rda-03---------------------------------------------------------------------------------------------------------
load(file = "my-df.rda")
ls(pattern = "my.df")
my.df


## ----rda-04---------------------------------------------------------------------------------------------------------
objcts <- ls(pattern = "*.df")
save(list = objcts, file = "my-df1.rda")


## ----rda-05---------------------------------------------------------------------------------------------------------
save(list = ls(pattern = "*.df"), file = "my-df1.rda")


## ----rda-06---------------------------------------------------------------------------------------------------------
unlink(c("my-df.rda", "my-df1.rda"))


## ----rds-1----------------------------------------------------------------------------------------------------------
saveRDS(my.df, "my-df.rds")


## ----rds-1a---------------------------------------------------------------------------------------------------------
readRDS("my-df.rds")


## ----rds-2----------------------------------------------------------------------------------------------------------
my_read.df <- readRDS("my-df.rds")
identical(my.df, my_read.df)


## ----rds-03---------------------------------------------------------------------------------------------------------
unlink("my-df.rds")


## ----exploring-dfs-1------------------------------------------------------------------------------------------------
class(cars)
nrow(cars)
ncol(cars)
names(cars)
head(cars)
tail(cars)
str(cars)


## ----exploring-dfs-2------------------------------------------------------------------------------------------------
sapply(X = cars, FUN = class)


## ----exploring-dfs-3------------------------------------------------------------------------------------------------
summary(cars)
sapply(cars, range)


## ----plot-0, include=FALSE, cache=FALSE-----------------------------------------------------------------------------
opts_chunk$set(opts_fig_narrow_square)


## ----plot-1---------------------------------------------------------------------------------------------------------
plot(x = cars$speed, y = cars$dist)


## ----plot-2---------------------------------------------------------------------------------------------------------
plot(dist ~ speed, data = cars)


## ----plot-3---------------------------------------------------------------------------------------------------------
plot(weight ~ feed, data = chickwts)


## ----gr-devices-01--------------------------------------------------------------------------------------------------
pdf(file = "output/my-file.pdf", width = 6, height = 5, onefile = TRUE)
plot(dist ~ speed, data = cars)
plot(weight ~ feed, data = chickwts)
dev.off()


## ----gr-devices-02--------------------------------------------------------------------------------------------------
png(file = "output/my-file.png", width = 600, height = 500)
plot(weight ~ feed, data = chickwts)
dev.off()


## ----gr-devices-03--------------------------------------------------------------------------------------------------
png(file = "output/my-file.png", width = 600, height = 500)
plot(dist ~ speed, data = cars)
text(x = 10, y = 110, labels = "some texts to be added")
dev.off()


## ----calculator-chapter-cleanup, include=FALSE----------------------------------------------------------------------
rm(list = setdiff(ls(pattern="*"), to.keep))

