/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import com.qarks.util.Cancellable;
import com.qarks.util.stream.StreamCopyListener;
import com.qarks.util.ui.DialogUtilities;
import com.qarks.util.ui.resources.ResourceKey;
import com.qarks.util.ui.resources.ResourceManager;
import com.qarks.util.ui.swing.CenteredPanel;
import com.qarks.util.ui.swing.SpringLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;

public class StreamCopyDialog
extends JDialog
implements StreamCopyListener,
ActionListener {
    private JButton ok;
    private JButton cancel;
    private JProgressBar progress;
    private Window parent;
    private boolean showOk;
    private long lengthCopied;
    private Timer timer;
    private Cancellable cancellable;

    public StreamCopyDialog(Window window, Cancellable cancellable, boolean bl) {
        super(window, "", Dialog.ModalityType.APPLICATION_MODAL);
        this.cancellable = cancellable;
        this.parent = window;
        this.showOk = bl;
        this.lengthCopied = 0L;
        this.ok = new JButton(ResourceManager.getString((Object)ResourceKey.OK));
        this.ok.setEnabled(false);
        this.cancel = new JButton(ResourceManager.getString((Object)ResourceKey.CANCEL));
        this.progress = new JProgressBar();
        this.progress.setPreferredSize(new Dimension(200, 30));
        this.timer = new Timer(200, this);
        Container container = this.getContentPane();
        container.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        container.add(jPanel);
        JPanel jPanel2 = new JPanel(new SpringLayout(SpringLayout.Type.HORIZONTAL, 5));
        jPanel.add((Component)this.progress, "Center");
        if (bl || cancellable != null) {
            jPanel2.add(this.ok);
            jPanel2.add(this.cancel);
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            jPanel.add((Component)new CenteredPanel(jPanel2), "South");
        }
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.ok) {
            this.dispose();
        } else if (object == this.cancel) {
            this.cancellable.cancel();
        } else if (object == this.timer) {
            this.progress.setValue((int)this.lengthCopied / 1000);
        }
    }

    @Override
    public void onFileCopyEnded(File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (StreamCopyDialog.this.showOk) {
                    StreamCopyDialog.this.ok.setEnabled(true);
                } else {
                    StreamCopyDialog.this.dispose();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void onFileCopyEnding(File file) {
    }

    @Override
    public void onFileCopyStart(final File file) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StreamCopyDialog.this.setTitle(file.getName());
                StreamCopyDialog.this.progress.setMaximum((int)(file.length() / 1000L));
                StreamCopyDialog.this.progress.setValue(0);
                StreamCopyDialog.this.timer.start();
                if (!StreamCopyDialog.this.isShowing()) {
                    DialogUtilities.centerWindow(StreamCopyDialog.this, StreamCopyDialog.this.parent);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void onLengthChanged(long l) {
        this.lengthCopied = l;
    }

    @Override
    public void onLengthChanged(long l, long l2) {
        this.lengthCopied = l;
    }
}

