/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.arithmetic;

import java.util.Iterator;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.VariableUtils;

public class UnCArExpression
implements ArExpression {
    Model model;
    IntVar me = null;
    ArExpression.Operator op;
    private final ArExpression e1;
    private final int e2;

    public UnCArExpression(ArExpression.Operator op, ArExpression e1, int e2) {
        this.op = op;
        this.e1 = e1;
        this.e2 = e2;
        this.model = e1.getModel();
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public ArExpression.Operator getOp() {
        return this.op;
    }

    @Override
    public IntVar intVar() {
        if (this.me == null) {
            IntVar v1 = this.e1.intVar();
            switch (this.op) {
                case ADD: {
                    this.me = this.model.intOffsetView(v1, this.e2);
                    break;
                }
                case SUB: {
                    this.me = this.model.intOffsetView(v1, -this.e2);
                    break;
                }
                case MUL: {
                    if (this.e2 > 0) {
                        this.me = this.model.intScaleView(v1, this.e2);
                        break;
                    }
                    int[] bounds = new int[]{Math.min(v1.getLB() * this.e2, v1.getUB() * this.e2), Math.max(v1.getLB() * this.e2, v1.getUB() * this.e2)};
                    this.me = this.model.intVar(this.model.generateName("mul_exp_"), bounds[0], bounds[1]);
                    this.model.times(v1, this.e2, this.me).post();
                    break;
                }
                case DIV: {
                    IntVar v2 = this.model.intVar(this.e2);
                    int[] bounds = VariableUtils.boundsForDivision(v1, v2);
                    this.me = this.model.intVar(this.model.generateName("div_exp_"), bounds[0], bounds[1]);
                    this.model.div(v1, v2, this.me).post();
                    break;
                }
                case MOD: {
                    int min = v1.stream().map(v -> v % this.e2).min().orElse(0);
                    int max = v1.stream().map(v -> v % this.e2).max().orElse(v1.getDomainSize());
                    this.me = this.model.intVar(this.model.generateName("mod_exp_"), min, max);
                    this.model.mod(v1, this.e2, this.me).post();
                    break;
                }
                case POW: {
                    int min = v1.stream().map(v -> (int)Math.floor(Math.pow(v, this.e2))).min().orElse(-21474836);
                    int max = v1.stream().map(v -> (int)Math.ceil(Math.pow(v, this.e2))).max().orElse(21474836);
                    this.me = this.model.intVar(this.model.generateName("pow_exp_"), min, max);
                    Tuples tuples = new Tuples(true);
                    Iterator iterator = v1.iterator();
                    while (iterator.hasNext()) {
                        int val1 = (Integer)iterator.next();
                        int res = (int)Math.pow(val1, this.e2);
                        if (!this.me.contains(res)) continue;
                        tuples.add(val1, res);
                    }
                    this.model.table(new IntVar[]{v1, this.me}, tuples).post();
                    break;
                }
                case MIN: {
                    this.me = this.model.intVar(this.model.generateName("min_exp_"), Math.min(v1.getLB(), this.e2), Math.min(v1.getUB(), this.e2));
                    this.model.min(this.me, v1, this.model.intVar(this.e2)).post();
                    break;
                }
                case MAX: {
                    this.me = this.model.intVar(this.model.generateName("max_exp_"), Math.max(v1.getLB(), this.e2), Math.max(v1.getUB(), this.e2));
                    this.model.max(this.me, v1, this.model.intVar(this.e2)).post();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
                }
            }
        }
        return this.me;
    }

    @Override
    public int ieval(int[] values, Map<IntVar, Integer> map) {
        return this.op.eval(this.e1.ieval(values, map), this.e2);
    }

    @Override
    public int getNoChild() {
        return 1;
    }

    @Override
    public ArExpression[] getExpressionChild() {
        return new ArExpression[]{this.e1};
    }

    public String toString() {
        return this.op.name() + "(" + this.e1.toString() + "," + this.e2 + ")";
    }
}

