/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.GroupShape;
import org.apache.poi.sl.usermodel.Shape;

public class DrawGroupShape
extends DrawShape {
    public DrawGroupShape(GroupShape<?, ?> shape) {
        super(shape);
    }

    @Override
    public void draw(Graphics2D graphics) {
        Rectangle interior = this.getShape().getInteriorAnchor();
        Rectangle exterior = this.getShape().getAnchor();
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        AffineTransform tx0 = new AffineTransform(tx);
        double scaleX = ((RectangularShape)interior).getWidth() == 0.0 ? 1.0 : ((RectangularShape)exterior).getWidth() / ((RectangularShape)interior).getWidth();
        double scaleY = ((RectangularShape)interior).getHeight() == 0.0 ? 1.0 : ((RectangularShape)exterior).getHeight() / ((RectangularShape)interior).getHeight();
        tx.translate(((RectangularShape)exterior).getX(), ((RectangularShape)exterior).getY());
        tx.scale(scaleX, scaleY);
        tx.translate(-((RectangularShape)interior).getX(), -((RectangularShape)interior).getY());
        DrawFactory drawFact = DrawFactory.getInstance(graphics);
        AffineTransform at2 = graphics.getTransform();
        Iterator i$ = this.getShape().iterator();
        while (i$.hasNext()) {
            Shape child = (Shape)i$.next();
            AffineTransform at = graphics.getTransform();
            graphics.setRenderingHint(Drawable.GSAVE, true);
            Drawable draw = drawFact.getDrawable(child);
            draw.applyTransform(graphics);
            draw.draw(graphics);
            graphics.setTransform(at);
            graphics.setRenderingHint(Drawable.GRESTORE, true);
        }
        graphics.setTransform(at2);
        graphics.setRenderingHint(Drawable.GROUP_TRANSFORM, tx0);
    }

    protected GroupShape<?, ?> getShape() {
        return (GroupShape)this.shape;
    }
}

