/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.evolutionary_algorithms;

public abstract class Cromosoma {
    protected int tamCromosoma;
    protected int[] rep;
    protected double fitness;

    public Cromosoma(int tam) {
        if (tam <= 1) {
            System.err.println("ERROR: Chromosome length must be greater than 1");
            System.exit(0);
        }
        this.fitness = -1.0;
        this.tamCromosoma = tam;
        this.rep = new int[tam];
        for (int i = 0; i < this.tamCromosoma; ++i) {
            this.rep[i] = -1;
        }
    }

    public abstract void initRand();

    public abstract void initPlantilla(Cromosoma var1, double var2);

    public abstract int devolverGen(int var1);

    public abstract void cambiarGen(int var1, int var2);

    public abstract void cruzar(Cromosoma var1, Cromosoma var2, Cromosoma var3);

    public abstract boolean cruzarHUX(Cromosoma var1, Cromosoma var2, Cromosoma var3, int var4);

    public abstract void mutar();

    public abstract String print();

    public abstract boolean[] devolverFeaturesVector();

    public void setFitness(double calidad) {
        this.fitness = calidad;
    }

    public double getFitness() {
        return this.fitness;
    }

    public int devolverTamCromosoma() {
        return this.tamCromosoma;
    }

    public boolean isEqual(Cromosoma cr) {
        if (this.tamCromosoma != cr.devolverTamCromosoma()) {
            System.err.println("ERROR: Chromosome length isn't equal");
            System.exit(0);
        }
        for (int i = 0; i < this.tamCromosoma; ++i) {
            if (this.rep[i] == cr.devolverGen(i)) continue;
            return false;
        }
        return true;
    }

    public void copy(Cromosoma cr) {
        if (this.tamCromosoma != cr.devolverTamCromosoma()) {
            System.err.println("ERROR: Chromosome length isn't equal");
            System.exit(0);
        }
        for (int i = 0; i < this.tamCromosoma; ++i) {
            this.rep[i] = cr.devolverGen(i);
        }
        this.fitness = cr.getFitness();
    }
}

