/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jclec.realarray.mut;

import net.sourceforge.jclec.realarray.UniformMutator;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RandomRangeMutator
extends UniformMutator {
    private static final long serialVersionUID = 6674358495153190338L;
    protected double interval;

    public double getInterval() {
        return this.interval;
    }

    public void setInterval(double interval) {
        this.interval = interval;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double interval = settings.getDouble("[@interval]", 2.0);
        this.setInterval(interval);
    }

    public boolean equals(Object other) {
        if (other instanceof RandomRangeMutator) {
            RandomRangeMutator o = (RandomRangeMutator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.interval, o.interval);
            eb.append(this.locusMutProb, o.locusMutProb);
            return eb.isEquals();
        }
        return false;
    }

    @Override
    protected double defaultLocusMutProb() {
        return 0.6;
    }

    @Override
    protected void doLocusMutation(double[] parentChromosome, double[] mutantChromosome, int locusIndex) {
        double newValue = parentChromosome[locusIndex] + this.randgen.uniform(-this.interval, this.interval);
        mutantChromosome[locusIndex] = this.genotypeSchema[locusIndex].nearestOf(newValue);
    }
}

