/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent.demographicmodel;

import dr.evolution.coalescent.DemographicFunction;
import dr.evolution.coalescent.TwoEpochDemographic;
import dr.evolution.util.Units;
import dr.evomodel.coalescent.demographicmodel.DemographicModel;
import dr.inference.model.Parameter;

public class TwoEpochDemographicModel
extends DemographicModel {
    private Parameter transitionTimeParameter = null;
    private DemographicModel demo1 = null;
    private DemographicModel demo2 = null;

    public TwoEpochDemographicModel(DemographicModel demographicModel, DemographicModel demographicModel2, Parameter parameter, Units.Type type) {
        this("twoEpoch", demographicModel, demographicModel2, parameter, type);
    }

    public TwoEpochDemographicModel(String string, DemographicModel demographicModel, DemographicModel demographicModel2, Parameter parameter, Units.Type type) {
        super(string);
        int n;
        this.demo1 = demographicModel;
        this.addModel(demographicModel);
        for (n = 0; n < demographicModel.getVariableCount(); ++n) {
            this.addVariable((Parameter)demographicModel.getVariable(n));
        }
        this.demo2 = demographicModel2;
        this.addModel(demographicModel2);
        for (n = 0; n < demographicModel2.getVariableCount(); ++n) {
            this.addVariable((Parameter)demographicModel2.getVariable(n));
        }
        this.transitionTimeParameter = parameter;
        this.addVariable(parameter);
        this.setUnits(type);
    }

    @Override
    public DemographicFunction getDemographicFunction() {
        TwoEpochDemographic twoEpochDemographic = new TwoEpochDemographic(this.demo1.getDemographicFunction(), this.demo2.getDemographicFunction(), this.getUnits());
        twoEpochDemographic.setTransitionTime(this.transitionTimeParameter.getParameterValue(0) - this.getTimeOffset());
        return twoEpochDemographic;
    }
}

