/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.modelling.arima.x13;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.maths.linearfilters.BackFilter;
import ec.tstoolkit.modelling.arima.IPreprocessingModule;
import ec.tstoolkit.modelling.arima.ModellingContext;
import ec.tstoolkit.modelling.arima.ProcessingResult;
import ec.tstoolkit.modelling.arima.x13.ArmaModule;
import ec.tstoolkit.modelling.arima.x13.DifferencingModule;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.sarima.SarmaSpecification;

public class AutoModel
implements IPreprocessingModule {
    private final DifferencingModule iddiff = new DifferencingModule();
    private final ArmaModule amdid = new ArmaModule();

    public double getEpsilon() {
        return this.iddiff.getEpsilon();
    }

    public void setEpsilon(double val) {
        this.iddiff.setEpsilon(val);
        this.amdid.setEpsilon(val);
    }

    public boolean isBalanced() {
        return this.amdid.isBalanced();
    }

    public void setBalanced(boolean balanced) {
        this.amdid.setBalanced(balanced);
    }

    public boolean isMixed() {
        return this.amdid.isMixed();
    }

    public void setMixed(boolean mixed) {
        this.amdid.setMixed(mixed);
    }

    @Override
    public ProcessingResult process(ModellingContext context) {
        int freq = context.description.getFrequency();
        if (context.estimation == null) {
            return ProcessingResult.Failed;
        }
        SarimaSpecification curspec = context.description.getSpecification();
        SarimaSpecification nspec = new SarimaSpecification(curspec.getFrequency());
        boolean nmean = false;
        try {
            DataBlock dres;
            DataBlock res = context.estimation.getLinearizedData();
            this.iddiff.process(res, freq, 0, 0);
            int nd = this.iddiff.getD();
            int nbd = this.iddiff.getBD();
            nmean = this.iddiff.isMeanCorrection();
            if (nd != 0 || nbd != 0) {
                BackFilter ur = this.iddiff.getDifferencingFilter();
                dres = new DataBlock(res.getLength() - ur.getDegree());
                ur.filter(res, dres);
            } else {
                dres = res;
            }
            SarmaSpecification rsltSpec = this.amdid.select(dres, curspec.getFrequency(), curspec.getFrequency() == 2 ? 1 : 2, 1, nd, nbd);
            nspec.copy(rsltSpec);
            nspec.setD(nd);
            nspec.setBD(nbd);
        }
        catch (RuntimeException err) {
            nspec.airline();
        }
        boolean changed = false;
        if (!curspec.equals((Object)nspec)) {
            context.description.setSpecification(nspec);
            changed = true;
        }
        if (nmean != context.description.isEstimatedMean()) {
            context.description.setMean(nmean);
            changed = true;
        }
        if (changed) {
            context.estimation = null;
            return ProcessingResult.Changed;
        }
        return ProcessingResult.Unchanged;
    }

    static SarimaSpecification calcmaxspec(int freq, int inic, int d, int bd) {
        SarimaSpecification spec = new SarimaSpecification(freq);
        spec.setD(d);
        spec.setBD(bd);
        spec.setP(2);
        spec.setQ(2);
        if (spec.getFrequency() > 1) {
            spec.setBP(1);
            spec.setBQ(1);
        }
        return spec;
    }
}

