/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import JFlex.Main;
import com.hp.hpl.jena.iri.ViolationCodes;
import com.hp.hpl.jena.iri.impl.Expansion;
import com.hp.hpl.jena.iri.impl.VarPattern;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;

class PatternCompiler
implements ViolationCodes {
    static VarPattern[] ipLiteral = new VarPattern[]{new VarPattern("\\[@{ipVFuture}\\]"), new VarPattern("\\[@{ipV6Address}\\]"), new VarPattern("\\[[^]*", 25)};
    static VarPattern[] ipVFuture = new VarPattern[]{new VarPattern("v@{lowerHexDig}+\\.[-a-zA-Z0-9._~!$&'()*+,;=:]*")};
    static VarPattern[] ipV6Address = new VarPattern[]{new VarPattern("((@{h16}:){6}@{ls32}|::(@{h16}:){5}@{ls32}|@{h16}?::(@{h16}:){4}@{ls32}|((@{h16}:){0,1}@{h16})?::(@{h16}:){3}@{ls32}|((@{h16}:){0,2}@{h16})?::(@{h16}:){2}@{ls32}|((@{h16}:){0,3}@{h16})?::(@{h16}:){1}@{ls32}|((@{h16}:){0,4}@{h16})?::@{ls32}|((@{h16}:){0,5}@{h16})?::@{h16}|((@{h16}:){0,6}@{h16})?::)")};
    static VarPattern[] h16 = new VarPattern[]{new VarPattern("@{lowerHexDig}{1,4}")};
    static VarPattern[] ls32 = new VarPattern[]{new VarPattern("(@{h16}:@{h16}|@{ipV4Address})")};
    static VarPattern[] ipV4Address = new VarPattern[]{new VarPattern("(@{decOctet}\\.){3}@{decOctet}"), new VarPattern("([0-9]+\\.){3}[0-9]+", 28), new VarPattern("[0-9\\.]+\\.[0-9\\.]+", 27)};
    static VarPattern[] decOctet = new VarPattern[]{new VarPattern("([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])")};
    static VarPattern[] regname = new VarPattern[]{new VarPattern("(@{label}\\.)*@{label}"), new VarPattern("[^]*", 29)};
    static VarPattern[] host = new VarPattern[]{new VarPattern("@{ipLiteral}"), new VarPattern("@{ipV4Address}"), new VarPattern("@{regname}")};
    static VarPattern[] lowerHexDig = new VarPattern[]{new VarPattern("[0-9a-f]"), new VarPattern("[0-9A-Fa-f]", 26)};
    static VarPattern[] label = new VarPattern[]{new VarPattern("@{labelPrefix}(@{labelInside}@{labelPostfix})?")};
    static VarPattern[] labelInside = new VarPattern[]{new VarPattern("@{labelSingleDashInside}?"), new VarPattern("(@{labelChar}|-)*", 20)};
    static VarPattern[] labelPrefix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 34), new VarPattern("@{labelChar}|@{acePrefix}", 32), new VarPattern("@{labelChar}|@{acePrefix}|-", new int[]{32, 34})};
    static VarPattern[] labelPostfix = new VarPattern[]{new VarPattern("@{labelChar}"), new VarPattern("-|@{labelChar}", 34)};
    static VarPattern[] labelSingleDashInside = new VarPattern[]{new VarPattern("(@{labelChar}+-)*@{labelChar}+")};
    static VarPattern[] acePrefix = new VarPattern[]{new VarPattern("@{letterDigit}{2}--")};
    static VarPattern[] letterDigit = new VarPattern[]{new VarPattern("[a-z0-9]"), new VarPattern("[a-zA-Z0-9]", 11)};
    static VarPattern[] labelChar = new VarPattern[]{new VarPattern("@{unreservedDNSLabel}")};
    static VarPattern[] unreservedDNSLabel = new VarPattern[]{new VarPattern("@{letterDigit}|_"), new VarPattern("@{letterDigit}|[_\\x80-\\uFFFF]", 22)};
    static long start;
    static String[] eCodeNames;
    static int count;
    static Writer out;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    PatternCompiler() {
    }

    public static void main(String[] args) throws IOException {
        start = System.currentTimeMillis();
        PatternCompiler.outRules("host");
        System.out.println(System.currentTimeMillis() - start);
    }

    private static void copy(String fname) throws IOException {
        int sz;
        FileReader in = new FileReader(fname);
        char[] buf = new char[2048];
        while ((sz = in.read(buf)) != -1) {
            out.write(buf, 0, sz);
        }
        ((Reader)in).close();
    }

    static VarPattern[] lookup(String name) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.hp.hpl.jena.iri.impl.PatternCompiler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field f = clazz.getDeclaredField(name);
            return (VarPattern[])f.get(null);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static String errorCodeName(int j) {
        if (eCodeNames == null) {
            eCodeNames = new String[200];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.hp.hpl.jena.iri.ViolationCodes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field[] f = clazz.getDeclaredFields();
            int i = 0;
            while (i < f.length) {
                try {
                    PatternCompiler.eCodeNames[f[i].getInt(null)] = f[i].getName();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return eCodeNames[j];
    }

    private static void outRules(String name) throws IOException {
        count = 0;
        out = new FileWriter("src/com/hp/hpl/jena/iri/impl/" + name + ".jflex");
        PatternCompiler.copy("src/com/hp/hpl/jena/iri/impl/iri.jflex");
        out.write("%class Lexer");
        out.write(name.substring(0, 1).toUpperCase());
        out.write(name.substring(1));
        out.write("\n%%\n");
        int[] exc1 = new int[]{20, 29};
        int[] empty = new int[]{};
        int[] sub1 = new int[]{32};
        int[] sub4 = new int[]{20};
        int[] sub3 = new int[]{29};
        new ExpandAndOutput(exc1, empty, true).expand("@{" + name + "}");
        new ExpandAndOutput(sub1, sub4, true).expand("@{" + name + "}");
        new ExpandAndOutput(empty, sub3, true).expand("@{" + name + "}");
        out.write("\n");
        System.out.println(String.valueOf(name) + ": " + count + " expansions");
        out.close();
        Main.main((String[])new String[]{"src/com/hp/hpl/jena/iri/impl/" + name + ".jflex"});
        System.out.println(System.currentTimeMillis() - start);
    }

    private static final class ExpandAndOutput
    extends Expansion {
        int[] exc;
        int[] sub;
        boolean incExc;
        int ruleCount = 1;

        ExpandAndOutput(int[] exclude, int[] subset, boolean incExc) {
            this.exc = exclude;
            this.sub = subset;
            this.incExc = incExc;
        }

        void doIt(String regex, int eCount, int[] eCodes, int cCount, String[] c) {
            if (this.incExc == (!this.overlap(this.exc, eCount, eCodes) && this.subset(this.sub, eCount, eCodes))) {
                try {
                    out.write("/*\n");
                    int j = 0;
                    while (j < cCount) {
                        out.write(c[j]);
                        out.write(10);
                        ++j;
                    }
                    out.write("*/\n");
                    out.write(regex);
                    out.write(" {\n");
                    out.write("rule(" + ++count + "); ");
                    int i = 0;
                    while (i < eCount) {
                        out.write("error(" + PatternCompiler.errorCodeName(eCodes[i]) + ");");
                        ++i;
                    }
                    out.write("}\n");
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private boolean subset(int[] ee, int el, int[] eCodes) {
            int i = 0;
            while (i < ee.length) {
                if (!this.in(ee[i], el, eCodes)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private boolean overlap(int[] ee, int el, int[] eCodes) {
            int i = 0;
            while (i < ee.length) {
                if (this.in(ee[i], el, eCodes)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean in(int e0, int eCount, int[] eCodes) {
            int i = 0;
            while (i < eCount) {
                if (eCodes[i] == e0) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

