/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Basic;

import keel.Algorithms.Preprocess.Basic.Metodo;
import keel.Algorithms.Preprocess.Basic.Referencia;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import org.core.Files;

public class KNN {
    public static void writeOutput(String filename, int[][] realClass, int[][] prediction, Attribute[] inputs, Attribute output, String relation) {
        int j;
        int i;
        String text = "";
        text = text + "@relation " + relation + "\n";
        for (i = 0; i < inputs.length; ++i) {
            text = text + "@attribute " + inputs[i].getName() + " ";
            if (inputs[i].getType() == 0) {
                text = text + "{";
                for (j = 0; j < inputs[i].getNominalValuesList().size(); ++j) {
                    text = text + (String)inputs[i].getNominalValuesList().elementAt(j);
                    if (j >= inputs[i].getNominalValuesList().size() - 1) continue;
                    text = text + ", ";
                }
                text = text + "}\n";
                continue;
            }
            text = inputs[i].getType() == 1 ? text + "integer" : text + "real";
            text = text + " [" + String.valueOf(inputs[i].getMinAttribute()) + ", " + String.valueOf(inputs[i].getMaxAttribute()) + "]\n";
        }
        text = text + "@attribute " + output.getName() + " ";
        if (output.getType() == 0) {
            text = text + "{";
            for (int j2 = 0; j2 < output.getNominalValuesList().size(); ++j2) {
                text = text + (String)output.getNominalValuesList().elementAt(j2);
                if (j2 >= output.getNominalValuesList().size() - 1) continue;
                text = text + ", ";
            }
            text = text + "}\n";
        } else {
            text = text + "integer [" + String.valueOf(output.getMinAttribute()) + ", " + String.valueOf(output.getMaxAttribute()) + "]\n";
        }
        text = text + "@data\n";
        Files.writeFile(filename, text);
        if (output.getType() == 1) {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + realClass[i][j] + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + prediction[i][j] + " ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        } else {
            text = "";
            for (i = 0; i < realClass.length; ++i) {
                for (j = 0; j < realClass[0].length; ++j) {
                    text = text + "" + (String)output.getNominalValuesList().elementAt(realClass[i][j]) + " ";
                }
                for (j = 0; j < realClass[0].length; ++j) {
                    text = prediction[i][j] > -1 ? text + "" + (String)output.getNominalValuesList().elementAt(prediction[i][j]) + " " : text + "Unclassified ";
                }
                text = text + "\n";
                if (i % 10 != 9) continue;
                Files.addToFile(filename, text);
                text = "";
            }
            if (realClass.length % 10 != 0) {
                Files.addToFile(filename, text);
            }
        }
    }

    protected static double distance(double[] instance1, double[] instance2) {
        double length = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            length += (instance1[i] - instance2[i]) * (instance1[i] - instance2[i]);
        }
        length = Math.sqrt(length);
        return length;
    }

    public static int evaluate(double[] example, double[][] trainData, int nClasses, int[] trainOutput, int k) {
        int i;
        int[] nearestN = new int[k];
        double[] minDist = new double[k];
        for (i = 0; i < k; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < trainData.length; ++i) {
            double dist = KNN.distance(trainData[i], example);
            if (!(dist > 0.0)) continue;
            boolean stop = false;
            for (int j = 0; j < k && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = k - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        int[] selectedClasses = new int[nClasses];
        for (i = 0; i < nClasses; ++i) {
            selectedClasses[i] = 0;
        }
        for (i = 0; i < k; ++i) {
            int n = trainOutput[nearestN[i]];
            selectedClasses[n] = selectedClasses[n] + 1;
        }
        int prediction = 0;
        int predictionValue = selectedClasses[0];
        for (i = 1; i < nClasses; ++i) {
            if (predictionValue >= selectedClasses[i]) continue;
            predictionValue = selectedClasses[i];
            prediction = i;
        }
        return prediction;
    }

    public static int evaluacionKNN(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        return KNN.evaluacionKNN2(nvec, conj, clases, ejemplo, nClases);
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        return votada;
    }

    public static int[] evaluacionKNN3(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] vecinosCercanos = new int[nvec];
        int[] clasesVecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            clasesVecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < vecinosCercanos.length; ++j) {
            if (vecinosCercanos[j] == -1) continue;
            clasesVecinosCercanos[j] = clases[vecinosCercanos[j]];
        }
        return clasesVecinosCercanos;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases, Referencia nVotos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        nVotos.entero = votaciones;
        return votada;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, int[] clases, double[] ejemplo, int nClases, int[] vecinos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], ejemplo);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    public static double distancia(double[] ej1, double[] ej2) {
        double suma = 0.0;
        for (int i = 0; i < ej1.length; ++i) {
            suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
        }
        suma = Math.sqrt(suma);
        return suma;
    }

    public static double distancia2(double[] ej1, double[] ej2) {
        double suma = 0.0;
        for (int i = 0; i < ej1.length; ++i) {
            suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
        }
        return suma;
    }

    public static int evaluacionKNN(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        return KNN.evaluacionKNN2(nvec, conj, real, nominal, nulos, clases, ejemplo, ejReal, ejNominal, ejNulos, nClases, distance);
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        return votada;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, Referencia nVotos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        nVotos.entero = votaciones;
        return votada;
    }

    public static int[] evaluacionKNN3(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] vecinosCercanos = new int[nvec];
        int[] clasesVecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            clasesVecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < vecinosCercanos.length; ++j) {
            if (vecinosCercanos[j] == -1) continue;
            clasesVecinosCercanos[j] = clases[vecinosCercanos[j]];
        }
        return clasesVecinosCercanos;
    }

    public static int evaluacionKNN2(int nvec, double[][] conj, double[][] real, int[][] nominal, boolean[][] nulos, int[] clases, double[] ejemplo, double[] ejReal, int[] ejNominal, boolean[] ejNulos, int nClases, boolean distance, int[] vecinos) {
        int j;
        int i;
        boolean parar = false;
        if (nvec > conj.length) {
            nvec = conj.length;
        }
        int[] votos = new int[nClases];
        int[] vecinosCercanos = new int[nvec];
        double[] minDistancias = new double[nvec];
        for (i = 0; i < nvec; ++i) {
            vecinosCercanos[i] = -1;
            minDistancias[i] = Double.POSITIVE_INFINITY;
        }
        for (i = 0; i < conj.length; ++i) {
            double dist = KNN.distancia(conj[i], real[i], nominal[i], nulos[i], ejemplo, ejReal, ejNominal, ejNulos, distance);
            if (!(dist > 0.0)) continue;
            parar = false;
            for (j = 0; j < nvec && !parar; ++j) {
                if (!(dist < minDistancias[j])) continue;
                parar = true;
                for (int l = nvec - 1; l >= j + 1; --l) {
                    minDistancias[l] = minDistancias[l - 1];
                    vecinosCercanos[l] = vecinosCercanos[l - 1];
                }
                minDistancias[j] = dist;
                vecinosCercanos[j] = i;
            }
        }
        for (j = 0; j < nClases; ++j) {
            votos[j] = 0;
        }
        for (j = 0; j < nvec; ++j) {
            if (vecinosCercanos[j] < 0) continue;
            int n = clases[vecinosCercanos[j]];
            votos[n] = votos[n] + 1;
        }
        int votada = 0;
        int votaciones = votos[0];
        for (j = 1; j < nClases; ++j) {
            if (votaciones >= votos[j]) continue;
            votaciones = votos[j];
            votada = j;
        }
        for (i = 0; i < vecinosCercanos.length; ++i) {
            vecinos[i] = vecinosCercanos[i];
        }
        return votada;
    }

    public static double distancia(double[] ej1, double[] ej1Real, int[] ej1Nom, boolean[] ej1Nul, double[] ej2, double[] ej2Real, int[] ej2Nom, boolean[] ej2Nul, boolean Euc) {
        double suma = 0.0;
        if (Euc) {
            for (int i = 0; i < ej1.length; ++i) {
                suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
            }
            suma = Math.sqrt(suma);
        } else {
            for (int i = 0; i < ej1.length; ++i) {
                if (ej1Nul[i] || ej2Nul[i]) {
                    suma += 1.0;
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    suma += Metodo.nominalDistance[i][ej1Nom[i]][ej2Nom[i]];
                    continue;
                }
                suma += Math.abs(ej1Real[i] - ej2Real[i]) / 4.0 * Metodo.stdDev[i];
            }
            suma = Math.sqrt(suma);
        }
        return suma;
    }

    public static double distancia2(double[] ej1, double[] ej1Real, int[] ej1Nom, boolean[] ej1Nul, double[] ej2, double[] ej2Real, int[] ej2Nom, boolean[] ej2Nul, boolean Euc) {
        double suma = 0.0;
        if (Euc) {
            for (int i = 0; i < ej1.length; ++i) {
                suma += (ej1[i] - ej2[i]) * (ej1[i] - ej2[i]);
            }
        } else {
            for (int i = 0; i < ej1.length; ++i) {
                if (ej1Nul[i] || ej2Nul[i]) {
                    suma += 1.0;
                    continue;
                }
                if (Attributes.getInputAttribute(i).getType() == 0) {
                    suma += Metodo.nominalDistance[i][ej1Nom[i]][ej2Nom[i]];
                    continue;
                }
                suma += Math.abs(ej1Real[i] - ej2Real[i]) / (4.0 * Metodo.stdDev[i]);
            }
        }
        return suma;
    }
}

