/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98;

import java.io.FileNotFoundException;
import java.io.IOException;
import keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98.RSFSS;
import keel.Algorithms.Shared.Parsing.ProcessConfig;
import keel.Algorithms.Shared.Parsing.ProcessDataset;
import org.core.Randomize;

public class FSS98 {
    static Randomize rand;

    public static void fuzzyFSSmodeling(boolean tty, ProcessConfig pc) {
        try {
            String readALine = new String();
            ProcessDataset pd = new ProcessDataset();
            readALine = (String)ProcessConfig.parInputData.get(0);
            if (ProcessConfig.parNewFormat) {
                pd.processModelDataset(readALine, true);
            } else {
                pd.oldClassificationProcess(readALine);
            }
            int nData = pd.getNdata();
            int nVariables = pd.getNvariables();
            int nInputs = pd.getNinputs();
            boolean nsalidas = true;
            double[][] X = pd.getX();
            double[] Y = pd.getY();
            double[] Yt = new double[Y.length];
            pd.showDatasetStatistics();
            double[] inputMaximum = pd.getImaximum();
            double[] inputMinimum = pd.getIminimum();
            double outputMaximum = pd.getOmaximum();
            double outputMinimum = pd.getOminimum();
            int nc = ProcessConfig.parRuleNumber;
            RSFSS rs = new RSFSS(X, Y);
            rs.RSFSSX2(nc, rand, ProcessConfig.parSigma);
            double error = 0.0;
            for (int i = 0; i < nData; ++i) {
                double[] theEvaluation = rs.getOutput(X[i]);
                error += (theEvaluation[0] - Y[i]) * (theEvaluation[0] - Y[i]);
                Yt[i] = theEvaluation[0];
            }
            pc.trainingResults(Y, Yt);
            System.out.println("MSE Train = " + (error /= (double)nData));
            ProcessDataset pdt = new ProcessDataset();
            readALine = (String)ProcessConfig.parInputData.get(2);
            if (ProcessConfig.parNewFormat) {
                pdt.processModelDataset(readALine, false);
            } else {
                pdt.oldClassificationProcess(readALine);
            }
            int nTest = pdt.getNdata();
            int nTestVariables = pdt.getNvariables();
            int nTestInputs = pdt.getNinputs();
            pdt.showDatasetStatistics();
            if (nTestInputs != nInputs) {
                throw new IOException("IOERR Test file");
            }
            double[][] Xp = pdt.getX();
            double[] Yp = pdt.getY();
            double[] Yo = new double[Yp.length];
            double RMS = 0.0;
            for (int i = 0; i < nTest; ++i) {
                double[] theEvaluation = rs.getOutput(Xp[i]);
                RMS += (theEvaluation[0] - Yp[i]) * (theEvaluation[0] - Yp[i]);
                Yo[i] = theEvaluation[0];
            }
            System.out.println("MSE Test = " + (RMS /= (double)nTest));
            pc.results(Yp, Yo);
        }
        catch (FileNotFoundException e) {
            System.err.println(e + " File not found");
        }
        catch (IOException e) {
            System.err.println(e + " Read Error");
        }
    }

    public static void main(String[] args) {
        boolean tty = false;
        ProcessConfig pc = new ProcessConfig();
        System.out.println("Reading configuration file: " + args[0]);
        if (pc.fileProcess(args[0]) < 0) {
            return;
        }
        int algo = ProcessConfig.parAlgorithmType;
        rand = new Randomize();
        Randomize.setSeed(ProcessConfig.parSeed);
        FSS98 wm = new FSS98();
        FSS98.fuzzyFSSmodeling(tty, pc);
    }
}

