/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.nonevolutionary_algorithms.SFS_IEP_FS;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class SFS {
    private Datos data;
    private Parametros params;
    private boolean[] features;

    public SFS(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
        this.features = new boolean[this.data.returnNumFeatures()];
    }

    private boolean[] randomSolution() {
        boolean[] fv = new boolean[Attributes.getInputNumAttributes()];
        for (int i = 0; i < fv.length; ++i) {
            fv[i] = Randomize.Randint(0, 2) != 0;
        }
        if (SFS.cardinalidadCto(fv) == 0) {
            fv[Randomize.Randint((int)0, (int)Attributes.getInputNumAttributes())] = true;
        }
        return fv;
    }

    private boolean[] startSolution() {
        boolean[] fv = new boolean[Attributes.getInputNumAttributes()];
        for (int i = 0; i < fv.length; ++i) {
            fv[i] = false;
        }
        return fv;
    }

    private static int cardinalidadCto(boolean[] featuresVector) {
        int cardinalidad = 0;
        for (int i = 0; i < featuresVector.length; ++i) {
            if (!featuresVector[i]) continue;
            ++cardinalidad;
        }
        return cardinalidad;
    }

    private static boolean[] neighbor(boolean[] featuresVector) {
        boolean[] fv = new boolean[featuresVector.length];
        for (int i = 0; i < fv.length; ++i) {
            fv[i] = featuresVector[i];
        }
        int toChange = Randomize.Randint(0, fv.length);
        boolean bl = fv[toChange] = !fv[toChange];
        if (SFS.cardinalidadCto(fv) == 0) {
            fv[Randomize.Randint((int)0, (int)Attributes.getInputNumAttributes())] = true;
        }
        return fv;
    }

    private void runSFS() {
        this.features = this.startSolution();
        double T = 0.0;
        int best_feature = 0;
        boolean forced_stop = false;
        while (T < this.params.threshold && !forced_stop) {
            double best = Double.MAX_VALUE;
            forced_stop = true;
            for (int i = 0; i < this.data.returnNumFeatures(); ++i) {
                if (this.features[i]) continue;
                this.features[i] = true;
                double current = this.data.measureIEP(this.features);
                this.features[i] = false;
                if (!(current < best)) continue;
                best_feature = i;
                best = current;
                forced_stop = false;
            }
            if (forced_stop) continue;
            T = best;
            this.features[best_feature] = true;
        }
        if (this.features == null) {
            System.err.println("ERROR: It couldn't be possible to find any solution.");
            System.exit(0);
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.runSFS();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        int numFeatures = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(this.features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(this.features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Files.writeFile(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, this.features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        long seed;
        double threshold;

        Parametros(String nombreFileParametros) {
            try {
                String fichero = Files.readFile(nombreFileParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFile = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFile.hasMoreTokens()) {
                    String linea = lineasFile.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamLong(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("threshold")) {
                        this.threshold = this.getParamFloat(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            contents = contents + "Measure threshold: " + this.threshold + "\n";
            contents = contents + "Seed: " + this.seed + "\n";
            System.out.println(contents);
        }

        private double getParamFloat(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Float.parseFloat(val);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

