## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
# remotes::install_github('ischlo/cppSim')

library(cppSim)

data("distance_test")
data("flows_test")
data("london_msoa")

distance_test <- distance_test / 1000


## -----------------------------------------------------------------------------

dim(distance_test)
dim(flows_test)


## ----echo=FALSE, fig.show='hold', out.width="45%"-----------------------------

oldpar <- par(cex = .6)

plot(density(distance_test), main = "Distribution of distances", xlab = "OD distance (km)")
plot(density(flows_test), main = "Distribution of flows", xlab = "flow", log = "x")

# Restore
par(oldpar)



## ----include=FALSE,eval=TRUE,echo=FALSE---------------------------------------

london_msoa |>
  sf::st_as_sf(wkt = ncol(london_msoa), crs = 4326) |>
  sf::st_geometry() |>
  plot(main = "London MSOAs")


## -----------------------------------------------------------------------------

beta <- .1

res_model <- cppSim::run_model(
  flows = flows_test,
  distance = distance_test,
  beta = beta
)

str(res_model)

dim(res_model$values)


## ----echo=FALSE---------------------------------------------------------------
plot(c(res_model$values),
  c(flows_test),
  main = "Model vs Data"
)


## -----------------------------------------------------------------------------
cor(
  c(res_model$values),
  c(flows_test)
)


## -----------------------------------------------------------------------------

res_sim <- cppSim::simulation(
  flows_matrix = flows_test,
  dist_matrix = distance_test
)

str(res_sim)

res_sim$best_fit_beta


## -----------------------------------------------------------------------------
plot(res_sim$best_fit_values,
  flows_test
  # ,log = 'xy'
  ,
  main = "Model vs Data"
)

## -----------------------------------------------------------------------------
cor(
  x = c(res_sim$best_fit_values),
  y = c(flows_test)
)


